/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.AAFrequency;
import jalview.analysis.Conservation;
import jalview.analysis.NJTree;
import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.Annotation;
import jalview.datamodel.CigarArray;
import jalview.datamodel.CigarSimple;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignmentPanel;
import jalview.gui.OOMWarning;
import jalview.gui.UserDefinedColours;
import jalview.schemes.ClustalxColourScheme;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemeProperty;
import jalview.schemes.ResidueProperties;
import jalview.schemes.UserColourScheme;
import jalview.structure.StructureSelectionManager;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class AlignViewport {
    int startRes;
    int endRes;
    int startSeq;
    int endSeq;
    boolean showJVSuffix = true;
    boolean showText = true;
    boolean showColourText = false;
    boolean showBoxes = true;
    boolean wrapAlignment = false;
    boolean renderGaps = true;
    boolean showSequenceFeatures = false;
    boolean showAnnotation = true;
    boolean colourAppliesToAllGroups = true;
    ColourSchemeI globalColourScheme = null;
    boolean conservationColourSelected = false;
    boolean abovePIDThreshold = false;
    SequenceGroup selectionGroup;
    int charHeight;
    int charWidth;
    boolean validCharWidth;
    int wrappedWidth;
    Font font;
    boolean seqNameItalics;
    AlignmentI alignment;
    ColumnSelection colSel = new ColumnSelection();
    int threshold;
    int increment;
    NJTree currentTree = null;
    boolean scaleAboveWrapped = false;
    boolean scaleLeftWrapped = true;
    boolean scaleRightWrapped = true;
    boolean hasHiddenColumns = false;
    boolean hasHiddenRows = false;
    boolean showHiddenMarkers = true;
    boolean cursorMode = false;
    Hashtable featuresDisplayed = null;
    public Hashtable[] hconsensus;
    AlignmentAnnotation consensus;
    AlignmentAnnotation conservation;
    AlignmentAnnotation quality;
    boolean autoCalculateConsensus = true;
    public int ConsPercGaps = 25;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    boolean ignoreGapsInConsensusCalculation = false;
    boolean isDataset = false;
    boolean antiAlias = false;
    boolean padGaps = false;
    Rectangle explodedPosition;
    String viewName;
    String sequenceSetID;
    boolean gatherViewsHere = false;
    Stack historyList = new Stack();
    Stack redoList = new Stack();
    Hashtable sequenceColours;
    int thresholdTextColour = 0;
    Color textColour = Color.black;
    Color textColour2 = Color.white;
    boolean rightAlignIds = false;
    Hashtable hiddenRepSequences;
    ConservationThread conservationThread;
    ConsensusThread consensusThread;
    boolean consUpdateNeeded = false;
    static boolean UPDATING_CONSENSUS = false;
    static boolean UPDATING_CONSERVATION = false;
    boolean updatingConsensus = false;
    boolean updatingConservation = false;
    boolean centreColumnLabels = false;

    public AlignViewport(AlignmentI al) {
        this.setAlignment(al);
        this.init();
    }

    public AlignViewport(AlignmentI al, ColumnSelection hiddenColumns) {
        this.setAlignment(al);
        if (hiddenColumns != null) {
            this.colSel = hiddenColumns;
            if (hiddenColumns.getHiddenColumns() != null) {
                this.hasHiddenColumns = true;
            }
        }
        this.init();
    }

    void init() {
        this.startRes = 0;
        this.endRes = this.alignment.getWidth() - 1;
        this.startSeq = 0;
        this.endSeq = this.alignment.getHeight() - 1;
        this.antiAlias = Cache.getDefault("ANTI_ALIAS", false);
        this.showJVSuffix = Cache.getDefault("SHOW_JVSUFFIX", true);
        this.showAnnotation = Cache.getDefault("SHOW_ANNOTATIONS", true);
        this.rightAlignIds = Cache.getDefault("RIGHT_ALIGN_IDS", false);
        this.centreColumnLabels = Cache.getDefault("CENTRE_COLUMN_LABELS", false);
        this.autoCalculateConsensus = Cache.getDefault("AUTO_CALC_CONSENSUS", true);
        this.padGaps = Cache.getDefault("PAD_GAPS", true);
        String fontName = Cache.getDefault("FONT_NAME", "SansSerif");
        String fontStyle = Cache.getDefault("FONT_STYLE", "0");
        String fontSize = Cache.getDefault("FONT_SIZE", "10");
        this.seqNameItalics = Cache.getDefault("ID_ITALICS", true);
        int style = 0;
        if (fontStyle.equals("bold")) {
            style = 1;
        } else if (fontStyle.equals("italic")) {
            style = 2;
        }
        this.setFont(new Font(fontName, style, Integer.parseInt(fontSize)));
        this.alignment.setGapCharacter(Cache.getDefault("GAP_SYMBOL", "-").charAt(0));
        if (this.hconsensus == null && !this.isDataset) {
            if (!this.alignment.isNucleotide()) {
                this.conservation = new AlignmentAnnotation("Conservation", "Conservation of total alignment less than " + this.ConsPercGaps + "% gaps", new Annotation[1], 0.0f, 11.0f, 1);
                this.conservation.hasText = true;
                this.conservation.autoCalculated = true;
                if (Cache.getDefault("SHOW_CONSERVATION", true)) {
                    this.alignment.addAnnotation(this.conservation);
                }
                if (Cache.getDefault("SHOW_QUALITY", true)) {
                    this.quality = new AlignmentAnnotation("Quality", "Alignment Quality based on Blosum62 scores", new Annotation[1], 0.0f, 11.0f, 1);
                    this.quality.hasText = true;
                    this.quality.autoCalculated = true;
                    this.alignment.addAnnotation(this.quality);
                }
            }
            this.consensus = new AlignmentAnnotation("Consensus", "PID", new Annotation[1], 0.0f, 100.0f, 1);
            this.consensus.hasText = true;
            this.consensus.autoCalculated = true;
            if (Cache.getDefault("SHOW_IDENTITY", true)) {
                this.alignment.addAnnotation(this.consensus);
            }
        }
        if (Cache.getProperty("DEFAULT_COLOUR") != null) {
            this.globalColourScheme = ColourSchemeProperty.getColour(this.alignment, Cache.getProperty("DEFAULT_COLOUR"));
            if (this.globalColourScheme instanceof UserColourScheme) {
                this.globalColourScheme = UserDefinedColours.loadDefaultColours();
                ((UserColourScheme)this.globalColourScheme).setThreshold(0, this.getIgnoreGapsConsensus());
            }
            if (this.globalColourScheme != null) {
                this.globalColourScheme.setConsensus(this.hconsensus);
            }
        }
        this.wrapAlignment = Cache.getDefault("WRAP_ALIGNMENT", false);
    }

    public void setShowSequenceFeatures(boolean b) {
        this.showSequenceFeatures = b;
    }

    public boolean getShowSequenceFeatures() {
        return this.showSequenceFeatures;
    }

    public void updateConservation(AlignmentPanel ap) {
        if (this.alignment.isNucleotide() || this.conservation == null) {
            return;
        }
        this.conservationThread = new ConservationThread(ap);
        this.conservationThread.start();
    }

    public void updateConsensus(AlignmentPanel ap) {
        this.consensusThread = new ConsensusThread(ap);
        this.consensusThread.start();
    }

    public SequenceI getConsensusSeq() {
        if (this.consensus == null) {
            this.updateConsensus(null);
        }
        if (this.consensus == null) {
            return null;
        }
        StringBuffer seqs = new StringBuffer();
        for (int i = 0; i < this.consensus.annotations.length; ++i) {
            if (this.consensus.annotations[i] == null) continue;
            if (this.consensus.annotations[i].description.charAt(0) == '[') {
                seqs.append(this.consensus.annotations[i].description.charAt(1));
                continue;
            }
            seqs.append(this.consensus.annotations[i].displayCharacter);
        }
        Sequence sq = new Sequence("Consensus", seqs.toString());
        sq.setDescription("Percentage Identity Consensus " + (this.ignoreGapsInConsensusCalculation ? " without gaps" : ""));
        return sq;
    }

    public SequenceGroup getSelectionGroup() {
        return this.selectionGroup;
    }

    public void setSelectionGroup(SequenceGroup sg) {
        this.selectionGroup = sg;
    }

    public boolean getConservationSelected() {
        return this.conservationColourSelected;
    }

    public void setConservationSelected(boolean b) {
        this.conservationColourSelected = b;
    }

    public boolean getAbovePIDThreshold() {
        return this.abovePIDThreshold;
    }

    public void setAbovePIDThreshold(boolean b) {
        this.abovePIDThreshold = b;
    }

    public int getStartRes() {
        return this.startRes;
    }

    public int getEndRes() {
        return this.endRes;
    }

    public int getStartSeq() {
        return this.startSeq;
    }

    public void setGlobalColourScheme(ColourSchemeI cs) {
        this.globalColourScheme = cs;
    }

    public ColourSchemeI getGlobalColourScheme() {
        return this.globalColourScheme;
    }

    public void setStartRes(int res) {
        this.startRes = res;
    }

    public void setStartSeq(int seq) {
        this.startSeq = seq;
    }

    public void setEndRes(int res) {
        if (res > this.alignment.getWidth() - 1) {
            res = this.alignment.getWidth() - 1;
        }
        if (res < 0) {
            res = 0;
        }
        this.endRes = res;
    }

    public void setEndSeq(int seq) {
        if (seq > this.alignment.getHeight()) {
            seq = this.alignment.getHeight();
        }
        if (seq < 0) {
            seq = 0;
        }
        this.endSeq = seq;
    }

    public int getEndSeq() {
        return this.endSeq;
    }

    public void setFont(Font f) {
        this.font = f;
        Container c = new Container();
        FontMetrics fm = c.getFontMetrics(this.font);
        this.setCharHeight(fm.getHeight());
        this.setCharWidth(fm.charWidth('M'));
        this.validCharWidth = true;
    }

    public Font getFont() {
        return this.font;
    }

    public void setCharWidth(int w) {
        this.charWidth = w;
    }

    public int getCharWidth() {
        return this.charWidth;
    }

    public void setCharHeight(int h) {
        this.charHeight = h;
    }

    public int getCharHeight() {
        return this.charHeight;
    }

    public void setWrappedWidth(int w) {
        this.wrappedWidth = w;
    }

    public int getWrappedWidth() {
        return this.wrappedWidth;
    }

    public AlignmentI getAlignment() {
        return this.alignment;
    }

    public void setAlignment(AlignmentI align) {
        if (this.alignment != null && this.alignment.getCodonFrames() != null) {
            StructureSelectionManager.getStructureSelectionManager().removeMappings(this.alignment.getCodonFrames());
        }
        this.alignment = align;
        if (this.alignment.getCodonFrames() != null) {
            StructureSelectionManager.getStructureSelectionManager().addMappings(this.alignment.getCodonFrames());
        }
    }

    public void setWrapAlignment(boolean state) {
        this.wrapAlignment = state;
    }

    public void setShowText(boolean state) {
        this.showText = state;
    }

    public void setRenderGaps(boolean state) {
        this.renderGaps = state;
    }

    public boolean getColourText() {
        return this.showColourText;
    }

    public void setColourText(boolean state) {
        this.showColourText = state;
    }

    public void setShowBoxes(boolean state) {
        this.showBoxes = state;
    }

    public boolean getWrapAlignment() {
        return this.wrapAlignment;
    }

    public boolean getShowText() {
        return this.showText;
    }

    public boolean getShowBoxes() {
        return this.showBoxes;
    }

    public char getGapCharacter() {
        return this.getAlignment().getGapCharacter();
    }

    public void setGapCharacter(char gap) {
        if (this.getAlignment() != null) {
            this.getAlignment().setGapCharacter(gap);
        }
    }

    public void setThreshold(int thresh) {
        this.threshold = thresh;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setIncrement(int inc) {
        this.increment = inc;
    }

    public int getIncrement() {
        return this.increment;
    }

    public ColumnSelection getColumnSelection() {
        return this.colSel;
    }

    public void setCurrentTree(NJTree tree) {
        this.currentTree = tree;
    }

    public NJTree getCurrentTree() {
        return this.currentTree;
    }

    public void setColourAppliesToAllGroups(boolean b) {
        this.colourAppliesToAllGroups = b;
    }

    public boolean getColourAppliesToAllGroups() {
        return this.colourAppliesToAllGroups;
    }

    public boolean getShowJVSuffix() {
        return this.showJVSuffix;
    }

    public void setShowJVSuffix(boolean b) {
        this.showJVSuffix = b;
    }

    public boolean getShowAnnotation() {
        return this.showAnnotation;
    }

    public void setShowAnnotation(boolean b) {
        this.showAnnotation = b;
    }

    public boolean getScaleAboveWrapped() {
        return this.scaleAboveWrapped;
    }

    public boolean getScaleLeftWrapped() {
        return this.scaleLeftWrapped;
    }

    public boolean getScaleRightWrapped() {
        return this.scaleRightWrapped;
    }

    public void setScaleAboveWrapped(boolean b) {
        this.scaleAboveWrapped = b;
    }

    public void setScaleLeftWrapped(boolean b) {
        this.scaleLeftWrapped = b;
    }

    public void setScaleRightWrapped(boolean b) {
        this.scaleRightWrapped = b;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void firePropertyChange(String prop, Object oldvalue, Object newvalue) {
        this.changeSupport.firePropertyChange(prop, oldvalue, newvalue);
    }

    public void setIgnoreGapsConsensus(boolean b, AlignmentPanel ap) {
        this.ignoreGapsInConsensusCalculation = b;
        this.updateConsensus(ap);
        if (this.globalColourScheme != null) {
            this.globalColourScheme.setThreshold(this.globalColourScheme.getThreshold(), this.ignoreGapsInConsensusCalculation);
        }
    }

    public boolean getIgnoreGapsConsensus() {
        return this.ignoreGapsInConsensusCalculation;
    }

    public void setDataset(boolean b) {
        this.isDataset = b;
    }

    public boolean isDataset() {
        return this.isDataset;
    }

    public void hideSelectedColumns() {
        if (this.colSel.size() < 1) {
            return;
        }
        this.colSel.hideSelectedColumns();
        this.setSelectionGroup(null);
        this.hasHiddenColumns = true;
    }

    public void hideColumns(int start, int end) {
        if (start == end) {
            this.colSel.hideColumns(start);
        } else {
            this.colSel.hideColumns(start, end);
        }
        this.hasHiddenColumns = true;
    }

    public void hideRepSequences(SequenceI repSequence, SequenceGroup sg) {
        int sSize = sg.getSize();
        if (sSize < 2) {
            return;
        }
        if (this.hiddenRepSequences == null) {
            this.hiddenRepSequences = new Hashtable();
        }
        this.hiddenRepSequences.put(repSequence, sg);
        SequenceI[] seqs = new SequenceI[sSize - 1];
        int index = 0;
        for (int i = 0; i < sSize; ++i) {
            if (sg.getSequenceAt(i) == repSequence) continue;
            if (index == sSize - 1) {
                return;
            }
            seqs[index++] = sg.getSequenceAt(i);
        }
        this.hideSequence(seqs);
    }

    public void hideAllSelectedSeqs() {
        if (this.selectionGroup == null || this.selectionGroup.getSize() < 1) {
            return;
        }
        SequenceI[] seqs = this.selectionGroup.getSequencesInOrder(this.alignment);
        this.hideSequence(seqs);
        this.setSelectionGroup(null);
    }

    public void hideSequence(SequenceI[] seq) {
        if (seq != null) {
            for (int i = 0; i < seq.length; ++i) {
                this.alignment.getHiddenSequences().hideSequence(seq[i]);
            }
            this.hasHiddenRows = true;
            this.firePropertyChange("alignment", null, this.alignment.getSequences());
        }
    }

    public void showSequence(int index) {
        Vector tmp = this.alignment.getHiddenSequences().showSequence(index, this.hiddenRepSequences);
        if (tmp.size() > 0) {
            if (this.selectionGroup == null) {
                this.selectionGroup = new SequenceGroup();
                this.selectionGroup.setEndRes(this.alignment.getWidth() - 1);
            }
            for (int t = 0; t < tmp.size(); ++t) {
                this.selectionGroup.addSequence((SequenceI)tmp.elementAt(t), false);
            }
            this.firePropertyChange("alignment", null, this.alignment.getSequences());
        }
        if (this.alignment.getHiddenSequences().getSize() < 1) {
            this.hasHiddenRows = false;
        }
    }

    public void showColumn(int col) {
        this.colSel.revealHiddenColumns(col);
        if (this.colSel.getHiddenColumns() == null) {
            this.hasHiddenColumns = false;
        }
    }

    public void showAllHiddenColumns() {
        this.colSel.revealAllHiddenColumns();
        this.hasHiddenColumns = false;
    }

    public void showAllHiddenSeqs() {
        if (this.alignment.getHiddenSequences().getSize() > 0) {
            if (this.selectionGroup == null) {
                this.selectionGroup = new SequenceGroup();
                this.selectionGroup.setEndRes(this.alignment.getWidth() - 1);
            }
            Vector tmp = this.alignment.getHiddenSequences().showAll(this.hiddenRepSequences);
            for (int t = 0; t < tmp.size(); ++t) {
                this.selectionGroup.addSequence((SequenceI)tmp.elementAt(t), false);
            }
            this.firePropertyChange("alignment", null, this.alignment.getSequences());
            this.hasHiddenRows = false;
            this.hiddenRepSequences = null;
        }
    }

    public void invertColumnSelection() {
        this.colSel.invertColumnSelection(0, this.alignment.getWidth());
    }

    public int adjustForHiddenSeqs(int alignmentIndex) {
        return this.alignment.getHiddenSequences().adjustForHiddenSeqs(alignmentIndex);
    }

    public SequenceI[] getSelectionAsNewSequence() {
        SequenceI[] sequences;
        if (this.selectionGroup == null) {
            sequences = this.alignment.getSequencesArray();
            AlignmentAnnotation[] annots = this.alignment.getAlignmentAnnotation();
            for (int i = 0; i < sequences.length; ++i) {
                sequences[i] = new Sequence(sequences[i], annots);
            }
        } else {
            sequences = this.selectionGroup.getSelectionAsNewSequences(this.alignment);
        }
        return sequences;
    }

    public SequenceI[] getSequenceSelection() {
        SequenceI[] sequences = this.selectionGroup == null ? this.alignment.getSequencesArray() : this.selectionGroup.getSequencesInOrder(this.alignment);
        return sequences;
    }

    public CigarArray getViewAsCigars(boolean selectedRegionOnly) {
        CigarArray selection;
        block14: {
            int end;
            int start;
            block11: {
                int iSize;
                selection = null;
                SequenceI[] seqs = null;
                start = 0;
                end = 0;
                if (selectedRegionOnly && this.selectionGroup != null) {
                    iSize = this.selectionGroup.getSize();
                    seqs = this.selectionGroup.getSequencesInOrder(this.alignment);
                    start = this.selectionGroup.getStartRes();
                    end = this.selectionGroup.getEndRes();
                } else {
                    iSize = this.alignment.getHeight();
                    seqs = this.alignment.getSequencesArray();
                    end = this.alignment.getWidth() - 1;
                }
                CigarSimple[] selseqs = new SeqCigar[iSize];
                for (int i = 0; i < iSize; ++i) {
                    selseqs[i] = new SeqCigar(seqs[i], start, end);
                }
                selection = new CigarArray(selseqs);
                if (!this.hasHiddenColumns) break block11;
                Vector regions = this.colSel.getHiddenColumns();
                int last = start;
                int j = 0;
                while (last < end & j < regions.size()) {
                    block13: {
                        int hideEnd;
                        int hideStart;
                        block12: {
                            int[] region = (int[])regions.elementAt(j);
                            hideStart = region[0];
                            hideEnd = region[1];
                            if (hideStart >= last) break block12;
                            if (hideEnd <= last) break block13;
                            hideStart = last;
                        }
                        if (hideStart > end) break;
                        if (hideEnd > end) {
                            hideEnd = end;
                        }
                        if (hideStart > hideEnd) break;
                        if (last < hideStart) {
                            selection.addOperation('M', hideStart - last);
                        }
                        selection.addOperation('D', 1 + hideEnd - hideStart);
                        last = hideEnd + 1;
                    }
                    ++j;
                }
                if (last < end) {
                    selection.addOperation('M', end - last + 1);
                }
                break block14;
            }
            selection.addOperation('M', end - start + 1);
        }
        return selection;
    }

    AlignmentView getAlignmentView(boolean selectedOnly) {
        CigarArray aligview = this.getViewAsCigars(selectedOnly);
        if (aligview != null) {
            return new AlignmentView(aligview, selectedOnly && this.selectionGroup != null ? this.selectionGroup.getStartRes() : 0);
        }
        return null;
    }

    public String[] getViewAsString(boolean selectedRegionOnly) {
        int iSize;
        String[] selection = null;
        SequenceI[] seqs = null;
        int start = 0;
        int end = 0;
        if (selectedRegionOnly && this.selectionGroup != null) {
            iSize = this.selectionGroup.getSize();
            seqs = this.selectionGroup.getSequencesInOrder(this.alignment);
            start = this.selectionGroup.getStartRes();
            end = this.selectionGroup.getEndRes() + 1;
        } else {
            iSize = this.alignment.getHeight();
            seqs = this.alignment.getSequencesArray();
            end = this.alignment.getWidth();
        }
        selection = new String[iSize];
        if (this.hasHiddenColumns) {
            selection = this.colSel.getVisibleSequenceStrings(start, end, seqs);
        } else {
            for (int i = 0; i < iSize; ++i) {
                selection[i] = seqs[i].getSequenceAsString(start, end);
            }
        }
        return selection;
    }

    public int[][] getVisibleRegionBoundaries(int min, int max) {
        Vector<int[]> regions = new Vector<int[]>();
        int start = min;
        int end = max;
        do {
            if (this.hasHiddenColumns) {
                if (start == 0) {
                    start = this.colSel.adjustForHiddenColumns(start);
                }
                if (start == (end = this.colSel.getHiddenBoundaryRight(start))) {
                    end = max;
                }
                if (end > max) {
                    end = max;
                }
            }
            regions.addElement(new int[]{start, end});
            if (!this.hasHiddenColumns) continue;
            start = this.colSel.adjustForHiddenColumns(end);
            start = this.colSel.getHiddenBoundaryLeft(start) + 1;
        } while (end < max);
        int[][] startEnd = new int[regions.size()][2];
        regions.copyInto((Object[])startEnd);
        return startEnd;
    }

    public boolean getShowHiddenMarkers() {
        return this.showHiddenMarkers;
    }

    public void setShowHiddenMarkers(boolean show) {
        this.showHiddenMarkers = show;
    }

    public String getSequenceSetId() {
        if (this.sequenceSetID == null) {
            this.sequenceSetID = this.alignment.hashCode() + "";
        }
        return this.sequenceSetID;
    }

    public void alignmentChanged(AlignmentPanel ap) {
        if (this.padGaps) {
            this.alignment.padGaps();
        }
        if (this.hconsensus != null && this.autoCalculateConsensus) {
            this.updateConsensus(ap);
            this.updateConservation(ap);
        }
        int alWidth = this.alignment.getWidth();
        Vector groups = this.alignment.getGroups();
        if (groups != null) {
            for (int i = 0; i < groups.size(); ++i) {
                SequenceGroup sg = (SequenceGroup)groups.elementAt(i);
                if (sg.getEndRes() <= alWidth) continue;
                sg.setEndRes(alWidth - 1);
            }
        }
        if (this.selectionGroup != null && this.selectionGroup.getEndRes() > alWidth) {
            this.selectionGroup.setEndRes(alWidth - 1);
        }
        this.resetAllColourSchemes();
    }

    void resetAllColourSchemes() {
        ColourSchemeI cs = this.globalColourScheme;
        if (cs != null) {
            if (cs instanceof ClustalxColourScheme) {
                ((ClustalxColourScheme)cs).resetClustalX(this.alignment.getSequences(), this.alignment.getWidth());
            }
            cs.setConsensus(this.hconsensus);
            if (cs.conservationApplied()) {
                Alignment al = (Alignment)this.alignment;
                Conservation c = new Conservation("All", ResidueProperties.propHash, 3, al.getSequences(), 0, al.getWidth() - 1);
                c.calculate();
                c.verdict(false, this.ConsPercGaps);
                cs.setConservation(c);
            }
        }
        int sSize = this.alignment.getGroups().size();
        for (int s = 0; s < sSize; ++s) {
            SequenceGroup sg = (SequenceGroup)this.alignment.getGroups().elementAt(s);
            if (sg.cs != null && sg.cs instanceof ClustalxColourScheme) {
                ((ClustalxColourScheme)sg.cs).resetClustalX(sg.getSequences(this.hiddenRepSequences), sg.getWidth());
            }
            sg.recalcConservation();
        }
    }

    public Color getSequenceColour(SequenceI seq) {
        if (this.sequenceColours == null || !this.sequenceColours.containsKey(seq)) {
            return Color.white;
        }
        return (Color)this.sequenceColours.get(seq);
    }

    public void setSequenceColour(SequenceI seq, Color col) {
        if (this.sequenceColours == null) {
            this.sequenceColours = new Hashtable();
        }
        if (col == null) {
            this.sequenceColours.remove(seq);
        } else {
            this.sequenceColours.put(seq, col);
        }
    }

    public int[] getViewAsVisibleContigs(boolean selectedRegionOnly) {
        int[] viscontigs = null;
        int start = 0;
        int end = 0;
        if (selectedRegionOnly && this.selectionGroup != null) {
            start = this.selectionGroup.getStartRes();
            end = this.selectionGroup.getEndRes() + 1;
        } else {
            end = this.alignment.getWidth();
        }
        viscontigs = this.colSel.getVisibleContigs(start, end);
        return viscontigs;
    }

    public long[] getUndoRedoHash() {
        if (this.historyList == null || this.redoList == null) {
            return new long[]{-1L, -1L};
        }
        return new long[]{this.historyList.hashCode(), this.redoList.hashCode()};
    }

    public boolean isUndoRedoHashModified(long[] undoredo) {
        if (undoredo == null) {
            return true;
        }
        long[] cstate = this.getUndoRedoHash();
        if (cstate.length != undoredo.length) {
            return true;
        }
        for (int i = 0; i < cstate.length; ++i) {
            if (cstate[i] == undoredo[i]) continue;
            return true;
        }
        return false;
    }

    public boolean getCentreColumnLabels() {
        return this.centreColumnLabels;
    }

    public void setCentreColumnLabels(boolean centrecolumnlabels) {
        this.centreColumnLabels = centrecolumnlabels;
    }

    public void updateSequenceIdColours() {
        Vector groups = this.alignment.getGroups();
        if (this.sequenceColours == null) {
            this.sequenceColours = new Hashtable();
        }
        int igSize = groups.size();
        for (int ig = 0; ig < igSize; ++ig) {
            SequenceGroup sg = (SequenceGroup)groups.elementAt(ig);
            if (sg.idColour == null) continue;
            Vector sqs = sg.getSequences(this.hiddenRepSequences);
            int sSize = sqs.size();
            for (int s = 0; s < sSize; ++s) {
                this.sequenceColours.put(sqs.elementAt(s), sg.idColour);
            }
        }
    }

    class ConsensusThread
    extends Thread {
        AlignmentPanel ap;

        public ConsensusThread(AlignmentPanel ap) {
            this.ap = ap;
        }

        public void run() {
            AlignViewport.this.updatingConsensus = true;
            while (UPDATING_CONSENSUS) {
                try {
                    if (this.ap != null) {
                        this.ap.paintAlignment(false);
                    }
                    Thread.sleep(200L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            UPDATING_CONSENSUS = true;
            try {
                int aWidth;
                int n = aWidth = AlignViewport.this.alignment != null ? AlignViewport.this.alignment.getWidth() : 0;
                if (aWidth < 0) {
                    return;
                }
                AlignViewport.this.consensus.annotations = null;
                AlignViewport.this.consensus.annotations = new Annotation[aWidth];
                AlignViewport.this.hconsensus = new Hashtable[aWidth];
                AAFrequency.calculate(AlignViewport.this.alignment.getSequencesArray(), 0, AlignViewport.this.alignment.getWidth(), AlignViewport.this.hconsensus);
                for (int i = 0; i < aWidth; ++i) {
                    float value = 0.0f;
                    value = AlignViewport.this.ignoreGapsInConsensusCalculation ? ((Float)AlignViewport.this.hconsensus[i].get("N")).floatValue() : ((Float)AlignViewport.this.hconsensus[i].get("G")).floatValue();
                    String maxRes = AlignViewport.this.hconsensus[i].get("R").toString();
                    String mouseOver = AlignViewport.this.hconsensus[i].get("R") + " ";
                    if (maxRes.length() > 1) {
                        mouseOver = "[" + maxRes + "] ";
                        maxRes = "+";
                    }
                    mouseOver = mouseOver + (int)value + "%";
                    AlignViewport.this.consensus.annotations[i] = new Annotation(maxRes, mouseOver, ' ', value);
                }
                if (AlignViewport.this.globalColourScheme != null) {
                    AlignViewport.this.globalColourScheme.setConsensus(AlignViewport.this.hconsensus);
                }
            }
            catch (OutOfMemoryError error) {
                AlignViewport.this.alignment.deleteAnnotation(AlignViewport.this.consensus);
                AlignViewport.this.consensus = null;
                AlignViewport.this.hconsensus = null;
                new OOMWarning("calculating consensus", error);
            }
            UPDATING_CONSENSUS = false;
            AlignViewport.this.updatingConsensus = false;
            if (this.ap != null) {
                this.ap.paintAlignment(true);
            }
        }
    }

    class ConservationThread
    extends Thread {
        AlignmentPanel ap;

        public ConservationThread(AlignmentPanel ap) {
            this.ap = ap;
        }

        public void run() {
            try {
                AlignViewport.this.updatingConservation = true;
                while (UPDATING_CONSERVATION) {
                    try {
                        if (this.ap != null) {
                            this.ap.paintAlignment(false);
                        }
                        Thread.sleep(200L);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                UPDATING_CONSERVATION = true;
                int alWidth = AlignViewport.this.alignment.getWidth();
                if (alWidth < 0) {
                    return;
                }
                Conservation cons = new Conservation("All", ResidueProperties.propHash, 3, AlignViewport.this.alignment.getSequences(), 0, alWidth - 1);
                cons.calculate();
                cons.verdict(false, AlignViewport.this.ConsPercGaps);
                if (AlignViewport.this.quality != null) {
                    cons.findQuality();
                }
                char[] sequence = cons.getConsSequence().getSequence();
                float minR = 0.3f;
                float minG = 0.0f;
                float minB = 0.0f;
                float maxR = 1.0f - minR;
                float maxG = 0.9f - minG;
                float maxB = 0.0f - minB;
                float min = 0.0f;
                float max = 11.0f;
                float qmin = 0.0f;
                float qmax = 0.0f;
                AlignViewport.this.conservation.annotations = new Annotation[alWidth];
                if (AlignViewport.this.quality != null) {
                    AlignViewport.this.quality.graphMax = cons.qualityRange[1].floatValue();
                    AlignViewport.this.quality.annotations = new Annotation[alWidth];
                    qmin = cons.qualityRange[0].floatValue();
                    qmax = cons.qualityRange[1].floatValue();
                }
                for (int i = 0; i < alWidth; ++i) {
                    float value = 0.0f;
                    char c = sequence[i];
                    if (Character.isDigit(c)) {
                        value = c - 48;
                    } else if (c == '*') {
                        value = 11.0f;
                    } else if (c == '+') {
                        value = 10.0f;
                    }
                    float vprop = value - min;
                    AlignViewport.this.conservation.annotations[i] = new Annotation(String.valueOf(c), String.valueOf(value), ' ', value, new Color(minR + maxR * (vprop /= max), minG + maxG * vprop, minB + maxB * vprop));
                    if (AlignViewport.this.quality == null) continue;
                    value = ((Double)cons.quality.get(i)).floatValue();
                    vprop = value - qmin;
                    AlignViewport.this.quality.annotations[i] = new Annotation(" ", String.valueOf(value), ' ', value, new Color(minR + maxR * (vprop /= qmax), minG + maxG * vprop, minB + maxB * vprop));
                }
            }
            catch (OutOfMemoryError error) {
                new OOMWarning("calculating conservation", error);
                AlignViewport.this.conservation = null;
                AlignViewport.this.quality = null;
            }
            UPDATING_CONSERVATION = false;
            AlignViewport.this.updatingConservation = false;
            if (this.ap != null) {
                this.ap.paintAlignment(true);
            }
        }
    }
}

