/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.datamodel.AlignmentI;
import jalview.datamodel.SearchResults;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.AnnotationLabels;
import jalview.gui.AnnotationPanel;
import jalview.gui.IdPanel;
import jalview.gui.IdwidthAdjuster;
import jalview.gui.OOMWarning;
import jalview.gui.OverviewPanel;
import jalview.gui.PaintRefresher;
import jalview.gui.ScalePanel;
import jalview.gui.SeqPanel;
import jalview.io.HTMLOutput;
import jalview.jbgui.GAlignmentPanel;
import jalview.schemes.ResidueProperties;
import jalview.structure.StructureSelectionManager;
import jalview.util.ImageMaker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.swing.SwingUtilities;

public class AlignmentPanel
extends GAlignmentPanel
implements AdjustmentListener,
Printable {
    public AlignViewport av;
    OverviewPanel overviewPanel;
    SeqPanel seqPanel;
    IdPanel idPanel;
    IdwidthAdjuster idwidthAdjuster;
    public AlignFrame alignFrame;
    ScalePanel scalePanel;
    AnnotationPanel annotationPanel;
    AnnotationLabels alabels;
    boolean fastPaint = true;
    int hextent = 0;
    int vextent = 0;

    public AlignmentPanel(AlignFrame af, final AlignViewport av) {
        this.alignFrame = af;
        this.av = av;
        this.seqPanel = new SeqPanel(av, this);
        this.idPanel = new IdPanel(av, this);
        this.scalePanel = new ScalePanel(av, this);
        this.idPanelHolder.add((Component)this.idPanel, "Center");
        this.idwidthAdjuster = new IdwidthAdjuster(this);
        this.idSpaceFillerPanel1.add((Component)this.idwidthAdjuster, "Center");
        this.annotationPanel = new AnnotationPanel(this);
        this.alabels = new AnnotationLabels(this);
        this.annotationScroller.setViewportView(this.annotationPanel);
        this.annotationSpaceFillerHolder.add((Component)this.alabels, "Center");
        this.scalePanelHolder.add((Component)this.scalePanel, "Center");
        this.seqPanelHolder.add((Component)this.seqPanel, "Center");
        this.setScrollValues(0, 0);
        this.setAnnotationVisible(av.getShowAnnotation());
        this.hscroll.addAdjustmentListener(this);
        this.vscroll.addAdjustmentListener(this);
        final AlignmentPanel ap = this;
        av.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("alignment")) {
                    PaintRefresher.Refresh(ap, av.getSequenceSetId(), true, true);
                    AlignmentPanel.this.alignmentChanged();
                }
            }
        });
        this.fontChanged();
        this.adjustAnnotationHeight();
    }

    public void alignmentChanged() {
        this.av.alignmentChanged(this);
        this.alignFrame.updateEditMenuBar();
        this.paintAlignment(true);
    }

    public void fontChanged() {
        FontMetrics fm = this.getFontMetrics(this.av.getFont());
        this.scalePanelHolder.setPreferredSize(new Dimension(10, this.av.charHeight + fm.getDescent()));
        this.idSpaceFillerPanel1.setPreferredSize(new Dimension(10, this.av.charHeight + fm.getDescent()));
        this.idPanel.idCanvas.gg = null;
        this.seqPanel.seqCanvas.img = null;
        this.annotationPanel.adjustPanelHeight();
        Dimension d = this.calculateIdWidth();
        d.setSize(d.width + 4, d.height);
        this.idPanel.idCanvas.setPreferredSize(d);
        this.hscrollFillerPanel.setPreferredSize(d);
        if (this.overviewPanel != null) {
            this.overviewPanel.setBoxPosition();
        }
        this.repaint();
    }

    public Dimension calculateIdWidth() {
        int i;
        Container c = new Container();
        FontMetrics fm = c.getFontMetrics(new Font(this.av.font.getName(), 2, this.av.font.getSize()));
        AlignmentI al = this.av.getAlignment();
        int afwidth = this.alignFrame != null ? this.alignFrame.getWidth() : 300;
        int maxwidth = Math.max(20, Math.min(afwidth - 200, 2 * afwidth / 3));
        int idWidth = 0;
        for (i = 0; i < al.getHeight() && al.getSequenceAt(i) != null; ++i) {
            SequenceI s = al.getSequenceAt(i);
            String id = s.getDisplayId(this.av.getShowJVSuffix());
            if (fm.stringWidth(id) <= idWidth) continue;
            idWidth = fm.stringWidth(id);
        }
        if (al.getAlignmentAnnotation() != null) {
            fm = c.getFontMetrics(this.alabels.getFont());
            for (i = 0; i < al.getAlignmentAnnotation().length; ++i) {
                String label = al.getAlignmentAnnotation()[i].label;
                if (fm.stringWidth(label) <= idWidth) continue;
                idWidth = fm.stringWidth(label);
            }
        }
        return new Dimension(Math.min(maxwidth, idWidth), 12);
    }

    public void highlightSearchResults(SearchResults results) {
        this.seqPanel.seqCanvas.highlightSearchResults(results);
        if (results != null) {
            SequenceI seq = results.getResultSequence(0);
            int seqIndex = this.av.alignment.findIndex(seq);
            int start = seq.findIndex(results.getResultStart(0)) - 1;
            int end = seq.findIndex(results.getResultEnd(0)) - 1;
            if (!this.av.wrapAlignment) {
                if (this.av.getStartRes() > end || this.av.getEndRes() < start || this.av.getStartSeq() > seqIndex || this.av.getEndSeq() < seqIndex) {
                    this.setScrollValues(start, seqIndex);
                }
            } else {
                this.scrollToWrappedVisible(start);
            }
        }
        this.paintAlignment(true);
    }

    void scrollToWrappedVisible(int res) {
        int cwidth = this.seqPanel.seqCanvas.getWrappedCanvasWidth(this.seqPanel.seqCanvas.getWidth());
        if (res <= this.av.getStartRes() || res >= this.av.getStartRes() + cwidth) {
            this.vscroll.setValue(res / cwidth);
            this.av.startRes = this.vscroll.getValue() * cwidth;
        }
    }

    public OverviewPanel getOverviewPanel() {
        return this.overviewPanel;
    }

    public void setOverviewPanel(OverviewPanel op) {
        this.overviewPanel = op;
    }

    public void setAnnotationVisible(boolean b) {
        if (!this.av.wrapAlignment) {
            this.annotationSpaceFillerHolder.setVisible(b);
            this.annotationScroller.setVisible(b);
        }
        this.repaint();
    }

    public void adjustAnnotationHeight() {
        if (this.alignFrame.getHeight() == 0) {
            System.out.println("NEEDS FIXING");
        }
        int height = this.annotationPanel.adjustPanelHeight();
        if (this.hscroll.isVisible()) {
            height += this.hscroll.getPreferredSize().height;
        }
        if (height > this.alignFrame.getHeight() / 2) {
            height = this.alignFrame.getHeight() / 2;
        }
        this.hscroll.addNotify();
        this.annotationScroller.setPreferredSize(new Dimension(this.annotationScroller.getWidth(), height));
        this.annotationSpaceFillerHolder.setPreferredSize(new Dimension(this.annotationSpaceFillerHolder.getWidth(), height));
        this.annotationScroller.validate();
        this.repaint();
    }

    public void setWrapAlignment(boolean wrap) {
        this.av.startSeq = 0;
        this.scalePanelHolder.setVisible(!wrap);
        this.hscroll.setVisible(!wrap);
        this.idwidthAdjuster.setVisible(!wrap);
        if (wrap) {
            this.annotationScroller.setVisible(false);
            this.annotationSpaceFillerHolder.setVisible(false);
        } else if (this.av.showAnnotation) {
            this.annotationScroller.setVisible(true);
            this.annotationSpaceFillerHolder.setVisible(true);
        }
        this.idSpaceFillerPanel1.setVisible(!wrap);
        this.repaint();
    }

    public boolean scrollUp(boolean up) {
        if (up) {
            if (this.vscroll.getValue() < 1) {
                return false;
            }
            this.fastPaint = false;
            this.vscroll.setValue(this.vscroll.getValue() - 1);
        } else {
            if (this.vextent + this.vscroll.getValue() >= this.av.getAlignment().getHeight()) {
                return false;
            }
            this.fastPaint = false;
            this.vscroll.setValue(this.vscroll.getValue() + 1);
        }
        this.fastPaint = true;
        return true;
    }

    public boolean scrollRight(boolean right) {
        if (!right) {
            if (this.hscroll.getValue() < 1) {
                return false;
            }
            this.fastPaint = false;
            this.hscroll.setValue(this.hscroll.getValue() - 1);
        } else {
            if (this.hextent + this.hscroll.getValue() >= this.av.getAlignment().getWidth()) {
                return false;
            }
            this.fastPaint = false;
            this.hscroll.setValue(this.hscroll.getValue() + 1);
        }
        this.fastPaint = true;
        return true;
    }

    public void setScrollValues(int x, int y) {
        int width = this.av.alignment.getWidth();
        int height = this.av.alignment.getHeight();
        if (this.av.hasHiddenColumns) {
            width = this.av.getColumnSelection().findColumnPosition(width);
        }
        this.av.setEndRes(x + this.seqPanel.seqCanvas.getWidth() / this.av.charWidth - 1);
        this.hextent = this.seqPanel.seqCanvas.getWidth() / this.av.charWidth;
        this.vextent = this.seqPanel.seqCanvas.getHeight() / this.av.charHeight;
        if (this.hextent > width) {
            this.hextent = width;
        }
        if (this.vextent > height) {
            this.vextent = height;
        }
        if (this.hextent + x > width) {
            x = width - this.hextent;
        }
        if (this.vextent + y > height) {
            y = height - this.vextent;
        }
        if (y < 0) {
            y = 0;
        }
        if (x < 0) {
            x = 0;
        }
        this.hscroll.setValues(x, this.hextent, 0, width);
        this.vscroll.setValues(y, this.vextent, 0, height);
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        int oldX = this.av.getStartRes();
        int oldY = this.av.getStartSeq();
        if (evt.getSource() == this.hscroll) {
            int x = this.hscroll.getValue();
            this.av.setStartRes(x);
            this.av.setEndRes(x + this.seqPanel.seqCanvas.getWidth() / this.av.getCharWidth() - 1);
        }
        if (evt.getSource() == this.vscroll) {
            int offy = this.vscroll.getValue();
            if (this.av.getWrapAlignment()) {
                if (offy > -1) {
                    int rowSize = this.seqPanel.seqCanvas.getWrappedCanvasWidth(this.seqPanel.seqCanvas.getWidth());
                    this.av.setStartRes(offy * rowSize);
                    this.av.setEndRes((offy + 1) * rowSize);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AlignmentPanel.this.setScrollValues(AlignmentPanel.this.av.getStartRes(), AlignmentPanel.this.av.getStartSeq());
                        }
                    });
                }
            } else {
                this.av.setStartSeq(offy);
                this.av.setEndSeq(offy + this.seqPanel.seqCanvas.getHeight() / this.av.getCharHeight());
            }
        }
        if (this.overviewPanel != null) {
            this.overviewPanel.setBoxPosition();
        }
        int scrollX = this.av.startRes - oldX;
        int scrollY = this.av.startSeq - oldY;
        if (this.av.getWrapAlignment() || !this.fastPaint) {
            this.repaint();
        } else {
            if (scrollX > this.av.endRes - this.av.startRes) {
                scrollX = this.av.endRes - this.av.startRes;
            } else if (scrollX < this.av.startRes - this.av.endRes) {
                scrollX = this.av.startRes - this.av.endRes;
            }
            if (scrollX != 0 || scrollY != 0) {
                this.idPanel.idCanvas.fastPaint(scrollY);
                this.seqPanel.seqCanvas.fastPaint(scrollX, scrollY);
                this.scalePanel.repaint();
                if (this.av.getShowAnnotation()) {
                    this.annotationPanel.fastPaint(scrollX);
                }
            }
        }
    }

    public void paintAlignment(boolean updateOverview) {
        this.repaint();
        if (updateOverview) {
            StructureSelectionManager.getStructureSelectionManager().sequenceColoursChanged(this);
            if (this.overviewPanel != null) {
                this.overviewPanel.updateOverviewImage();
            }
        }
    }

    public void paintComponent(Graphics g) {
        this.invalidate();
        Dimension d = this.idPanel.idCanvas.getPreferredSize();
        this.idPanelHolder.setPreferredSize(d);
        this.hscrollFillerPanel.setPreferredSize(new Dimension(d.width, 12));
        this.validate();
        if (this.av.getWrapAlignment()) {
            int canvasWidth;
            int maxwidth = this.av.alignment.getWidth();
            if (this.av.hasHiddenColumns) {
                maxwidth = this.av.getColumnSelection().findColumnPosition(maxwidth) - 1;
            }
            if ((canvasWidth = this.seqPanel.seqCanvas.getWrappedCanvasWidth(this.seqPanel.seqCanvas.getWidth())) > 0) {
                int max = maxwidth / this.seqPanel.seqCanvas.getWrappedCanvasWidth(this.seqPanel.seqCanvas.getWidth()) + 1;
                this.vscroll.setMaximum(max);
                this.vscroll.setUnitIncrement(1);
                this.vscroll.setVisibleAmount(1);
            }
        } else {
            this.setScrollValues(this.av.getStartRes(), this.av.getStartSeq());
        }
    }

    public int print(Graphics pg, PageFormat pf, int pi) throws PrinterException {
        pg.translate((int)pf.getImageableX(), (int)pf.getImageableY());
        int pwidth = (int)pf.getImageableWidth();
        int pheight = (int)pf.getImageableHeight();
        if (this.av.getWrapAlignment()) {
            return this.printWrappedAlignment(pg, pwidth, pheight, pi);
        }
        return this.printUnwrapped(pg, pwidth, pheight, pi);
    }

    public int printUnwrapped(Graphics pg, int pwidth, int pheight, int pi) throws PrinterException {
        int startSeq;
        int endSeq;
        int idWidth = this.getVisibleIdWidth();
        FontMetrics fm = this.getFontMetrics(this.av.getFont());
        int scaleHeight = this.av.charHeight + fm.getDescent();
        pg.setColor(Color.white);
        pg.fillRect(0, 0, pwidth, pheight);
        pg.setFont(this.av.getFont());
        int totalRes = (pwidth - idWidth) / this.av.getCharWidth();
        int totalSeq = (pheight - scaleHeight) / this.av.getCharHeight() - 1;
        int pagesWide = this.av.getAlignment().getWidth() / totalRes + 1;
        int startRes = pi % pagesWide * totalRes;
        int endRes = startRes + totalRes - 1;
        if (endRes > this.av.getAlignment().getWidth() - 1) {
            endRes = this.av.getAlignment().getWidth() - 1;
        }
        if ((endSeq = (startSeq = pi / pagesWide * totalSeq) + totalSeq) > this.av.getAlignment().getHeight()) {
            endSeq = this.av.getAlignment().getHeight();
        }
        int pagesHigh = (this.av.alignment.getHeight() / totalSeq + 1) * pheight;
        if (this.av.showAnnotation) {
            pagesHigh += this.annotationPanel.adjustPanelHeight() + 3;
        }
        if (pi >= pagesWide * (pagesHigh /= pheight)) {
            return 1;
        }
        pg.translate(idWidth, 0);
        this.scalePanel.drawScale(pg, startRes, endRes, pwidth - idWidth, scaleHeight);
        pg.translate(-idWidth, scaleHeight);
        Color currentColor = null;
        Color currentTextColor = null;
        pg.setFont(this.idPanel.idCanvas.idfont);
        for (int i = startSeq; i < endSeq; ++i) {
            SequenceI seq = this.av.getAlignment().getSequenceAt(i);
            if (this.av.getSelectionGroup() != null && this.av.getSelectionGroup().getSequences(null).contains(seq)) {
                currentColor = Color.gray;
                currentTextColor = Color.black;
            } else {
                currentColor = this.av.getSequenceColour(seq);
                currentTextColor = Color.black;
            }
            pg.setColor(currentColor);
            pg.fillRect(0, (i - startSeq) * this.av.charHeight, idWidth, this.av.getCharHeight());
            pg.setColor(currentTextColor);
            int xPos = 0;
            if (this.av.rightAlignIds) {
                fm = pg.getFontMetrics();
                xPos = idWidth - fm.stringWidth(seq.getDisplayId(this.av.getShowJVSuffix())) - 4;
            }
            pg.drawString(seq.getDisplayId(this.av.getShowJVSuffix()), xPos, (i - startSeq) * this.av.charHeight + this.av.getCharHeight() - this.av.getCharHeight() / 5);
        }
        pg.setFont(this.av.getFont());
        pg.translate(idWidth, 0);
        this.seqPanel.seqCanvas.drawPanel(pg, startRes, endRes, startSeq, endSeq, 0);
        if (this.av.showAnnotation && endSeq == this.av.alignment.getHeight()) {
            pg.translate(-idWidth - 3, (endSeq - startSeq) * this.av.charHeight + 3);
            this.alabels.drawComponent((Graphics2D)pg, idWidth);
            pg.translate(idWidth + 3, 0);
            this.annotationPanel.drawComponent((Graphics2D)pg, startRes, endRes + 1);
        }
        return 0;
    }

    public int printWrappedAlignment(Graphics pg, int pwidth, int pheight, int pi) throws PrinterException {
        int annotationHeight = 0;
        AnnotationLabels labels = null;
        if (this.av.showAnnotation) {
            annotationHeight = this.annotationPanel.adjustPanelHeight();
            labels = new AnnotationLabels(this.av);
        }
        int hgap = this.av.charHeight;
        if (this.av.scaleAboveWrapped) {
            hgap += this.av.charHeight;
        }
        int cHeight = this.av.getAlignment().getHeight() * this.av.charHeight + hgap + annotationHeight;
        int idWidth = this.getVisibleIdWidth();
        int maxwidth = this.av.alignment.getWidth();
        if (this.av.hasHiddenColumns) {
            maxwidth = this.av.getColumnSelection().findColumnPosition(maxwidth) - 1;
        }
        int resWidth = this.seqPanel.seqCanvas.getWrappedCanvasWidth(pwidth - idWidth);
        int totalHeight = cHeight * (maxwidth / resWidth + 1);
        pg.setColor(Color.white);
        pg.fillRect(0, 0, pwidth, pheight);
        pg.setFont(this.av.getFont());
        pg.setColor(Color.black);
        pg.translate(0, -pi * pheight);
        pg.setClip(0, pi * pheight, pwidth, pheight);
        int ypos = hgap;
        do {
            for (int i = 0; i < this.av.alignment.getHeight(); ++i) {
                pg.setFont(this.idPanel.idCanvas.idfont);
                SequenceI s = this.av.alignment.getSequenceAt(i);
                String string = s.getDisplayId(this.av.getShowJVSuffix());
                int xPos = 0;
                if (this.av.rightAlignIds) {
                    FontMetrics fm = pg.getFontMetrics();
                    xPos = idWidth - fm.stringWidth(string) - 4;
                }
                pg.drawString(string, xPos, i * this.av.charHeight + ypos + this.av.charHeight - this.av.charHeight / 5);
            }
            if (labels == null) continue;
            pg.translate(-3, ypos + this.av.getAlignment().getHeight() * this.av.charHeight);
            pg.setFont(this.av.getFont());
            labels.drawComponent(pg, idWidth);
            pg.translate(3, -ypos - this.av.getAlignment().getHeight() * this.av.charHeight);
        } while ((ypos += cHeight) < totalHeight);
        pg.translate(idWidth, 0);
        this.seqPanel.seqCanvas.drawWrappedPanel(pg, pwidth - idWidth, totalHeight, 0);
        if (pi * pheight < totalHeight) {
            return 0;
        }
        return 1;
    }

    int getVisibleIdWidth() {
        return this.idPanel.getWidth() > 0 ? this.idPanel.getWidth() : this.calculateIdWidth().width + 4;
    }

    void makeAlignmentImage(int type, File file) {
        int maxwidth = this.av.alignment.getWidth();
        if (this.av.hasHiddenColumns) {
            maxwidth = this.av.getColumnSelection().findColumnPosition(maxwidth);
        }
        int height = (this.av.alignment.getHeight() + 1) * this.av.charHeight + this.scalePanel.getHeight();
        int width = this.getVisibleIdWidth() + maxwidth * this.av.charWidth;
        if (this.av.getWrapAlignment()) {
            height = this.getWrappedHeight();
            width = System.getProperty("java.awt.headless") != null && System.getProperty("java.awt.headless").equals("true") ? this.alignFrame.getWidth() - this.vscroll.getPreferredSize().width - this.alignFrame.getInsets().left - this.alignFrame.getInsets().right : this.seqPanel.getWidth() + this.getVisibleIdWidth();
        } else if (this.av.getShowAnnotation()) {
            height += this.annotationPanel.adjustPanelHeight() + 3;
        }
        try {
            ImageMaker im = type == 1 ? new ImageMaker(this, 1, "Create PNG image from alignment", width, height, file, null) : new ImageMaker(this, 0, "Create EPS file from alignment", width, height, file, this.alignFrame.getTitle());
            if (this.av.getWrapAlignment()) {
                if (im.getGraphics() != null) {
                    this.printWrappedAlignment(im.getGraphics(), width, height, 0);
                    im.writeImage();
                }
            } else if (im.getGraphics() != null) {
                this.printUnwrapped(im.getGraphics(), width, height, 0);
                im.writeImage();
            }
        }
        catch (OutOfMemoryError err) {
            System.out.println("########################\nOUT OF MEMORY " + file + "\n" + "########################");
            new OOMWarning("Creating Image for " + file, err);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void makeEPS(File epsFile) {
        this.makeAlignmentImage(0, epsFile);
    }

    public void makePNG(File pngFile) {
        this.makeAlignmentImage(1, pngFile);
    }

    public void makePNGImageMap(File imgMapFile, String imageName) {
        int idWidth = this.getVisibleIdWidth();
        FontMetrics fm = this.getFontMetrics(this.av.getFont());
        int scaleHeight = this.av.charHeight + fm.getDescent();
        if (imgMapFile != null) {
            try {
                int sSize = this.av.alignment.getHeight();
                int alwidth = this.av.alignment.getWidth();
                StringBuffer text = new StringBuffer();
                PrintWriter out = new PrintWriter(new FileWriter(imgMapFile));
                out.println(HTMLOutput.getImageMapHTML());
                out.println("<img src=\"" + imageName + "\" border=\"0\" usemap=\"#Map\" >" + "<map name=\"Map\">");
                for (int s = 0; s < sSize; ++s) {
                    int sy = s * this.av.charHeight + scaleHeight;
                    SequenceI seq = this.av.alignment.getSequenceAt(s);
                    SequenceFeature[] features = seq.getDatasetSequence().getSequenceFeatures();
                    SequenceGroup[] groups = this.av.alignment.findAllGroups(seq);
                    for (int res = 0; res < alwidth; ++res) {
                        text = new StringBuffer();
                        Object obj = null;
                        obj = this.av.alignment.isNucleotide() ? (Object)ResidueProperties.nucleotideName.get(seq.getCharAt(res) + "") : (Object)ResidueProperties.aa2Triplet.get(seq.getCharAt(res) + "");
                        if (obj == null) continue;
                        String triplet = obj.toString();
                        int alIndex = seq.findPosition(res);
                        int gSize = groups.length;
                        for (int g = 0; g < gSize; ++g) {
                            if (text.length() < 1) {
                                text.append("<area shape=\"rect\" coords=\"" + (idWidth + res * this.av.charWidth) + "," + sy + "," + (idWidth + (res + 1) * this.av.charWidth) + "," + (this.av.charHeight + sy) + "\"" + " onMouseOver=\"toolTip('" + alIndex + " " + triplet);
                            }
                            if (groups[g].getStartRes() >= res || groups[g].getEndRes() <= res) continue;
                            text.append("<br><em>" + groups[g].getName() + "</em>");
                        }
                        if (features != null) {
                            if (text.length() < 1) {
                                text.append("<area shape=\"rect\" coords=\"" + (idWidth + res * this.av.charWidth) + "," + sy + "," + (idWidth + (res + 1) * this.av.charWidth) + "," + (this.av.charHeight + sy) + "\"" + " onMouseOver=\"toolTip('" + alIndex + " " + triplet);
                            }
                            int fSize = features.length;
                            for (int f = 0; f < fSize; ++f) {
                                if (features[f].getBegin() > seq.findPosition(res) || features[f].getEnd() < seq.findPosition(res)) continue;
                                if (features[f].getType().equals("disulfide bond")) {
                                    if (features[f].getBegin() != seq.findPosition(res) && features[f].getEnd() != seq.findPosition(res)) continue;
                                    text.append("<br>disulfide bond " + features[f].getBegin() + ":" + features[f].getEnd());
                                    continue;
                                }
                                text.append("<br>");
                                text.append(features[f].getType());
                                if (features[f].getDescription() != null && !features[f].getType().equals(features[f].getDescription())) {
                                    text.append(" " + features[f].getDescription());
                                }
                                if (features[f].getValue("status") == null) continue;
                                text.append(" (" + features[f].getValue("status") + ")");
                            }
                        }
                        if (text.length() <= 1) continue;
                        text.append("')\"; onMouseOut=\"toolTip()\";  href=\"#\">");
                        out.println(text.toString());
                    }
                }
                out.println("</map></body></html>");
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    int getWrappedHeight() {
        int seqPanelWidth = this.seqPanel.seqCanvas.getWidth();
        if (System.getProperty("java.awt.headless") != null && System.getProperty("java.awt.headless").equals("true")) {
            seqPanelWidth = this.alignFrame.getWidth() - this.getVisibleIdWidth() - this.vscroll.getPreferredSize().width - this.alignFrame.getInsets().left - this.alignFrame.getInsets().right;
        }
        int chunkWidth = this.seqPanel.seqCanvas.getWrappedCanvasWidth(seqPanelWidth);
        int hgap = this.av.charHeight;
        if (this.av.scaleAboveWrapped) {
            hgap += this.av.charHeight;
        }
        int annotationHeight = 0;
        if (this.av.showAnnotation) {
            annotationHeight = this.annotationPanel.adjustPanelHeight();
        }
        int cHeight = this.av.getAlignment().getHeight() * this.av.charHeight + hgap + annotationHeight;
        int maxwidth = this.av.alignment.getWidth();
        if (this.av.hasHiddenColumns) {
            maxwidth = this.av.getColumnSelection().findColumnPosition(maxwidth) - 1;
        }
        int height = (maxwidth / chunkWidth + 1) * cHeight;
        return height;
    }
}

