/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.AlignSeq;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.AnnotationExporter;
import jalview.gui.Desktop;
import jalview.gui.EditNameDialog;
import jalview.io.FormatAdapter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class AnnotationLabels
extends JPanel
implements MouseListener,
MouseMotionListener,
ActionListener {
    static String ADDNEW = "Add New Row";
    static String EDITNAME = "Edit Label/Description";
    static String HIDE = "Hide This Row";
    static String DELETE = "Delete This Row";
    static String SHOWALL = "Show All Hidden Rows";
    static String OUTPUT_TEXT = "Export Annotation";
    static String COPYCONS_SEQ = "Copy Consensus Sequence";
    boolean resizePanel = false;
    Image image;
    AlignmentPanel ap;
    AlignViewport av;
    boolean resizing = false;
    MouseEvent dragEvent;
    int oldY;
    int selectedRow;
    int scrollOffset = 0;
    Font font = new Font("Arial", 0, 11);

    public AnnotationLabels(AlignmentPanel ap) {
        this.ap = ap;
        this.av = ap.av;
        ToolTipManager.sharedInstance().registerComponent(this);
        URL url = this.getClass().getResource("/images/idwidth.gif");
        Image temp = null;
        if (url != null) {
            temp = Toolkit.getDefaultToolkit().createImage(url);
        }
        try {
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(temp, 0);
            mt.waitForID(0);
        }
        catch (Exception ex) {
            // empty catch block
        }
        BufferedImage bi = new BufferedImage(temp.getHeight(this), temp.getWidth(this), 1);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.rotate(Math.toRadians(90.0));
        g.drawImage(temp, 0, -bi.getWidth(this), this);
        this.image = bi;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public AnnotationLabels(AlignViewport av) {
        this.av = av;
    }

    public void setScrollOffset(int y) {
        this.scrollOffset = y;
        this.repaint();
    }

    void getSelectedRow(int y) {
        int height = 0;
        AlignmentAnnotation[] aa = this.ap.av.alignment.getAlignmentAnnotation();
        if (aa != null) {
            for (int i = 0; i < aa.length; ++i) {
                if (!aa[i].visible || y >= (height += aa[i].height)) continue;
                this.selectedRow = i;
                break;
            }
        }
    }

    public void actionPerformed(ActionEvent evt) {
        SequenceI cons;
        AlignmentAnnotation[] aa = this.ap.av.alignment.getAlignmentAnnotation();
        if (evt.getActionCommand().equals(ADDNEW)) {
            AlignmentAnnotation newAnnotation = new AlignmentAnnotation(null, null, new Annotation[this.ap.av.alignment.getWidth()]);
            if (!this.editLabelDescription(newAnnotation)) {
                return;
            }
            this.ap.av.alignment.addAnnotation(newAnnotation);
            this.ap.av.alignment.setAnnotationIndex(newAnnotation, 0);
        } else if (evt.getActionCommand().equals(EDITNAME)) {
            this.editLabelDescription(aa[this.selectedRow]);
            this.repaint();
        } else if (evt.getActionCommand().equals(HIDE)) {
            aa[this.selectedRow].visible = false;
            if (aa[this.selectedRow].label.equals("Quality")) {
                this.ap.av.quality = null;
            }
        } else if (evt.getActionCommand().equals(DELETE)) {
            this.ap.av.alignment.deleteAnnotation(aa[this.selectedRow]);
        } else if (evt.getActionCommand().equals(SHOWALL)) {
            for (int i = 0; i < aa.length; ++i) {
                if (aa[i].visible || aa[i].annotations == null) continue;
                aa[i].visible = true;
            }
        } else if (evt.getActionCommand().equals(OUTPUT_TEXT)) {
            new AnnotationExporter().exportAnnotations(this.ap, new AlignmentAnnotation[]{aa[this.selectedRow]}, null, null);
        } else if (evt.getActionCommand().equals(COPYCONS_SEQ) && (cons = this.av.getConsensusSeq()) != null) {
            this.copy_annotseqtoclipboard(cons);
        }
        this.ap.annotationPanel.adjustPanelHeight();
        this.ap.annotationScroller.validate();
        this.ap.paintAlignment(true);
    }

    boolean editLabelDescription(AlignmentAnnotation annotation) {
        EditNameDialog dialog = new EditNameDialog(annotation.label, annotation.description, "       Annotation Name ", "Annotation Description ", "Edit Annotation Name/Description");
        if (!dialog.accept) {
            return false;
        }
        annotation.label = dialog.getName();
        String text = dialog.getDescription();
        if (text != null && text.length() == 0) {
            text = null;
        }
        annotation.description = text;
        return true;
    }

    public void mousePressed(MouseEvent evt) {
        this.getSelectedRow(evt.getY() - this.scrollOffset);
        this.oldY = evt.getY();
    }

    public void mouseReleased(MouseEvent evt) {
        int start = this.selectedRow;
        this.getSelectedRow(evt.getY() - this.scrollOffset);
        int end = this.selectedRow;
        if (start != end) {
            AlignmentAnnotation startAA = this.ap.av.alignment.getAlignmentAnnotation()[start];
            AlignmentAnnotation endAA = this.ap.av.alignment.getAlignmentAnnotation()[end];
            this.ap.av.alignment.getAlignmentAnnotation()[end] = startAA;
            this.ap.av.alignment.getAlignmentAnnotation()[start] = endAA;
        }
        this.resizePanel = false;
        this.dragEvent = null;
        this.repaint();
        this.ap.annotationPanel.repaint();
    }

    public void mouseEntered(MouseEvent evt) {
        if (evt.getY() < 10) {
            this.resizePanel = true;
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent evt) {
        if (this.dragEvent == null) {
            this.resizePanel = false;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent evt) {
        this.dragEvent = evt;
        if (this.resizePanel) {
            Dimension d = this.ap.annotationScroller.getPreferredSize();
            int dif = evt.getY() - this.oldY;
            dif /= this.ap.av.charHeight;
            if (d.height - (dif *= this.ap.av.charHeight) > 20) {
                this.ap.annotationScroller.setPreferredSize(new Dimension(d.width, d.height - dif));
                d = this.ap.annotationSpaceFillerHolder.getPreferredSize();
                this.ap.annotationSpaceFillerHolder.setPreferredSize(new Dimension(d.width, d.height - dif));
                this.ap.paintAlignment(true);
            }
            this.ap.addNotify();
        } else {
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent evt) {
        this.resizePanel = evt.getY() < 10;
        this.getSelectedRow(evt.getY() - this.scrollOffset);
        if (this.selectedRow > -1 && this.ap.av.alignment.getAlignmentAnnotation().length > this.selectedRow) {
            AlignmentAnnotation aa = this.ap.av.alignment.getAlignmentAnnotation()[this.selectedRow];
            StringBuffer desc = new StringBuffer("<html>");
            if (aa.description != null && !aa.description.equals("New description")) {
                desc.append(aa.getDescription(true));
                if (aa.hasScore) {
                    desc.append("<br>");
                }
            }
            if (aa.hasScore()) {
                desc.append("Score: " + aa.score);
            }
            if (desc.length() != 6) {
                desc.append("</html>");
                this.setToolTipText(desc.toString());
            } else {
                this.setToolTipText(null);
            }
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (!SwingUtilities.isRightMouseButton(evt)) {
            return;
        }
        AlignmentAnnotation[] aa = this.ap.av.alignment.getAlignmentAnnotation();
        JPopupMenu pop = new JPopupMenu("Annotations");
        JMenuItem item = new JMenuItem(ADDNEW);
        item.addActionListener(this);
        if (aa == null || aa.length == 0) {
            item = new JMenuItem(SHOWALL);
            item.addActionListener(this);
            pop.add(item);
            pop.show(this, evt.getX(), evt.getY());
            return;
        }
        pop.add(item);
        item = new JMenuItem(EDITNAME);
        item.addActionListener(this);
        pop.add(item);
        item = new JMenuItem(HIDE);
        item.addActionListener(this);
        pop.add(item);
        item = new JMenuItem(DELETE);
        item.addActionListener(this);
        pop.add(item);
        item = new JMenuItem(SHOWALL);
        item.addActionListener(this);
        pop.add(item);
        item = new JMenuItem(OUTPUT_TEXT);
        item.addActionListener(this);
        pop.add(item);
        if (this.selectedRow < aa.length && aa[this.selectedRow] == this.ap.av.consensus) {
            pop.addSeparator();
            final JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem("Ignore Gaps In Consensus", this.ap.av.getIgnoreGapsConsensus());
            cbmi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AnnotationLabels.this.ap.av.setIgnoreGapsConsensus(cbmi.getState(), AnnotationLabels.this.ap);
                }
            });
            pop.add(cbmi);
            JMenuItem consclipbrd = new JMenuItem(COPYCONS_SEQ);
            consclipbrd.addActionListener(this);
            pop.add(consclipbrd);
        }
        pop.show(this, evt.getX(), evt.getY());
    }

    protected void copy_annotseqtoclipboard(SequenceI sq) {
        SequenceI[] seqs = new SequenceI[]{sq};
        String[] omitHidden = null;
        SequenceI[] dseqs = new SequenceI[]{sq.getDatasetSequence()};
        if (dseqs[0] == null) {
            dseqs[0] = new Sequence(sq);
            dseqs[0].setSequence(AlignSeq.extractGaps(" .-", sq.getSequenceAsString()));
            sq.setDatasetSequence(dseqs[0]);
        }
        Alignment ds = new Alignment(dseqs);
        if (this.av.hasHiddenColumns) {
            omitHidden = this.av.getColumnSelection().getVisibleSequenceStrings(0, sq.getLength(), seqs);
        }
        String output = new FormatAdapter().formatSequences("Fasta", seqs, omitHidden);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(output), Desktop.instance);
        Vector<int[]> hiddenColumns = null;
        if (this.av.hasHiddenColumns) {
            hiddenColumns = new Vector<int[]>();
            for (int i = 0; i < this.av.getColumnSelection().getHiddenColumns().size(); ++i) {
                int[] region = (int[])this.av.getColumnSelection().getHiddenColumns().elementAt(i);
                hiddenColumns.addElement(new int[]{region[0], region[1]});
            }
        }
        Desktop.jalviewClipboard = new Object[]{seqs, ds, hiddenColumns};
    }

    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        if (width == 0) {
            width = this.ap.calculateIdWidth().width + 4;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.av.antiAlias) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.drawComponent(g2, width);
    }

    public void drawComponent(Graphics g, int width) {
        if (this.av.getFont().getSize() < 10) {
            g.setFont(this.font);
        } else {
            g.setFont(this.av.getFont());
        }
        FontMetrics fm = g.getFontMetrics(g.getFont());
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.translate(0, this.scrollOffset);
        g.setColor(Color.black);
        AlignmentAnnotation[] aa = this.av.alignment.getAlignmentAnnotation();
        int fontHeight = g.getFont().getSize();
        int y = 0;
        int x = 0;
        int graphExtras = 0;
        int offset = 0;
        if (aa != null) {
            for (int i = 0; i < aa.length; ++i) {
                g.setColor(Color.black);
                if (!aa[i].visible) continue;
                y += aa[i].height;
                offset = -aa[i].height / 2;
                if (aa[i].hasText) {
                    offset += fm.getHeight() / 2;
                    offset -= fm.getDescent();
                } else {
                    offset += fm.getDescent();
                }
                x = width - fm.stringWidth(aa[i].label) - 3;
                if (aa[i].graphGroup > -1) {
                    int gg;
                    int groupSize = 0;
                    for (gg = 0; gg < aa.length; ++gg) {
                        if (aa[gg].graphGroup != aa[i].graphGroup) continue;
                        ++groupSize;
                    }
                    if (groupSize * (fontHeight + 8) < aa[i].height) {
                        graphExtras = (aa[i].height - groupSize * (fontHeight + 8)) / 2;
                    }
                    for (gg = 0; gg < aa.length; ++gg) {
                        if (aa[gg].graphGroup != aa[i].graphGroup) continue;
                        x = width - fm.stringWidth(aa[gg].label) - 3;
                        g.drawString(aa[gg].label, x, y - graphExtras);
                        if (aa[gg].annotations[0] != null) {
                            g.setColor(aa[gg].annotations[0].colour);
                        }
                        g.drawLine(x, y - graphExtras - 3, x + fm.stringWidth(aa[gg].label), y - graphExtras - 3);
                        g.setColor(Color.black);
                        graphExtras += fontHeight + 8;
                    }
                    continue;
                }
                g.drawString(aa[i].label, x, y + offset);
            }
        }
        if (this.resizePanel) {
            g.drawImage(this.image, 2, 0 - this.scrollOffset, this);
        } else if (this.dragEvent != null && aa != null) {
            g.setColor(Color.lightGray);
            g.drawString(aa[this.selectedRow].label, this.dragEvent.getX(), this.dragEvent.getY() - this.scrollOffset);
        }
        if (aa == null || aa.length < 1) {
            g.drawString("Right click", 2, 8);
            g.drawString("to add annotation", 2, 18);
        }
    }
}

