/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.gui.ConsoleDocument;
import jalview.gui.EnterListener;
import jalview.gui.ScriptWindow;
import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import org.jmol.api.JmolViewer;

class ConsoleTextPane
extends JTextPane {
    ConsoleDocument consoleDoc = (ConsoleDocument)this.getDocument();
    EnterListener enterListener;
    JmolViewer viewer;

    ConsoleTextPane(ScriptWindow scriptWindow) {
        super(new ConsoleDocument());
        this.consoleDoc.setConsoleTextPane(this);
        this.enterListener = scriptWindow;
        this.viewer = scriptWindow.viewer;
    }

    public String getCommandString() {
        String cmd = this.consoleDoc.getCommandString();
        return cmd;
    }

    public void setPrompt() {
        this.consoleDoc.setPrompt();
    }

    public void appendNewline() {
        this.consoleDoc.appendNewline();
    }

    public void outputError(String strError) {
        this.consoleDoc.outputError(strError);
    }

    public void outputErrorForeground(String strError) {
        this.consoleDoc.outputErrorForeground(strError);
    }

    public void outputEcho(String strEcho) {
        this.consoleDoc.outputEcho(strEcho);
    }

    public void outputStatus(String strStatus) {
        this.consoleDoc.outputStatus(strStatus);
    }

    public void enterPressed() {
        if (this.enterListener != null) {
            this.enterListener.enterPressed();
        }
    }

    public void clearContent() {
        this.clearContent(null);
    }

    public void clearContent(String text) {
        this.consoleDoc.clearContent();
        if (text != null) {
            this.consoleDoc.outputEcho(text);
        }
        this.setPrompt();
    }

    protected void processKeyEvent(KeyEvent ke) {
        if (ke.getKeyCode() == 38 && ke.getID() == 401 && !ke.isControlDown()) {
            this.recallCommand(true);
        } else if (ke.getKeyCode() == 40 && ke.getID() == 401 && !ke.isControlDown()) {
            this.recallCommand(false);
        } else if ((ke.getKeyCode() == 40 || ke.getKeyCode() == 38) && ke.getID() == 401 && ke.isControlDown()) {
            super.processKeyEvent(new KeyEvent((Component)ke.getSource(), ke.getID(), ke.getWhen(), 0, ke.getKeyCode(), ke.getKeyChar(), ke.getKeyLocation()));
        } else {
            super.processKeyEvent(ke);
            if (ke.getID() == 402 && ke.getKeyCode() > 40 || ke.getKeyCode() == 8) {
                this.checkCommand();
            }
        }
    }

    void recallCommand(boolean up) {
        String cmd = this.viewer.getSetHistory(up ? -1 : 1);
        if (cmd == null) {
            return;
        }
        try {
            if (cmd.endsWith("#??")) {
                cmd = cmd.substring(0, cmd.indexOf("#??"));
                this.consoleDoc.replaceCommand(cmd, true);
            } else {
                this.consoleDoc.replaceCommand(cmd, false);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    void checkCommand() {
        String strCommand = this.consoleDoc.getCommandString();
        if (strCommand.length() == 0) {
            return;
        }
        this.consoleDoc.colorCommand(this.viewer.scriptCheck(strCommand) == null ? this.consoleDoc.attUserInput : this.consoleDoc.attError);
    }
}

