/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.Desktop;
import jalview.io.FormatAdapter;
import jalview.io.IdentifyFile;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.jbgui.GCutAndPasteTransfer;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class CutAndPasteTransfer
extends GCutAndPasteTransfer {
    AlignViewport viewport;

    public CutAndPasteTransfer() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CutAndPasteTransfer.this.textarea.requestFocus();
            }
        });
    }

    public void setForInput(AlignViewport viewport) {
        this.viewport = viewport;
        if (viewport != null) {
            this.ok.setText("Add");
        }
        this.getContentPane().add((Component)this.inputButtonPanel, "South");
    }

    public String getText() {
        return this.textarea.getText();
    }

    public void setText(String text) {
        this.textarea.setText(text);
    }

    public void appendText(String text) {
        this.textarea.append(text);
    }

    public void save_actionPerformed(ActionEvent e) {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle("Save Text to File");
        chooser.setToolTipText("Save");
        int value = chooser.showSaveDialog(this);
        if (value == 0) {
            try {
                PrintWriter out = new PrintWriter(new FileWriter(chooser.getSelectedFile()));
                out.print(this.getText());
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void copyItem_actionPerformed(ActionEvent e) {
        this.textarea.getSelectedText();
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        c.setContents(new StringSelection(this.textarea.getSelectedText()), null);
    }

    public void pasteMenu_actionPerformed(ActionEvent e) {
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = c.getContents(this);
        if (contents == null) {
            return;
        }
        try {
            this.textarea.append((String)contents.getTransferData(DataFlavor.stringFlavor));
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void ok_actionPerformed(ActionEvent e) {
        String format = new IdentifyFile().Identify(this.getText(), "Paste");
        Alignment al = null;
        if (FormatAdapter.isValidFormat(format)) {
            try {
                al = new FormatAdapter().readFile(this.getText(), "Paste", format);
            }
            catch (IOException ex) {
                JOptionPane.showInternalMessageDialog(Desktop.desktop, "Couldn't read the pasted text.\n" + ex.toString(), "Error parsing text", 2);
            }
        }
        if (al != null) {
            if (this.viewport != null) {
                for (int i = 0; i < al.getHeight(); ++i) {
                    this.viewport.getAlignment().addSequence(al.getSequenceAt(i));
                }
                this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
            } else {
                AlignFrame af = new AlignFrame(al, 700, 500);
                af.currentFileFormat = format;
                Desktop.addInternalFrame(af, "Cut & Paste input - " + format, 700, 500);
                af.statusBar.setText("Successfully pasted alignment file");
                try {
                    af.setMaximum(Cache.getDefault("SHOW_FULLSCREEN", false));
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public void cancel_actionPerformed(ActionEvent e) {
        try {
            this.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void textarea_mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            JPopupMenu popup = new JPopupMenu("Edit");
            JMenuItem item = new JMenuItem("Copy");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CutAndPasteTransfer.this.copyItem_actionPerformed(e);
                }
            });
            popup.add(item);
            item = new JMenuItem("Paste");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CutAndPasteTransfer.this.pasteMenu_actionPerformed(e);
                }
            });
            popup.add(item);
            popup.show(this, e.getX() + 10, e.getY() + this.textarea.getY() + 40);
        }
    }
}

