/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.gui.Desktop;
import jalview.jbgui.GDasSourceBrowser;
import jalview.util.TableSorter;
import jalview.ws.DasSequenceFeatureFetcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.biojava.dasobert.dasregistry.Das1Source;
import org.biojava.dasobert.dasregistry.DasCoordinateSystem;
import org.biojava.dasobert.dasregistry.DasSource;

public class DasSourceBrowser
extends GDasSourceBrowser
implements Runnable,
ListSelectionListener {
    static DasSource[] dasSources = null;
    Hashtable localSources = null;
    Vector selectedSources;
    public static String DEFAULT_REGISTRY = "http://www.dasregistry.org/das1/sources/";
    public boolean loadingDasSources = false;

    protected static String getDasRegistryURL() {
        String registry = Cache.getDefault("DAS_REGISTRY_URL", DEFAULT_REGISTRY);
        if (registry.indexOf("/registry/das1/sources/") > -1) {
            Cache.setProperty("DAS_REGISTRY_URL", DEFAULT_REGISTRY);
            registry = DEFAULT_REGISTRY;
        }
        return registry;
    }

    public DasSourceBrowser() {
        String registry = DasSourceBrowser.getDasRegistryURL();
        this.registryURL.setText(registry);
        this.setSelectedFromProperties();
        this.displayFullDetails(null);
        this.table.setSelectionMode(0);
        this.filter1.addListSelectionListener(this);
        this.filter2.addListSelectionListener(this);
        this.filter3.addListSelectionListener(this);
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    DasSourceBrowser.this.displayFullDetails(DasSourceBrowser.this.table.getValueAt(selectedRow, 0).toString());
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2 || SwingUtilities.isRightMouseButton(evt)) {
                    DasSourceBrowser.this.editRemoveLocalSource(evt);
                }
            }
        });
        if (dasSources != null) {
            this.init();
        }
    }

    public void paintComponent(Graphics g) {
        if (dasSources == null && !this.loadingDasSources) {
            Thread worker = new Thread(this);
            worker.start();
        }
    }

    void init() {
        int dSize = dasSources.length;
        Object[][] data = new Object[dSize][2];
        for (int i = 0; i < dSize; ++i) {
            data[i][0] = dasSources[i].getNickname();
            data[i][1] = new Boolean(this.selectedSources.contains(dasSources[i].getNickname()));
        }
        this.refreshTableData(data);
        this.setCapabilities(dasSources);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TableSorter sorter = (TableSorter)DasSourceBrowser.this.table.getModel();
                sorter.setSortingStatus(1, -1);
                sorter.setSortingStatus(1, 0);
            }
        });
        this.progressBar.setIndeterminate(false);
        this.progressBar.setVisible(false);
        this.addLocal.setVisible(true);
        this.refresh.setVisible(true);
    }

    public void refreshTableData(Object[][] data) {
        TableSorter sorter = new TableSorter(new DASTableModel(data));
        sorter.setTableHeader(this.table.getTableHeader());
        this.table.setModel(sorter);
    }

    void displayFullDetails(String nickName) {
        StringBuffer text = new StringBuffer("<HTML><font size=\"2\" face=\"Verdana, Arial, Helvetica, sans-serif\">");
        if (nickName == null) {
            this.fullDetails.setText(text + "Select a DAS service from the table" + " to read a full description here.</font></html>");
            return;
        }
        int dSize = dasSources.length;
        for (int i = 0; i < dSize; ++i) {
            if (!dasSources[i].getNickname().equals(nickName)) continue;
            DasSource ds = dasSources[i];
            text.append("<font color=\"#0000FF\">Id:</font> " + dasSources[i].getId() + "<br>");
            text.append("<font color=\"#0000FF\">Nickname:</font> " + dasSources[i].getNickname() + "<br>");
            text.append("<font color=\"#0000FF\">URL:</font> " + dasSources[i].getUrl() + "<br>");
            text.append("<font color=\"#0000FF\">Admin Email:</font> <a href=\"mailto:" + dasSources[i].getAdminemail() + "\">" + dasSources[i].getAdminemail() + "</a>" + "<br>");
            text.append("<font color=\"#0000FF\">Registered at:</font> " + dasSources[i].getRegisterDate() + "<br>");
            text.append("<font color=\"#0000FF\">Last successful test:</font> " + dasSources[i].getLeaseDate() + "<br>");
            text.append("<font color=\"#0000FF\">Labels:</font> ");
            for (int s = 0; s < dasSources[i].getLabels().length; ++s) {
                text.append(dasSources[i].getLabels()[s]);
                if (s < dasSources[i].getLabels().length - 1) {
                    text.append(",");
                }
                text.append(" ");
            }
            text.append("<br>");
            text.append("<font color=\"#0000FF\">Capabilities:</font> ");
            String[] scap = dasSources[i].getCapabilities();
            for (int j = 0; j < scap.length; ++j) {
                text.append(scap[j]);
                if (j >= scap.length - 1) continue;
                text.append(", ");
            }
            text.append("<br>");
            text.append("<font color=\"#0000FF\">Coordinates:</font> ");
            DasCoordinateSystem[] dcs = ds.getCoordinateSystem();
            for (int j = 0; j < dcs.length; ++j) {
                text.append("(" + dcs[j].getUniqueId() + ") " + dcs[j].getCategory() + ", " + dcs[j].getName());
                if (dcs[j].getNCBITaxId() != 0) {
                    text.append(", " + dcs[j].getNCBITaxId());
                }
                if (dcs[j].getOrganismName().length() > 0) {
                    text.append(", " + dcs[j].getOrganismName());
                }
                text.append("<br>");
            }
            text.append("<font color=\"#0000FF\">Description:</font> " + dasSources[i].getDescription() + "<br>");
            if (dasSources[i].getHelperurl() != null && dasSources[i].getHelperurl().length() > 0) {
                text.append("<font color=\"#0000FF\"><a href=\"" + dasSources[i].getHelperurl() + "\">Go to site</a></font<br>");
            }
            text.append("</font></html>");
            break;
        }
        this.fullDetails.setText(text.toString());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DasSourceBrowser.this.fullDetailsScrollpane.getVerticalScrollBar().setValue(0);
            }
        });
    }

    public void run() {
        this.loadingDasSources = true;
        this.addLocal.setVisible(false);
        this.refresh.setVisible(false);
        this.progressBar.setVisible(true);
        this.progressBar.setIndeterminate(true);
        dasSources = null;
        this.getDASSource();
        this.init();
        this.loadingDasSources = false;
    }

    public Vector getSelectedSources() {
        Vector<DasSource> selected = new Vector<DasSource>();
        block0: for (int r = 0; r < this.selectedSources.size(); ++r) {
            for (int i = 0; i < dasSources.length; ++i) {
                if (!dasSources[i].getNickname().equals(this.selectedSources.elementAt(r))) continue;
                selected.addElement(dasSources[i]);
                continue block0;
            }
        }
        return selected;
    }

    public DasSource[] getDASSource() {
        if (dasSources == null) {
            dasSources = DasSequenceFeatureFetcher.getDASSources();
            this.appendLocalSources();
        }
        return dasSources;
    }

    public void refresh_actionPerformed(ActionEvent e) {
        this.saveProperties(Cache.applicationProperties);
        Thread worker = new Thread(this);
        worker.start();
    }

    private void setCapabilities(DasSource[] sources) {
        Vector<String> authority = new Vector<String>();
        Vector<String> type = new Vector<String>();
        Vector<String> label = new Vector<String>();
        authority.addElement("Any");
        type.addElement("Any");
        label.addElement("Any");
        for (int i = 0; i < sources.length; ++i) {
            DasSource ds = sources[i];
            DasCoordinateSystem[] dcs = ds.getCoordinateSystem();
            for (int j = 0; j < dcs.length; ++j) {
                if (!type.contains(dcs[j].getCategory())) {
                    type.addElement(dcs[j].getCategory());
                }
                if (authority.contains(dcs[j].getName())) continue;
                authority.addElement(dcs[j].getName());
            }
            String[] slabels = ds.getLabels();
            for (int s = 0; s < slabels.length; ++s) {
                if (label.contains(slabels[s])) continue;
                label.addElement(slabels[s]);
            }
        }
        this.filter1.setListData(authority);
        this.filter2.setListData(type);
        this.filter3.setListData(label);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DasSourceBrowser.this.filter1.setSelectedIndex(0);
                DasSourceBrowser.this.filter2.setSelectedIndex(0);
                DasSourceBrowser.this.filter3.setSelectedIndex(0);
            }
        });
    }

    public void amendLocal(boolean newSource) {
        String url = "http://localhost:8080/";
        String nickname = "";
        if (!newSource) {
            int selectedRow = this.table.getSelectionModel().getMinSelectionIndex();
            nickname = this.table.getValueAt(selectedRow, 0).toString();
            url = ((DasSource)this.localSources.get(nickname)).getUrl();
        }
        JTextField nametf = new JTextField(nickname, 40);
        JTextField urltf = new JTextField(url, 40);
        JPanel panel = new JPanel(new BorderLayout());
        JPanel pane12 = new JPanel(new BorderLayout());
        pane12.add((Component)new JLabel("Nickname: "), "Center");
        pane12.add((Component)nametf, "East");
        panel.add((Component)pane12, "North");
        pane12 = new JPanel(new BorderLayout());
        pane12.add((Component)new JLabel("URL: "), "Center");
        pane12.add((Component)urltf, "East");
        panel.add((Component)pane12, "South");
        int reply = JOptionPane.showInternalConfirmDialog(Desktop.desktop, panel, "Enter Nickname & URL of Local DAS Source", 2);
        if (reply != 0) {
            return;
        }
        if (!urltf.getText().endsWith("/")) {
            urltf.setText(urltf.getText() + "/");
        }
        Das1Source local = new Das1Source();
        local.setUrl(urltf.getText());
        local.setNickname(nametf.getText());
        if (this.localSources == null) {
            this.localSources = new Hashtable();
        }
        this.localSources.put(local.getNickname(), local);
        if (!newSource && !nickname.equals(nametf.getText())) {
            this.localSources.remove(nickname);
        }
        int size = dasSources.length;
        int adjust = newSource ? 1 : 0;
        Object[][] data = new Object[size + adjust][2];
        for (int i = 0; i < size; ++i) {
            if (!newSource && dasSources[i].getNickname().equals(nickname)) {
                dasSources[i].setNickname(local.getNickname());
                dasSources[i].setUrl(local.getUrl());
                data[i][0] = local.getNickname();
                data[i][1] = new Boolean(true);
                continue;
            }
            data[i][0] = dasSources[i].getNickname();
            data[i][1] = new Boolean(this.selectedSources.contains(dasSources[i].getNickname()));
        }
        if (newSource) {
            data[size][0] = local.getNickname();
            data[size][1] = new Boolean(true);
            this.selectedSources.add(local.getNickname());
        }
        DasSource[] tmp = new DasSource[size + adjust];
        System.arraycopy(dasSources, 0, tmp, 0, size);
        if (newSource) {
            tmp[size] = local;
        }
        dasSources = tmp;
        this.refreshTableData(data);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DasSourceBrowser.this.scrollPane.getVerticalScrollBar().setValue(DasSourceBrowser.this.scrollPane.getVerticalScrollBar().getMaximum());
            }
        });
        this.displayFullDetails(local.getNickname());
    }

    public void editRemoveLocalSource(MouseEvent evt) {
        int selectedRow = this.table.getSelectionModel().getMinSelectionIndex();
        if (selectedRow == -1) {
            return;
        }
        String nickname = this.table.getValueAt(selectedRow, 0).toString();
        if (!this.localSources.containsKey(nickname)) {
            JOptionPane.showInternalMessageDialog(Desktop.desktop, "You can only edit or remove local DAS Sources!", "Public DAS source - not editable", 2);
            return;
        }
        Object[] options = new Object[]{"Edit", "Remove", "Cancel"};
        int choice = JOptionPane.showInternalOptionDialog(Desktop.desktop, "Do you want to edit or remove " + nickname + "?", "Edit / Remove Local DAS Source", 1, 3, null, options, options[2]);
        switch (choice) {
            case 0: {
                this.amendLocal(false);
                break;
            }
            case 1: {
                this.localSources.remove(nickname);
                this.selectedSources.remove(nickname);
                Object[][] data = new Object[dasSources.length - 1][2];
                DasSource[] tmp = new DasSource[dasSources.length - 1];
                int index = 0;
                for (int i = 0; i < dasSources.length; ++i) {
                    if (dasSources[i].getNickname().equals(nickname)) continue;
                    tmp[index] = dasSources[i];
                    data[index][0] = dasSources[i].getNickname();
                    data[index][1] = new Boolean(this.selectedSources.contains(dasSources[i].getNickname()));
                    ++index;
                }
                dasSources = tmp;
                this.refreshTableData(data);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DasSourceBrowser.this.scrollPane.getVerticalScrollBar().setValue(DasSourceBrowser.this.scrollPane.getVerticalScrollBar().getMaximum());
                    }
                });
            }
        }
    }

    void appendLocalSources() {
        if (this.localSources == null) {
            return;
        }
        int size = dasSources != null ? dasSources.length : 0;
        int lsize = this.localSources.size();
        Object[][] data = new Object[size + lsize][2];
        for (int i = 0; i < size; ++i) {
            data[i][0] = dasSources[i].getNickname();
            data[i][1] = new Boolean(this.selectedSources.contains(dasSources[i].getNickname()));
        }
        DasSource[] tmp = new DasSource[size + lsize];
        if (dasSources != null) {
            System.arraycopy(dasSources, 0, tmp, 0, size);
        }
        Enumeration en = this.localSources.keys();
        int index = size;
        while (en.hasMoreElements()) {
            String key = en.nextElement().toString();
            data[index][0] = key;
            data[index][1] = new Boolean(false);
            tmp[index] = new Das1Source();
            tmp[index].setNickname(key);
            tmp[index].setUrl(((DasSource)this.localSources.get(key)).getUrl());
            ++index;
        }
        dasSources = tmp;
        this.refreshTableData(data);
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        this.displayFullDetails(null);
        int dSize = dasSources.length;
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Boolean> selected = new ArrayList<Boolean>();
        Object[] dummyFeatureList = new Object[]{"features"};
        block0: for (int i = 0; i < dSize; ++i) {
            DasSource ds = dasSources[i];
            DasCoordinateSystem[] dcs = ds.getCoordinateSystem();
            if (dcs.length == 0 && ds.getCapabilities().length == 0 && this.filter1.getSelectedIndex() == 0 && this.filter2.getSelectedIndex() == 0 && this.filter3.getSelectedIndex() == 0) {
                names.add(ds.getNickname());
                selected.add(new Boolean(this.selectedSources.contains(ds.getNickname())));
                continue;
            }
            if (!this.selectedInList(dummyFeatureList, ds.getCapabilities()) || !this.selectedInList(this.filter3.getSelectedValues(), ds.getLabels())) continue;
            for (int j = 0; j < dcs.length; ++j) {
                if (!this.selectedInList(this.filter1.getSelectedValues(), new String[]{dcs[j].getName()}) || !this.selectedInList(this.filter2.getSelectedValues(), new String[]{dcs[j].getCategory()})) continue;
                names.add(ds.getNickname());
                selected.add(new Boolean(this.selectedSources.contains(ds.getNickname())));
                continue block0;
            }
        }
        dSize = names.size();
        Object[][] data = new Object[dSize][2];
        for (int d = 0; d < dSize; ++d) {
            data[d][0] = names.get(d);
            data[d][1] = selected.get(d);
        }
        this.refreshTableData(data);
    }

    boolean selectedInList(Object[] selection, String[] items) {
        for (int i = 0; i < selection.length; ++i) {
            if (selection[i].equals("Any")) {
                return true;
            }
            for (int j = 0; j < items.length; ++j) {
                if (!selection[i].equals(items[j])) continue;
                return true;
            }
        }
        return false;
    }

    void setSelectedFromProperties() {
        String active = Cache.getDefault("DAS_ACTIVE_SOURCE", "uniprot");
        StringTokenizer st = new StringTokenizer(active, "\t");
        this.selectedSources = new Vector();
        while (st.hasMoreTokens()) {
            this.selectedSources.addElement(st.nextToken());
        }
        String local = Cache.getProperty("DAS_LOCAL_SOURCE");
        if (local != null) {
            if (this.localSources == null) {
                this.localSources = new Hashtable();
            }
            st = new StringTokenizer(local, "\t");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int bar = token.indexOf("|");
                Das1Source source = new Das1Source();
                source.setUrl(token.substring(bar + 1));
                source.setNickname(token.substring(0, bar));
                this.localSources.put(source.getNickname(), source);
            }
        }
    }

    public void reset_actionPerformed(ActionEvent e) {
        this.registryURL.setText(DEFAULT_REGISTRY);
    }

    public void saveProperties(Properties properties) {
        if (this.registryURL.getText() == null || this.registryURL.getText().length() < 1) {
            properties.remove("DAS_REGISTRY_URL");
        } else {
            properties.setProperty("DAS_REGISTRY_URL", this.registryURL.getText());
        }
        StringBuffer sb = new StringBuffer();
        for (int r = 0; r < this.table.getModel().getRowCount(); ++r) {
            if (!((Boolean)this.table.getValueAt(r, 1)).booleanValue()) continue;
            sb.append(this.table.getValueAt(r, 0) + "\t");
        }
        properties.setProperty("DAS_ACTIVE_SOURCE", sb.toString());
        if (this.localSources != null) {
            sb = new StringBuffer();
            Enumeration en = this.localSources.keys();
            while (en.hasMoreElements()) {
                String token = en.nextElement().toString();
                sb.append(token + "|" + ((DasSource)this.localSources.get(token)).getUrl() + "\t");
            }
            properties.setProperty("DAS_LOCAL_SOURCE", sb.toString());
        }
    }

    class DASTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Nickname", "Use Source"};
        private Object[][] data;

        public DASTableModel(Object[][] data) {
            this.data = data;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
            String name = this.getValueAt(row, 0).toString();
            boolean selected = (Boolean)value;
            if (DasSourceBrowser.this.selectedSources.contains(name) && !selected) {
                DasSourceBrowser.this.selectedSources.remove(name);
            }
            if (!DasSourceBrowser.this.selectedSources.contains(name) && selected) {
                DasSourceBrowser.this.selectedSources.add(name);
            }
        }
    }
}

