/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.IProgressIndicator;
import jalview.gui.Jalview2XML;
import jalview.gui.PCAPanel;
import jalview.gui.PaintRefresher;
import jalview.gui.PairwiseAlignPanel;
import jalview.gui.Preferences;
import jalview.gui.SequenceFetcher;
import jalview.gui.SplashScreen;
import jalview.gui.TreePanel;
import jalview.gui.UserQuestionnaireCheck;
import jalview.gui.VamsasApplication;
import jalview.io.AppletFormatAdapter;
import jalview.io.FileLoader;
import jalview.io.FormatAdapter;
import jalview.io.IdentifyFile;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.jbgui.GDesktop;
import jalview.ws.Discoverer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class Desktop
extends GDesktop
implements DropTargetListener,
ClipboardOwner,
IProgressIndicator {
    public static Desktop instance;
    public static MyDesktopPane desktop;
    static int openFrameCount;
    static final int xOffset = 30;
    static final int yOffset = 30;
    public static Discoverer discoverer;
    public static Object[] jalviewClipboard;
    public static boolean internalCopy;
    static int fileLoadingCount;
    JPanel progressPanel;
    int totalProgressCount = 0;
    VamsasApplication v_client = null;
    JProgressBar vamUpdate = null;
    protected JMenuItem groovyShell;
    private Hashtable progressBars;

    public Desktop() {
        instance = this;
        this.doVamsasClientCheck();
        this.doGroovyCheck();
        this.setTitle("Jalview " + Cache.getProperty("VERSION"));
        this.setDefaultCloseOperation(3);
        boolean selmemusage = Cache.getDefault("SHOW_MEMUSAGE", false);
        desktop = new MyDesktopPane(selmemusage);
        this.showMemusage.setSelected(selmemusage);
        desktop.setBackground(Color.white);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)desktop, "Center");
        desktop.setDragMode(1);
        desktop.setDesktopManager(new DefaultDesktopManager());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        String x = Cache.getProperty("SCREEN_X");
        String y = Cache.getProperty("SCREEN_Y");
        String width = Cache.getProperty("SCREEN_WIDTH");
        String height = Cache.getProperty("SCREEN_HEIGHT");
        if (x != null && y != null && width != null && height != null) {
            this.setBounds(Integer.parseInt(x), Integer.parseInt(y), Integer.parseInt(width), Integer.parseInt(height));
        } else {
            this.setBounds((screenSize.width - 900) / 2, (screenSize.height - 650) / 2, 900, 650);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Desktop.this.quit();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (SwingUtilities.isRightMouseButton(evt)) {
                    Desktop.this.showPasteMenu(evt.getX(), evt.getY());
                }
            }
        });
        this.setDropTarget(new DropTarget(desktop, this));
        new SplashScreen();
        discoverer = new Discoverer();
    }

    private void doVamsasClientCheck() {
        if (Cache.vamsasJarsPresent()) {
            this.setupVamsasDisconnectedGui();
            this.VamsasMenu.setVisible(true);
            final Desktop us = this;
            this.VamsasMenu.addMenuListener(new MenuListener(){
                boolean refresh = true;

                public void menuCanceled(MenuEvent e) {
                    this.refresh = true;
                }

                public void menuDeselected(MenuEvent e) {
                    this.refresh = true;
                }

                public void menuSelected(MenuEvent e) {
                    if (this.refresh) {
                        us.buildVamsasStMenu();
                        this.refresh = false;
                    }
                }
            });
            this.vamsasStart.setVisible(true);
        }
    }

    void showPasteMenu(int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem item = new JMenuItem("Paste To New Window");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Desktop.this.paste();
            }
        });
        popup.add(item);
        popup.show(this, x, y);
    }

    public void paste() {
        try {
            Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = c.getContents(this);
            if (contents != null) {
                String file = (String)contents.getTransferData(DataFlavor.stringFlavor);
                String format = new IdentifyFile().Identify(file, FormatAdapter.PASTE);
                new FileLoader().LoadFile(file, FormatAdapter.PASTE, format);
            }
        }
        catch (Exception ex) {
            System.out.println("Unable to paste alignment from system clipboard:\n" + ex);
        }
    }

    public static synchronized void addInternalFrame(JInternalFrame frame, String title, int w, int h) {
        Desktop.addInternalFrame(frame, title, w, h, true);
    }

    public static synchronized void addInternalFrame(final JInternalFrame frame, String title, int w, int h, boolean resizable) {
        frame.setTitle(title);
        if (frame.getWidth() < 1 || frame.getHeight() < 1) {
            frame.setSize(w, h);
        }
        if (System.getProperty("java.awt.headless") != null && System.getProperty("java.awt.headless").equals("true")) {
            return;
        }
        ++openFrameCount;
        frame.setVisible(true);
        frame.setClosable(true);
        frame.setResizable(resizable);
        frame.setMaximizable(resizable);
        frame.setIconifiable(resizable);
        frame.setFrameIcon(null);
        if (frame.getX() < 1 && frame.getY() < 1) {
            frame.setLocation(30 * openFrameCount, 30 * ((openFrameCount - 1) % 10) + 30);
        }
        final JMenuItem menuItem = new JMenuItem(title);
        frame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameActivated(InternalFrameEvent evt) {
                JInternalFrame itf = desktop.getSelectedFrame();
                if (itf != null) {
                    itf.requestFocus();
                }
            }

            public void internalFrameClosed(InternalFrameEvent evt) {
                PaintRefresher.RemoveComponent(frame);
                --openFrameCount;
                windowMenu.remove(menuItem);
                JInternalFrame itf = desktop.getSelectedFrame();
                if (itf != null) {
                    itf.requestFocus();
                }
                System.gc();
            }
        });
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    frame.setSelected(true);
                    frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
        windowMenu.add(menuItem);
        desktop.add(frame);
        frame.toFront();
        try {
            frame.setSelected(true);
            frame.requestFocus();
        }
        catch (PropertyVetoException ve) {
            // empty catch block
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        if (!internalCopy) {
            jalviewClipboard = null;
        }
        internalCopy = false;
    }

    public void dragEnter(DropTargetDragEvent evt) {
    }

    public void dragExit(DropTargetEvent evt) {
    }

    public void dragOver(DropTargetDragEvent evt) {
    }

    public void dropActionChanged(DropTargetDragEvent evt) {
    }

    public void drop(DropTargetDropEvent evt) {
        Transferable t = evt.getTransferable();
        ArrayList<File> files = null;
        try {
            DataFlavor uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                evt.acceptDrop(3);
                files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            } else if (t.isDataFlavorSupported(uriListFlavor)) {
                evt.acceptDrop(3);
                String data = (String)t.getTransferData(uriListFlavor);
                files = new ArrayList<File>(1);
                StringTokenizer st = new StringTokenizer(data, "\r\n");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    if (s.startsWith("#")) continue;
                    URI uri = new URI(s);
                    File file = new File(uri);
                    files.add(file);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (files != null) {
            try {
                for (int i = 0; i < files.size(); ++i) {
                    String file = files.get(i).toString();
                    String protocol = FormatAdapter.FILE;
                    String format = null;
                    format = file.endsWith(".jar") ? "Jalview" : new IdentifyFile().Identify(file, protocol);
                    new FileLoader().LoadFile(file, protocol, format);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void inputLocalFileMenuItem_actionPerformed(AlignViewport viewport) {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"), AppletFormatAdapter.READABLE_EXTENSIONS, AppletFormatAdapter.READABLE_FNAMES, Cache.getProperty("DEFAULT_FILE_FORMAT"));
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle("Open local file");
        chooser.setToolTipText("Open");
        int value = chooser.showOpenDialog(this);
        if (value == 0) {
            String choice = chooser.getSelectedFile().getPath();
            Cache.setProperty("LAST_DIRECTORY", chooser.getSelectedFile().getParent());
            String format = null;
            format = chooser.getSelectedFormat().equals("Jalview") ? "Jalview" : new IdentifyFile().Identify(choice, FormatAdapter.FILE);
            if (viewport != null) {
                new FileLoader().LoadFile(viewport, choice, FormatAdapter.FILE, format);
            } else {
                new FileLoader().LoadFile(choice, FormatAdapter.FILE, format);
            }
        }
    }

    public void inputURLMenuItem_actionPerformed(AlignViewport viewport) {
        int reply;
        JLabel label = new JLabel("Enter URL of Input File");
        JComboBox<Object> history = new JComboBox<Object>();
        JPanel panel = new JPanel(new GridLayout(2, 1));
        panel.add(label);
        panel.add(history);
        history.setPreferredSize(new Dimension(400, 20));
        history.setEditable(true);
        history.addItem("http://www.");
        String historyItems = Cache.getProperty("RECENT_URL");
        if (historyItems != null) {
            StringTokenizer st = new StringTokenizer(historyItems, "\t");
            while (st.hasMoreTokens()) {
                history.addItem(st.nextElement());
            }
        }
        if ((reply = JOptionPane.showInternalConfirmDialog(desktop, panel, "Input Alignment From URL", 2)) != 0) {
            return;
        }
        String url = history.getSelectedItem().toString();
        if (url.toLowerCase().endsWith(".jar")) {
            if (viewport != null) {
                new FileLoader().LoadFile(viewport, url, FormatAdapter.URL, "Jalview");
            } else {
                new FileLoader().LoadFile(url, FormatAdapter.URL, "Jalview");
            }
        } else {
            String format = new IdentifyFile().Identify(url, FormatAdapter.URL);
            if (format.equals("URL NOT FOUND")) {
                JOptionPane.showInternalMessageDialog(desktop, "Couldn't locate " + url, "URL not found", 2);
                return;
            }
            if (viewport != null) {
                new FileLoader().LoadFile(viewport, url, FormatAdapter.URL, format);
            } else {
                new FileLoader().LoadFile(url, FormatAdapter.URL, format);
            }
        }
    }

    public void inputTextboxMenuItem_actionPerformed(AlignViewport viewport) {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        cap.setForInput(viewport);
        Desktop.addInternalFrame(cap, "Cut & Paste Alignment File", 600, 500);
    }

    public void quit() {
        Cache.setProperty("SCREEN_X", this.getBounds().x + "");
        Cache.setProperty("SCREEN_Y", this.getBounds().y + "");
        Cache.setProperty("SCREEN_WIDTH", this.getWidth() + "");
        Cache.setProperty("SCREEN_HEIGHT", this.getHeight() + "");
        System.exit(0);
    }

    public void aboutMenuItem_actionPerformed(ActionEvent e) {
        StringBuffer message = new StringBuffer("Jalview version " + Cache.getProperty("VERSION") + "; last updated: " + Cache.getDefault("BUILD_DATE", "unknown"));
        if (!Cache.getProperty("LATEST_VERSION").equals(Cache.getProperty("VERSION"))) {
            message.append("\n\n!! Jalview version " + Cache.getProperty("LATEST_VERSION") + " is available for download from http://www.jalview.org !!\n");
        }
        message.append("\nAuthors:  Andrew Waterhouse, Jim Procter, Michele Clamp, James Cuff, Steve Searle,\n    David Martin & Geoff Barton.\nDevelopment managed by The Barton Group, University of Dundee, Scotland, UK.\n\nFor help, see the FAQ at www.jalview.org and/or join the jalview-discuss@jalview.org mailing list\n\nIf  you use Jalview, please cite:\nWaterhouse, A.M., Procter, J.B., Martin, D.M.A, Clamp, M. and Barton, G. J. (2009)\nJalview Version 2 - a multiple sequence alignment editor and analysis workbench\nBioinformatics doi: 10.1093/bioinformatics/btp033");
        JOptionPane.showInternalMessageDialog(desktop, message.toString(), "About Jalview", 1);
    }

    public void documentationMenuItem_actionPerformed(ActionEvent e) {
        try {
            ClassLoader cl = Desktop.class.getClassLoader();
            URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)"help/help");
            HelpSet hs = new HelpSet(cl, url);
            HelpBroker hb = hs.createHelpBroker();
            hb.setCurrentID("home");
            hb.setDisplayed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeAll_actionPerformed(ActionEvent e) {
        JInternalFrame[] frames = desktop.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            try {
                frames[i].setClosed(true);
                continue;
            }
            catch (PropertyVetoException ex) {
                // empty catch block
            }
        }
        System.out.println("ALL CLOSED");
    }

    public void raiseRelated_actionPerformed(ActionEvent e) {
        this.reorderAssociatedWindows(false, false);
    }

    public void minimizeAssociated_actionPerformed(ActionEvent e) {
        this.reorderAssociatedWindows(true, false);
    }

    void closeAssociatedWindows() {
        this.reorderAssociatedWindows(false, true);
    }

    protected void garbageCollect_actionPerformed(ActionEvent e) {
        Cache.log.debug((Object)"Collecting garbage...");
        System.gc();
        Cache.log.debug((Object)"Finished garbage collection.");
    }

    protected void showMemusage_actionPerformed(ActionEvent e) {
        desktop.showMemoryUsage(this.showMemusage.isSelected());
    }

    void reorderAssociatedWindows(boolean minimize, boolean close) {
        JInternalFrame[] frames = desktop.getAllFrames();
        if (frames == null || frames.length < 1) {
            return;
        }
        AlignViewport source = null;
        AlignViewport target = null;
        if (frames[0] instanceof AlignFrame) {
            source = ((AlignFrame)frames[0]).getCurrentView();
        } else if (frames[0] instanceof TreePanel) {
            source = ((TreePanel)frames[0]).getViewPort();
        } else if (frames[0] instanceof PCAPanel) {
            source = ((PCAPanel)frames[0]).av;
        } else if (frames[0].getContentPane() instanceof PairwiseAlignPanel) {
            source = ((PairwiseAlignPanel)frames[0].getContentPane()).av;
        }
        if (source != null) {
            for (int i = 0; i < frames.length; ++i) {
                target = null;
                if (frames[i] == null) continue;
                if (frames[i] instanceof AlignFrame) {
                    target = ((AlignFrame)frames[i]).getCurrentView();
                } else if (frames[i] instanceof TreePanel) {
                    target = ((TreePanel)frames[i]).getViewPort();
                } else if (frames[i] instanceof PCAPanel) {
                    target = ((PCAPanel)frames[i]).av;
                } else if (frames[i].getContentPane() instanceof PairwiseAlignPanel) {
                    target = ((PairwiseAlignPanel)frames[i].getContentPane()).av;
                }
                if (source != target) continue;
                try {
                    if (close) {
                        frames[i].setClosed(true);
                        continue;
                    }
                    frames[i].setIcon(minimize);
                    if (minimize) continue;
                    frames[i].toFront();
                    continue;
                }
                catch (PropertyVetoException ex) {
                    // empty catch block
                }
            }
        }
    }

    protected void preferences_actionPerformed(ActionEvent e) {
        new Preferences();
    }

    public void saveState_actionPerformed(ActionEvent e) {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"), new String[]{"jar"}, new String[]{"Jalview Project"}, "Jalview Project");
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle("Save State");
        int value = chooser.showSaveDialog(this);
        if (value == 0) {
            File choice = chooser.getSelectedFile();
            Cache.setProperty("LAST_DIRECTORY", choice.getParent());
            new Jalview2XML().SaveState(choice);
        }
    }

    public void loadState_actionPerformed(ActionEvent e) {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"), new String[]{"jar"}, new String[]{"Jalview Project"}, "Jalview Project");
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle("Restore state");
        int value = chooser.showOpenDialog(this);
        if (value == 0) {
            String choice = chooser.getSelectedFile().getAbsolutePath();
            Cache.setProperty("LAST_DIRECTORY", chooser.getSelectedFile().getParent());
            new Jalview2XML().LoadJalviewAlign(choice);
        }
    }

    public void inputSequence_actionPerformed(ActionEvent e) {
        new SequenceFetcher(this);
    }

    public void startLoading(String fileName) {
        if (fileLoadingCount == 0) {
            this.addProgressPanel("Loading File: " + fileName + "   ");
        }
        ++fileLoadingCount;
    }

    private JProgressBar addProgressPanel(String string) {
        if (this.progressPanel == null) {
            this.progressPanel = new JPanel(new BorderLayout());
            this.totalProgressCount = 0;
        }
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        this.progressPanel.add((Component)new JLabel(string), "West");
        this.progressPanel.add((Component)progressBar, "Center");
        instance.getContentPane().add((Component)this.progressPanel, "South");
        ++this.totalProgressCount;
        this.validate();
        return progressBar;
    }

    private void removeProgressPanel(JProgressBar progbar) {
        if (this.progressPanel != null) {
            this.progressPanel.remove(progbar);
            if (--this.totalProgressCount < 1) {
                this.getContentPane().remove(this.progressPanel);
                this.progressPanel = null;
            }
        }
        this.validate();
    }

    public void stopLoading() {
        if (--fileLoadingCount < 1) {
            if (this.progressPanel != null) {
                this.getContentPane().remove(this.progressPanel);
                this.progressPanel = null;
            }
            fileLoadingCount = 0;
        }
        this.validate();
    }

    public static int getViewCount(String viewId) {
        int count = 0;
        JInternalFrame[] frames = desktop.getAllFrames();
        for (int t = 0; t < frames.length; ++t) {
            if (!(frames[t] instanceof AlignFrame)) continue;
            AlignFrame af = (AlignFrame)frames[t];
            for (int a = 0; a < af.alignPanels.size(); ++a) {
                if (!viewId.equals(((AlignmentPanel)af.alignPanels.elementAt((int)a)).av.getSequenceSetId())) continue;
                ++count;
            }
        }
        return count;
    }

    public void explodeViews(AlignFrame af) {
        int size = af.alignPanels.size();
        if (size < 2) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            AlignmentPanel ap = (AlignmentPanel)af.alignPanels.elementAt(i);
            AlignFrame newaf = new AlignFrame(ap);
            if (ap.av.explodedPosition != null && !ap.av.explodedPosition.equals(af.getBounds())) {
                newaf.setBounds(ap.av.explodedPosition);
            }
            ap.av.gatherViewsHere = false;
            Desktop.addInternalFrame(newaf, af.getTitle(), 700, 500);
        }
        af.alignPanels.clear();
        af.closeMenuItem_actionPerformed(true);
    }

    public void gatherViews(AlignFrame source) {
        source.viewport.gatherViewsHere = true;
        source.viewport.explodedPosition = source.getBounds();
        JInternalFrame[] frames = desktop.getAllFrames();
        String viewId = source.viewport.sequenceSetID;
        for (int t = 0; t < frames.length; ++t) {
            if (!(frames[t] instanceof AlignFrame) || frames[t] == source) continue;
            AlignFrame af = (AlignFrame)frames[t];
            boolean gatherThis = false;
            for (int a = 0; a < af.alignPanels.size(); ++a) {
                AlignmentPanel ap = (AlignmentPanel)af.alignPanels.elementAt(a);
                if (!viewId.equals(ap.av.getSequenceSetId())) continue;
                gatherThis = true;
                ap.av.gatherViewsHere = false;
                ap.av.explodedPosition = af.getBounds();
                source.addAlignmentPanel(ap, false);
            }
            if (!gatherThis) continue;
            af.alignPanels.clear();
            af.closeMenuItem_actionPerformed(true);
        }
    }

    public void vamsasImport_actionPerformed(ActionEvent e) {
        if (this.v_client == null) {
            JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
            chooser.setFileView(new JalviewFileView());
            chooser.setDialogTitle("Open a saved VAMSAS session");
            chooser.setToolTipText("select a vamsas session to be opened as a new vamsas session.");
            int value = chooser.showOpenDialog(this);
            if (value == 0) {
                try {
                    this.v_client = new VamsasApplication(this, chooser.getSelectedFile());
                }
                catch (Exception ex) {
                    Cache.log.error((Object)"New vamsas session from existing session file failed:", (Throwable)ex);
                    return;
                }
                this.setupVamsasConnectedGui();
                this.v_client.initial_update();
            }
        } else {
            Cache.log.error((Object)"Implementation error - load session from a running session is not supported.");
        }
    }

    public void vamsasStart_actionPerformed(ActionEvent e) {
        if (this.v_client == null) {
            this.v_client = new VamsasApplication(this);
            this.setupVamsasConnectedGui();
            this.v_client.initial_update();
        } else {
            this.v_client.push_update();
        }
    }

    protected void setupVamsasConnectedGui() {
        this.vamsasStart.setText("Session Update");
        this.vamsasSave.setVisible(true);
        this.vamsasStop.setVisible(true);
        this.vamsasImport.setVisible(false);
    }

    protected void setupVamsasDisconnectedGui() {
        this.vamsasSave.setVisible(false);
        this.vamsasStop.setVisible(false);
        this.vamsasImport.setVisible(true);
        this.vamsasStart.setText("New Vamsas Session");
    }

    public void vamsasStop_actionPerformed(ActionEvent e) {
        if (this.v_client != null) {
            this.v_client.end_session();
            this.v_client = null;
            this.setupVamsasDisconnectedGui();
        }
    }

    protected void buildVamsasStMenu() {
        if (this.v_client == null) {
            String[] sess = null;
            try {
                sess = VamsasApplication.getSessionList();
            }
            catch (Exception e) {
                Cache.log.warn((Object)"Problem getting current sessions list.", (Throwable)e);
                sess = null;
            }
            if (sess != null) {
                Cache.log.debug((Object)("Got current sessions list: " + sess.length + " entries."));
                this.VamsasStMenu.removeAll();
                for (int i = 0; i < sess.length; ++i) {
                    JMenuItem sessit = new JMenuItem();
                    sessit.setText(sess[i]);
                    sessit.setToolTipText("Connect to session " + sess[i]);
                    final Desktop dsktp = this;
                    final String mysesid = sess[i];
                    sessit.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            if (dsktp.v_client == null) {
                                Thread rthr = new Thread(new Runnable(){

                                    public void run() {
                                        (this).dsktp.v_client = new VamsasApplication(dsktp, mysesid);
                                        dsktp.setupVamsasConnectedGui();
                                        (this).dsktp.v_client.initial_update();
                                    }
                                });
                                rthr.start();
                            }
                        }
                    });
                    this.VamsasStMenu.add(sessit);
                }
                this.VamsasStMenu.setVisible(sess.length > 0);
            } else {
                Cache.log.debug((Object)"No current vamsas sessions.");
                this.VamsasStMenu.removeAll();
                this.VamsasStMenu.setVisible(false);
            }
        } else {
            this.VamsasStMenu.setVisible(false);
        }
    }

    public void vamsasSave_actionPerformed(ActionEvent e) {
        if (this.v_client != null) {
            JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"), new String[]{"vdj"}, new String[]{"Vamsas Document"}, "Vamsas Document");
            chooser.setFileView(new JalviewFileView());
            chooser.setDialogTitle("Save Vamsas Document Archive");
            int value = chooser.showSaveDialog(this);
            if (value == 0) {
                File choice = chooser.getSelectedFile();
                Cache.setProperty("LAST_DIRECTORY", choice.getParent());
                String warnmsg = null;
                String warnttl = null;
                try {
                    this.v_client.vclient.storeDocument(choice);
                }
                catch (Error ex) {
                    warnttl = "Serious Problem saving Vamsas Document";
                    warnmsg = ex.toString();
                    Cache.log.error((Object)("Error Whilst saving document to " + choice), (Throwable)ex);
                }
                catch (Exception ex) {
                    warnttl = "Problem saving Vamsas Document.";
                    warnmsg = ex.toString();
                    Cache.log.warn((Object)("Exception Whilst saving document to " + choice), (Throwable)ex);
                }
                if (warnmsg != null) {
                    JOptionPane.showInternalMessageDialog(desktop, warnmsg, warnttl, 0);
                }
            }
        }
    }

    public void setVamsasUpdate(boolean b) {
        Cache.log.debug((Object)("Setting gui for Vamsas update " + (b ? "in progress" : "finished")));
        if (this.vamUpdate != null) {
            this.removeProgressPanel(this.vamUpdate);
        }
        if (b) {
            this.vamUpdate = this.addProgressPanel("Updating vamsas session");
        }
        this.vamsasStart.setVisible(!b);
        this.vamsasStop.setVisible(!b);
        this.vamsasSave.setVisible(!b);
    }

    public JInternalFrame[] getAllFrames() {
        return desktop.getAllFrames();
    }

    public void checkForQuestionnaire(String url) {
        UserQuestionnaireCheck jvq = new UserQuestionnaireCheck(url);
        new Thread(jvq).start();
    }

    public void doGroovyCheck() {
        if (Cache.groovyJarsPresent()) {
            this.groovyShell = new JMenuItem();
            this.groovyShell.setText("Groovy Console...");
            this.groovyShell.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Desktop.this.groovyShell_actionPerformed(e);
                }
            });
            this.toolsMenu.add(this.groovyShell);
            this.groovyShell.setVisible(true);
        }
    }

    public static AlignFrame[] getAlignframes() {
        JInternalFrame[] frames = desktop.getAllFrames();
        if (frames == null) {
            return null;
        }
        Vector<AlignFrame> avp = new Vector<AlignFrame>();
        try {
            for (int i = frames.length - 1; i > -1; --i) {
                if (!(frames[i] instanceof AlignFrame)) continue;
                AlignFrame af = (AlignFrame)frames[i];
                avp.addElement(af);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (avp.size() == 0) {
            return null;
        }
        AlignFrame[] afs = new AlignFrame[avp.size()];
        int j = avp.size();
        for (int i = 0; i < j; ++i) {
            afs[i] = (AlignFrame)avp.elementAt(i);
        }
        avp.clear();
        return afs;
    }

    public void groovyShell_actionPerformed(ActionEvent e) {
        if (!Cache.groovyJarsPresent()) {
            throw new Error("Implementation Error. Cannot create groovyShell without Groovy on the classpath!");
        }
        try {
            Class<?> gcClass = Desktop.class.getClassLoader().loadClass("groovy.ui.Console");
            Constructor<?> gccons = gcClass.getConstructor(null);
            Method setvar = gcClass.getMethod("setVariable", String.class, Object.class);
            Method run = gcClass.getMethod("run", null);
            Object gc = gccons.newInstance(null);
            setvar.invoke(gc, "Jalview", this);
            run.invoke(gc, null);
        }
        catch (Exception ex) {
            Cache.log.error((Object)"Groovy Shell Creation failed.", (Throwable)ex);
            JOptionPane.showInternalMessageDialog(desktop, "Couldn't create the groovy Shell. Check the error log for the details of what went wrong.", "Jalview Groovy Support Failed", 0);
        }
    }

    public void setProgressBar(String message, long id) {
        if (this.progressBars == null) {
            this.progressBars = new Hashtable();
        }
        if (this.progressBars.get(new Long(id)) != null) {
            JProgressBar progressPanel = (JProgressBar)this.progressBars.remove(new Long(id));
            this.removeProgressPanel(progressPanel);
        } else {
            this.progressBars.put(new Long(id), this.addProgressPanel(message));
        }
    }

    static {
        openFrameCount = 0;
        internalCopy = false;
        fileLoadingCount = 0;
    }

    public class MyDesktopPane
    extends JDesktopPane
    implements Runnable {
        boolean showMemoryUsage = false;
        Runtime runtime;
        NumberFormat df;
        float maxMemory;
        float allocatedMemory;
        float freeMemory;
        float totalFreeMemory;
        float percentUsage;

        public MyDesktopPane(boolean showMemoryUsage) {
            this.showMemoryUsage(showMemoryUsage);
        }

        public void showMemoryUsage(boolean showMemoryUsage) {
            this.showMemoryUsage = showMemoryUsage;
            if (showMemoryUsage) {
                Thread worker = new Thread(this);
                worker.start();
            }
        }

        public boolean isShowMemoryUsage() {
            return this.showMemoryUsage;
        }

        public void run() {
            this.df = NumberFormat.getNumberInstance();
            this.df.setMaximumFractionDigits(2);
            this.runtime = Runtime.getRuntime();
            while (this.showMemoryUsage) {
                try {
                    this.maxMemory = (float)this.runtime.maxMemory() / 1048576.0f;
                    this.allocatedMemory = (float)this.runtime.totalMemory() / 1048576.0f;
                    this.freeMemory = (float)this.runtime.freeMemory() / 1048576.0f;
                    this.totalFreeMemory = this.freeMemory + (this.maxMemory - this.allocatedMemory);
                    this.percentUsage = this.totalFreeMemory / this.maxMemory * 100.0f;
                    this.repaint();
                    Thread.sleep(3000L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public void paintComponent(Graphics g) {
            if (this.showMemoryUsage) {
                if (this.percentUsage < 20.0f) {
                    g.setColor(Color.red);
                }
                g.drawString("Total Free Memory: " + this.df.format(this.totalFreeMemory) + "MB; Max Memory: " + this.df.format(this.maxMemory) + "MB; " + this.df.format(this.percentUsage) + "%", 10, this.getHeight() - g.getFontMetrics().getHeight());
            }
        }
    }
}

