/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.datamodel.SearchResults;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.io.FeaturesFile;
import jalview.schemes.UserColourScheme;
import jalview.util.Comparison;
import jalview.util.QuickSort;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FeatureRenderer {
    AlignmentPanel ap;
    AlignViewport av;
    Color resBoxColour;
    float transparency = 1.0f;
    FontMetrics fm;
    int charOffset;
    Hashtable featureColours = new Hashtable();
    Hashtable featureGroups = new Hashtable();
    Object currentColour;
    String[] renderOrder;
    PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    Vector allfeatures;
    BufferedImage offscreenImage;
    boolean offscreenRender = false;
    SequenceI lastSeq;
    SequenceFeature[] sequenceFeatures;
    int sfSize;
    int sfindex;
    int spos;
    int epos;
    char s;
    int i;
    boolean newFeatureAdded = false;
    boolean findingFeatures = false;
    protected Boolean firing = Boolean.FALSE;
    static String lastFeatureAdded;
    static String lastFeatureGroupAdded;
    static String lastDescriptionAdded;
    int featureIndex = 0;
    Hashtable featureOrder = null;

    public FeatureRenderer(AlignmentPanel ap) {
        this.ap = ap;
        this.av = ap.av;
    }

    public FeatureRendererSettings getSettings() {
        return new FeatureRendererSettings(this);
    }

    public void transferSettings(FeatureRendererSettings fr) {
        this.renderOrder = fr.renderOrder;
        this.featureGroups = fr.featureGroups;
        this.featureColours = fr.featureColours;
        this.transparency = fr.transparency;
        this.featureOrder = fr.featureOrder;
    }

    public void transferSettings(FeatureRenderer fr) {
        this.renderOrder = fr.renderOrder;
        this.featureGroups = fr.featureGroups;
        this.featureColours = fr.featureColours;
        this.transparency = fr.transparency;
        this.featureOrder = fr.featureOrder;
    }

    public Color findFeatureColour(Color initialCol, SequenceI seq, int res) {
        return new Color(this.findFeatureColour(initialCol.getRGB(), seq, res));
    }

    public int findFeatureColour(int initialCol, SequenceI seq, int column) {
        if (!this.av.showSequenceFeatures) {
            return initialCol;
        }
        if (seq != this.lastSeq) {
            this.lastSeq = seq;
            this.sequenceFeatures = this.lastSeq.getDatasetSequence().getSequenceFeatures();
            if (this.sequenceFeatures != null) {
                this.sfSize = this.sequenceFeatures.length;
            }
        }
        if (this.sequenceFeatures != this.lastSeq.getDatasetSequence().getSequenceFeatures()) {
            this.sequenceFeatures = this.lastSeq.getDatasetSequence().getSequenceFeatures();
            if (this.sequenceFeatures != null) {
                this.sfSize = this.sequenceFeatures.length;
            }
        }
        if (this.sequenceFeatures == null || this.sfSize == 0) {
            return initialCol;
        }
        if (Comparison.isGap(this.lastSeq.getCharAt(column))) {
            return Color.white.getRGB();
        }
        if (this.transparency != 1.0f && this.offscreenImage == null) {
            this.offscreenImage = new BufferedImage(1, 1, 2);
        }
        this.currentColour = null;
        this.offscreenRender = true;
        if (this.offscreenImage != null) {
            this.offscreenImage.setRGB(0, 0, initialCol);
            this.drawSequence(this.offscreenImage.getGraphics(), this.lastSeq, column, column, 0);
            return this.offscreenImage.getRGB(0, 0);
        }
        this.drawSequence(null, this.lastSeq, this.lastSeq.findPosition(column), -1, -1);
        if (this.currentColour == null) {
            return initialCol;
        }
        return (Integer)this.currentColour;
    }

    public synchronized void drawSequence(Graphics g, SequenceI seq, int start, int end, int y1) {
        if (seq.getDatasetSequence().getSequenceFeatures() == null || seq.getDatasetSequence().getSequenceFeatures().length == 0) {
            return;
        }
        if (g != null) {
            this.fm = g.getFontMetrics();
        }
        if (this.av.featuresDisplayed == null || this.renderOrder == null || this.newFeatureAdded) {
            this.findAllFeatures();
            if (this.av.featuresDisplayed.size() < 1) {
                return;
            }
            this.sequenceFeatures = seq.getDatasetSequence().getSequenceFeatures();
        }
        if (this.lastSeq == null || seq != this.lastSeq || seq.getDatasetSequence().getSequenceFeatures() != this.sequenceFeatures) {
            this.lastSeq = seq;
            this.sequenceFeatures = seq.getDatasetSequence().getSequenceFeatures();
        }
        if (this.transparency != 1.0f && g != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(AlphaComposite.getInstance(3, this.transparency));
        }
        if (!this.offscreenRender) {
            this.spos = this.lastSeq.findPosition(start);
            this.epos = this.lastSeq.findPosition(end);
        }
        this.sfSize = this.sequenceFeatures.length;
        for (int renderIndex = 0; renderIndex < this.renderOrder.length; ++renderIndex) {
            String type = this.renderOrder[renderIndex];
            if (type == null || !this.av.featuresDisplayed.containsKey(type)) continue;
            this.sfindex = 0;
            while (this.sfindex < this.sfSize) {
                if (this.sequenceFeatures[this.sfindex].type.equals(type) && (this.featureGroups == null || this.sequenceFeatures[this.sfindex].featureGroup == null || this.sequenceFeatures[this.sfindex].featureGroup.length() == 0 || !this.featureGroups.containsKey(this.sequenceFeatures[this.sfindex].featureGroup) || ((Boolean)this.featureGroups.get(this.sequenceFeatures[this.sfindex].featureGroup)).booleanValue()) && (this.offscreenRender || this.sequenceFeatures[this.sfindex].getBegin() <= this.epos && this.sequenceFeatures[this.sfindex].getEnd() >= this.spos)) {
                    if (this.offscreenRender && this.offscreenImage == null) {
                        if (this.sequenceFeatures[this.sfindex].begin <= start && this.sequenceFeatures[this.sfindex].end >= start) {
                            this.currentColour = this.av.featuresDisplayed.get(this.sequenceFeatures[this.sfindex].type);
                        }
                    } else if (this.sequenceFeatures[this.sfindex].type.equals("disulfide bond")) {
                        this.renderFeature(g, seq, seq.findIndex(this.sequenceFeatures[this.sfindex].begin) - 1, seq.findIndex(this.sequenceFeatures[this.sfindex].begin) - 1, new Color((Integer)this.av.featuresDisplayed.get(this.sequenceFeatures[this.sfindex].type)), start, end, y1);
                        this.renderFeature(g, seq, seq.findIndex(this.sequenceFeatures[this.sfindex].end) - 1, seq.findIndex(this.sequenceFeatures[this.sfindex].end) - 1, new Color((Integer)this.av.featuresDisplayed.get(this.sequenceFeatures[this.sfindex].type)), start, end, y1);
                    } else {
                        this.renderFeature(g, seq, seq.findIndex(this.sequenceFeatures[this.sfindex].begin) - 1, seq.findIndex(this.sequenceFeatures[this.sfindex].end) - 1, this.getColour(this.sequenceFeatures[this.sfindex].type), start, end, y1);
                    }
                }
                ++this.sfindex;
            }
        }
        if (this.transparency != 1.0f && g != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }

    void renderFeature(Graphics g, SequenceI seq, int fstart, int fend, Color featureColour, int start, int end, int y1) {
        if (fstart <= end && fend >= start) {
            if (fstart < start) {
                fstart = start;
            }
            if (fend >= end) {
                fend = end;
            }
            int pady = y1 + this.av.charHeight - this.av.charHeight / 5;
            this.i = fstart;
            while (this.i <= fend) {
                this.s = seq.getCharAt(this.i);
                if (!Comparison.isGap(this.s)) {
                    g.setColor(featureColour);
                    g.fillRect((this.i - start) * this.av.charWidth, y1, this.av.charWidth, this.av.charHeight);
                    if (!this.offscreenRender && this.av.validCharWidth) {
                        g.setColor(Color.white);
                        this.charOffset = (this.av.charWidth - this.fm.charWidth(this.s)) / 2;
                        g.drawString(String.valueOf(this.s), this.charOffset + this.av.charWidth * (this.i - start), pady);
                    }
                }
                ++this.i;
            }
        }
    }

    public void featuresAdded() {
        this.lastSeq = null;
        this.findAllFeatures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void findAllFeatures() {
        Boolean bl = this.firing;
        synchronized (bl) {
            if (this.firing.equals(Boolean.FALSE)) {
                this.firing = Boolean.TRUE;
                this.findAllFeatures(true);
                this.changeSupport.firePropertyChange("changeSupport", null, null);
                this.firing = Boolean.FALSE;
            }
        }
    }

    synchronized void findAllFeatures(boolean newMadeVisible) {
        int i;
        this.newFeatureAdded = false;
        if (this.findingFeatures) {
            this.newFeatureAdded = true;
            return;
        }
        this.findingFeatures = true;
        if (this.av.featuresDisplayed == null) {
            this.av.featuresDisplayed = new Hashtable();
        }
        this.allfeatures = new Vector();
        Vector<String> oldfeatures = new Vector<String>();
        if (this.renderOrder != null) {
            for (i = 0; i < this.renderOrder.length; ++i) {
                if (this.renderOrder[i] == null) continue;
                oldfeatures.addElement(this.renderOrder[i]);
            }
        }
        for (i = 0; i < this.av.alignment.getHeight(); ++i) {
            SequenceFeature[] features = this.av.alignment.getSequenceAt(i).getDatasetSequence().getSequenceFeatures();
            if (features == null) continue;
            int index = 0;
            while (index < features.length) {
                if (!this.av.featuresDisplayed.containsKey(features[index].getType())) {
                    boolean visible;
                    if (this.featureGroups.containsKey(features[index].getType()) && !(visible = ((Boolean)this.featureGroups.get(features[index].featureGroup)).booleanValue())) {
                        ++index;
                        continue;
                    }
                    if ((features[index].begin != 0 || features[index].end != 0) && newMadeVisible && !oldfeatures.contains(features[index].getType())) {
                        this.av.featuresDisplayed.put(features[index].getType(), new Integer(this.getColour(features[index].getType()).getRGB()));
                        this.setOrder(features[index].getType(), 0.0f);
                    }
                }
                if (!this.allfeatures.contains(features[index].getType())) {
                    this.allfeatures.addElement(features[index].getType());
                }
                ++index;
            }
        }
        this.updateRenderOrder(this.allfeatures);
        this.findingFeatures = false;
    }

    private void updateRenderOrder(Vector allFeatures) {
        int i;
        Vector allfeatures = new Vector(allFeatures);
        String[] oldRender = this.renderOrder;
        this.renderOrder = new String[allfeatures.size()];
        boolean initOrders = this.featureOrder == null;
        int opos = 0;
        if (oldRender != null && oldRender.length > 0) {
            for (int j = 0; j < oldRender.length; ++j) {
                if (oldRender[j] == null) continue;
                if (initOrders) {
                    this.setOrder(oldRender[j], 1.0f - (1.0f + (float)j) / (float)oldRender.length);
                }
                if (!allfeatures.contains(oldRender[j])) continue;
                this.renderOrder[opos++] = oldRender[j];
                allfeatures.removeElement(oldRender[j]);
            }
        }
        if (allfeatures.size() == 0) {
            return;
        }
        int iSize = i = allfeatures.size() - 1;
        boolean sort = false;
        Object[] newf = new String[allfeatures.size()];
        float[] sortOrder = new float[allfeatures.size()];
        Enumeration en = allfeatures.elements();
        while (en.hasMoreElements()) {
            newf[i] = en.nextElement().toString();
            if (initOrders || !this.featureOrder.containsKey(newf[i])) {
                int denom = initOrders ? allfeatures.size() : this.featureOrder.size();
                this.setOrder((String)newf[i], (float)i / (float)denom);
            }
            sortOrder[i] = 2.0f - ((Float)this.featureOrder.get(newf[i])).floatValue();
            if (i < iSize) {
                sort = sort || sortOrder[i] > sortOrder[i + 1];
            }
            --i;
        }
        if (iSize > 1 && sort) {
            QuickSort.sort(sortOrder, newf);
        }
        sortOrder = null;
        System.arraycopy(newf, 0, this.renderOrder, opos, newf.length);
    }

    public Color getColour(String featureType) {
        if (!this.featureColours.containsKey(featureType)) {
            UserColourScheme ucs = new UserColourScheme();
            Color col = ucs.createColourFromName(featureType);
            this.featureColours.put(featureType, col);
            return col;
        }
        return (Color)this.featureColours.get(featureType);
    }

    boolean amendFeatures(final SequenceI[] sequences, final SequenceFeature[] features, boolean newFeatures, final AlignmentPanel ap) {
        this.featureIndex = 0;
        JPanel bigPanel = new JPanel(new BorderLayout());
        final JTextField name = new JTextField(25);
        final JTextField source = new JTextField(25);
        final JTextArea description = new JTextArea(3, 25);
        final JSpinner start = new JSpinner();
        final JSpinner end = new JSpinner();
        start.setPreferredSize(new Dimension(80, 20));
        end.setPreferredSize(new Dimension(80, 20));
        final JPanel colour = new JPanel();
        colour.setBorder(BorderFactory.createEtchedBorder());
        colour.setMaximumSize(new Dimension(40, 10));
        colour.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Color col = JColorChooser.showDialog(Desktop.desktop, "Select Feature Colour", colour.getBackground());
                if (col != null) {
                    colour.setBackground(col);
                }
            }
        });
        JPanel tmp = new JPanel();
        JPanel panel = new JPanel(new GridLayout(3, 1));
        if (!newFeatures && features.length > 1) {
            panel = new JPanel(new GridLayout(4, 1));
            tmp = new JPanel();
            tmp.add(new JLabel("Select Feature: "));
            final JComboBox<String> overlaps = new JComboBox<String>();
            for (int i = 0; i < features.length; ++i) {
                overlaps.addItem(features[i].getType() + "/" + features[i].getBegin() + "-" + features[i].getEnd() + " (" + features[i].getFeatureGroup() + ")");
            }
            tmp.add(overlaps);
            overlaps.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    Color col;
                    int index = overlaps.getSelectedIndex();
                    if (index != -1) {
                        FeatureRenderer.this.featureIndex = index;
                        name.setText(features[index].getType());
                        description.setText(features[index].getDescription());
                        source.setText(features[index].getFeatureGroup());
                        start.setValue(new Integer(features[index].getBegin()));
                        end.setValue(new Integer(features[index].getEnd()));
                        SearchResults highlight = new SearchResults();
                        highlight.addResult(sequences[0], features[index].getBegin(), features[index].getEnd());
                        ap.seqPanel.seqCanvas.highlightSearchResults(highlight);
                    }
                    if ((col = FeatureRenderer.this.getColour(name.getText())) == null) {
                        col = new UserColourScheme().createColourFromName(name.getText());
                    }
                    colour.setBackground(col);
                }
            });
            panel.add(tmp);
        }
        tmp = new JPanel();
        panel.add(tmp);
        tmp.add(new JLabel("Name: ", 4));
        tmp.add(name);
        tmp = new JPanel();
        panel.add(tmp);
        tmp.add(new JLabel("Group: ", 4));
        tmp.add(source);
        tmp = new JPanel();
        panel.add(tmp);
        tmp.add(new JLabel("Colour: ", 4));
        tmp.add(colour);
        colour.setPreferredSize(new Dimension(150, 15));
        bigPanel.add((Component)panel, "North");
        panel = new JPanel();
        panel.add(new JLabel("Description: ", 4));
        description.setFont(new Font("Verdana", 0, 11));
        description.setLineWrap(true);
        panel.add(new JScrollPane(description));
        if (!newFeatures) {
            bigPanel.add((Component)panel, "South");
            panel = new JPanel();
            panel.add(new JLabel(" Start:", 4));
            panel.add(start);
            panel.add(new JLabel("  End:", 4));
            panel.add(end);
            bigPanel.add((Component)panel, "Center");
        } else {
            bigPanel.add((Component)panel, "Center");
        }
        if (lastFeatureAdded == null) {
            lastFeatureAdded = features[0].type != null ? features[0].type : "feature_1";
        }
        if (lastFeatureGroupAdded == null) {
            lastFeatureGroupAdded = features[0].featureGroup != null ? features[0].featureGroup : "Jalview";
        }
        if (newFeatures) {
            name.setText(lastFeatureAdded);
            source.setText(lastFeatureGroupAdded);
        } else {
            name.setText(features[0].getType());
            source.setText(features[0].getFeatureGroup());
        }
        start.setValue(new Integer(features[0].getBegin()));
        end.setValue(new Integer(features[0].getEnd()));
        description.setText(features[0].getDescription());
        colour.setBackground(this.getColour(name.getText()));
        Object[] options = !newFeatures ? new Object[]{"Amend", "Delete", "Cancel"} : new Object[]{"OK", "Cancel"};
        String title = newFeatures ? "Create New Sequence Feature(s)" : "Amend/Delete Features for " + sequences[0].getName();
        int reply = JOptionPane.showInternalOptionDialog(Desktop.desktop, bigPanel, title, 1, 3, null, options, "OK");
        FeaturesFile ffile = new FeaturesFile();
        if (reply == 0 && name.getText().length() > 0) {
            this.lastSeq = null;
            lastFeatureAdded = name.getText().trim();
            lastFeatureGroupAdded = source.getText().trim();
            lastDescriptionAdded = description.getText().replaceAll("\n", " ");
            if (lastFeatureGroupAdded.length() < 1) {
                lastFeatureGroupAdded = null;
            }
        }
        if (!newFeatures) {
            SequenceFeature sf = features[this.featureIndex];
            if (reply == 1) {
                sequences[0].getDatasetSequence().deleteFeature(sf);
            } else if (reply == 0) {
                sf.type = lastFeatureAdded;
                sf.featureGroup = lastFeatureGroupAdded;
                sf.description = lastDescriptionAdded;
                this.setColour(sf.type, colour.getBackground());
                this.av.featuresDisplayed.put(sf.type, new Integer(colour.getBackground().getRGB()));
                try {
                    sf.begin = (Integer)start.getValue();
                    sf.end = (Integer)end.getValue();
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                ffile.parseDescriptionHTML(sf, false);
            }
        } else {
            if (reply == 0 && lastFeatureAdded.length() > 0) {
                for (int i = 0; i < sequences.length; ++i) {
                    features[i].type = lastFeatureAdded;
                    if (lastFeatureGroupAdded != null) {
                        features[i].featureGroup = lastFeatureGroupAdded;
                    }
                    features[i].description = lastDescriptionAdded;
                    sequences[i].addSequenceFeature(features[i]);
                    ffile.parseDescriptionHTML(features[i], false);
                }
                if (this.av.featuresDisplayed == null) {
                    this.av.featuresDisplayed = new Hashtable();
                }
                if (lastFeatureGroupAdded != null) {
                    if (this.featureGroups == null) {
                        this.featureGroups = new Hashtable();
                    }
                    this.featureGroups.put(lastFeatureGroupAdded, new Boolean(true));
                }
                Color col = colour.getBackground();
                this.setColour(lastFeatureAdded, colour.getBackground());
                this.av.featuresDisplayed.put(lastFeatureAdded, new Integer(col.getRGB()));
                this.findAllFeatures(false);
                ap.paintAlignment(true);
                return true;
            }
            return false;
        }
        ap.paintAlignment(true);
        return true;
    }

    public void setColour(String featureType, Color col) {
        this.featureColours.put(featureType, col);
    }

    public void setTransparency(float value) {
        this.transparency = value;
    }

    public float getTransparency() {
        return this.transparency;
    }

    public void setFeaturePriority(Object[][] data) {
        this.setFeaturePriority(data, true);
    }

    public void setFeaturePriority(Object[][] data, boolean visibleNew) {
        if (visibleNew) {
            if (this.av.featuresDisplayed != null) {
                this.av.featuresDisplayed.clear();
            } else {
                this.av.featuresDisplayed = new Hashtable();
            }
        }
        if (data == null) {
            return;
        }
        this.renderOrder = new String[data.length];
        if (data.length > 0) {
            for (int i = 0; i < data.length; ++i) {
                String type = data[i][0].toString();
                this.setColour(type, (Color)data[i][1]);
                if (((Boolean)data[i][2]).booleanValue()) {
                    this.av.featuresDisplayed.put(type, new Integer(this.getColour(type).getRGB()));
                }
                this.renderOrder[data.length - i - 1] = type;
            }
        }
    }

    public float setOrder(String type, float position) {
        if (this.featureOrder == null) {
            this.featureOrder = new Hashtable();
        }
        this.featureOrder.put(type, new Float(position));
        return position;
    }

    public float getOrder(String type) {
        if (this.featureOrder != null && this.featureOrder.containsKey(type)) {
            return ((Float)this.featureOrder.get(type)).floatValue();
        }
        return -1.0f;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public class FeatureRendererSettings
    implements Cloneable {
        String[] renderOrder;
        Hashtable featureGroups;
        Hashtable featureColours;
        float transparency;
        Hashtable featureOrder;

        public FeatureRendererSettings(String[] renderOrder, Hashtable featureGroups, Hashtable featureColours, float transparency, Hashtable featureOrder) {
            this.renderOrder = renderOrder;
            this.featureGroups = featureGroups;
            this.featureColours = featureColours;
            this.transparency = transparency;
            this.featureOrder = featureOrder;
        }

        public FeatureRendererSettings(FeatureRenderer fr) {
            this.renderOrder = fr.renderOrder;
            this.featureGroups = fr.featureGroups;
            this.featureColours = fr.featureColours;
            this.transparency = fr.transparency;
            this.featureOrder = fr.featureOrder;
        }
    }
}

