/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.TreePanel;
import jalview.jbgui.GFontChooser;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;

public class FontChooser
extends GFontChooser {
    AlignmentPanel ap;
    TreePanel tp;
    Font oldFont;
    boolean init = true;
    JInternalFrame frame;

    public FontChooser(TreePanel tp) {
        this.tp = tp;
        this.ap = tp.treeCanvas.ap;
        this.oldFont = tp.getTreeFont();
        this.defaultButton.setVisible(false);
        this.smoothFont.setEnabled(false);
        this.init();
    }

    public FontChooser(AlignmentPanel ap) {
        this.oldFont = ap.av.getFont();
        this.ap = ap;
        this.init();
    }

    void init() {
        int i;
        this.frame = new JInternalFrame();
        this.frame.setContentPane(this);
        this.smoothFont.setSelected(this.ap.av.antiAlias);
        if (this.tp != null) {
            Desktop.addInternalFrame(this.frame, "Change Font (Tree Panel)", 340, 170, false);
        } else {
            Desktop.addInternalFrame(this.frame, "Change Font", 340, 170, false);
        }
        this.frame.setLayer(JLayeredPane.PALETTE_LAYER);
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (i = 0; i < fonts.length; ++i) {
            this.fontName.addItem(fonts[i]);
        }
        for (i = 1; i < 51; ++i) {
            this.fontSize.addItem(i + "");
        }
        this.fontStyle.addItem("plain");
        this.fontStyle.addItem("bold");
        this.fontStyle.addItem("italic");
        this.fontName.setSelectedItem(this.oldFont.getName());
        this.fontSize.setSelectedItem(this.oldFont.getSize() + "");
        this.fontStyle.setSelectedIndex(this.oldFont.getStyle());
        FontMetrics fm = this.getGraphics().getFontMetrics(this.oldFont);
        this.monospaced.setSelected(fm.getStringBounds("M", this.getGraphics()).getWidth() == fm.getStringBounds("|", this.getGraphics()).getWidth());
        this.init = false;
    }

    public void smoothFont_actionPerformed(ActionEvent e) {
        this.ap.av.antiAlias = this.smoothFont.isSelected();
        this.ap.annotationPanel.image = null;
        this.ap.paintAlignment(true);
    }

    protected void ok_actionPerformed(ActionEvent e) {
        try {
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.ap != null && this.ap.getOverviewPanel() != null) {
            this.ap.getOverviewPanel().updateOverviewImage();
        }
    }

    protected void cancel_actionPerformed(ActionEvent e) {
        if (this.ap != null) {
            this.ap.av.setFont(this.oldFont);
            this.ap.paintAlignment(true);
        } else if (this.tp != null) {
            this.tp.setTreeFont(this.oldFont);
        }
        this.fontName.setSelectedItem(this.oldFont.getName());
        this.fontSize.setSelectedItem(this.oldFont.getSize() + "");
        this.fontStyle.setSelectedIndex(this.oldFont.getStyle());
        try {
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void changeFont() {
        Font newFont = new Font(this.fontName.getSelectedItem().toString(), this.fontStyle.getSelectedIndex(), Integer.parseInt(this.fontSize.getSelectedItem().toString()));
        if (this.tp != null) {
            this.tp.setTreeFont(newFont);
        } else if (this.ap != null) {
            this.ap.av.setFont(newFont);
            this.ap.fontChanged();
        }
        FontMetrics fm = this.getGraphics().getFontMetrics(newFont);
        this.monospaced.setSelected(fm.getStringBounds("M", this.getGraphics()).getWidth() == fm.getStringBounds("|", this.getGraphics()).getWidth());
    }

    protected void fontName_actionPerformed(ActionEvent e) {
        if (this.init) {
            return;
        }
        this.changeFont();
    }

    protected void fontSize_actionPerformed(ActionEvent e) {
        if (this.init) {
            return;
        }
        this.changeFont();
    }

    protected void fontStyle_actionPerformed(ActionEvent e) {
        if (this.init) {
            return;
        }
        this.changeFont();
    }

    public void defaultButton_actionPerformed(ActionEvent e) {
        Cache.setProperty("FONT_NAME", this.fontName.getSelectedItem().toString());
        Cache.setProperty("FONT_STYLE", this.fontStyle.getSelectedIndex() + "");
        Cache.setProperty("FONT_SIZE", this.fontSize.getSelectedItem().toString());
        Cache.setProperty("ANTI_ALIAS", Boolean.toString(this.smoothFont.isSelected()));
    }
}

