/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.datamodel.SequenceI;
import jalview.gui.AlignViewport;
import jalview.gui.AnnotationLabels;
import jalview.gui.AnnotationPanel;
import jalview.gui.PaintRefresher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JPanel;

public class IdCanvas
extends JPanel {
    protected AlignViewport av;
    protected boolean showScores = true;
    protected int maxIdLength = -1;
    protected String maxIdStr = null;
    BufferedImage image;
    Graphics2D gg;
    int imgHeight = 0;
    boolean fastPaint = false;
    Vector searchResults;
    FontMetrics fm;
    AnnotationLabels labels = null;
    AnnotationPanel ap;
    Font idfont;

    public IdCanvas(AlignViewport av) {
        this.setLayout(new BorderLayout());
        this.av = av;
        PaintRefresher.Register(this, av.getSequenceSetId());
    }

    public void drawIdString(Graphics2D gg, SequenceI s, int i, int starty, int ypos) {
        int xPos = 0;
        int panelWidth = this.getWidth();
        int charHeight = this.av.charHeight;
        if (this.searchResults != null && this.searchResults.contains(s)) {
            gg.setColor(Color.black);
            gg.fillRect(0, (i - starty) * charHeight + ypos, this.getWidth(), charHeight);
            gg.setColor(Color.white);
        } else if (this.av.getSelectionGroup() != null && this.av.getSelectionGroup().getSequences(null).contains(s)) {
            gg.setColor(Color.lightGray);
            gg.fillRect(0, (i - starty) * charHeight + ypos, this.getWidth(), charHeight);
            gg.setColor(Color.white);
        } else {
            gg.setColor(this.av.getSequenceColour(s));
            gg.fillRect(0, (i - starty) * charHeight + ypos, this.getWidth(), charHeight);
            gg.setColor(Color.black);
        }
        if (this.av.rightAlignIds) {
            xPos = panelWidth - this.fm.stringWidth(s.getDisplayId(this.av.getShowJVSuffix())) - 4;
        }
        gg.drawString(s.getDisplayId(this.av.getShowJVSuffix()), xPos, (i - starty + 1) * charHeight + ypos - charHeight / 5);
        if (this.av.hasHiddenRows && this.av.showHiddenMarkers) {
            this.drawMarker(i, starty, ypos);
        }
    }

    public void fastPaint(int vertical) {
        if (this.gg == null) {
            this.repaint();
            return;
        }
        this.gg.copyArea(0, 0, this.getWidth(), this.imgHeight, 0, -vertical * this.av.charHeight);
        int ss = this.av.startSeq;
        int es = this.av.endSeq;
        int transY = 0;
        if (vertical > 0) {
            ss = es - vertical;
            if (ss < this.av.startSeq) {
                ss = this.av.startSeq;
            } else {
                transY = this.imgHeight - vertical * this.av.charHeight;
            }
        } else if (vertical < 0 && (es = ss - vertical) > this.av.endSeq) {
            es = this.av.endSeq;
        }
        this.gg.translate(0, transY);
        this.drawIds(ss, es);
        this.gg.translate(0, -transY);
        this.fastPaint = true;
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.fastPaint) {
            this.fastPaint = false;
            g.drawImage(this.image, 0, 0, this);
            return;
        }
        int oldHeight = this.imgHeight;
        this.imgHeight = this.getHeight();
        this.imgHeight -= this.imgHeight % this.av.charHeight;
        if (this.imgHeight < 1) {
            return;
        }
        if (oldHeight != this.imgHeight || this.image.getWidth(this) != this.getWidth()) {
            this.image = new BufferedImage(this.getWidth(), this.imgHeight, 1);
        }
        this.gg = (Graphics2D)this.image.getGraphics();
        this.gg.setColor(Color.white);
        this.gg.fillRect(0, 0, this.getWidth(), this.imgHeight);
        this.drawIds(this.av.getStartSeq(), this.av.endSeq);
        g.drawImage(this.image, 0, 0, this);
    }

    void drawIds(int starty, int endy) {
        this.idfont = this.av.seqNameItalics ? new Font(this.av.getFont().getName(), 2, this.av.getFont().getSize()) : this.av.getFont();
        this.gg.setFont(this.idfont);
        this.fm = this.gg.getFontMetrics();
        if (this.av.antiAlias) {
            this.gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        Color currentColor = Color.white;
        Color currentTextColor = Color.black;
        if (this.av.getWrapAlignment()) {
            int maxwidth = this.av.alignment.getWidth();
            int alheight = this.av.alignment.getHeight();
            if (this.av.hasHiddenColumns) {
                maxwidth = this.av.getColumnSelection().findColumnPosition(maxwidth) - 1;
            }
            int annotationHeight = 0;
            if (this.av.showAnnotation) {
                if (this.ap == null) {
                    this.ap = new AnnotationPanel(this.av);
                }
                annotationHeight = this.ap.adjustPanelHeight();
                if (this.labels == null) {
                    this.labels = new AnnotationLabels(this.av);
                }
            }
            int hgap = this.av.charHeight;
            if (this.av.scaleAboveWrapped) {
                hgap += this.av.charHeight;
            }
            int cHeight = alheight * this.av.charHeight + hgap + annotationHeight;
            int rowSize = this.av.getEndRes() - this.av.getStartRes();
            int ypos = hgap;
            for (int row = this.av.startRes; ypos <= this.getHeight() && row < maxwidth; ypos += cHeight, row += rowSize) {
                for (int i = starty; i < alheight; ++i) {
                    SequenceI s = this.av.alignment.getSequenceAt(i);
                    if (this.av.hasHiddenRows) {
                        this.setHiddenFont(s);
                    } else {
                        this.gg.setFont(this.idfont);
                    }
                    this.drawIdString(this.gg, s, i, 0, ypos);
                }
                if (this.labels == null || !this.av.showAnnotation) continue;
                this.gg.translate(0, ypos + alheight * this.av.charHeight);
                this.labels.drawComponent(this.gg, this.getWidth());
                this.gg.translate(0, -ypos - alheight * this.av.charHeight);
            }
        } else {
            this.labels = null;
            int panelWidth = this.getWidth();
            int xPos = 0;
            for (int i = starty; i < endy; ++i) {
                SequenceI sequence = this.av.alignment.getSequenceAt(i);
                if (sequence == null) continue;
                if (this.av.hasHiddenRows) {
                    this.setHiddenFont(sequence);
                }
                if (this.searchResults != null && this.searchResults.contains(sequence)) {
                    currentColor = Color.black;
                    currentTextColor = Color.white;
                } else if (this.av.getSelectionGroup() != null && this.av.getSelectionGroup().getSequences(null).contains(sequence)) {
                    currentColor = Color.lightGray;
                    currentTextColor = Color.black;
                } else {
                    currentColor = this.av.getSequenceColour(sequence);
                    currentTextColor = Color.black;
                }
                this.gg.setColor(currentColor);
                this.gg.fillRect(0, (i - starty) * this.av.charHeight, this.getWidth(), this.av.charHeight);
                this.gg.setColor(currentTextColor);
                String string = sequence.getDisplayId(this.av.getShowJVSuffix());
                if (this.av.rightAlignIds) {
                    xPos = panelWidth - this.fm.stringWidth(string) - 4;
                }
                this.gg.drawString(string, xPos, (i - starty) * this.av.charHeight + this.av.charHeight - this.av.charHeight / 5);
                if (!this.av.hasHiddenRows || !this.av.showHiddenMarkers) continue;
                this.drawMarker(i, starty, 0);
            }
        }
    }

    void drawMarker(int i, int starty, int yoffset) {
        SequenceI[] hseqs = this.av.alignment.getHiddenSequences().hiddenSequences;
        int hSize = hseqs.length;
        int hiddenIndex = i;
        int lastIndex = i - 1;
        int nextIndex = i + 1;
        for (int j = 0; j < hSize; ++j) {
            if (hseqs[j] == null) continue;
            if (j - 1 < hiddenIndex) {
                ++hiddenIndex;
            }
            if (j - 1 < lastIndex) {
                ++lastIndex;
            }
            if (j - 1 >= nextIndex) continue;
            ++nextIndex;
        }
        boolean below = hiddenIndex > lastIndex + 1;
        boolean above = nextIndex > hiddenIndex + 1;
        this.gg.setColor(Color.blue);
        if (below) {
            this.gg.fillPolygon(new int[]{this.getWidth() - this.av.charHeight, this.getWidth() - this.av.charHeight, this.getWidth()}, new int[]{(i - starty) * this.av.charHeight + yoffset, (i - starty) * this.av.charHeight + yoffset + this.av.charHeight / 4, (i - starty) * this.av.charHeight + yoffset}, 3);
        }
        if (above) {
            this.gg.fillPolygon(new int[]{this.getWidth() - this.av.charHeight, this.getWidth() - this.av.charHeight, this.getWidth()}, new int[]{(i - starty + 1) * this.av.charHeight + yoffset, (i - starty + 1) * this.av.charHeight + yoffset - this.av.charHeight / 4, (i - starty + 1) * this.av.charHeight + yoffset}, 3);
        }
    }

    void setHiddenFont(SequenceI seq) {
        Font bold = new Font(this.av.getFont().getName(), 1, this.av.getFont().getSize());
        if (this.av.hiddenRepSequences != null && this.av.hiddenRepSequences.containsKey(seq)) {
            this.gg.setFont(bold);
        } else {
            this.gg.setFont(this.idfont);
        }
    }

    public void setHighlighted(Vector found) {
        this.searchResults = found;
        this.repaint();
    }
}

