/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.gui.AlignmentPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import javax.swing.JPanel;

public class IdwidthAdjuster
extends JPanel
implements MouseListener,
MouseMotionListener {
    boolean active = false;
    int oldX = 0;
    Image image;
    AlignmentPanel ap;

    public IdwidthAdjuster(AlignmentPanel ap) {
        this.ap = ap;
        URL url = this.getClass().getResource("/images/idwidth.gif");
        if (url != null) {
            this.image = Toolkit.getDefaultToolkit().createImage(url);
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void mousePressed(MouseEvent evt) {
        this.oldX = evt.getX();
    }

    public void mouseReleased(MouseEvent evt) {
        this.active = false;
        this.repaint();
    }

    public void mouseEntered(MouseEvent evt) {
        this.active = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent evt) {
        this.active = false;
        this.repaint();
    }

    public void mouseDragged(MouseEvent evt) {
        this.active = true;
        Dimension d = this.ap.idPanel.idCanvas.getPreferredSize();
        int dif = evt.getX() - this.oldX;
        if (d.width + dif > 20 || dif > 0) {
            this.ap.idPanel.idCanvas.setPreferredSize(new Dimension(d.width + dif, d.height));
            this.ap.paintAlignment(true);
        }
        this.oldX = evt.getX();
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void paintComponent(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.active && this.image != null) {
            g.drawImage(this.image, this.getWidth() - 20, 2, this);
        }
    }
}

