/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.AlignSeq;
import jalview.analysis.Conservation;
import jalview.bin.Cache;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.GraphLine;
import jalview.datamodel.Mapping;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.AppJmol;
import jalview.gui.Desktop;
import jalview.gui.Jalview2XML_V1;
import jalview.gui.PaintRefresher;
import jalview.gui.TreePanel;
import jalview.io.AppletFormatAdapter;
import jalview.io.NewickFile;
import jalview.schemabinding.version2.AlcodMap;
import jalview.schemabinding.version2.Alcodon;
import jalview.schemabinding.version2.AlcodonFrame;
import jalview.schemabinding.version2.AnnotationColours;
import jalview.schemabinding.version2.AnnotationElement;
import jalview.schemabinding.version2.Colour;
import jalview.schemabinding.version2.DBRef;
import jalview.schemabinding.version2.FeatureSettings;
import jalview.schemabinding.version2.Features;
import jalview.schemabinding.version2.Group;
import jalview.schemabinding.version2.HiddenColumns;
import jalview.schemabinding.version2.JGroup;
import jalview.schemabinding.version2.JSeq;
import jalview.schemabinding.version2.JalviewModel;
import jalview.schemabinding.version2.JalviewModelSequence;
import jalview.schemabinding.version2.MapListFrom;
import jalview.schemabinding.version2.MapListTo;
import jalview.schemabinding.version2.MappingChoice;
import jalview.schemabinding.version2.OtherData;
import jalview.schemabinding.version2.PdbentryItem;
import jalview.schemabinding.version2.Pdbids;
import jalview.schemabinding.version2.Property;
import jalview.schemabinding.version2.SequenceSet;
import jalview.schemabinding.version2.SequenceSetProperties;
import jalview.schemabinding.version2.Setting;
import jalview.schemabinding.version2.StructureState;
import jalview.schemabinding.version2.ThresholdLine;
import jalview.schemabinding.version2.Tree;
import jalview.schemabinding.version2.UserColours;
import jalview.schemabinding.version2.VamsasModel;
import jalview.schemabinding.version2.Viewport;
import jalview.schemes.AnnotationColourGradient;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemeProperty;
import jalview.schemes.ResidueColourScheme;
import jalview.schemes.ResidueProperties;
import jalview.schemes.UserColourScheme;
import jalview.structure.StructureSelectionManager;
import jalview.util.Format;
import jalview.util.MapList;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;

public class Jalview2XML {
    IdentityHashMap seqsToIds = null;
    Hashtable seqRefIds = null;
    Vector frefedSequence = null;
    boolean raiseGUI = true;
    Hashtable viewportsAdded;
    Hashtable annotationIds = new Hashtable();
    String uniqueSetSuffix = "";
    Vector pdbfiles = null;
    Hashtable alreadyLoadedPDB;
    Hashtable datasetIds = null;

    String seqHash(SequenceI sq) {
        if (this.seqsToIds == null) {
            this.initSeqRefs();
        }
        if (this.seqsToIds.containsKey(sq)) {
            return (String)this.seqsToIds.get(sq);
        }
        String key = "sq" + (this.seqsToIds.size() + 1);
        this.seqsToIds.put(sq, key);
        return key;
    }

    void clearSeqRefs() {
        this.seqRefIds.clear();
        this.seqsToIds.clear();
    }

    void initSeqRefs() {
        if (this.seqsToIds == null) {
            this.seqsToIds = new IdentityHashMap();
        }
        if (this.seqRefIds == null) {
            this.seqRefIds = new Hashtable();
        }
    }

    public Jalview2XML() {
    }

    public Jalview2XML(boolean raiseGUI) {
        this.raiseGUI = raiseGUI;
    }

    public void resolveFrefedSequences() {
        if (this.frefedSequence.size() > 0) {
            int r = 0;
            int rSize = this.frefedSequence.size();
            while (r < rSize) {
                Object[] ref = (Object[])this.frefedSequence.elementAt(r);
                if (ref != null) {
                    String sref = (String)ref[0];
                    if (this.seqRefIds.containsKey(sref)) {
                        SequenceI seq;
                        if (ref[1] instanceof Mapping) {
                            seq = (SequenceI)this.seqRefIds.get(sref);
                            while (seq.getDatasetSequence() != null) {
                                seq = seq.getDatasetSequence();
                            }
                            ((Mapping)ref[1]).setTo(seq);
                            continue;
                        }
                        if (ref[1] instanceof AlignedCodonFrame) {
                            seq = (SequenceI)this.seqRefIds.get(sref);
                            while (seq.getDatasetSequence() != null) {
                                seq = seq.getDatasetSequence();
                            }
                            if (ref[2] != null && ref[2] instanceof Mapping) {
                                Mapping mp = (Mapping)ref[2];
                                ((AlignedCodonFrame)ref[1]).addMap(seq, mp.getTo(), mp.getMap());
                            } else {
                                System.err.println("IMPLEMENTATION ERROR: Unimplemented forward sequence references for AlcodonFrames involving " + ref[2].getClass() + " type objects.");
                            }
                        } else {
                            System.err.println("IMPLEMENTATION ERROR: Unimplemented forward sequence references for " + ref[1].getClass() + " type objects.");
                        }
                        this.frefedSequence.remove(r);
                        --rSize;
                        continue;
                    }
                    System.err.println("IMPLEMENTATION WARNING: Unresolved forward reference for hash string " + ref[0] + " with objecttype " + ref[1].getClass());
                    ++r;
                    continue;
                }
                this.frefedSequence.remove(r);
                --rSize;
            }
        }
    }

    public void SaveState(File statefile) {
        JInternalFrame[] frames = Desktop.desktop.getAllFrames();
        if (frames == null) {
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(statefile);
            JarOutputStream jout = new JarOutputStream(fos);
            Object out = null;
            Vector<String> shortNames = new Vector<String>();
            for (int i = frames.length - 1; i > -1; --i) {
                if (!(frames[i] instanceof AlignFrame)) continue;
                AlignFrame af = (AlignFrame)frames[i];
                String shortName = af.getTitle();
                if (shortName.indexOf(File.separatorChar) > -1) {
                    shortName = shortName.substring(shortName.lastIndexOf(File.separatorChar) + 1);
                }
                int count = 1;
                while (shortNames.contains(shortName)) {
                    if (shortName.endsWith("_" + (count - 1))) {
                        shortName = shortName.substring(0, shortName.lastIndexOf("_"));
                    }
                    shortName = shortName.concat("_" + count);
                    ++count;
                }
                shortNames.addElement(shortName);
                if (!shortName.endsWith(".xml")) {
                    shortName = shortName + ".xml";
                }
                int apSize = af.alignPanels.size();
                for (int ap = 0; ap < apSize; ++ap) {
                    String fileName;
                    AlignmentPanel apanel = (AlignmentPanel)af.alignPanels.elementAt(ap);
                    String string = fileName = apSize == 1 ? shortName : ap + shortName;
                    if (!fileName.endsWith(".xml")) {
                        fileName = fileName + ".xml";
                    }
                    this.SaveState(apanel, fileName, jout);
                }
            }
            try {
                jout.flush();
            }
            catch (Exception foo) {
                // empty catch block
            }
            jout.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean SaveAlignment(AlignFrame af, String jarFile, String fileName) {
        try {
            int apSize = af.alignPanels.size();
            FileOutputStream fos = new FileOutputStream(jarFile);
            JarOutputStream jout = new JarOutputStream(fos);
            for (int ap = 0; ap < apSize; ++ap) {
                String jfileName;
                AlignmentPanel apanel = (AlignmentPanel)af.alignPanels.elementAt(ap);
                String string = jfileName = apSize == 1 ? fileName : fileName + ap;
                if (!jfileName.endsWith(".xml")) {
                    jfileName = jfileName + ".xml";
                }
                this.SaveState(apanel, jfileName, jout);
            }
            try {
                jout.flush();
            }
            catch (Exception foo) {
                // empty catch block
            }
            jout.close();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public JalviewModel SaveState(AlignmentPanel ap, String fileName, JarOutputStream jout) {
        this.initSeqRefs();
        Vector userColours = new Vector();
        AlignViewport av = ap.av;
        JalviewModel object = new JalviewModel();
        object.setVamsasModel(new VamsasModel());
        object.setCreationDate(new Date(System.currentTimeMillis()));
        object.setVersion(Cache.getProperty("VERSION"));
        AlignmentI jal = av.alignment;
        if (av.hasHiddenRows) {
            jal = jal.getHiddenSequences().getFullAlignment();
        }
        SequenceSet vamsasSet = new SequenceSet();
        JalviewModelSequence jms = new JalviewModelSequence();
        vamsasSet.setGapChar(jal.getGapCharacter() + "");
        if (jal.getDataset() != null) {
            vamsasSet.setDatasetId(jal.getDataset().hashCode() + "");
        }
        if (jal.getProperties() != null) {
            Enumeration en = jal.getProperties().keys();
            while (en.hasMoreElements()) {
                String key = en.nextElement().toString();
                SequenceSetProperties ssp = new SequenceSetProperties();
                ssp.setKey(key);
                ssp.setValue(jal.getProperties().get(key).toString());
                vamsasSet.addSequenceSetProperties(ssp);
            }
        }
        String id = "";
        for (int i = 0; i < jal.getHeight(); ++i) {
            SequenceI jds = jal.getSequenceAt(i);
            id = this.seqHash(jds);
            if (this.seqRefIds.get(id) == null) {
                jalview.schemabinding.version2.Sequence vamsasSeq = this.createVamsasSequence(id, jds);
                vamsasSet.addSequence(vamsasSeq);
                this.seqRefIds.put(id, jds);
            }
            JSeq jseq = new JSeq();
            jseq.setStart(jds.getStart());
            jseq.setEnd(jds.getEnd());
            jseq.setColour(av.getSequenceColour(jds).getRGB());
            jseq.setId(id);
            if (av.hasHiddenRows) {
                jseq.setHidden(av.alignment.getHiddenSequences().isHidden(jds));
                if (av.hiddenRepSequences != null && av.hiddenRepSequences.containsKey(jal.getSequenceAt(i))) {
                    SequenceI[] reps = ((SequenceGroup)av.hiddenRepSequences.get(jal.getSequenceAt(i))).getSequencesInOrder(jal);
                    for (int h = 0; h < reps.length; ++h) {
                        if (reps[h] == jal.getSequenceAt(i)) continue;
                        jseq.addHiddenSequences(jal.findIndex(reps[h]));
                    }
                }
            }
            if (jds.getDatasetSequence().getSequenceFeatures() != null) {
                SequenceFeature[] sf = jds.getDatasetSequence().getSequenceFeatures();
                for (int index = 0; index < sf.length; ++index) {
                    Features features = new Features();
                    features.setBegin(sf[index].getBegin());
                    features.setEnd(sf[index].getEnd());
                    features.setDescription(sf[index].getDescription());
                    features.setType(sf[index].getType());
                    features.setFeatureGroup(sf[index].getFeatureGroup());
                    features.setScore(sf[index].getScore());
                    if (sf[index].links != null) {
                        for (int l = 0; l < sf[index].links.size(); ++l) {
                            OtherData keyValue = new OtherData();
                            keyValue.setKey("LINK_" + l);
                            keyValue.setValue(sf[index].links.elementAt(l).toString());
                            features.addOtherData(keyValue);
                        }
                    }
                    if (sf[index].otherDetails != null) {
                        Enumeration keys = sf[index].otherDetails.keys();
                        while (keys.hasMoreElements()) {
                            String key = keys.nextElement().toString();
                            OtherData keyValue = new OtherData();
                            keyValue.setKey(key);
                            keyValue.setValue(sf[index].otherDetails.get(key).toString());
                            features.addOtherData(keyValue);
                        }
                    }
                    jseq.addFeatures(features);
                }
            }
            if (jds.getDatasetSequence().getPDBId() != null) {
                Enumeration en = jds.getDatasetSequence().getPDBId().elements();
                while (en.hasMoreElements()) {
                    Pdbids pdb = new Pdbids();
                    PDBEntry entry = (PDBEntry)en.nextElement();
                    pdb.setId(entry.getId());
                    pdb.setType(entry.getType());
                    JInternalFrame[] frames = Desktop.desktop.getAllFrames();
                    for (int f = frames.length - 1; f > -1; --f) {
                        if (!(frames[f] instanceof AppJmol)) continue;
                        AppJmol jmol = (AppJmol)frames[f];
                        if (!jmol.pdbentry.getId().equals(entry.getId())) continue;
                        StructureState state = new StructureState();
                        state.setVisible(true);
                        state.setXpos(jmol.getX());
                        state.setYpos(jmol.getY());
                        state.setWidth(jmol.getWidth());
                        state.setHeight(jmol.getHeight());
                        String statestring = jmol.viewer.getStateInfo();
                        if (state != null) {
                            state.setContent(statestring.replaceAll("\n", ""));
                        }
                        for (int s = 0; s < jmol.sequence.length; ++s) {
                            if (jal.findIndex(jmol.sequence[s]) <= -1) continue;
                            pdb.addStructureState(state);
                        }
                    }
                    if (entry.getFile() != null) {
                        pdb.setFile(entry.getFile());
                        if (this.pdbfiles == null) {
                            this.pdbfiles = new Vector();
                        }
                        if (!this.pdbfiles.contains(entry.getId())) {
                            this.pdbfiles.addElement(entry.getId());
                            try {
                                File file = new File(entry.getFile());
                                if (file.exists() && jout != null) {
                                    byte[] data = new byte[(int)file.length()];
                                    jout.putNextEntry(new JarEntry(entry.getId()));
                                    DataInputStream dis = new DataInputStream(new FileInputStream(file));
                                    dis.readFully(data);
                                    DataOutputStream dout = new DataOutputStream(jout);
                                    dout.write(data, 0, data.length);
                                    dout.flush();
                                    jout.closeEntry();
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    if (entry.getProperty() != null) {
                        PdbentryItem item = new PdbentryItem();
                        Hashtable properties = entry.getProperty();
                        Enumeration en2 = properties.keys();
                        while (en2.hasMoreElements()) {
                            Property prop = new Property();
                            String key = en2.nextElement().toString();
                            prop.setName(key);
                            prop.setValue(properties.get(key).toString());
                            item.addProperty(prop);
                        }
                        pdb.addPdbentryItem(item);
                    }
                    jseq.addPdbids(pdb);
                }
            }
            jms.addJSeq(jseq);
        }
        if (av.hasHiddenRows) {
            jal = av.alignment;
        }
        if (jal.getCodonFrames() != null && jal.getCodonFrames().length > 0) {
            AlignedCodonFrame[] jac = jal.getCodonFrames();
            for (int i = 0; i < jac.length; ++i) {
                AlcodonFrame alc = new AlcodonFrame();
                vamsasSet.addAlcodonFrame(alc);
                for (int p = 0; p < jac[i].aaWidth; ++p) {
                    Alcodon cmap = new Alcodon();
                    cmap.setPos1(jac[i].codons[p][0]);
                    cmap.setPos2(jac[i].codons[p][1]);
                    cmap.setPos3(jac[i].codons[p][2]);
                    alc.addAlcodon(cmap);
                }
                if (jac[i].getProtMappings() == null || jac[i].getProtMappings().length <= 0) continue;
                SequenceI[] dnas = jac[i].getdnaSeqs();
                Mapping[] pmaps = jac[i].getProtMappings();
                for (int m = 0; m < pmaps.length; ++m) {
                    AlcodMap alcmap = new AlcodMap();
                    alcmap.setDnasq("" + this.seqHash(dnas[m]));
                    alcmap.setMapping(this.createVamsasMapping(pmaps[m], dnas[m], null, false));
                    alc.addAlcodMap(alcmap);
                }
            }
        }
        if (av.currentTree != null && Desktop.desktop != null) {
            JInternalFrame[] frames = Desktop.desktop.getAllFrames();
            for (int t = 0; t < frames.length; ++t) {
                if (!(frames[t] instanceof TreePanel)) continue;
                TreePanel tp = (TreePanel)frames[t];
                if (tp.treeCanvas.av.alignment != jal) continue;
                Tree tree = new Tree();
                tree.setTitle(tp.getTitle());
                tree.setCurrentTree(av.currentTree == tp.getTree());
                tree.setNewick(tp.getTree().toString());
                tree.setThreshold(tp.treeCanvas.threshold);
                tree.setFitToWindow(tp.fitToWindow.getState());
                tree.setFontName(tp.getTreeFont().getName());
                tree.setFontSize(tp.getTreeFont().getSize());
                tree.setFontStyle(tp.getTreeFont().getStyle());
                tree.setMarkUnlinked(tp.placeholdersMenu.getState());
                tree.setShowBootstrap(tp.bootstrapMenu.getState());
                tree.setShowDistances(tp.distanceMenu.getState());
                tree.setHeight(tp.getHeight());
                tree.setWidth(tp.getWidth());
                tree.setXpos(tp.getX());
                tree.setYpos(tp.getY());
                jms.addTree(tree);
            }
        }
        if (jal.getAlignmentAnnotation() != null) {
            AlignmentAnnotation[] aa = jal.getAlignmentAnnotation();
            for (int i = 0; i < aa.length; ++i) {
                jalview.schemabinding.version2.Annotation an = new jalview.schemabinding.version2.Annotation();
                if (aa[i].annotationId != null) {
                    this.annotationIds.put(aa[i].annotationId, aa[i]);
                }
                an.setId(aa[i].annotationId);
                if (aa[i] == av.quality || aa[i] == av.conservation || aa[i] == av.consensus) {
                    an.setLabel(aa[i].label);
                    an.setGraph(true);
                    vamsasSet.addAnnotation(an);
                    continue;
                }
                an.setVisible(aa[i].visible);
                an.setDescription(aa[i].description);
                if (aa[i].sequenceRef != null) {
                    an.setSequenceRef(aa[i].sequenceRef.getName());
                }
                if (aa[i].graph > 0) {
                    an.setGraph(true);
                    an.setGraphType(aa[i].graph);
                    an.setGraphGroup(aa[i].graphGroup);
                    if (aa[i].getThreshold() != null) {
                        ThresholdLine line = new ThresholdLine();
                        line.setLabel(aa[i].getThreshold().label);
                        line.setValue(aa[i].getThreshold().value);
                        line.setColour(aa[i].getThreshold().colour.getRGB());
                        an.setThresholdLine(line);
                    }
                } else {
                    an.setGraph(false);
                }
                an.setLabel(aa[i].label);
                if (aa[i].hasScore()) {
                    an.setScore(aa[i].getScore());
                }
                if (aa[i].annotations != null) {
                    an.setScoreOnly(false);
                    for (int a = 0; a < aa[i].annotations.length; ++a) {
                        if (aa[i] == null || aa[i].annotations[a] == null) continue;
                        AnnotationElement ae = new AnnotationElement();
                        if (aa[i].annotations[a].description != null) {
                            ae.setDescription(aa[i].annotations[a].description);
                        }
                        if (aa[i].annotations[a].displayCharacter != null) {
                            ae.setDisplayCharacter(aa[i].annotations[a].displayCharacter);
                        }
                        if (!Float.isNaN(aa[i].annotations[a].value)) {
                            ae.setValue(aa[i].annotations[a].value);
                        }
                        ae.setPosition(a);
                        if (aa[i].annotations[a].secondaryStructure != ' ' && aa[i].annotations[a].secondaryStructure != '\u0000') {
                            ae.setSecondaryStructure(aa[i].annotations[a].secondaryStructure + "");
                        }
                        if (aa[i].annotations[a].colour != null && aa[i].annotations[a].colour != Color.black) {
                            ae.setColour(aa[i].annotations[a].colour.getRGB());
                        }
                        an.addAnnotationElement(ae);
                    }
                } else {
                    an.setScoreOnly(true);
                }
                vamsasSet.addAnnotation(an);
            }
        }
        if (jal.getGroups() != null) {
            JGroup[] groups = new JGroup[jal.getGroups().size()];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = new JGroup();
                SequenceGroup sg = (SequenceGroup)jal.getGroups().elementAt(i);
                groups[i].setStart(sg.getStartRes());
                groups[i].setEnd(sg.getEndRes());
                groups[i].setName(sg.getName());
                if (sg.cs != null) {
                    if (sg.cs.conservationApplied()) {
                        groups[i].setConsThreshold(sg.cs.getConservationInc());
                        if (sg.cs instanceof UserColourScheme) {
                            groups[i].setColour(this.SetUserColourScheme(sg.cs, userColours, jms));
                        } else {
                            groups[i].setColour(ColourSchemeProperty.getColourName(sg.cs));
                        }
                    } else if (sg.cs instanceof AnnotationColourGradient) {
                        groups[i].setColour(ColourSchemeProperty.getColourName(((AnnotationColourGradient)sg.cs).getBaseColour()));
                    } else if (sg.cs instanceof UserColourScheme) {
                        groups[i].setColour(this.SetUserColourScheme(sg.cs, userColours, jms));
                    } else {
                        groups[i].setColour(ColourSchemeProperty.getColourName(sg.cs));
                    }
                    groups[i].setPidThreshold(sg.cs.getThreshold());
                }
                groups[i].setOutlineColour(sg.getOutlineColour().getRGB());
                groups[i].setDisplayBoxes(sg.getDisplayBoxes());
                groups[i].setDisplayText(sg.getDisplayText());
                groups[i].setColourText(sg.getColourText());
                groups[i].setTextCol1(sg.textColour.getRGB());
                groups[i].setTextCol2(sg.textColour2.getRGB());
                groups[i].setTextColThreshold(sg.thresholdTextColour);
                for (int s = 0; s < sg.getSize(); ++s) {
                    Sequence seq = (Sequence)sg.getSequenceAt(s);
                    groups[i].addSeq(this.seqHash(seq));
                }
            }
            jms.setJGroup(groups);
        }
        Viewport view = new Viewport();
        view.setTitle(ap.alignFrame.getTitle());
        view.setSequenceSetId(av.getSequenceSetId());
        view.setViewName(av.viewName);
        view.setGatheredViews(av.gatherViewsHere);
        if (ap.av.explodedPosition != null) {
            view.setXpos(av.explodedPosition.x);
            view.setYpos(av.explodedPosition.y);
            view.setWidth(av.explodedPosition.width);
            view.setHeight(av.explodedPosition.height);
        } else {
            view.setXpos(ap.alignFrame.getBounds().x);
            view.setYpos(ap.alignFrame.getBounds().y);
            view.setWidth(ap.alignFrame.getBounds().width);
            view.setHeight(ap.alignFrame.getBounds().height);
        }
        view.setStartRes(av.startRes);
        view.setStartSeq(av.startSeq);
        if (av.getGlobalColourScheme() instanceof UserColourScheme) {
            view.setBgColour(this.SetUserColourScheme(av.getGlobalColourScheme(), userColours, jms));
        } else if (av.getGlobalColourScheme() instanceof AnnotationColourGradient) {
            AnnotationColourGradient acg = (AnnotationColourGradient)av.getGlobalColourScheme();
            AnnotationColours ac = new AnnotationColours();
            ac.setAboveThreshold(acg.getAboveThreshold());
            ac.setThreshold(acg.getAnnotationThreshold());
            ac.setAnnotation(acg.getAnnotation());
            if (acg.getBaseColour() instanceof UserColourScheme) {
                ac.setColourScheme(this.SetUserColourScheme(acg.getBaseColour(), userColours, jms));
            } else {
                ac.setColourScheme(ColourSchemeProperty.getColourName(acg.getBaseColour()));
            }
            ac.setMaxColour(acg.getMaxColour().getRGB());
            ac.setMinColour(acg.getMinColour().getRGB());
            view.setAnnotationColours(ac);
            view.setBgColour("AnnotationColourGradient");
        } else {
            view.setBgColour(ColourSchemeProperty.getColourName(av.getGlobalColourScheme()));
        }
        ColourSchemeI cs = av.getGlobalColourScheme();
        if (cs != null) {
            if (cs.conservationApplied()) {
                view.setConsThreshold(cs.getConservationInc());
                if (cs instanceof UserColourScheme) {
                    view.setBgColour(this.SetUserColourScheme(cs, userColours, jms));
                }
            }
            if (cs instanceof ResidueColourScheme) {
                view.setPidThreshold(cs.getThreshold());
            }
        }
        view.setConservationSelected(av.getConservationSelected());
        view.setPidSelected(av.getAbovePIDThreshold());
        view.setFontName(av.font.getName());
        view.setFontSize(av.font.getSize());
        view.setFontStyle(av.font.getStyle());
        view.setRenderGaps(av.renderGaps);
        view.setShowAnnotation(av.getShowAnnotation());
        view.setShowBoxes(av.getShowBoxes());
        view.setShowColourText(av.getColourText());
        view.setShowFullId(av.getShowJVSuffix());
        view.setRightAlignIds(av.rightAlignIds);
        view.setShowSequenceFeatures(av.showSequenceFeatures);
        view.setShowText(av.getShowText());
        view.setWrapAlignment(av.getWrapAlignment());
        view.setTextCol1(av.textColour.getRGB());
        view.setTextCol2(av.textColour2.getRGB());
        view.setTextColThreshold(av.thresholdTextColour);
        if (av.featuresDisplayed != null) {
            FeatureSettings fs = new FeatureSettings();
            String[] renderOrder = ap.seqPanel.seqCanvas.getFeatureRenderer().renderOrder;
            Vector<String> settingsAdded = new Vector<String>();
            for (int ro = 0; ro < renderOrder.length; ++ro) {
                Setting setting = new Setting();
                setting.setType(renderOrder[ro]);
                setting.setColour(ap.seqPanel.seqCanvas.getFeatureRenderer().getColour(renderOrder[ro]).getRGB());
                setting.setDisplay(av.featuresDisplayed.containsKey(renderOrder[ro]));
                float rorder = ap.seqPanel.seqCanvas.getFeatureRenderer().getOrder(renderOrder[ro]);
                if (rorder > -1.0f) {
                    setting.setOrder(rorder);
                }
                fs.addSetting(setting);
                settingsAdded.addElement(renderOrder[ro]);
            }
            Enumeration en = ap.seqPanel.seqCanvas.getFeatureRenderer().featureColours.keys();
            while (en.hasMoreElements()) {
                String key = en.nextElement().toString();
                if (settingsAdded.contains(key)) continue;
                Setting setting = new Setting();
                setting.setType(key);
                setting.setColour(ap.seqPanel.seqCanvas.getFeatureRenderer().getColour(key).getRGB());
                setting.setDisplay(false);
                float rorder = ap.seqPanel.seqCanvas.getFeatureRenderer().getOrder(key);
                if (rorder > -1.0f) {
                    setting.setOrder(rorder);
                }
                fs.addSetting(setting);
                settingsAdded.addElement(key);
            }
            en = ap.seqPanel.seqCanvas.getFeatureRenderer().featureGroups.keys();
            Vector<String> groupsAdded = new Vector<String>();
            while (en.hasMoreElements()) {
                String grp = en.nextElement().toString();
                if (groupsAdded.contains(grp)) continue;
                Group g = new Group();
                g.setName(grp);
                g.setDisplay((Boolean)ap.seqPanel.seqCanvas.getFeatureRenderer().featureGroups.get(grp));
                fs.addGroup(g);
                groupsAdded.addElement(grp);
            }
            jms.setFeatureSettings(fs);
        }
        if (av.hasHiddenColumns) {
            for (int c = 0; c < av.getColumnSelection().getHiddenColumns().size(); ++c) {
                int[] region = (int[])av.getColumnSelection().getHiddenColumns().elementAt(c);
                HiddenColumns hc = new HiddenColumns();
                hc.setStart(region[0]);
                hc.setEnd(region[1]);
                view.addHiddenColumns(hc);
            }
        }
        jms.addViewport(view);
        object.setJalviewModelSequence(jms);
        object.getVamsasModel().addSequenceSet(vamsasSet);
        if (jout != null && fileName != null) {
            try {
                JarEntry entry = new JarEntry(fileName);
                jout.putNextEntry(entry);
                PrintWriter pout = new PrintWriter(new OutputStreamWriter((OutputStream)jout, "UTF-8"));
                Marshaller marshaller = new Marshaller((Writer)pout);
                marshaller.marshal((Object)object);
                pout.flush();
                jout.closeEntry();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return object;
    }

    private jalview.schemabinding.version2.Sequence createVamsasSequence(String id, SequenceI jds) {
        return this.createVamsasSequence(true, id, jds, null);
    }

    private jalview.schemabinding.version2.Sequence createVamsasSequence(boolean recurse, String id, SequenceI jds, SequenceI parentseq) {
        jalview.schemabinding.version2.Sequence vamsasSeq = new jalview.schemabinding.version2.Sequence();
        vamsasSeq.setId(id);
        vamsasSeq.setName(jds.getName());
        vamsasSeq.setSequence(jds.getSequenceAsString());
        vamsasSeq.setDescription(jds.getDescription());
        DBRefEntry[] dbrefs = null;
        if (jds.getDatasetSequence() != null) {
            vamsasSeq.setDsseqid(this.seqHash(jds.getDatasetSequence()));
            if (jds.getDatasetSequence().getDBRef() != null) {
                dbrefs = jds.getDatasetSequence().getDBRef();
            }
        } else {
            vamsasSeq.setDsseqid(id);
            dbrefs = jds.getDBRef();
        }
        if (dbrefs != null) {
            for (int d = 0; d < dbrefs.length; ++d) {
                DBRef dbref = new DBRef();
                dbref.setSource(dbrefs[d].getSource());
                dbref.setVersion(dbrefs[d].getVersion());
                dbref.setAccessionId(dbrefs[d].getAccessionId());
                if (dbrefs[d].hasMap()) {
                    jalview.schemabinding.version2.Mapping mp = this.createVamsasMapping(dbrefs[d].getMap(), parentseq, jds, recurse);
                    dbref.setMapping(mp);
                }
                vamsasSeq.addDBRef(dbref);
            }
        }
        return vamsasSeq;
    }

    private jalview.schemabinding.version2.Mapping createVamsasMapping(Mapping jmp, SequenceI parentseq, SequenceI jds, boolean recurse) {
        jalview.schemabinding.version2.Mapping mp = null;
        if (jmp.getMap() != null) {
            int s;
            mp = new jalview.schemabinding.version2.Mapping();
            MapList mlst = jmp.getMap();
            int[] r = mlst.getFromRanges();
            for (s = 0; s < r.length; s += 2) {
                MapListFrom mfrom = new MapListFrom();
                mfrom.setStart(r[s]);
                mfrom.setEnd(r[s + 1]);
                mp.addMapListFrom(mfrom);
            }
            r = mlst.getToRanges();
            for (s = 0; s < r.length; s += 2) {
                MapListTo mto = new MapListTo();
                mto.setStart(r[s]);
                mto.setEnd(r[s + 1]);
                mp.addMapListTo(mto);
            }
            mp.setMapFromUnit(mlst.getFromRatio());
            mp.setMapToUnit(mlst.getToRatio());
            if (jmp.getTo() != null) {
                MappingChoice mpc = new MappingChoice();
                if (recurse && (parentseq != jmp.getTo() || parentseq.getDatasetSequence() != jmp.getTo())) {
                    mpc.setSequence(this.createVamsasSequence(false, this.seqHash(jmp.getTo()), jmp.getTo(), jds));
                } else {
                    String jmpid = "";
                    SequenceI ps = null;
                    if (parentseq != jmp.getTo() && parentseq.getDatasetSequence() != jmp.getTo()) {
                        ps = jmp.getTo();
                        jmpid = this.seqHash(ps);
                    } else {
                        ps = parentseq;
                        jmpid = this.seqHash(ps);
                    }
                    mpc.setDseqFor(jmpid);
                    if (!this.seqRefIds.containsKey(mpc.getDseqFor())) {
                        Cache.log.debug((Object)"creatign new DseqFor ID");
                        this.seqRefIds.put(mpc.getDseqFor(), ps);
                    } else {
                        Cache.log.debug((Object)"reusing DseqFor ID");
                    }
                }
                mp.setMappingChoice(mpc);
            }
        }
        return mp;
    }

    String SetUserColourScheme(ColourSchemeI cs, Vector userColours, JalviewModelSequence jms) {
        String id = null;
        UserColourScheme ucs = (UserColourScheme)cs;
        if (!userColours.contains(ucs)) {
            Colour col;
            int i;
            userColours.add(ucs);
            Color[] colours = ucs.getColours();
            UserColours uc = new UserColours();
            jalview.schemabinding.version2.UserColourScheme jbucs = new jalview.schemabinding.version2.UserColourScheme();
            for (i = 0; i < colours.length; ++i) {
                col = new Colour();
                col.setName(ResidueProperties.aa[i]);
                col.setRGB(Format.getHexString(colours[i]));
                jbucs.addColour(col);
            }
            if (ucs.getLowerCaseColours() != null) {
                colours = ucs.getLowerCaseColours();
                for (i = 0; i < colours.length; ++i) {
                    col = new Colour();
                    col.setName(ResidueProperties.aa[i].toLowerCase());
                    col.setRGB(Format.getHexString(colours[i]));
                    jbucs.addColour(col);
                }
            }
            id = "ucs" + userColours.indexOf(ucs);
            uc.setId(id);
            uc.setUserColourScheme(jbucs);
            jms.addUserColours(uc);
        }
        return id;
    }

    UserColourScheme GetUserColourScheme(JalviewModelSequence jms, String id) {
        UserColours[] uc = jms.getUserColours();
        UserColours colours = null;
        for (int i = 0; i < uc.length; ++i) {
            if (!uc[i].getId().equals(id)) continue;
            colours = uc[i];
            break;
        }
        Color[] newColours = new Color[24];
        for (int i = 0; i < 24; ++i) {
            newColours[i] = new Color(Integer.parseInt(colours.getUserColourScheme().getColour(i).getRGB(), 16));
        }
        UserColourScheme ucs = new UserColourScheme(newColours);
        if (colours.getUserColourScheme().getColourCount() > 24) {
            newColours = new Color[23];
            for (int i = 0; i < 23; ++i) {
                newColours[i] = new Color(Integer.parseInt(colours.getUserColourScheme().getColour(i + 24).getRGB(), 16));
            }
            ucs.setLowerCaseColours(newColours);
        }
        return ucs;
    }

    public AlignFrame LoadJalviewAlign(String file) {
        this.uniqueSetSuffix = System.currentTimeMillis() % 100000L + "";
        AlignFrame af = null;
        this.seqRefIds = new Hashtable();
        this.viewportsAdded = new Hashtable();
        this.frefedSequence = new Vector();
        Hashtable<String, AlignFrame> gatherToThisFrame = new Hashtable<String, AlignFrame>();
        String errorMessage = null;
        try {
            URL url = null;
            if (file.startsWith("http://")) {
                url = new URL(file);
            }
            JarInputStream jin = null;
            JarEntry jarentry = null;
            int entryCount = 1;
            do {
                jin = url != null ? new JarInputStream(url.openStream()) : new JarInputStream(new FileInputStream(file));
                for (int i = 0; i < entryCount; ++i) {
                    jarentry = jin.getNextJarEntry();
                }
                if (jarentry != null && jarentry.getName().endsWith(".xml")) {
                    InputStreamReader in = new InputStreamReader((InputStream)jin, "UTF-8");
                    JalviewModel object = new JalviewModel();
                    Unmarshaller unmar = new Unmarshaller((Object)object);
                    unmar.setValidation(false);
                    object = (JalviewModel)unmar.unmarshal((Reader)in);
                    af = this.LoadFromObject(object, file, true);
                    if (af.viewport.gatherViewsHere) {
                        gatherToThisFrame.put(af.viewport.getSequenceSetId(), af);
                    }
                    ++entryCount;
                    continue;
                }
                if (jarentry == null) continue;
                ++entryCount;
            } while (jarentry != null);
            this.resolveFrefedSequences();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            errorMessage = "Couldn't locate Jalview XML file : " + file;
            System.err.println("Exception whilst loading jalview XML file : " + ex + "\n");
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            errorMessage = "Couldn't locate Jalview XML file : " + file;
            System.err.println("Exception whilst loading jalview XML file : " + ex + "\n");
        }
        catch (Exception ex) {
            System.err.println("Parsing as Jalview Version 2 file failed.");
            ex.printStackTrace(System.err);
            try {
                af = new Jalview2XML_V1(this.raiseGUI).LoadJalviewAlign(file);
            }
            catch (Exception ex2) {
                System.err.println("Exception whilst loading as jalviewXMLV1:");
                ex2.printStackTrace();
                af = null;
            }
            if (Desktop.instance != null) {
                Desktop.instance.stopLoading();
            }
            if (af != null) {
                System.out.println("Successfully loaded archive file");
                return af;
            }
            ex.printStackTrace();
            System.err.println("Exception whilst loading jalview XML file : " + ex + "\n");
        }
        if (Desktop.instance != null) {
            Desktop.instance.stopLoading();
        }
        Enumeration en = gatherToThisFrame.elements();
        while (en.hasMoreElements()) {
            Desktop.instance.gatherViews((AlignFrame)en.nextElement());
        }
        if (errorMessage != null) {
            final String finalErrorMessage = errorMessage;
            if (this.raiseGUI) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showInternalMessageDialog(Desktop.desktop, finalErrorMessage, "Error loading Jalview file", 2);
                    }
                });
            } else {
                System.err.println("Problem loading Jalview file: " + errorMessage);
            }
        }
        return af;
    }

    String loadPDBFile(String file, String pdbId) {
        if (this.alreadyLoadedPDB == null) {
            this.alreadyLoadedPDB = new Hashtable();
        }
        if (this.alreadyLoadedPDB.containsKey(pdbId)) {
            return this.alreadyLoadedPDB.get(pdbId).toString();
        }
        try {
            String data;
            JarInputStream jin = null;
            jin = file.startsWith("http://") ? new JarInputStream(new URL(file).openStream()) : new JarInputStream(new FileInputStream(file));
            JarEntry entry = null;
            while (!(entry = jin.getNextJarEntry()).getName().equals(pdbId)) {
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(jin));
            File outFile = File.createTempFile("jalview_pdb", ".txt");
            outFile.deleteOnExit();
            PrintWriter out = new PrintWriter(new FileOutputStream(outFile));
            while ((data = in.readLine()) != null) {
                out.println(data);
            }
            try {
                out.flush();
            }
            catch (Exception foo) {
                // empty catch block
            }
            out.close();
            this.alreadyLoadedPDB.put(pdbId, outFile.getAbsolutePath());
            return outFile.getAbsolutePath();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    AlignFrame LoadFromObject(JalviewModel object, String file, boolean loadTreesAndStructures) {
        int i;
        SequenceSet vamsasSet = object.getVamsasModel().getSequenceSet(0);
        jalview.schemabinding.version2.Sequence[] vamsasSeq = vamsasSet.getSequence();
        JalviewModelSequence jms = object.getJalviewModelSequence();
        Viewport view = jms.getViewport(0);
        Vector<Sequence> hiddenSeqs = null;
        ArrayList<Sequence> tmpseqs = new ArrayList<Sequence>();
        boolean multipleView = false;
        JSeq[] JSEQ = object.getJalviewModelSequence().getJSeq();
        int vi = 0;
        for (int i2 = 0; i2 < JSEQ.length; ++i2) {
            String seqId = JSEQ[i2].getId() + "";
            if (this.seqRefIds.get(seqId) != null) {
                tmpseqs.add((Sequence)this.seqRefIds.get(seqId));
                multipleView = true;
            } else {
                Sequence jseq = new Sequence(vamsasSeq[vi].getName(), vamsasSeq[vi].getSequence());
                jseq.setDescription(vamsasSeq[vi].getDescription());
                jseq.setStart(JSEQ[i2].getStart());
                jseq.setEnd(JSEQ[i2].getEnd());
                jseq.setVamsasId(this.uniqueSetSuffix + seqId);
                this.seqRefIds.put(vamsasSeq[vi].getId() + "", jseq);
                tmpseqs.add(jseq);
                ++vi;
            }
            if (!JSEQ[i2].getHidden()) continue;
            if (hiddenSeqs == null) {
                hiddenSeqs = new Vector<Sequence>();
            }
            hiddenSeqs.addElement((Sequence)this.seqRefIds.get(seqId));
        }
        SequenceI[] orderedSeqs = new Sequence[tmpseqs.size()];
        tmpseqs.toArray(orderedSeqs);
        Alignment al = new Alignment(orderedSeqs);
        for (int i3 = 0; i3 < vamsasSet.getSequenceSetPropertiesCount(); ++i3) {
            SequenceSetProperties ssp = vamsasSet.getSequenceSetProperties(i3);
            al.setProperty(ssp.getKey(), ssp.getValue());
        }
        if (vamsasSet.getDatasetId() == null || vamsasSet.getDatasetId() == "") {
            al.setDataset(null);
        } else {
            this.recoverDatasetFor(vamsasSet, al);
        }
        Hashtable pdbloaded = new Hashtable();
        if (!multipleView) {
            for (int i4 = 0; i4 < vamsasSeq.length; ++i4) {
                if (JSEQ[i4].getFeaturesCount() > 0) {
                    Features[] features = JSEQ[i4].getFeatures();
                    for (int f = 0; f < features.length; ++f) {
                        SequenceFeature sf = new SequenceFeature(features[f].getType(), features[f].getDescription(), features[f].getStatus(), features[f].getBegin(), features[f].getEnd(), features[f].getFeatureGroup());
                        sf.setScore(features[f].getScore());
                        for (int od = 0; od < features[f].getOtherDataCount(); ++od) {
                            OtherData keyValue = features[f].getOtherData(od);
                            if (keyValue.getKey().startsWith("LINK")) {
                                sf.addLink(keyValue.getValue());
                                continue;
                            }
                            sf.setValue(keyValue.getKey(), keyValue.getValue());
                        }
                        al.getSequenceAt(i4).getDatasetSequence().addSequenceFeature(sf);
                    }
                }
                if (vamsasSeq[i4].getDBRefCount() > 0) {
                    this.addDBRefs(al.getSequenceAt(i4).getDatasetSequence(), vamsasSeq[i4]);
                }
                if (JSEQ[i4].getPdbidsCount() <= 0) continue;
                Pdbids[] ids = JSEQ[i4].getPdbids();
                for (int p = 0; p < ids.length; ++p) {
                    PDBEntry entry = new PDBEntry();
                    entry.setId(ids[p].getId());
                    entry.setType(ids[p].getType());
                    if (ids[p].getFile() != null) {
                        if (!pdbloaded.containsKey(ids[p].getFile())) {
                            entry.setFile(this.loadPDBFile(file, ids[p].getId()));
                        } else {
                            entry.setFile(pdbloaded.get(ids[p].getId()).toString());
                        }
                    }
                    al.getSequenceAt(i4).getDatasetSequence().addPDBId(entry);
                }
            }
        }
        if (vamsasSet.getAlcodonFrameCount() > 0) {
            AlcodonFrame[] alc = vamsasSet.getAlcodonFrame();
            for (int i5 = 0; i5 < alc.length; ++i5) {
                AlignedCodonFrame cf = new AlignedCodonFrame(alc[i5].getAlcodonCount());
                if (alc[i5].getAlcodonCount() > 0) {
                    Alcodon[] alcods = alc[i5].getAlcodon();
                    for (int p = 0; p < cf.codons.length; ++p) {
                        cf.codons[p] = new int[3];
                        cf.codons[p][0] = (int)alcods[p].getPos1();
                        cf.codons[p][1] = (int)alcods[p].getPos2();
                        cf.codons[p][2] = (int)alcods[p].getPos3();
                    }
                }
                if (alc[i5].getAlcodMapCount() > 0) {
                    AlcodMap[] maps = alc[i5].getAlcodMap();
                    for (int m = 0; m < maps.length; ++m) {
                        SequenceI dnaseq = (SequenceI)this.seqRefIds.get(maps[m].getDnasq());
                        Mapping mapping = null;
                        if (maps[m].getMapping() != null) {
                            mapping = this.addMapping(maps[m].getMapping());
                        }
                        if (dnaseq != null) {
                            cf.addMap(dnaseq, mapping.getTo(), mapping.getMap());
                            continue;
                        }
                        this.frefedSequence.add(new Object[]{maps[m].getDnasq(), cf, mapping});
                    }
                }
                al.addCodonFrame(cf);
            }
        }
        boolean hideQuality = true;
        boolean hideConservation = true;
        boolean hideConsensus = true;
        if (vamsasSet.getAnnotationCount() > 0) {
            jalview.schemabinding.version2.Annotation[] an = vamsasSet.getAnnotation();
            for (i = 0; i < an.length; ++i) {
                if (an[i].getLabel().equals("Quality")) {
                    hideQuality = false;
                    continue;
                }
                if (an[i].getLabel().equals("Conservation")) {
                    hideConservation = false;
                    continue;
                }
                if (an[i].getLabel().equals("Consensus")) {
                    hideConsensus = false;
                    continue;
                }
                if (an[i].getId() != null && this.annotationIds.containsKey(an[i].getId())) {
                    AlignmentAnnotation jda = (AlignmentAnnotation)this.annotationIds.get(an[i].getId());
                    if (an[i].hasVisible()) {
                        jda.visible = an[i].getVisible();
                    }
                    al.addAnnotation(jda);
                    continue;
                }
                AnnotationElement[] ae = an[i].getAnnotationElement();
                Annotation[] anot = null;
                if (!an[i].getScoreOnly()) {
                    anot = new Annotation[al.getWidth()];
                    for (int aa = 0; aa < ae.length && aa < anot.length; ++aa) {
                        if (ae[aa].getPosition() >= anot.length) continue;
                        anot[ae[aa].getPosition()] = new Annotation(ae[aa].getDisplayCharacter(), ae[aa].getDescription(), ae[aa].getSecondaryStructure() == null || ae[aa].getSecondaryStructure().length() == 0 ? (char)' ' : ae[aa].getSecondaryStructure().charAt(0), ae[aa].getValue());
                        anot[ae[aa].getPosition()].colour = new Color(ae[aa].getColour());
                    }
                }
                AlignmentAnnotation jaa = null;
                if (an[i].getGraph()) {
                    jaa = new AlignmentAnnotation(an[i].getLabel(), an[i].getDescription(), anot, 0.0f, 0.0f, an[i].getGraphType());
                    jaa.graphGroup = an[i].getGraphGroup();
                    if (an[i].getThresholdLine() != null) {
                        jaa.setThreshold(new GraphLine(an[i].getThresholdLine().getValue(), an[i].getThresholdLine().getLabel(), new Color(an[i].getThresholdLine().getColour())));
                    }
                } else {
                    jaa = new AlignmentAnnotation(an[i].getLabel(), an[i].getDescription(), anot);
                }
                if (an[i].getId() != null) {
                    this.annotationIds.put(an[i].getId(), jaa);
                    jaa.annotationId = an[i].getId();
                }
                if (an[i].getSequenceRef() != null && al.findName(an[i].getSequenceRef()) != null) {
                    jaa.createSequenceMapping(al.findName(an[i].getSequenceRef()), 1, true);
                    al.findName(an[i].getSequenceRef()).addAlignmentAnnotation(jaa);
                }
                if (an[i].hasScore()) {
                    jaa.setScore(an[i].getScore());
                }
                if (an[i].hasVisible()) {
                    jaa.visible = an[i].getVisible();
                }
                al.addAnnotation(jaa);
            }
        }
        if (jms.getJGroupCount() > 0) {
            JGroup[] groups = jms.getJGroup();
            for (i = 0; i < groups.length; ++i) {
                ColourSchemeI cs = null;
                if (groups[i].getColour() != null && (cs = groups[i].getColour().startsWith("ucs") ? this.GetUserColourScheme(jms, groups[i].getColour()) : ColourSchemeProperty.getColour(al, groups[i].getColour())) != null) {
                    cs.setThreshold(groups[i].getPidThreshold(), true);
                }
                Vector<SequenceI> seqs = new Vector<SequenceI>();
                for (int s = 0; s < groups[i].getSeqCount(); ++s) {
                    String seqId = groups[i].getSeq(s) + "";
                    SequenceI ts = (SequenceI)this.seqRefIds.get(seqId);
                    if (ts == null) continue;
                    seqs.addElement(ts);
                }
                if (seqs.size() < 1) continue;
                SequenceGroup sg = new SequenceGroup(seqs, groups[i].getName(), cs, groups[i].getDisplayBoxes(), groups[i].getDisplayText(), groups[i].getColourText(), groups[i].getStart(), groups[i].getEnd());
                sg.setOutlineColour(new Color(groups[i].getOutlineColour()));
                sg.textColour = new Color(groups[i].getTextCol1());
                sg.textColour2 = new Color(groups[i].getTextCol2());
                sg.thresholdTextColour = groups[i].getTextColThreshold();
                if (groups[i].getConsThreshold() != 0) {
                    Conservation c = new Conservation("All", ResidueProperties.propHash, 3, sg.getSequences(null), 0, sg.getWidth() - 1);
                    c.calculate();
                    c.verdict(false, 25.0f);
                    sg.cs.setConservation(c);
                }
                al.addGroup(sg);
            }
        }
        AlignFrame af = new AlignFrame(al, view.getWidth(), view.getHeight());
        af.setFileName(file, "Jalview");
        for (i = 0; i < JSEQ.length; ++i) {
            af.viewport.setSequenceColour(af.viewport.alignment.getSequenceAt(i), new Color(JSEQ[i].getColour()));
        }
        String uniqueSeqSetId = view.getSequenceSetId() + this.uniqueSetSuffix;
        af.viewport.gatherViewsHere = view.getGatheredViews();
        if (view.getSequenceSetId() != null) {
            AlignViewport av = (AlignViewport)this.viewportsAdded.get(uniqueSeqSetId);
            af.viewport.sequenceSetID = uniqueSeqSetId;
            if (av != null) {
                af.viewport.historyList = av.historyList;
                af.viewport.redoList = av.redoList;
            } else {
                this.viewportsAdded.put(uniqueSeqSetId, af.viewport);
            }
            PaintRefresher.Register(af.alignPanel, uniqueSeqSetId);
        }
        if (hiddenSeqs != null) {
            for (int s = 0; s < JSEQ.length; ++s) {
                SequenceGroup hidden = new SequenceGroup();
                for (int r = 0; r < JSEQ[s].getHiddenSequencesCount(); ++r) {
                    hidden.addSequence(al.getSequenceAt(JSEQ[s].getHiddenSequences(r)), false);
                }
                af.viewport.hideRepSequences(al.getSequenceAt(s), hidden);
            }
            SequenceI[] hseqs = new SequenceI[hiddenSeqs.size()];
            for (int s = 0; s < hiddenSeqs.size(); ++s) {
                hseqs[s] = (SequenceI)hiddenSeqs.elementAt(s);
            }
            af.viewport.hideSequence(hseqs);
        }
        if ((hideConsensus || hideQuality || hideConservation) && al.getAlignmentAnnotation() != null) {
            int hSize = al.getAlignmentAnnotation().length;
            for (int h = 0; h < hSize; ++h) {
                if (!(hideConsensus && al.getAlignmentAnnotation()[h].label.equals("Consensus") || hideQuality && al.getAlignmentAnnotation()[h].label.equals("Quality")) && (!hideConservation || !al.getAlignmentAnnotation()[h].label.equals("Conservation"))) continue;
                al.deleteAnnotation(al.getAlignmentAnnotation()[h]);
                --hSize;
                --h;
            }
            af.alignPanel.adjustAnnotationHeight();
        }
        if (view.getViewName() != null) {
            af.viewport.viewName = view.getViewName();
            af.setInitialTabVisible();
        }
        af.setBounds(view.getXpos(), view.getYpos(), view.getWidth(), view.getHeight());
        af.viewport.setShowAnnotation(view.getShowAnnotation());
        af.viewport.setAbovePIDThreshold(view.getPidSelected());
        af.viewport.setColourText(view.getShowColourText());
        af.viewport.setConservationSelected(view.getConservationSelected());
        af.viewport.setShowJVSuffix(view.getShowFullId());
        af.viewport.rightAlignIds = view.getRightAlignIds();
        af.viewport.setFont(new Font(view.getFontName(), view.getFontStyle(), view.getFontSize()));
        af.alignPanel.fontChanged();
        af.viewport.setRenderGaps(view.getRenderGaps());
        af.viewport.setWrapAlignment(view.getWrapAlignment());
        af.alignPanel.setWrapAlignment(view.getWrapAlignment());
        af.viewport.setShowAnnotation(view.getShowAnnotation());
        af.alignPanel.setAnnotationVisible(view.getShowAnnotation());
        af.viewport.setShowBoxes(view.getShowBoxes());
        af.viewport.setShowText(view.getShowText());
        af.viewport.textColour = new Color(view.getTextCol1());
        af.viewport.textColour2 = new Color(view.getTextCol2());
        af.viewport.thresholdTextColour = view.getTextColThreshold();
        af.viewport.setStartRes(view.getStartRes());
        af.viewport.setStartSeq(view.getStartSeq());
        ColourSchemeI cs = null;
        if (view.getBgColour() != null) {
            if (view.getBgColour().startsWith("ucs")) {
                cs = this.GetUserColourScheme(jms, view.getBgColour());
            } else if (view.getBgColour().startsWith("Annotation")) {
                for (int i6 = 0; i6 < af.viewport.alignment.getAlignmentAnnotation().length; ++i6) {
                    if (!af.viewport.alignment.getAlignmentAnnotation()[i6].label.equals(view.getAnnotationColours().getAnnotation())) continue;
                    if (af.viewport.alignment.getAlignmentAnnotation()[i6].getThreshold() == null) {
                        af.viewport.alignment.getAlignmentAnnotation()[i6].setThreshold(new GraphLine(view.getAnnotationColours().getThreshold(), "Threshold", Color.black));
                    }
                    cs = view.getAnnotationColours().getColourScheme().equals("None") ? new AnnotationColourGradient(af.viewport.alignment.getAlignmentAnnotation()[i6], new Color(view.getAnnotationColours().getMinColour()), new Color(view.getAnnotationColours().getMaxColour()), view.getAnnotationColours().getAboveThreshold()) : (view.getAnnotationColours().getColourScheme().startsWith("ucs") ? new AnnotationColourGradient(af.viewport.alignment.getAlignmentAnnotation()[i6], this.GetUserColourScheme(jms, view.getAnnotationColours().getColourScheme()), view.getAnnotationColours().getAboveThreshold()) : new AnnotationColourGradient(af.viewport.alignment.getAlignmentAnnotation()[i6], ColourSchemeProperty.getColour(al, view.getAnnotationColours().getColourScheme()), view.getAnnotationColours().getAboveThreshold()));
                    if (al.getGroups() != null) {
                        for (int g = 0; g < al.getGroups().size(); ++g) {
                            SequenceGroup sg = (SequenceGroup)al.getGroups().elementAt(g);
                            if (sg.cs == null) continue;
                            sg.cs = new AnnotationColourGradient(af.viewport.alignment.getAlignmentAnnotation()[i6], sg.cs, view.getAnnotationColours().getAboveThreshold());
                        }
                    }
                    break;
                }
            } else {
                cs = ColourSchemeProperty.getColour(al, view.getBgColour());
            }
            if (cs != null) {
                cs.setThreshold(view.getPidThreshold(), true);
                cs.setConsensus(af.viewport.hconsensus);
            }
        }
        af.viewport.setGlobalColourScheme(cs);
        af.viewport.setColourAppliesToAllGroups(false);
        if (view.getConservationSelected() && cs != null) {
            cs.setConservationInc(view.getConsThreshold());
        }
        af.changeColour(cs);
        af.viewport.setColourAppliesToAllGroups(true);
        if (view.getShowSequenceFeatures()) {
            af.viewport.showSequenceFeatures = true;
        }
        if (jms.getFeatureSettings() != null) {
            Hashtable<String, Boolean> fgtable;
            af.viewport.featuresDisplayed = new Hashtable();
            String[] renderOrder = new String[jms.getFeatureSettings().getSettingCount()];
            for (int fs = 0; fs < jms.getFeatureSettings().getSettingCount(); ++fs) {
                Setting setting = jms.getFeatureSettings().getSetting(fs);
                af.alignPanel.seqPanel.seqCanvas.getFeatureRenderer().setColour(setting.getType(), new Color(setting.getColour()));
                renderOrder[fs] = setting.getType();
                if (setting.hasOrder()) {
                    af.alignPanel.seqPanel.seqCanvas.getFeatureRenderer().setOrder(setting.getType(), setting.getOrder());
                } else {
                    af.alignPanel.seqPanel.seqCanvas.getFeatureRenderer().setOrder(setting.getType(), fs / jms.getFeatureSettings().getSettingCount());
                }
                if (!setting.getDisplay()) continue;
                af.viewport.featuresDisplayed.put(setting.getType(), new Integer(setting.getColour()));
            }
            af.alignPanel.seqPanel.seqCanvas.getFeatureRenderer().renderOrder = renderOrder;
            af.alignPanel.seqPanel.seqCanvas.getFeatureRenderer().featureGroups = fgtable = new Hashtable<String, Boolean>();
            for (int gs = 0; gs < jms.getFeatureSettings().getGroupCount(); ++gs) {
                Group grp = jms.getFeatureSettings().getGroup(gs);
                fgtable.put(grp.getName(), new Boolean(grp.getDisplay()));
            }
        }
        if (view.getHiddenColumnsCount() > 0) {
            for (int c = 0; c < view.getHiddenColumnsCount(); ++c) {
                af.viewport.hideColumns(view.getHiddenColumns(c).getStart(), view.getHiddenColumns(c).getEnd());
            }
        }
        af.setMenusFromViewport(af.viewport);
        Desktop.addInternalFrame(af, view.getTitle(), view.getWidth(), view.getHeight());
        if (loadTreesAndStructures && jms.getTreeCount() > 0) {
            try {
                for (int t = 0; t < jms.getTreeCount(); ++t) {
                    Tree tree = jms.getTree(t);
                    TreePanel tp = af.ShowNewickTree(new NewickFile(tree.getNewick()), tree.getTitle(), tree.getWidth(), tree.getHeight(), tree.getXpos(), tree.getYpos());
                    tp.fitToWindow.setState(tree.getFitToWindow());
                    tp.fitToWindow_actionPerformed(null);
                    if (tree.getFontName() != null) {
                        tp.setTreeFont(new Font(tree.getFontName(), tree.getFontStyle(), tree.getFontSize()));
                    } else {
                        tp.setTreeFont(new Font(view.getFontName(), view.getFontStyle(), tree.getFontSize()));
                    }
                    tp.showPlaceholders(tree.getMarkUnlinked());
                    tp.showBootstrap(tree.getShowBootstrap());
                    tp.showDistances(tree.getShowDistances());
                    tp.treeCanvas.threshold = tree.getThreshold();
                    if (!tree.getCurrentTree()) continue;
                    af.viewport.setCurrentTree(tp.getTree());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (loadTreesAndStructures) {
            for (int i7 = 0; i7 < JSEQ.length; ++i7) {
                if (JSEQ[i7].getPdbidsCount() <= 0) continue;
                Pdbids[] ids = JSEQ[i7].getPdbids();
                for (int p = 0; p < ids.length; ++p) {
                    for (int s = 0; s < ids[p].getStructureStateCount(); ++s) {
                        PDBEntry jpdb = new PDBEntry();
                        jpdb.setFile(this.loadPDBFile(ids[p].getFile(), ids[p].getId()));
                        jpdb.setId(ids[p].getId());
                        int x = ids[p].getStructureState(s).getXpos();
                        int y = ids[p].getStructureState(s).getYpos();
                        int width = ids[p].getStructureState(s).getWidth();
                        int height = ids[p].getStructureState(s).getHeight();
                        JInternalFrame comp = null;
                        JInternalFrame[] frames = null;
                        do {
                            try {
                                frames = Desktop.desktop.getAllFrames();
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                frames = null;
                                try {
                                    Thread.sleep(10L);
                                }
                                catch (Exception f) {
                                    // empty catch block
                                }
                            }
                        } while (frames == null);
                        for (int f = 0; f < frames.length; ++f) {
                            if (!(frames[f] instanceof AppJmol) || frames[f].getX() != x || frames[f].getY() != y || frames[f].getHeight() != height || frames[f].getWidth() != width) continue;
                            comp = frames[f];
                            break;
                        }
                        Desktop.desktop.getComponentAt(x, y);
                        String pdbFile = this.loadPDBFile(file, ids[p].getId());
                        SequenceI[] seq = new SequenceI[]{(SequenceI)this.seqRefIds.get(JSEQ[i7].getId() + "")};
                        if (comp == null) {
                            String state = ids[p].getStructureState(s).getContent();
                            StringBuffer newFileLoc = new StringBuffer(state.substring(0, state.indexOf("\"", state.indexOf("load")) + 1));
                            newFileLoc.append(jpdb.getFile());
                            newFileLoc.append(state.substring(state.indexOf("\"", state.indexOf("load \"") + 6)));
                            new AppJmol(pdbFile, ids[p].getId(), seq, af.alignPanel, newFileLoc.toString(), new Rectangle(x, y, width, height));
                            continue;
                        }
                        if (comp == null) continue;
                        StructureSelectionManager.getStructureSelectionManager().setMapping(seq, null, pdbFile, AppletFormatAdapter.FILE);
                        ((AppJmol)comp).addSequence(seq);
                    }
                }
            }
        }
        return af;
    }

    private void recoverDatasetFor(SequenceSet vamsasSet, Alignment al) {
        Alignment ds = this.getDatasetFor(vamsasSet.getDatasetId());
        Vector dseqs = null;
        if (ds == null) {
            dseqs = new Vector();
        }
        int iSize = vamsasSet.getSequenceCount();
        for (int i = 0; i < iSize; ++i) {
            jalview.schemabinding.version2.Sequence vamsasSeq = vamsasSet.getSequence(i);
            this.ensureJalviewDatasetSequence(vamsasSeq, ds, dseqs);
        }
        if (ds == null) {
            Object[] dsseqs = new SequenceI[dseqs.size()];
            dseqs.copyInto(dsseqs);
            ds = new Alignment((SequenceI[])dsseqs);
            this.addDatasetRef(vamsasSet.getDatasetId(), ds);
        }
        if (al.getDataset() == null) {
            al.setDataset(ds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureJalviewDatasetSequence(jalview.schemabinding.version2.Sequence vamsasSeq, AlignmentI ds, Vector dseqs) {
        Sequence sq = (Sequence)this.seqRefIds.get(vamsasSeq.getId());
        SequenceI dsq = null;
        if (sq != null && sq.getDatasetSequence() != null) {
            dsq = sq.getDatasetSequence();
        }
        String sqid = vamsasSeq.getDsseqid();
        if (dsq == null) {
            if (sqid != null) {
                dsq = (SequenceI)this.seqRefIds.get(sqid);
            }
            if (dsq == null) {
                dsq = sq.createDatasetSequence();
                if (sqid == null) {
                    sqid = this.seqHash(dsq);
                }
                dsq.setVamsasId(this.uniqueSetSuffix + sqid);
                this.seqRefIds.put(sqid, dsq);
                if (ds == null) {
                    if (dseqs != null) {
                        dseqs.addElement(dsq);
                    }
                } else {
                    ds.addSequence(dsq);
                }
            } else if (sq != dsq) {
                sq.setDatasetSequence(dsq);
            }
        }
        if (sq != dsq) {
            StringBuffer sb = new StringBuffer();
            String newres = AlignSeq.extractGaps(" .-", sq.getSequenceAsString());
            if (!newres.equalsIgnoreCase(dsq.getSequenceAsString()) && newres.length() > dsq.getLength()) {
                SequenceI sequenceI = dsq;
                synchronized (sequenceI) {
                    dsq.setSequence(sb.toString());
                }
                System.err.println("DEBUG Notice:  Merged dataset sequence");
            }
        }
    }

    private Alignment getDatasetFor(String datasetId) {
        if (this.datasetIds == null) {
            this.datasetIds = new Hashtable();
            return null;
        }
        if (this.datasetIds.containsKey(datasetId)) {
            return (Alignment)this.datasetIds.get(datasetId);
        }
        return null;
    }

    private void addDatasetRef(String datasetId, Alignment dataset) {
        if (this.datasetIds == null) {
            this.datasetIds = new Hashtable();
        }
        this.datasetIds.put(datasetId, dataset);
    }

    private void addDBRefs(SequenceI datasetSequence, jalview.schemabinding.version2.Sequence sequence) {
        for (int d = 0; d < sequence.getDBRefCount(); ++d) {
            DBRef dr = sequence.getDBRef(d);
            DBRefEntry entry = new DBRefEntry(sequence.getDBRef(d).getSource(), sequence.getDBRef(d).getVersion(), sequence.getDBRef(d).getAccessionId());
            if (dr.getMapping() != null) {
                entry.setMap(this.addMapping(dr.getMapping()));
            }
            datasetSequence.addDBRef(entry);
        }
    }

    private Mapping addMapping(jalview.schemabinding.version2.Mapping m) {
        SequenceI dsto = null;
        int[] fr = new int[m.getMapListFromCount() * 2];
        Enumeration f = m.enumerateMapListFrom();
        int _i = 0;
        while (f.hasMoreElements()) {
            MapListFrom mf = (MapListFrom)f.nextElement();
            fr[_i] = mf.getStart();
            fr[_i + 1] = mf.getEnd();
            _i += 2;
        }
        int[] fto = new int[m.getMapListToCount() * 2];
        f = m.enumerateMapListTo();
        int _i2 = 0;
        while (f.hasMoreElements()) {
            MapListTo mf = (MapListTo)f.nextElement();
            fto[_i2] = mf.getStart();
            fto[_i2 + 1] = mf.getEnd();
            _i2 += 2;
        }
        Mapping jmap = new Mapping(dsto, fr, fto, (int)m.getMapFromUnit(), (int)m.getMapToUnit());
        if (m.getMappingChoice() != null) {
            MappingChoice mc = m.getMappingChoice();
            if (mc.getDseqFor() != null) {
                if (this.seqRefIds.containsKey(mc.getDseqFor())) {
                    jmap.setTo((SequenceI)this.seqRefIds.get(mc.getDseqFor()));
                } else {
                    this.frefedSequence.add(new Object[]{mc.getDseqFor(), jmap});
                }
            } else {
                jalview.schemabinding.version2.Sequence ms = mc.getSequence();
                Sequence djs = null;
                String sqid = ms.getDsseqid();
                if (sqid != null && sqid.length() > 0) {
                    djs = (Sequence)this.seqRefIds.get(sqid);
                } else {
                    System.err.println("Warning - making up dataset sequence id for DbRef sequence map reference");
                    sqid = ms.toString();
                }
                if (djs == null) {
                    djs = new Sequence(ms.getName(), ms.getSequence());
                    djs.setStart(jmap.getMap().getToLowest());
                    djs.setEnd(jmap.getMap().getToHighest());
                    djs.setVamsasId(this.uniqueSetSuffix + sqid);
                    jmap.setTo(djs);
                    this.seqRefIds.put(sqid, djs);
                }
                Cache.log.debug((Object)"about to recurse on addDBRefs.");
                this.addDBRefs(djs, ms);
            }
        }
        return jmap;
    }

    public AlignmentPanel copyAlignPanel(AlignmentPanel ap, boolean keepSeqRefs) {
        JalviewModel jm = this.SaveState(ap, null, null);
        if (!keepSeqRefs) {
            this.clearSeqRefs();
            jm.getJalviewModelSequence().getViewport(0).setSequenceSetId(null);
        } else {
            this.uniqueSetSuffix = "";
        }
        this.viewportsAdded = new Hashtable();
        AlignFrame af = this.LoadFromObject(jm, null, false);
        af.alignPanels.clear();
        af.closeMenuItem_actionPerformed(true);
        return af.alignPanel;
    }

    protected void finalize() throws Throwable {
        this.clearSeqRefs();
        this.seqRefIds = null;
        this.seqsToIds = null;
        super.finalize();
    }
}

