/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.Conservation;
import jalview.binding.Annotation;
import jalview.binding.AnnotationElement;
import jalview.binding.Features;
import jalview.binding.JGroup;
import jalview.binding.JSeq;
import jalview.binding.JalviewModel;
import jalview.binding.JalviewModelSequence;
import jalview.binding.Pdbids;
import jalview.binding.Sequence;
import jalview.binding.SequenceSet;
import jalview.binding.Setting;
import jalview.binding.Tree;
import jalview.binding.UserColours;
import jalview.binding.Viewport;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.TreePanel;
import jalview.io.NewickFile;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemeProperty;
import jalview.schemes.ResidueProperties;
import jalview.schemes.UserColourScheme;
import java.awt.Color;
import java.awt.Font;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Jalview2XML_V1 {
    boolean raiseGUI = true;

    public Jalview2XML_V1() {
    }

    public Jalview2XML_V1(boolean raiseGUI) {
        this.raiseGUI = raiseGUI;
    }

    UserColourScheme GetUserColourScheme(JalviewModelSequence jms, String id) {
        UserColours[] uc = jms.getUserColours();
        UserColours colours = null;
        for (int i = 0; i < uc.length; ++i) {
            if (!uc[i].getId().equals(id)) continue;
            colours = uc[i];
            break;
        }
        int csize = colours.getUserColourScheme().getColourCount();
        Color[] newColours = new Color[csize];
        for (int i = 0; i < csize; ++i) {
            newColours[i] = new Color(Integer.parseInt(colours.getUserColourScheme().getColour(i).getRGB(), 16));
        }
        return new UserColourScheme(newColours);
    }

    public AlignFrame LoadJalviewAlign(final String file) {
        AlignFrame af;
        block7: {
            af = null;
            try {
                URL url = null;
                if (file.startsWith("http://")) {
                    url = new URL(file);
                }
                JarInputStream jin = null;
                JarEntry jarentry = null;
                int entryCount = 1;
                do {
                    jin = url != null ? new JarInputStream(url.openStream()) : new JarInputStream(new FileInputStream(file));
                    for (int i = 0; i < entryCount; ++i) {
                        jarentry = jin.getNextJarEntry();
                    }
                    if (jarentry == null) continue;
                    InputStreamReader in = new InputStreamReader((InputStream)jin, "UTF-8");
                    JalviewModel object = new JalviewModel();
                    object = JalviewModel.unmarshal(in);
                    af = this.LoadFromObject(object, file);
                    ++entryCount;
                } while (jarentry != null);
            }
            catch (UnknownHostException ex) {
                ex.printStackTrace();
                if (this.raiseGUI) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            System.err.println("Couldn't locate Jalview XML file : " + ex + "\n");
                            JOptionPane.showInternalMessageDialog(Desktop.desktop, "Couldn't locate " + file, "URL not found", 2);
                        }
                    });
                }
            }
            catch (Exception ex) {
                System.err.println("Exception whilst loading jalview XML file : ");
                ex.printStackTrace();
                if (!this.raiseGUI) break block7;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showInternalMessageDialog(Desktop.desktop, "Error loading  " + file, "Error loading Jalview file", 2);
                    }
                });
            }
        }
        return af;
    }

    AlignFrame LoadFromObject(JalviewModel object, String file) {
        Vector<SequenceI> seqids = new Vector<SequenceI>();
        SequenceSet vamsasSet = object.getVamsasModel().getSequenceSet(0);
        Sequence[] vamsasSeq = vamsasSet.getSequence();
        JalviewModelSequence jms = object.getJalviewModelSequence();
        SequenceI[] jseqs = new jalview.datamodel.Sequence[vamsasSeq.length];
        JSeq[] JSEQ = object.getJalviewModelSequence().getJSeq();
        for (int i = 0; i < vamsasSeq.length; ++i) {
            jseqs[i] = new jalview.datamodel.Sequence(vamsasSeq[i].getName(), vamsasSeq[i].getSequence());
            ((jalview.datamodel.Sequence)jseqs[i]).setStart(JSEQ[i].getStart());
            ((jalview.datamodel.Sequence)jseqs[i]).setEnd(JSEQ[i].getEnd());
            seqids.add(jseqs[i]);
        }
        Alignment al = new Alignment(jseqs);
        al.setDataset(null);
        for (int i = 0; i < vamsasSeq.length; ++i) {
            if (JSEQ[i].getFeaturesCount() > 0) {
                Features[] features = JSEQ[i].getFeatures();
                for (int f = 0; f < features.length; ++f) {
                    SequenceFeature sf = new SequenceFeature(features[f].getType(), features[f].getDescription(), features[f].getStatus(), features[f].getBegin(), features[f].getEnd(), null);
                    al.getSequenceAt(i).getDatasetSequence().addSequenceFeature(sf);
                }
            }
            if (JSEQ[i].getPdbidsCount() <= 0) continue;
            Pdbids[] ids = JSEQ[i].getPdbids();
            for (int p = 0; p < ids.length; ++p) {
                PDBEntry entry = new PDBEntry();
                entry.setId(ids[p].getId());
                entry.setType(ids[p].getType());
                al.getSequenceAt(i).getDatasetSequence().addPDBId(entry);
            }
        }
        if (vamsasSet.getAnnotation() != null) {
            Annotation[] an = vamsasSet.getAnnotation();
            for (int i = 0; i < an.length; ++i) {
                AnnotationElement[] ae = an[i].getAnnotationElement();
                jalview.datamodel.Annotation[] anot = new jalview.datamodel.Annotation[al.getWidth()];
                for (int aa = 0; aa < ae.length; ++aa) {
                    anot[ae[aa].getPosition()] = new jalview.datamodel.Annotation(ae[aa].getDisplayCharacter(), ae[aa].getDescription(), ae[aa].getSecondaryStructure().charAt(0), ae[aa].getValue());
                }
                AlignmentAnnotation jaa = null;
                jaa = an[i].getGraph() ? new AlignmentAnnotation(an[i].getLabel(), an[i].getDescription(), anot, 0.0f, 0.0f, 1) : new AlignmentAnnotation(an[i].getLabel(), an[i].getDescription(), anot);
                al.addAnnotation(jaa);
            }
        }
        Viewport[] views = jms.getViewport();
        Viewport view = views[0];
        AlignFrame af = new AlignFrame(al, view.getWidth(), view.getHeight());
        af.setFileName(file, "Jalview");
        for (int i = 0; i < JSEQ.length; ++i) {
            af.viewport.setSequenceColour(af.viewport.alignment.getSequenceAt(i), new Color(JSEQ[i].getColour()));
        }
        if (jms.getJGroupCount() > 0) {
            JGroup[] groups = jms.getJGroup();
            for (int i = 0; i < groups.length; ++i) {
                ColourSchemeI cs = null;
                if (groups[i].getColour() != null && (cs = groups[i].getColour().startsWith("ucs") ? this.GetUserColourScheme(jms, groups[i].getColour()) : ColourSchemeProperty.getColour(al, groups[i].getColour())) != null) {
                    cs.setThreshold(groups[i].getPidThreshold(), true);
                }
                Vector<SequenceI> seqs = new Vector<SequenceI>();
                int[] ids = groups[i].getSeq();
                for (int s = 0; s < ids.length; ++s) {
                    seqs.addElement((SequenceI)seqids.elementAt(ids[s]));
                }
                SequenceGroup sg = new SequenceGroup(seqs, groups[i].getName(), cs, groups[i].getDisplayBoxes(), groups[i].getDisplayText(), groups[i].getColourText(), groups[i].getStart(), groups[i].getEnd());
                sg.setOutlineColour(new Color(groups[i].getOutlineColour()));
                if (groups[i].getConsThreshold() != 0) {
                    Conservation c = new Conservation("All", ResidueProperties.propHash, 3, sg.getSequences(null), 0, sg.getWidth() - 1);
                    c.calculate();
                    c.verdict(false, 25.0f);
                    sg.cs.setConservation(c);
                }
                al.addGroup(sg);
            }
        }
        af.setBounds(view.getXpos(), view.getYpos(), view.getWidth(), view.getHeight());
        af.viewport.setStartRes(view.getStartRes());
        af.viewport.setStartSeq(view.getStartSeq());
        af.viewport.setShowAnnotation(view.getShowAnnotation());
        af.viewport.setAbovePIDThreshold(view.getPidSelected());
        af.viewport.setColourText(view.getShowColourText());
        af.viewport.setConservationSelected(view.getConservationSelected());
        af.viewport.setShowJVSuffix(view.getShowFullId());
        af.viewport.setFont(new Font(view.getFontName(), view.getFontStyle(), view.getFontSize()));
        af.alignPanel.fontChanged();
        af.viewport.setRenderGaps(view.getRenderGaps());
        af.viewport.setWrapAlignment(view.getWrapAlignment());
        af.alignPanel.setWrapAlignment(view.getWrapAlignment());
        af.viewport.setShowAnnotation(view.getShowAnnotation());
        af.alignPanel.setAnnotationVisible(view.getShowAnnotation());
        af.viewport.setShowBoxes(view.getShowBoxes());
        af.viewport.setShowText(view.getShowText());
        ColourSchemeI cs = null;
        if (view.getBgColour() != null && (cs = view.getBgColour().startsWith("ucs") ? this.GetUserColourScheme(jms, view.getBgColour()) : ColourSchemeProperty.getColour(al, view.getBgColour())) != null) {
            cs.setThreshold(view.getPidThreshold(), true);
            cs.setConsensus(af.viewport.hconsensus);
        }
        af.viewport.setGlobalColourScheme(cs);
        af.viewport.setColourAppliesToAllGroups(false);
        af.changeColour(cs);
        if (view.getConservationSelected() && cs != null) {
            cs.setConservationInc(view.getConsThreshold());
        }
        af.viewport.setColourAppliesToAllGroups(true);
        af.viewport.showSequenceFeatures = view.getShowSequenceFeatures();
        if (jms.getFeatureSettings() != null) {
            af.viewport.featuresDisplayed = new Hashtable();
            String[] renderOrder = new String[jms.getFeatureSettings().getSettingCount()];
            for (int fs = 0; fs < jms.getFeatureSettings().getSettingCount(); ++fs) {
                Setting setting = jms.getFeatureSettings().getSetting(fs);
                af.alignPanel.seqPanel.seqCanvas.getFeatureRenderer().setColour(setting.getType(), new Color(setting.getColour()));
                renderOrder[fs] = setting.getType();
                if (!setting.getDisplay()) continue;
                af.viewport.featuresDisplayed.put(setting.getType(), new Integer(setting.getColour()));
            }
            af.alignPanel.seqPanel.seqCanvas.getFeatureRenderer().renderOrder = renderOrder;
        }
        af.setMenusFromViewport(af.viewport);
        Desktop.addInternalFrame(af, view.getTitle(), view.getWidth(), view.getHeight());
        if (jms.getTreeCount() > 0) {
            try {
                for (int t = 0; t < jms.getTreeCount(); ++t) {
                    Tree tree = jms.getTree(t);
                    TreePanel tp = af.ShowNewickTree(new NewickFile(tree.getNewick()), tree.getTitle(), tree.getWidth(), tree.getHeight(), tree.getXpos(), tree.getYpos());
                    tp.fitToWindow.setState(tree.getFitToWindow());
                    tp.fitToWindow_actionPerformed(null);
                    if (tree.getFontName() != null) {
                        tp.setTreeFont(new Font(tree.getFontName(), tree.getFontStyle(), tree.getFontSize()));
                    } else {
                        tp.setTreeFont(new Font(view.getFontName(), view.getFontStyle(), tree.getFontSize()));
                    }
                    tp.showPlaceholders(tree.getMarkUnlinked());
                    tp.showBootstrap(tree.getShowBootstrap());
                    tp.showDistances(tree.getShowDistances());
                    tp.treeCanvas.threshold = tree.getThreshold();
                    if (!tree.getCurrentTree()) continue;
                    af.viewport.setCurrentTree(tp.getTree());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return af;
    }
}

