/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.datamodel.SequenceI;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.FeatureRenderer;
import jalview.gui.SequenceRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class OverviewPanel
extends JPanel
implements Runnable {
    BufferedImage miniMe;
    AlignViewport av;
    AlignmentPanel ap;
    float scalew = 1.0f;
    float scaleh = 1.0f;
    int width;
    int sequencesHeight;
    int graphHeight = 20;
    int boxX = -1;
    int boxY = -1;
    int boxWidth = -1;
    int boxHeight = -1;
    boolean resizing = false;
    SequenceRenderer sr;
    FeatureRenderer fr;
    boolean resizeAgain = false;

    public OverviewPanel(AlignmentPanel ap) {
        this.av = ap.av;
        this.ap = ap;
        this.setLayout(null);
        this.sr = new SequenceRenderer(this.av);
        this.sr.renderGaps = false;
        this.sr.forOverview = true;
        this.fr = new FeatureRenderer(ap);
        float initialScale = (float)this.av.alignment.getWidth() / (float)this.av.alignment.getHeight();
        if (this.av.conservation == null) {
            this.graphHeight = 0;
        }
        if (this.av.alignment.getWidth() > this.av.alignment.getHeight()) {
            this.width = 400;
            this.sequencesHeight = (int)(400.0f / initialScale);
            if (this.sequencesHeight < 40) {
                this.sequencesHeight = 40;
            }
        } else {
            this.width = (int)(400.0f * initialScale);
            this.sequencesHeight = 300;
            if (this.width < 120) {
                this.width = 120;
            }
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                if (OverviewPanel.this.getWidth() != OverviewPanel.this.width || OverviewPanel.this.getHeight() != OverviewPanel.this.sequencesHeight + OverviewPanel.this.graphHeight) {
                    OverviewPanel.this.updateOverviewImage();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                if (!OverviewPanel.this.av.wrapAlignment) {
                    OverviewPanel.this.boxX = evt.getX();
                    OverviewPanel.this.boxY = evt.getY();
                    OverviewPanel.this.checkValid();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (!OverviewPanel.this.av.wrapAlignment) {
                    OverviewPanel.this.boxX = evt.getX();
                    OverviewPanel.this.boxY = evt.getY();
                    OverviewPanel.this.checkValid();
                }
            }
        });
        this.updateOverviewImage();
    }

    void checkValid() {
        if (this.boxY < 0) {
            this.boxY = 0;
        }
        if (this.boxY > this.sequencesHeight - this.boxHeight) {
            this.boxY = this.sequencesHeight - this.boxHeight + 1;
        }
        if (this.boxX < 0) {
            this.boxX = 0;
        }
        if (this.boxX > this.width - this.boxWidth) {
            if (this.av.hasHiddenColumns) {
                this.boxWidth = (int)((float)((this.av.endRes - this.av.startRes + 1) * this.av.getCharWidth()) * this.scalew);
            }
            this.boxX = this.width - this.boxWidth;
        }
        int col = (int)((float)this.boxX / this.scalew / (float)this.av.getCharWidth());
        int row = (int)((float)this.boxY / this.scaleh / (float)this.av.getCharHeight());
        if (this.av.hasHiddenColumns) {
            if (!this.av.getColumnSelection().isVisible(col)) {
                return;
            }
            col = this.av.getColumnSelection().findColumnPosition(col);
        }
        if (this.av.hasHiddenRows) {
            row = this.av.alignment.getHiddenSequences().findIndexWithoutHiddenSeqs(row);
        }
        this.ap.setScrollValues(col, row);
    }

    public void updateOverviewImage() {
        if (this.resizing) {
            this.resizeAgain = true;
            return;
        }
        this.resizing = true;
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this.width = this.getWidth();
            this.sequencesHeight = this.getHeight() - this.graphHeight;
        }
        this.setPreferredSize(new Dimension(this.width, this.sequencesHeight + this.graphHeight));
        Thread thread = new Thread(this);
        thread.start();
        this.repaint();
    }

    public void run() {
        int col;
        this.miniMe = null;
        if (this.av.showSequenceFeatures) {
            this.fr.transferSettings(this.ap.seqPanel.seqCanvas.getFeatureRenderer());
        }
        int alwidth = this.av.alignment.getWidth();
        int alheight = this.av.alignment.getHeight() + this.av.alignment.getHiddenSequences().getSize();
        this.setPreferredSize(new Dimension(this.width, this.sequencesHeight + this.graphHeight));
        int fullsizeWidth = alwidth * this.av.getCharWidth();
        int fullsizeHeight = alheight * this.av.getCharHeight();
        this.scalew = (float)this.width / (float)fullsizeWidth;
        this.scaleh = (float)this.sequencesHeight / (float)fullsizeHeight;
        this.miniMe = new BufferedImage(this.width, this.sequencesHeight + this.graphHeight, 1);
        Graphics mg = this.miniMe.getGraphics();
        mg.setColor(Color.orange);
        mg.fillRect(0, 0, this.width, this.miniMe.getHeight());
        float sampleCol = (float)alwidth / (float)this.width;
        float sampleRow = (float)alheight / (float)this.sequencesHeight;
        int lastcol = -1;
        int lastrow = -1;
        int color = Color.white.getRGB();
        boolean hiddenRow = false;
        for (int row = 0; row < this.sequencesHeight; ++row) {
            SequenceI seq;
            if ((int)((float)row * sampleRow) == lastrow) {
                for (col = 0; col < this.width; ++col) {
                    this.miniMe.setRGB(col, row, this.miniMe.getRGB(col, row - 1));
                }
                continue;
            }
            lastrow = (int)((float)row * sampleRow);
            hiddenRow = false;
            if (this.av.hasHiddenRows) {
                seq = this.av.alignment.getHiddenSequences().getHiddenSequence(lastrow);
                if (seq == null) {
                    int index = this.av.alignment.getHiddenSequences().findIndexWithoutHiddenSeqs(lastrow);
                    seq = this.av.alignment.getSequenceAt(index);
                } else {
                    hiddenRow = true;
                }
            } else {
                seq = this.av.alignment.getSequenceAt(lastrow);
            }
            if (seq == null) {
                System.out.println(lastrow + " null");
                continue;
            }
            for (col = 0; col < this.width; ++col) {
                if ((int)((float)col * sampleCol) == lastcol && (int)((float)row * sampleRow) == lastrow) {
                    this.miniMe.setRGB(col, row, color);
                    continue;
                }
                lastcol = (int)((float)col * sampleCol);
                if (seq.getLength() > lastcol) {
                    color = this.sr.getResidueBoxColour(seq, lastcol).getRGB();
                    if (this.av.showSequenceFeatures) {
                        color = this.fr.findFeatureColour(color, seq, lastcol);
                    }
                } else {
                    color = -1;
                }
                if (hiddenRow || this.av.hasHiddenColumns && !this.av.getColumnSelection().isVisible(lastcol)) {
                    color = new Color(color).darker().darker().getRGB();
                }
                this.miniMe.setRGB(col, row, color);
            }
        }
        if (this.av.conservation != null) {
            for (col = 0; col < this.width; ++col) {
                lastcol = (int)((float)col * sampleCol);
                mg.translate(col, this.sequencesHeight);
                this.ap.annotationPanel.drawGraph(mg, this.av.conservation, (int)sampleCol + 1, this.graphHeight, (int)((float)col * sampleCol), (int)((float)col * sampleCol) + 1);
                mg.translate(-col, -this.sequencesHeight);
            }
        }
        System.gc();
        this.resizing = false;
        this.setBoxPosition();
        if (this.resizeAgain) {
            this.resizeAgain = false;
            this.updateOverviewImage();
        }
    }

    public void setBoxPosition() {
        int fullsizeWidth = this.av.alignment.getWidth() * this.av.getCharWidth();
        int fullsizeHeight = (this.av.alignment.getHeight() + this.av.alignment.getHiddenSequences().getSize()) * this.av.getCharHeight();
        int startRes = this.av.getStartRes();
        int endRes = this.av.getEndRes();
        if (this.av.hasHiddenColumns) {
            startRes = this.av.getColumnSelection().adjustForHiddenColumns(startRes);
            endRes = this.av.getColumnSelection().adjustForHiddenColumns(endRes);
        }
        int startSeq = this.av.startSeq;
        int endSeq = this.av.endSeq;
        if (this.av.hasHiddenRows) {
            startSeq = this.av.alignment.getHiddenSequences().adjustForHiddenSeqs(startSeq);
            endSeq = this.av.alignment.getHiddenSequences().adjustForHiddenSeqs(endSeq);
        }
        this.scalew = (float)this.width / (float)fullsizeWidth;
        this.scaleh = (float)this.sequencesHeight / (float)fullsizeHeight;
        this.boxX = (int)((float)(startRes * this.av.getCharWidth()) * this.scalew);
        this.boxY = (int)((float)(startSeq * this.av.getCharHeight()) * this.scaleh);
        this.boxWidth = this.av.hasHiddenColumns ? (int)((float)((endRes - startRes + 1) * this.av.getCharWidth()) * this.scalew) : (int)((float)((endRes - startRes + 1) * this.av.getCharWidth()) * this.scalew);
        this.boxHeight = (int)((float)((endSeq - startSeq) * this.av.getCharHeight()) * this.scaleh);
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        if (this.resizing) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else if (this.miniMe != null) {
            g.drawImage(this.miniMe, 0, 0, this);
        }
        g.setColor(Color.red);
        g.drawRect(this.boxX, this.boxY, this.boxWidth, this.boxHeight);
        g.drawRect(this.boxX + 1, this.boxY + 1, this.boxWidth - 2, this.boxHeight - 2);
    }
}

