/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.PCA;
import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequencePoint;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.gui.OOMWarning;
import jalview.gui.PaintRefresher;
import jalview.gui.RotatableCanvas;
import jalview.jbgui.GPCAPanel;
import jalview.util.ImageMaker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;

public class PCAPanel
extends GPCAPanel
implements Runnable {
    PCA pca;
    int top;
    RotatableCanvas rc;
    AlignmentPanel ap;
    AlignViewport av;
    AlignmentView seqstrings;
    SequenceI[] seqs;

    public PCAPanel(AlignmentPanel ap) {
        this.av = ap.av;
        this.ap = ap;
        boolean sameLength = true;
        this.seqstrings = this.av.getAlignmentView(this.av.getSelectionGroup() != null);
        this.seqs = this.av.getSelectionGroup() == null ? this.av.alignment.getSequencesArray() : this.av.getSelectionGroup().getSequencesInOrder(this.av.alignment);
        SeqCigar[] sq = this.seqstrings.getSequences();
        int length = sq[0].getWidth();
        for (int i = 0; i < this.seqs.length; ++i) {
            if (sq[i].getWidth() == length) continue;
            sameLength = false;
            break;
        }
        if (!sameLength) {
            JOptionPane.showMessageDialog(Desktop.desktop, "The sequences must be aligned before calculating PCA.\nTry using the Pad function in the edit menu,\nor one of the multiple sequence alignment web services.", "Sequences not aligned", 2);
            return;
        }
        Desktop.addInternalFrame(this, "Principal component analysis", 400, 400);
        PaintRefresher.Register(this, this.av.getSequenceSetId());
        this.rc = new RotatableCanvas(ap);
        this.getContentPane().add((Component)this.rc, "Center");
        Thread worker = new Thread(this);
        worker.start();
    }

    public void bgcolour_actionPerformed(ActionEvent e) {
        Color col = JColorChooser.showDialog(this, "Select Background Colour", this.rc.bgColour);
        if (col != null) {
            this.rc.bgColour = col;
        }
        this.rc.repaint();
    }

    public void run() {
        try {
            int ii;
            this.pca = new PCA(this.seqstrings.getSequenceStrings(' '));
            this.pca.run();
            for (ii = 0; ii < this.seqs.length && this.seqs[ii] != null; ++ii) {
            }
            double[][] comps = new double[ii][ii];
            for (int i = 0; i < ii; ++i) {
                if (!(this.pca.getEigenvalue(i) > 1.0E-4)) continue;
                comps[i] = this.pca.component(i);
            }
            this.xCombobox.setSelectedIndex(0);
            this.yCombobox.setSelectedIndex(1);
            this.zCombobox.setSelectedIndex(2);
            this.top = this.pca.getM().rows - 1;
            Vector<SequencePoint> points = new Vector<SequencePoint>();
            float[][] scores = this.pca.getComponents(this.top - 1, this.top - 2, this.top - 3, 100.0f);
            for (int i = 0; i < this.pca.getM().rows; ++i) {
                SequencePoint sp = new SequencePoint(this.seqs[i], scores[i]);
                points.addElement(sp);
            }
            this.rc.setPoints(points, this.pca.getM().rows);
            this.rc.repaint();
            this.addKeyListener(this.rc);
        }
        catch (OutOfMemoryError er) {
            new OOMWarning("calculating PCA", er);
        }
    }

    void doDimensionChange() {
        if (this.top == 0) {
            return;
        }
        int dim1 = this.top - this.xCombobox.getSelectedIndex();
        int dim2 = this.top - this.yCombobox.getSelectedIndex();
        int dim3 = this.top - this.zCombobox.getSelectedIndex();
        float[][] scores = this.pca.getComponents(dim1, dim2, dim3, 100.0f);
        for (int i = 0; i < this.pca.getM().rows; ++i) {
            ((SequencePoint)this.rc.points.elementAt((int)i)).coord = scores[i];
        }
        this.rc.img = null;
        this.rc.rotmat.setIdentity();
        this.rc.initAxes();
        this.rc.paint(this.rc.getGraphics());
    }

    protected void xCombobox_actionPerformed(ActionEvent e) {
        this.doDimensionChange();
    }

    protected void yCombobox_actionPerformed(ActionEvent e) {
        this.doDimensionChange();
    }

    protected void zCombobox_actionPerformed(ActionEvent e) {
        this.doDimensionChange();
    }

    public void outputValues_actionPerformed(ActionEvent e) {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        Desktop.addInternalFrame(cap, "PCA details", 500, 500);
        cap.setText(this.pca.getDetails());
    }

    public void showLabels_actionPerformed(ActionEvent e) {
        this.rc.showLabels(this.showLabels.getState());
    }

    public void print_actionPerformed(ActionEvent e) {
        PCAPrinter printer = new PCAPrinter();
        printer.start();
    }

    public void originalSeqData_actionPerformed(ActionEvent e) {
        if (this.seqstrings == null) {
            Cache.log.info((Object)"Unexpected call to originalSeqData_actionPerformed - should have hidden this menu action.");
            return;
        }
        char gc = '-';
        try {
            gc = this.av.getGapCharacter();
        }
        catch (Exception ex) {
            // empty catch block
        }
        Object[] alAndColsel = this.seqstrings.getAlignmentAndColumnSelection(gc);
        if (alAndColsel != null && alAndColsel[0] != null) {
            Alignment dataset;
            Alignment al = new Alignment((SequenceI[])alAndColsel[0]);
            Alignment alignment = dataset = this.av != null && this.av.getAlignment() != null ? this.av.getAlignment().getDataset() : null;
            if (dataset != null) {
                al.setDataset(dataset);
            }
            AlignFrame af = new AlignFrame(al, (ColumnSelection)alAndColsel[1], 700, 500);
            Desktop.addInternalFrame(af, "Original Data for " + this.title, 700, 500);
        }
    }

    public void eps_actionPerformed(ActionEvent e) {
        this.makePCAImage(0);
    }

    public void png_actionPerformed(ActionEvent e) {
        this.makePCAImage(1);
    }

    void makePCAImage(int type) {
        int width = this.rc.getWidth();
        int height = this.rc.getHeight();
        ImageMaker im = type == 1 ? new ImageMaker(this, 1, "Make PNG image from PCA", width, height, null, null) : new ImageMaker(this, 0, "Make EPS file from PCA", width, height, null, this.getTitle());
        if (im.getGraphics() != null) {
            this.rc.drawBackground(im.getGraphics(), Color.black);
            this.rc.drawScene(im.getGraphics());
            if (this.rc.drawAxes) {
                this.rc.drawAxes(im.getGraphics());
            }
            im.writeImage();
        }
    }

    public void viewMenu_menuSelected() {
        this.buildAssociatedViewMenu();
    }

    void buildAssociatedViewMenu() {
        AlignmentPanel[] aps = PaintRefresher.getAssociatedPanels(this.av.getSequenceSetId());
        if (aps.length == 1 && this.rc.av == aps[0].av) {
            this.associateViewsMenu.setVisible(false);
            return;
        }
        this.associateViewsMenu.setVisible(true);
        if (this.viewMenu.getItem(this.viewMenu.getItemCount() - 2) instanceof JMenuItem) {
            this.viewMenu.insertSeparator(this.viewMenu.getItemCount() - 1);
        }
        this.associateViewsMenu.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        int iSize = aps.length;
        final PCAPanel thisPCAPanel = this;
        for (int i = 0; i < iSize; ++i) {
            final AlignmentPanel ap = aps[i];
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(ap.av.viewName, ap.av == this.rc.av);
            buttonGroup.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    PCAPanel.this.rc.applyToAllViews = false;
                    PCAPanel.this.rc.av = ap.av;
                    PCAPanel.this.rc.ap = ap;
                    PaintRefresher.Register(thisPCAPanel, ap.av.getSequenceSetId());
                }
            });
            this.associateViewsMenu.add(item);
        }
        final JRadioButtonMenuItem itemf = new JRadioButtonMenuItem("All Views");
        buttonGroup.add(itemf);
        itemf.setSelected(this.rc.applyToAllViews);
        itemf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PCAPanel.this.rc.applyToAllViews = itemf.isSelected();
            }
        });
        this.associateViewsMenu.add(itemf);
    }

    class PCAPrinter
    extends Thread
    implements Printable {
        PCAPrinter() {
        }

        public void run() {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            PageFormat pf = printJob.pageDialog(printJob.defaultPage());
            printJob.setPrintable(this, pf);
            if (printJob.printDialog()) {
                try {
                    printJob.print();
                }
                catch (Exception PrintException) {
                    PrintException.printStackTrace();
                }
            }
        }

        public int print(Graphics pg, PageFormat pf, int pi) throws PrinterException {
            pg.translate((int)pf.getImageableX(), (int)pf.getImageableY());
            PCAPanel.this.rc.drawBackground(pg, PCAPanel.this.rc.bgColour);
            PCAPanel.this.rc.drawScene(pg);
            if (PCAPanel.this.rc.drawAxes) {
                PCAPanel.this.rc.drawAxes(pg);
            }
            if (pi == 0) {
                return 0;
            }
            return 1;
        }
    }
}

