/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.AlignSeq;
import jalview.datamodel.Alignment;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.Desktop;
import jalview.jbgui.GPairwiseAlignPanel;
import jalview.util.Format;
import java.awt.event.ActionEvent;
import java.util.Vector;

public class PairwiseAlignPanel
extends GPairwiseAlignPanel {
    AlignViewport av;
    Vector sequences;

    public PairwiseAlignPanel(AlignViewport av) {
        int j;
        int i;
        this.av = av;
        this.sequences = new Vector();
        String[] seqStrings = av.getViewAsString(true);
        SequenceI[] seqs = av.getSelectionGroup() == null ? av.alignment.getSequencesArray() : av.getSelectionGroup().getSequencesInOrder(av.alignment);
        String type = av.alignment.isNucleotide() ? "dna" : "pep";
        float[][] scores = new float[seqs.length][seqs.length];
        double totscore = 0.0;
        int count = seqs.length;
        for (i = 1; i < count; ++i) {
            for (j = 0; j < i; ++j) {
                AlignSeq as = new AlignSeq(seqs[i], seqStrings[i], seqs[j], seqStrings[j], type);
                if (as.s1str.length() == 0 || as.s2str.length() == 0) continue;
                as.calcScoreMatrix();
                as.traceAlignment();
                as.printAlignment(System.out);
                scores[i][j] = (float)as.getMaxScore() / (float)as.getASeq1().length;
                totscore += (double)scores[i][j];
                this.textarea.append(as.getOutput());
                Sequence seq = new Sequence(as.getS1().getName(), as.getAStr1(), as.getS1().getStart(), as.getS1().getEnd());
                this.sequences.add(seq);
                seq = new Sequence(as.getS2().getName(), as.getAStr2(), as.getS2().getStart(), as.getS2().getEnd());
                this.sequences.add(seq);
            }
        }
        if (count > 2) {
            System.out.println("Pairwise alignment scaled similarity score matrix\n");
            for (i = 0; i < count; ++i) {
                Format.print(System.out, "%s \n", "" + i + " " + seqs[i].getName());
            }
            System.out.println("\n");
            for (i = 0; i < count; ++i) {
                for (j = 0; j < i; ++j) {
                    Format.print(System.out, "%7.3f", (double)scores[i][j] / totscore);
                }
            }
            System.out.println("\n");
        }
    }

    protected void viewInEditorButton_actionPerformed(ActionEvent e) {
        SequenceI[] seq = new Sequence[this.sequences.size()];
        for (int i = 0; i < this.sequences.size(); ++i) {
            seq[i] = (Sequence)this.sequences.elementAt(i);
        }
        AlignFrame af = new AlignFrame(new Alignment(seq), 700, 500);
        Desktop.addInternalFrame(af, "Pairwise Aligned Sequences", 700, 500);
    }
}

