/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.gui.Desktop;
import java.awt.Component;
import javax.swing.JOptionPane;

public class PromptUserConfig
implements Runnable {
    String property = null;
    boolean allowCancel = false;
    String dialogTitle;
    String dialogText;
    Runnable iftrue = null;
    Runnable iffalse = null;
    Runnable ifundef = null;
    private Component component;
    private boolean removeifunset;

    public boolean isRemoveifunset() {
        return this.removeifunset;
    }

    public void setRemoveifunset(boolean removeifunset) {
        this.removeifunset = removeifunset;
    }

    public PromptUserConfig(Component desktop, String property, String dialogTitle, String dialogText, Runnable iftrue, Runnable iffalse, Runnable ifundef, boolean allowCancel) {
        this.component = desktop;
        this.property = property;
        this.dialogTitle = dialogTitle;
        this.dialogText = dialogText;
        this.iftrue = iftrue;
        this.iffalse = iffalse;
        this.ifundef = ifundef;
        this.allowCancel = allowCancel;
    }

    public void run() {
        if (this.property == null) {
            return;
        }
        String lastq = Cache.getProperty(this.property);
        if (lastq == null) {
            this.raiseDialog();
            Cache.log.debug((Object)"Got user response.");
        }
        lastq = Cache.getProperty(this.property);
        String extype = "";
        Exception e = null;
        if (lastq == null) {
            try {
                if (this.ifundef != null) {
                    this.ifundef.run();
                }
            }
            catch (Exception ex) {
                e = ex;
                extype = "undefined";
            }
        } else if (Boolean.valueOf(lastq).booleanValue()) {
            try {
                if (this.iftrue != null) {
                    this.iftrue.run();
                }
            }
            catch (Exception ex) {
                e = ex;
                extype = "if true";
            }
        } else {
            try {
                if (this.iffalse != null) {
                    this.iffalse.run();
                }
            }
            catch (Exception ex) {
                e = ex;
                extype = "if false";
            }
        }
        if (e != null) {
            Cache.log.warn((Object)("Unexpected exception when executing the " + extype + " runnable for property " + this.property), (Throwable)e);
        }
    }

    private void raiseDialog() {
        if (Cache.log.isDebugEnabled()) {
            Cache.log.debug((Object)("Prompting user for " + this.dialogTitle + " for Cache property " + this.property));
        }
        try {
            int reply = JOptionPane.showInternalConfirmDialog(Desktop.desktop, this.dialogText, this.dialogTitle, this.allowCancel ? 1 : 0, 3);
            Cache.log.debug((Object)("Got response : " + reply));
            if (reply == 0) {
                Cache.setProperty(this.property, "true");
            } else if (reply == 1) {
                if (this.removeifunset) {
                    Cache.removeProperty(this.property);
                } else {
                    Cache.setProperty(this.property, "false");
                }
            } else {
                Cache.log.debug((Object)("User cancelled setting " + this.property));
                return;
            }
            if (Cache.log.isDebugEnabled()) {
                Cache.log.debug((Object)("User set property to " + Cache.getProperty(this.property)));
            }
        }
        catch (Exception e) {
            Cache.log.warn((Object)("Unexpected exception when prompting user for yes/no setting for property " + this.property), (Throwable)e);
        }
    }
}

