/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequencePoint;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.PaintRefresher;
import jalview.math.RotatableMatrix;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class RotatableCanvas
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    RotatableMatrix idmat = new RotatableMatrix(3, 3);
    RotatableMatrix objmat = new RotatableMatrix(3, 3);
    RotatableMatrix rotmat = new RotatableMatrix(3, 3);
    boolean drawAxes = true;
    int omx = 0;
    int mx = 0;
    int omy = 0;
    int my = 0;
    Image img;
    Graphics ig;
    Dimension prefsize;
    float[] centre = new float[3];
    float[] width = new float[3];
    float[] max = new float[3];
    float[] min = new float[3];
    float maxwidth;
    float scale;
    int npoint;
    Vector points;
    float[][] orig;
    float[][] axes;
    int startx;
    int starty;
    int lastx;
    int lasty;
    int rectx1;
    int recty1;
    int rectx2;
    int recty2;
    float scalefactor = 1.0f;
    AlignViewport av;
    AlignmentPanel ap;
    boolean showLabels = false;
    Color bgColour = Color.black;
    boolean applyToAllViews = false;

    public RotatableCanvas(AlignmentPanel ap) {
        this.av = ap.av;
        this.ap = ap;
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getWheelRotation() > 0) {
                    RotatableCanvas.this.scale = (float)((double)RotatableCanvas.this.scale * 1.1);
                    RotatableCanvas.this.repaint();
                } else {
                    RotatableCanvas.this.scale = (float)((double)RotatableCanvas.this.scale * 0.9);
                    RotatableCanvas.this.repaint();
                }
            }
        });
    }

    public void showLabels(boolean b) {
        this.showLabels = b;
        this.repaint();
    }

    public void setPoints(Vector points, int npoint) {
        int i;
        this.points = points;
        this.npoint = npoint;
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.prefsize = this.getPreferredSize();
        this.orig = new float[npoint][3];
        for (i = 0; i < npoint; ++i) {
            SequencePoint sp = (SequencePoint)points.elementAt(i);
            for (int j = 0; j < 3; ++j) {
                this.orig[i][j] = sp.coord[j];
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (i != j) {
                    this.idmat.addElement(i, j, 0.0f);
                    this.objmat.addElement(i, j, 0.0f);
                    this.rotmat.addElement(i, j, 0.0f);
                    continue;
                }
                this.idmat.addElement(i, j, 0.0f);
                this.objmat.addElement(i, j, 0.0f);
                this.rotmat.addElement(i, j, 0.0f);
            }
        }
        this.axes = new float[3][3];
        this.initAxes();
        this.findCentre();
        this.findWidth();
        this.scale = this.findScale();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void initAxes() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.axes[i][j] = i != j ? 0.0f : 1.0f;
            }
        }
    }

    public void findWidth() {
        this.max = new float[3];
        this.min = new float[3];
        this.max[0] = -1.0E30f;
        this.max[1] = -1.0E30f;
        this.max[2] = -1.0E30f;
        this.min[0] = 1.0E30f;
        this.min[1] = 1.0E30f;
        this.min[2] = 1.0E30f;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < this.npoint; ++j) {
                SequencePoint sp = (SequencePoint)this.points.elementAt(j);
                if (sp.coord[i] >= this.max[i]) {
                    this.max[i] = sp.coord[i];
                }
                if (!(sp.coord[i] <= this.min[i])) continue;
                this.min[i] = sp.coord[i];
            }
        }
        this.width[0] = Math.abs(this.max[0] - this.min[0]);
        this.width[1] = Math.abs(this.max[1] - this.min[1]);
        this.width[2] = Math.abs(this.max[2] - this.min[2]);
        this.maxwidth = this.width[0];
        if (this.width[1] > this.width[0]) {
            this.maxwidth = this.width[1];
        }
        if (this.width[2] > this.width[1]) {
            this.maxwidth = this.width[2];
        }
    }

    public float findScale() {
        int height;
        int width;
        if (this.getWidth() != 0) {
            width = this.getWidth();
            height = this.getHeight();
        } else {
            width = this.prefsize.width;
            height = this.prefsize.height;
        }
        int dim = width < height ? width : height;
        return (float)dim * this.scalefactor / (2.0f * this.maxwidth);
    }

    public void findCentre() {
        this.findWidth();
        this.centre[0] = (this.max[0] + this.min[0]) / 2.0f;
        this.centre[1] = (this.max[1] + this.min[1]) / 2.0f;
        this.centre[2] = (this.max[2] + this.min[2]) / 2.0f;
    }

    public Dimension getPreferredSize() {
        if (this.prefsize != null) {
            return this.prefsize;
        }
        return new Dimension(400, 400);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void paintComponent(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.points == null) {
            g.setFont(new Font("Verdana", 0, 18));
            g.drawString("Calculating PCA....", 20, this.getHeight() / 2);
        } else {
            if (this.img == null || this.prefsize.width != this.getWidth() || this.prefsize.height != this.getHeight()) {
                this.prefsize.width = this.getWidth();
                this.prefsize.height = this.getHeight();
                this.scale = this.findScale();
                this.img = this.createImage(this.getWidth(), this.getHeight());
                this.ig = this.img.getGraphics();
            }
            this.drawBackground(this.ig, this.bgColour);
            this.drawScene(this.ig);
            if (this.drawAxes) {
                this.drawAxes(this.ig);
            }
            g.drawImage(this.img, 0, 0, this);
        }
    }

    public void drawAxes(Graphics g) {
        g.setColor(Color.yellow);
        for (int i = 0; i < 3; ++i) {
            g.drawLine(this.getWidth() / 2, this.getHeight() / 2, (int)(this.axes[i][0] * this.scale * this.max[0] + (float)(this.getWidth() / 2)), (int)(this.axes[i][1] * this.scale * this.max[1] + (float)(this.getHeight() / 2)));
        }
    }

    public void drawBackground(Graphics g, Color col) {
        g.setColor(col);
        g.fillRect(0, 0, this.prefsize.width, this.prefsize.height);
    }

    public void drawScene(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int halfwidth = this.getWidth() / 2;
        int halfheight = this.getHeight() / 2;
        for (int i = 0; i < this.npoint; ++i) {
            SequencePoint sp = (SequencePoint)this.points.elementAt(i);
            int x = (int)((sp.coord[0] - this.centre[0]) * this.scale) + halfwidth;
            int y = (int)((sp.coord[1] - this.centre[1]) * this.scale) + halfheight;
            float z = sp.coord[1] - this.centre[2];
            if (this.av.getSequenceColour(sp.sequence) == Color.black) {
                g.setColor(Color.white);
            } else {
                g.setColor(this.av.getSequenceColour(sp.sequence));
            }
            if (this.av.getSelectionGroup() != null && this.av.getSelectionGroup().getSequences(null).contains(((SequencePoint)this.points.elementAt((int)i)).sequence)) {
                g.setColor(Color.gray);
            }
            if (z < 0.0f) {
                g.setColor(g.getColor().darker());
            }
            g.fillRect(x - 3, y - 3, 6, 6);
            if (!this.showLabels) continue;
            g.setColor(Color.red);
            g.drawString(((SequencePoint)this.points.elementAt((int)i)).sequence.getName(), x - 3, y - 4);
        }
    }

    public Dimension minimumsize() {
        return this.prefsize;
    }

    public Dimension preferredsize() {
        return this.prefsize;
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 38) {
            this.scalefactor = (float)((double)this.scalefactor * 1.1);
            this.scale = this.findScale();
        } else if (evt.getKeyCode() == 40) {
            this.scalefactor = (float)((double)this.scalefactor * 0.9);
            this.scale = this.findScale();
        } else if (evt.getKeyChar() == 's') {
            System.err.println("DEBUG: Rectangle selection");
            if (this.rectx2 != -1 && this.recty2 != -1) {
                this.rectSelect(this.rectx1, this.recty1, this.rectx2, this.recty2);
            }
        }
        this.repaint();
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        this.mx = x;
        this.my = y;
        this.omx = this.mx;
        this.omy = this.my;
        this.startx = x;
        this.starty = y;
        this.rectx1 = x;
        this.recty1 = y;
        this.rectx2 = -1;
        this.recty2 = -1;
        SequenceI found = this.findPoint(x, y);
        if (found != null) {
            AlignmentPanel[] aps = this.getAssociatedPanels();
            for (int a = 0; a < aps.length; ++a) {
                if (aps[a].av.getSelectionGroup() != null) {
                    aps[a].av.getSelectionGroup().addOrRemove(found, true);
                    continue;
                }
                aps[a].av.setSelectionGroup(new SequenceGroup());
                aps[a].av.getSelectionGroup().addOrRemove(found, true);
                aps[a].av.getSelectionGroup().setEndRes(aps[a].av.alignment.getWidth() - 1);
            }
            PaintRefresher.Refresh(this, this.av.getSequenceSetId());
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent evt) {
        SequenceI found = this.findPoint(evt.getX(), evt.getY());
        if (found != null) {
            this.setToolTipText(found.getName());
        } else {
            this.setToolTipText(null);
        }
    }

    public void mouseDragged(MouseEvent evt) {
        this.mx = evt.getX();
        this.my = evt.getY();
        if ((evt.getModifiers() & 8) == 0) {
            int i;
            this.rotmat.setIdentity();
            this.rotmat.rotate(this.my - this.omy, 'x');
            this.rotmat.rotate(this.mx - this.omx, 'y');
            for (i = 0; i < this.npoint; ++i) {
                SequencePoint sp = (SequencePoint)this.points.elementAt(i);
                sp.coord[0] = sp.coord[0] - this.centre[0];
                sp.coord[1] = sp.coord[1] - this.centre[1];
                sp.coord[2] = sp.coord[2] - this.centre[2];
                sp.coord = this.rotmat.vectorMultiply(sp.coord);
                sp.coord[0] = sp.coord[0] + this.centre[0];
                sp.coord[1] = sp.coord[1] + this.centre[1];
                sp.coord[2] = sp.coord[2] + this.centre[2];
            }
            for (i = 0; i < 3; ++i) {
                this.axes[i] = this.rotmat.vectorMultiply(this.axes[i]);
            }
            this.omx = this.mx;
            this.omy = this.my;
            this.paint(this.getGraphics());
        }
    }

    public void rectSelect(int x1, int y1, int x2, int y2) {
        for (int i = 0; i < this.npoint; ++i) {
            SequencePoint sp = (SequencePoint)this.points.elementAt(i);
            int tmp1 = (int)((double)((sp.coord[0] - this.centre[0]) * this.scale) + (double)this.getWidth() / 2.0);
            int tmp2 = (int)((double)((sp.coord[1] - this.centre[1]) * this.scale) + (double)this.getHeight() / 2.0);
            if (tmp1 <= x1 || tmp1 >= x2 || tmp2 <= y1 || tmp2 >= y2 || this.av == null || this.av.getSelectionGroup().getSequences(null).contains(sp.sequence)) continue;
            this.av.getSelectionGroup().addSequence(sp.sequence, true);
        }
    }

    public SequenceI findPoint(int x, int y) {
        int halfwidth = this.getWidth() / 2;
        int halfheight = this.getHeight() / 2;
        int found = -1;
        for (int i = 0; i < this.npoint; ++i) {
            SequencePoint sp = (SequencePoint)this.points.elementAt(i);
            int px = (int)((sp.coord[0] - this.centre[0]) * this.scale) + halfwidth;
            int py = (int)((sp.coord[1] - this.centre[1]) * this.scale) + halfheight;
            if (Math.abs(px - x) >= 3 || Math.abs(py - y) >= 3) continue;
            found = i;
        }
        if (found != -1) {
            return ((SequencePoint)this.points.elementAt((int)found)).sequence;
        }
        return null;
    }

    AlignmentPanel[] getAssociatedPanels() {
        if (this.applyToAllViews) {
            return PaintRefresher.getAssociatedPanels(this.av.getSequenceSetId());
        }
        return new AlignmentPanel[]{this.ap};
    }
}

