/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.gui.AppJmol;
import jalview.gui.ConsoleTextPane;
import jalview.gui.EnterListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;

public final class ScriptWindow
extends JPanel
implements ActionListener,
EnterListener {
    private ConsoleTextPane console;
    private JButton closeButton;
    private JButton runButton;
    private JButton haltButton;
    private JButton clearButton;
    private JButton historyButton;
    private JButton stateButton;
    JmolViewer viewer;
    AppJmol appJmol;
    boolean isError = false;
    ExecuteCommandThread execThread;

    public ScriptWindow(AppJmol appJmol) {
        this.viewer = appJmol.viewer;
        this.appJmol = appJmol;
        this.setLayout(new BorderLayout());
        this.console = new ConsoleTextPane(this);
        this.console.setPrompt();
        this.add((Component)new JScrollPane(this.console), "Center");
        JPanel buttonPanel = new JPanel();
        this.add((Component)buttonPanel, "South");
        this.runButton = new JButton(GT._((String)"Run"));
        this.haltButton = new JButton(GT._((String)"Halt"));
        this.runButton.addActionListener(this);
        this.haltButton.addActionListener(this);
        this.haltButton.setEnabled(false);
        this.clearButton = new JButton(GT._((String)"Clear"));
        this.clearButton.addActionListener(this);
        buttonPanel.add(this.clearButton);
        this.historyButton = new JButton(GT._((String)"History"));
        this.historyButton.addActionListener(this);
        buttonPanel.add(this.historyButton);
        this.stateButton = new JButton(GT._((String)"State"));
        this.stateButton.addActionListener(this);
        buttonPanel.add(this.stateButton);
        this.closeButton = new JButton(GT._((String)"Close"));
        this.closeButton.addActionListener(this);
        buttonPanel.add(this.closeButton);
        for (int i = 0; i < buttonPanel.getComponentCount(); ++i) {
        }
    }

    public void sendConsoleEcho(String strEcho) {
        if (strEcho != null && !this.isError) {
            this.console.outputEcho(strEcho);
        }
        this.setError(false);
    }

    void setError(boolean TF) {
        this.isError = TF;
    }

    public void sendConsoleMessage(String strStatus) {
        if (strStatus == null) {
            this.console.clearContent();
            this.console.outputStatus("");
        } else if (strStatus.indexOf("ERROR:") >= 0) {
            this.console.outputError(strStatus);
            this.isError = true;
        } else if (!this.isError) {
            this.console.outputStatus(strStatus);
        }
    }

    public void notifyScriptTermination(String strMsg, int msWalltime) {
        if (strMsg != null && strMsg.indexOf("ERROR") >= 0) {
            this.console.outputError(strMsg);
        }
        this.runButton.setEnabled(true);
        this.haltButton.setEnabled(false);
    }

    public void enterPressed() {
        this.runButton.doClick(100);
    }

    void executeCommandAsThread() {
        String strCommand = this.console.getCommandString().trim();
        if (strCommand.length() > 0) {
            this.execThread = new ExecuteCommandThread(strCommand);
            this.execThread.start();
        }
    }

    void executeCommand(String strCommand) {
        this.setError(false);
        this.console.appendNewline();
        this.console.setPrompt();
        if (strCommand.length() > 0) {
            boolean doWait;
            String strErrorMessage = null;
            boolean bl = doWait = strCommand.indexOf("WAIT ") == 0;
            if (doWait) {
                this.runButton.setEnabled(false);
                this.haltButton.setEnabled(true);
                Vector info = (Vector)this.viewer.scriptWaitStatus(strCommand.substring(5), "+fileLoaded,+scriptStarted,+scriptStatus,+scriptEcho,+scriptTerminated");
                this.runButton.setEnabled(true);
                this.haltButton.setEnabled(false);
                for (int i = 0; i < info.size(); ++i) {
                    Vector statusRecordSet = (Vector)info.get(i);
                    for (int j = 0; j < statusRecordSet.size(); ++j) {
                        Vector statusRecord = (Vector)statusRecordSet.get(j);
                        Logger.info((String)("msg#=" + statusRecord.get(0) + " " + statusRecord.get(1) + " intInfo=" + statusRecord.get(2) + " stringInfo=" + statusRecord.get(3)));
                    }
                }
                this.console.appendNewline();
            } else {
                boolean isScriptExecuting = this.viewer.isScriptExecuting();
                strErrorMessage = this.viewer.checkHalt(strCommand) ? (isScriptExecuting ? "string execution halted with " + strCommand : "no script was executing") : "";
                if (strErrorMessage != null && strErrorMessage.length() > 0) {
                    this.console.outputError(strErrorMessage);
                } else {
                    this.haltButton.setEnabled(true);
                    this.viewer.script(strCommand);
                }
            }
        }
        this.console.grabFocus();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.closeButton) {
            this.appJmol.showConsole(false);
        } else if (source == this.runButton) {
            this.executeCommandAsThread();
        } else if (source == this.clearButton) {
            this.console.clearContent();
        } else if (source == this.historyButton) {
            this.console.clearContent(this.viewer.getSetHistory(Integer.MAX_VALUE));
        } else if (source == this.stateButton) {
            this.console.clearContent(this.viewer.getStateInfo());
        } else if (source == this.haltButton) {
            this.viewer.haltScriptExecution();
        }
        this.console.grabFocus();
    }

    class ExecuteCommandThread
    extends Thread {
        String strCommand;

        ExecuteCommandThread(String command) {
            this.strCommand = command;
        }

        public void run() {
            try {
                ScriptWindow.this.executeCommand(this.strCommand);
            }
            catch (Exception ie) {
                Logger.debug((String)("execution command interrupted!" + ie));
            }
        }
    }
}

