/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import com.stevesoft.pat.Regex;
import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.DasSourceBrowser;
import jalview.gui.Desktop;
import jalview.gui.IProgressIndicator;
import jalview.io.FormatAdapter;
import jalview.io.IdentifyFile;
import jalview.util.Platform;
import jalview.ws.seqfetcher.DbSourceProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class SequenceFetcher
extends JPanel
implements Runnable {
    JInternalFrame frame;
    IProgressIndicator guiWindow;
    AlignFrame alignFrame;
    StringBuffer result;
    final String noDbSelected = "-- Select Database --";
    Hashtable sources = new Hashtable();
    private static jalview.ws.SequenceFetcher sfetch = null;
    private static String dasRegistry = null;
    JLabel dbeg = new JLabel();
    JComboBox database = new JComboBox();
    JLabel jLabel1 = new JLabel();
    JButton ok = new JButton();
    JButton clear = new JButton();
    JButton example = new JButton();
    JButton close = new JButton();
    JPanel jPanel1 = new JPanel();
    JTextArea textArea = new JTextArea();
    JScrollPane jScrollPane1 = new JScrollPane();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();

    public static jalview.ws.SequenceFetcher getSequenceFetcherSingleton(IProgressIndicator guiWindow) {
        if (sfetch == null || dasRegistry != DasSourceBrowser.getDasRegistryURL()) {
            if (guiWindow != null) {
                guiWindow.setProgressBar("Initialising Sequence Database Fetchers", Thread.currentThread().hashCode());
            }
            dasRegistry = DasSourceBrowser.getDasRegistryURL();
            jalview.ws.SequenceFetcher sf = new jalview.ws.SequenceFetcher();
            if (guiWindow != null) {
                guiWindow.setProgressBar("Initialising Sequence Database Fetchers", Thread.currentThread().hashCode());
            }
            sfetch = sf;
        }
        return sfetch;
    }

    public SequenceFetcher(IProgressIndicator guiIndic) {
        final IProgressIndicator guiWindow = guiIndic;
        final SequenceFetcher us = this;
        Thread sf = new Thread(new Runnable(){

            public void run() {
                if (SequenceFetcher.getSequenceFetcherSingleton(guiWindow) != null) {
                    us.initGui(guiWindow);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JOptionPane.showInternalMessageDialog(Desktop.desktop, "Could not create the sequence fetcher client. Check error logs for details.", "Couldn't create SequenceFetcher", 0);
                        }
                    });
                }
            }
        });
        sf.start();
    }

    private void initGui(IProgressIndicator guiWindow) {
        this.guiWindow = guiWindow;
        if (guiWindow instanceof AlignFrame) {
            this.alignFrame = (AlignFrame)guiWindow;
        }
        this.database.addItem("-- Select Database --");
        String[] dbs = sfetch.getOrderedSupportedSources();
        for (int i = 0; i < dbs.length; ++i) {
            if (this.sources.containsValue(dbs[i])) continue;
            String name = sfetch.getSourceProxy(dbs[i]).getDbName();
            if (!this.sources.containsKey(name)) {
                this.database.addItem(name);
            }
            this.sources.put(name, dbs[i]);
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.frame = new JInternalFrame();
        this.frame.setContentPane(this);
        if (new Platform().isAMac()) {
            Desktop.addInternalFrame(this.frame, this.getFrameTitle(), 400, 180);
        } else {
            Desktop.addInternalFrame(this.frame, this.getFrameTitle(), 400, 140);
        }
    }

    private String getFrameTitle() {
        return (this.alignFrame == null ? "New " : "Additional ") + "Sequence Fetcher";
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout2);
        this.database.setFont(new Font("Verdana", 0, 11));
        this.dbeg.setFont(new Font("Verdana", 1, 11));
        this.jLabel1.setFont(new Font("Verdana", 2, 11));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Separate multiple accession ids with semi colon \";\"");
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SequenceFetcher.this.ok_actionPerformed();
            }
        });
        this.clear.setText("Clear");
        this.clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SequenceFetcher.this.clear_actionPerformed();
            }
        });
        this.example.setText("Example");
        this.example.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SequenceFetcher.this.example_actionPerformed();
            }
        });
        this.close.setText("Close");
        this.close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SequenceFetcher.this.close_actionPerformed(e);
            }
        });
        this.textArea.setFont(new Font("Verdana", 0, 11));
        this.textArea.setLineWrap(true);
        this.textArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SequenceFetcher.this.ok_actionPerformed();
                }
            }
        });
        this.jPanel3.setLayout(this.borderLayout1);
        this.borderLayout1.setVgap(5);
        this.jPanel1.add(this.ok);
        this.jPanel1.add(this.example);
        this.jPanel1.add(this.clear);
        this.jPanel1.add(this.close);
        this.jPanel3.add((Component)this.jPanel2, "Center");
        this.jPanel2.setLayout(this.borderLayout3);
        this.database.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbSourceProxy db = null;
                try {
                    db = sfetch.getSourceProxy((String)SequenceFetcher.this.sources.get(SequenceFetcher.this.database.getSelectedItem()));
                    SequenceFetcher.this.dbeg.setText("Example query: " + db.getTestQuery());
                }
                catch (Exception ex) {
                    SequenceFetcher.this.dbeg.setText("");
                }
                SequenceFetcher.this.jPanel2.repaint();
            }
        });
        this.dbeg.setText("");
        this.jPanel2.add((Component)this.database, "North");
        this.jPanel2.add((Component)this.dbeg, "Center");
        this.jPanel2.add((Component)this.jLabel1, "South");
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.jPanel1, "South");
        this.add((Component)this.jPanel3, "Center");
        this.add((Component)this.jPanel2, "North");
        this.jScrollPane1.getViewport().add(this.textArea);
    }

    protected void example_actionPerformed() {
        DbSourceProxy db = null;
        try {
            db = sfetch.getSourceProxy((String)this.sources.get(this.database.getSelectedItem()));
            this.textArea.setText(db.getTestQuery());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jPanel3.repaint();
    }

    protected void clear_actionPerformed() {
        this.textArea.setText("");
        this.jPanel3.repaint();
    }

    public void close_actionPerformed(ActionEvent e) {
        try {
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ok_actionPerformed() {
        this.database.setEnabled(false);
        this.textArea.setEnabled(false);
        this.ok.setEnabled(false);
        this.close.setEnabled(false);
        Thread worker = new Thread(this);
        worker.start();
    }

    private void resetDialog() {
        this.database.setEnabled(true);
        this.textArea.setEnabled(true);
        this.ok.setEnabled(true);
        this.close.setEnabled(true);
    }

    public void run() {
        AlignmentI aresult;
        block17: {
            String error = "";
            if (this.database.getSelectedItem().equals("-- Select Database --")) {
                error = error + "Please select the source database\n";
            }
            Regex empty = new Regex("\\s+", "");
            this.textArea.setText(empty.replaceAll(this.textArea.getText()));
            if (this.textArea.getText().length() == 0) {
                error = error + "Please enter a (semi-colon separated list of) database id(s)";
            }
            if (error.length() > 0) {
                this.showErrorMessage(error);
                this.resetDialog();
                return;
            }
            aresult = null;
            Object source = this.database.getSelectedItem();
            StringTokenizer en = new StringTokenizer(this.textArea.getText(), ";");
            try {
                this.guiWindow.setProgressBar("Fetching Sequences from " + this.database.getSelectedItem(), Thread.currentThread().hashCode());
                DbSourceProxy proxy = sfetch.getSourceProxy((String)this.sources.get(source));
                if (proxy.getAccessionSeparator() == null) {
                    while (en.hasMoreElements()) {
                        String item = (String)en.nextElement();
                        try {
                            AlignmentI indres;
                            if (aresult != null) {
                                try {
                                    Thread.sleep(5L);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            if ((indres = proxy.getSequenceRecords(item)) == null) continue;
                            if (aresult == null) {
                                aresult = indres;
                                continue;
                            }
                            aresult.append(indres);
                        }
                        catch (Exception e) {
                            Cache.log.info((Object)("Error retrieving " + item + " from " + source), (Throwable)e);
                        }
                    }
                    break block17;
                }
                StringBuffer multiacc = new StringBuffer();
                while (en.hasMoreElements()) {
                    multiacc.append(en.nextElement());
                    if (!en.hasMoreElements()) continue;
                    multiacc.append(proxy.getAccessionSeparator());
                }
                aresult = proxy.getSequenceRecords(multiacc.toString());
            }
            catch (Exception e) {
                this.showErrorMessage("Error retrieving " + this.textArea.getText() + " from " + this.database.getSelectedItem());
                System.err.println("Retrieval failed for source ='" + this.database.getSelectedItem() + "' and query\n'" + this.textArea.getText() + "'\n");
                e.printStackTrace();
            }
            catch (OutOfMemoryError e) {
                this.showErrorMessage("Out of Memory when retrieving " + this.textArea.getText() + " from " + this.database.getSelectedItem() + "\nPlease see the Jalview FAQ for instructions for increasing the memory available to Jalview.\n");
                e.printStackTrace();
            }
            catch (Error e) {
                this.showErrorMessage("Serious Error retrieving " + this.textArea.getText() + " from " + this.database.getSelectedItem());
                e.printStackTrace();
            }
        }
        if (aresult != null) {
            this.parseResult(aresult, null, null);
        }
        this.guiWindow.setProgressBar(null, Thread.currentThread().hashCode());
        this.resetDialog();
    }

    AlignmentI parseResult(String result, String title) {
        String format = new IdentifyFile().Identify(result, "Paste");
        Alignment sequences = null;
        if (FormatAdapter.isValidFormat(format)) {
            sequences = null;
            try {
                sequences = new FormatAdapter().readFile(result.toString(), "Paste", format);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (sequences != null) {
                return this.parseResult(sequences, title, format);
            }
        } else {
            this.showErrorMessage("Error retrieving " + this.textArea.getText() + " from " + this.database.getSelectedItem());
        }
        return null;
    }

    AlignmentI parseResult(AlignmentI al, String title, String currentFileFormat) {
        if (al != null && al.getHeight() > 0) {
            if (this.alignFrame == null) {
                AlignFrame af = new AlignFrame(al, 700, 500);
                if (currentFileFormat != null) {
                    af.currentFileFormat = currentFileFormat;
                }
                if (title == null) {
                    title = "Retrieved from " + this.database.getSelectedItem();
                }
                SequenceFeature[] sfs = null;
                Enumeration sq = al.getSequences().elements();
                while (sq.hasMoreElements()) {
                    sfs = ((SequenceI)sq.nextElement()).getDatasetSequence().getSequenceFeatures();
                    if (sfs == null || sfs.length <= 0) continue;
                    af.setShowSeqFeatures(true);
                    break;
                }
                Desktop.addInternalFrame(af, title, 700, 500);
                af.statusBar.setText("Successfully pasted alignment file");
                try {
                    af.setMaximum(Cache.getDefault("SHOW_FULLSCREEN", false));
                }
                catch (Exception ex) {}
            } else {
                for (int i = 0; i < al.getHeight(); ++i) {
                    this.alignFrame.viewport.alignment.addSequence(al.getSequenceAt(i));
                }
                this.alignFrame.viewport.setEndSeq(this.alignFrame.viewport.alignment.getHeight());
                this.alignFrame.viewport.alignment.getWidth();
                this.alignFrame.viewport.firePropertyChange("alignment", null, this.alignFrame.viewport.getAlignment().getSequences());
            }
        }
        return al;
    }

    void showErrorMessage(final String error) {
        this.resetDialog();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showInternalMessageDialog(Desktop.desktop, error, "Error Retrieving Data", 2);
            }
        });
    }
}

