/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignViewport;
import jalview.schemes.ColourSchemeI;
import jalview.util.Comparison;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class SequenceRenderer {
    AlignViewport av;
    FontMetrics fm;
    boolean renderGaps = true;
    SequenceGroup currentSequenceGroup = null;
    SequenceGroup[] allGroups = null;
    Color resBoxColour;
    Graphics graphics;
    boolean monospacedFont;
    boolean forOverview = false;

    public SequenceRenderer(AlignViewport av) {
        this.av = av;
    }

    public void prepare(Graphics g, boolean renderGaps) {
        this.graphics = g;
        this.fm = g.getFontMetrics();
        double dwidth = this.fm.getStringBounds("M", g).getWidth();
        this.monospacedFont = dwidth == this.fm.getStringBounds("|", g).getWidth() && (double)this.av.charWidth == dwidth;
        this.renderGaps = renderGaps;
    }

    public Color getResidueBoxColour(SequenceI seq, int i) {
        this.allGroups = this.av.alignment.findAllGroups(seq);
        if (this.inCurrentSequenceGroup(i)) {
            if (this.currentSequenceGroup.getDisplayBoxes()) {
                this.getBoxColour(this.currentSequenceGroup.cs, seq, i);
            }
        } else if (this.av.getShowBoxes()) {
            this.getBoxColour(this.av.globalColourScheme, seq, i);
        }
        return this.resBoxColour;
    }

    void getBoxColour(ColourSchemeI cs, SequenceI seq, int i) {
        this.resBoxColour = cs != null ? cs.findColour(seq.getCharAt(i), i) : (this.forOverview && !Comparison.isGap(seq.getCharAt(i)) ? Color.lightGray : Color.white);
    }

    public void drawSequence(SequenceI seq, SequenceGroup[] sg, int start, int end, int y1) {
        this.allGroups = sg;
        this.drawBoxes(seq, start, end, y1);
        if (this.av.validCharWidth) {
            this.drawText(seq, start, end, y1);
        }
    }

    public synchronized void drawBoxes(SequenceI seq, int start, int end, int y1) {
        int length = seq.getLength();
        int curStart = -1;
        int curWidth = this.av.charWidth;
        Color tempColour = null;
        for (int i = start; i <= end; ++i) {
            this.resBoxColour = Color.white;
            if (i < length) {
                if (this.inCurrentSequenceGroup(i)) {
                    if (this.currentSequenceGroup.getDisplayBoxes()) {
                        this.getBoxColour(this.currentSequenceGroup.cs, seq, i);
                    }
                } else if (this.av.getShowBoxes()) {
                    this.getBoxColour(this.av.globalColourScheme, seq, i);
                }
            }
            if (this.resBoxColour != tempColour) {
                if (tempColour != null) {
                    this.graphics.fillRect(this.av.charWidth * (curStart - start), y1, curWidth, this.av.charHeight);
                }
                this.graphics.setColor(this.resBoxColour);
                curStart = i;
                curWidth = this.av.charWidth;
                tempColour = this.resBoxColour;
                continue;
            }
            curWidth += this.av.charWidth;
        }
        this.graphics.fillRect(this.av.charWidth * (curStart - start), y1, curWidth, this.av.charHeight);
    }

    public void drawText(SequenceI seq, int start, int end, int y1) {
        y1 += this.av.charHeight - this.av.charHeight / 5;
        int charOffset = 0;
        if (end + 1 >= seq.getLength()) {
            end = seq.getLength() - 1;
        }
        this.graphics.setColor(this.av.textColour);
        if (this.monospacedFont && this.av.showText && this.allGroups.length == 0 && !this.av.getColourText() && this.av.thresholdTextColour == 0) {
            if (this.av.renderGaps) {
                this.graphics.drawString(seq.getSequenceAsString(start, end + 1), 0, y1);
            } else {
                char gap = this.av.getGapCharacter();
                this.graphics.drawString(seq.getSequenceAsString(start, end + 1).replace(gap, ' '), 0, y1);
            }
        } else {
            boolean getboxColour = false;
            for (int i = start; i <= end; ++i) {
                this.graphics.setColor(this.av.textColour);
                getboxColour = false;
                char s = seq.getCharAt(i);
                if (!this.renderGaps && Comparison.isGap(s)) continue;
                if (this.inCurrentSequenceGroup(i)) {
                    if (!this.currentSequenceGroup.getDisplayText()) continue;
                    if (this.currentSequenceGroup.thresholdTextColour > 0 || this.currentSequenceGroup.getColourText()) {
                        getboxColour = true;
                        this.getBoxColour(this.currentSequenceGroup.cs, seq, i);
                        if (this.currentSequenceGroup.getColourText()) {
                            this.graphics.setColor(this.resBoxColour.darker());
                        }
                        if (this.currentSequenceGroup.thresholdTextColour > 0 && this.resBoxColour.getRed() + this.resBoxColour.getBlue() + this.resBoxColour.getGreen() < this.currentSequenceGroup.thresholdTextColour) {
                            this.graphics.setColor(this.currentSequenceGroup.textColour2);
                        }
                    } else {
                        this.graphics.setColor(this.currentSequenceGroup.textColour);
                    }
                } else {
                    if (!this.av.getShowText()) continue;
                    if (this.av.getColourText()) {
                        getboxColour = true;
                        this.getBoxColour(this.av.globalColourScheme, seq, i);
                        if (this.av.getShowBoxes()) {
                            this.graphics.setColor(this.resBoxColour.darker());
                        } else {
                            this.graphics.setColor(this.resBoxColour);
                        }
                    }
                    if (this.av.thresholdTextColour > 0) {
                        if (!getboxColour) {
                            this.getBoxColour(this.av.globalColourScheme, seq, i);
                        }
                        if (this.resBoxColour.getRed() + this.resBoxColour.getBlue() + this.resBoxColour.getGreen() < this.av.thresholdTextColour) {
                            this.graphics.setColor(this.av.textColour2);
                        }
                    }
                }
                charOffset = (this.av.charWidth - this.fm.charWidth(s)) / 2;
                this.graphics.drawString(String.valueOf(s), charOffset + this.av.charWidth * (i - start), y1);
            }
        }
    }

    boolean inCurrentSequenceGroup(int res) {
        if (this.allGroups == null) {
            return false;
        }
        for (int i = 0; i < this.allGroups.length; ++i) {
            if (this.allGroups[i].getStartRes() > res || this.allGroups[i].getEndRes() < res) continue;
            this.currentSequenceGroup = this.allGroups[i];
            return true;
        }
        return false;
    }

    public void drawHighlightedText(SequenceI seq, int start, int end, int x1, int y1) {
        int pady = this.av.charHeight / 5;
        int charOffset = 0;
        this.graphics.setColor(Color.BLACK);
        this.graphics.fillRect(x1, y1, this.av.charWidth * (end - start + 1), this.av.charHeight);
        this.graphics.setColor(Color.white);
        char s = '~';
        if (this.av.validCharWidth) {
            for (int i = start; i <= end; ++i) {
                if (i < seq.getLength()) {
                    s = seq.getCharAt(i);
                }
                charOffset = (this.av.charWidth - this.fm.charWidth(s)) / 2;
                this.graphics.drawString(String.valueOf(s), charOffset + x1 + this.av.charWidth * (i - start), y1 + this.av.charHeight - pady);
            }
        }
    }

    public void drawCursor(SequenceI seq, int res, int x1, int y1) {
        int pady = this.av.charHeight / 5;
        int charOffset = 0;
        this.graphics.setColor(Color.black);
        this.graphics.fillRect(x1, y1, this.av.charWidth, this.av.charHeight);
        if (this.av.validCharWidth) {
            this.graphics.setColor(Color.white);
            char s = seq.getCharAt(res);
            charOffset = (this.av.charWidth - this.fm.charWidth(s)) / 2;
            this.graphics.drawString(String.valueOf(s), charOffset + x1, y1 + this.av.charHeight - pady);
        }
    }
}

