/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.datamodel.SequenceGroup;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.jbgui.GSliderPanel;
import jalview.schemes.ColourSchemeI;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class SliderPanel
extends GSliderPanel {
    static JInternalFrame conservationSlider;
    static JInternalFrame PIDSlider;
    AlignmentPanel ap;
    boolean forConservation = true;
    ColourSchemeI cs;

    public SliderPanel(final AlignmentPanel ap, int value, boolean forConserve, ColourSchemeI cs) {
        this.ap = ap;
        this.cs = cs;
        this.forConservation = forConserve;
        this.undoButton.setVisible(false);
        this.applyButton.setVisible(false);
        if (this.forConservation) {
            this.label.setText("Enter value to increase conservation visibility");
            this.slider.setMinimum(0);
            this.slider.setMaximum(100);
        } else {
            this.label.setText("Enter % identity above which to colour residues");
            this.slider.setMinimum(0);
            this.slider.setMaximum(100);
        }
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SliderPanel.this.valueField.setText(SliderPanel.this.slider.getValue() + "");
                SliderPanel.this.valueChanged(SliderPanel.this.slider.getValue());
            }
        });
        this.slider.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                ap.paintAlignment(true);
            }
        });
        this.slider.setValue(value);
        this.valueField.setText(value + "");
    }

    public static int setConservationSlider(AlignmentPanel ap, ColourSchemeI cs, String source) {
        SliderPanel sp = null;
        if (conservationSlider == null) {
            sp = new SliderPanel(ap, cs.getConservationInc(), true, cs);
            conservationSlider = new JInternalFrame();
            conservationSlider.setContentPane(sp);
            conservationSlider.setLayer(JLayeredPane.PALETTE_LAYER);
        } else {
            sp = (SliderPanel)conservationSlider.getContentPane();
            sp.cs = cs;
        }
        conservationSlider.setTitle("Conservation Colour Increment  (" + source + ")");
        if (ap.av.alignment.getGroups() != null) {
            sp.setAllGroupsCheckEnabled(true);
        } else {
            sp.setAllGroupsCheckEnabled(false);
        }
        return sp.getValue();
    }

    public static void showConservationSlider() {
        try {
            PIDSlider.setClosed(true);
            PIDSlider = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!conservationSlider.isVisible()) {
            Desktop.addInternalFrame(conservationSlider, conservationSlider.getTitle(), 420, 90, false);
            conservationSlider.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameClosed(InternalFrameEvent e) {
                    conservationSlider = null;
                }
            });
            conservationSlider.setLayer(JLayeredPane.PALETTE_LAYER);
        }
    }

    public static int setPIDSliderSource(AlignmentPanel ap, ColourSchemeI cs, String source) {
        SliderPanel pid = null;
        int threshold = cs.getThreshold();
        if (PIDSlider == null) {
            pid = new SliderPanel(ap, threshold, false, cs);
            PIDSlider = new JInternalFrame();
            PIDSlider.setContentPane(pid);
            PIDSlider.setLayer(JLayeredPane.PALETTE_LAYER);
        } else {
            pid = (SliderPanel)PIDSlider.getContentPane();
            pid.cs = cs;
        }
        PIDSlider.setTitle("Percentage Identity Threshold (" + source + ")");
        if (ap.av.alignment.getGroups() != null) {
            pid.setAllGroupsCheckEnabled(true);
        } else {
            pid.setAllGroupsCheckEnabled(false);
        }
        return pid.getValue();
    }

    public static void showPIDSlider() {
        try {
            conservationSlider.setClosed(true);
            conservationSlider = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!PIDSlider.isVisible()) {
            Desktop.addInternalFrame(PIDSlider, PIDSlider.getTitle(), 420, 90, false);
            PIDSlider.setLayer(JLayeredPane.PALETTE_LAYER);
            PIDSlider.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameClosed(InternalFrameEvent e) {
                    PIDSlider = null;
                }
            });
            PIDSlider.setLayer(JLayeredPane.PALETTE_LAYER);
        }
    }

    public void valueChanged(int i) {
        if (this.cs == null) {
            return;
        }
        ColourSchemeI toChange = null;
        Vector allGroups = null;
        int groupIndex = 0;
        if (this.allGroupsCheck.isSelected()) {
            allGroups = this.ap.av.alignment.getGroups();
            groupIndex = allGroups.size() - 1;
        } else {
            toChange = this.cs;
        }
        while (groupIndex > -1) {
            if (allGroups != null && (toChange = ((SequenceGroup)allGroups.get((int)groupIndex)).cs) == null) {
                --groupIndex;
                continue;
            }
            if (this.forConservation) {
                if (toChange.conservationApplied()) {
                    toChange.setConservationInc(i);
                }
            } else {
                toChange.setThreshold(i, this.ap.av.getIgnoreGapsConsensus());
            }
            --groupIndex;
        }
        this.ap.seqPanel.seqCanvas.repaint();
    }

    public void setAllGroupsCheckEnabled(boolean b) {
        this.allGroupsCheck.setEnabled(b);
    }

    public void valueField_actionPerformed(ActionEvent e) {
        try {
            int i = Integer.parseInt(this.valueField.getText());
            this.slider.setValue(i);
        }
        catch (NumberFormatException ex) {
            this.valueField.setText(this.slider.getValue() + "");
        }
    }

    public void setValue(int value) {
        this.slider.setValue(value);
    }

    public int getValue() {
        return Integer.parseInt(this.valueField.getText());
    }

    public void slider_mouseReleased(MouseEvent e) {
        if (this.ap.overviewPanel != null) {
            this.ap.overviewPanel.updateOverviewImage();
        }
    }
}

