/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.gui.Desktop;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class SplashScreen
extends JPanel
implements Runnable {
    boolean visible = true;
    JInternalFrame iframe;
    Image image;
    int fontSize = 11;
    int yoffset = 30;

    public SplashScreen() {
        Thread t = new Thread(this);
        t.start();
    }

    void initSplashScreenWindow() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                try {
                    SplashScreen.this.visible = false;
                    SplashScreen.this.closeSplash();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        try {
            URL url = this.getClass().getResource("/images/logo.gif");
            if (url != null) {
                this.image = Toolkit.getDefaultToolkit().createImage(url);
                MediaTracker mt = new MediaTracker(this);
                mt.addImage(this.image, 0);
                mt.waitForID(0);
                Desktop.instance.setIconImage(this.image);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.iframe = new JInternalFrame();
        this.iframe.setFrameIcon(null);
        this.iframe.setClosable(false);
        this.iframe.setContentPane(this);
        this.iframe.setLayer(JLayeredPane.PALETTE_LAYER);
        Desktop.desktop.add(this.iframe);
        this.iframe.setVisible(true);
        this.iframe.setBounds((Desktop.instance.getWidth() - 750) / 2, (Desktop.instance.getHeight() - 160) / 2, 750, 190);
    }

    public void run() {
        this.initSplashScreenWindow();
        long startTime = System.currentTimeMillis() / 1000L;
        while (this.visible) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (System.currentTimeMillis() / 1000L - startTime > 5L) {
                this.visible = false;
                continue;
            }
            this.repaint();
        }
        this.closeSplash();
    }

    public void closeSplash() {
        try {
            this.iframe.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paintComponent(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.black);
        g.setFont(new Font("Verdana", 1, this.fontSize + 6));
        if (this.image != null) {
            g.drawImage(this.image, 5, this.yoffset + 12, this);
        }
        int y = this.yoffset;
        g.drawString("Jalview " + Cache.getProperty("VERSION"), 50, y);
        FontMetrics fm = g.getFontMetrics();
        int vwidth = fm.stringWidth("Jalview " + Cache.getProperty("VERSION"));
        g.setFont(new Font("Verdana", 1, this.fontSize + 2));
        g.drawString("Last updated: " + Cache.getDefault("BUILD_DATE", "unknown"), 50 + vwidth + 5, y);
        if (Cache.getDefault("LATEST_VERSION", "Checking").equals("Checking")) {
            g.drawString("...Checking latest version...", 50, y += this.fontSize + 10);
            y += 5;
            g.setColor(Color.black);
        } else if (!Cache.getDefault("LATEST_VERSION", "Checking").equals(Cache.getProperty("VERSION"))) {
            if (Cache.getProperty("VERSION").toLowerCase().indexOf("automated build") == -1) {
                g.setColor(Color.red);
            }
            g.drawString("!! Jalview version " + Cache.getDefault("LATEST_VERSION", "..Checking..") + " is available for download from http://www.jalview.org !!", 50, y += this.fontSize + 10);
            y += 5;
            g.setColor(Color.black);
        }
        g.setFont(new Font("Verdana", 1, this.fontSize));
        g.drawString("Authors: Andrew Waterhouse, Jim Procter, Michele Clamp, James Cuff, Steve Searle,", 50, y += this.fontSize + 4);
        g.drawString("David Martin & Geoff Barton.", 60, y += this.fontSize + 4);
        g.drawString("Development managed by The Barton Group, University of Dundee.", 50, y += this.fontSize + 4);
        g.drawString("If  you use Jalview, please cite: ", 50, y += this.fontSize + 4);
        g.drawString("Waterhouse, A.M., Procter, J.B., Martin, D.M.A, Clamp, M. and Barton, G. J. (2009)", 50, y += this.fontSize + 4);
        g.drawString("Jalview Version 2 - a multiple sequence alignment editor and analysis workbench", 50, y += this.fontSize + 4);
        g.drawString("Bioinformatics doi: 10.1093/bioinformatics/btp033", 50, y += this.fontSize + 4);
    }
}

