/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.datamodel.SequenceGroup;
import jalview.gui.AlignmentPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TextColourChooser {
    AlignmentPanel ap;
    SequenceGroup sg;

    public void chooseColour(AlignmentPanel ap, SequenceGroup sg) {
        int originalThreshold;
        int original2;
        int original1;
        this.ap = ap;
        this.sg = sg;
        if (sg == null) {
            original1 = ap.av.textColour.getRGB();
            original2 = ap.av.textColour2.getRGB();
            originalThreshold = ap.av.thresholdTextColour;
        } else {
            original1 = sg.textColour.getRGB();
            original2 = sg.textColour2.getRGB();
            originalThreshold = sg.thresholdTextColour;
        }
        final JSlider slider = new JSlider(0, 750, originalThreshold);
        final JPanel col1 = new JPanel();
        col1.setPreferredSize(new Dimension(40, 20));
        col1.setBorder(BorderFactory.createEtchedBorder());
        col1.setToolTipText("Dark Colour");
        col1.setBackground(new Color(original1));
        final JPanel col2 = new JPanel();
        col2.setPreferredSize(new Dimension(40, 20));
        col2.setBorder(BorderFactory.createEtchedBorder());
        col2.setToolTipText("Light Colour");
        col2.setBackground(new Color(original2));
        final JPanel bigpanel = new JPanel(new BorderLayout());
        JPanel panel = new JPanel();
        bigpanel.add((Component)panel, "Center");
        bigpanel.add((Component)new JLabel("<html><i>Select a dark and light text colour, then set the threshold to<br>switch between colours, based on background colour</i></html>"), "North");
        panel.add(col1);
        panel.add(slider);
        panel.add(col2);
        col1.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Color col = JColorChooser.showDialog(bigpanel, "Select Colour for Text", col1.getBackground());
                if (col != null) {
                    TextColourChooser.this.colour1Changed(col);
                    col1.setBackground(col);
                }
            }
        });
        col2.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Color col = JColorChooser.showDialog(bigpanel, "Select Colour for Text", col2.getBackground());
                if (col != null) {
                    TextColourChooser.this.colour2Changed(col);
                    col2.setBackground(col);
                }
            }
        });
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TextColourChooser.this.thresholdChanged(slider.getValue());
            }
        });
        int reply = JOptionPane.showInternalOptionDialog(ap, bigpanel, "Adjust Foreground Text Colour Threshold", 2, 3, null, null, null);
        if (reply == 2) {
            if (sg == null) {
                ap.av.textColour = new Color(original1);
                ap.av.textColour2 = new Color(original2);
                ap.av.thresholdTextColour = originalThreshold;
            } else {
                sg.textColour = new Color(original1);
                sg.textColour2 = new Color(original2);
                sg.thresholdTextColour = originalThreshold;
            }
        }
    }

    void colour1Changed(Color col) {
        if (this.sg == null) {
            this.ap.av.textColour = col;
            if (this.ap.av.colourAppliesToAllGroups) {
                this.setGroupTextColour();
            }
        } else {
            this.sg.textColour = col;
        }
        this.ap.paintAlignment(true);
    }

    void colour2Changed(Color col) {
        if (this.sg == null) {
            this.ap.av.textColour2 = col;
            if (this.ap.av.colourAppliesToAllGroups) {
                this.setGroupTextColour();
            }
        } else {
            this.sg.textColour2 = col;
        }
        this.ap.paintAlignment(true);
    }

    void thresholdChanged(int value) {
        if (this.sg == null) {
            this.ap.av.thresholdTextColour = value;
            if (this.ap.av.colourAppliesToAllGroups) {
                this.setGroupTextColour();
            }
        } else {
            this.sg.thresholdTextColour = value;
        }
        this.ap.paintAlignment(true);
    }

    void setGroupTextColour() {
        if (this.ap.av.alignment.getGroups() == null) {
            return;
        }
        Vector groups = this.ap.av.alignment.getGroups();
        for (int i = 0; i < groups.size(); ++i) {
            SequenceGroup sg = (SequenceGroup)groups.elementAt(i);
            sg.textColour = this.ap.av.textColour;
            sg.textColour2 = this.ap.av.textColour2;
            sg.thresholdTextColour = this.ap.av.thresholdTextColour;
        }
    }
}

