/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.gui.Desktop;
import jalview.jbgui.GWebserviceInfo;
import jalview.ws.WSClientI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class WebserviceInfo
extends GWebserviceInfo {
    public static final int STATE_QUEUING = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_STOPPED_OK = 2;
    public static final int STATE_CANCELLED_OK = 3;
    public static final int STATE_STOPPED_ERROR = 4;
    public static final int STATE_STOPPED_SERVERERROR = 5;
    int currentStatus = 0;
    Image image;
    int angle = 0;
    String title = "";
    WSClientI thisService;
    boolean serviceIsCancellable;
    JInternalFrame frame;
    JTabbedPane subjobs = null;
    Vector jobPanes = null;
    private boolean serviceCanMergeResults = false;
    private boolean viewResultsImmediatly = true;

    public synchronized int addJobPane() {
        JScrollPane jobpane = new JScrollPane();
        JTextArea progressText = new JTextArea();
        progressText.setFont(new Font("Verdana", 0, 10));
        progressText.setBorder(null);
        progressText.setEditable(false);
        progressText.setText("WS Job");
        progressText.setLineWrap(true);
        progressText.setWrapStyleWord(true);
        jobpane.setName("JobPane");
        jobpane.getViewport().add((Component)progressText, null);
        jobpane.setBorder(null);
        if (this.jobPanes == null) {
            this.jobPanes = new Vector();
        }
        int newpane = this.jobPanes.size();
        this.jobPanes.add(jobpane);
        if (newpane == 0) {
            this.add((Component)jobpane, "Center");
        } else {
            if (newpane == 1) {
                JScrollPane firstpane = (JScrollPane)this.jobPanes.get(0);
                this.remove(firstpane);
                this.subjobs = new JTabbedPane();
                this.add((Component)this.subjobs, "Center");
                this.subjobs.add(firstpane);
                this.subjobs.setTitleAt(0, firstpane.getName());
            }
            this.subjobs.add(jobpane);
        }
        return newpane;
    }

    public WebserviceInfo(String title, String info) {
        this.init(title, info, 520, 500);
    }

    public WebserviceInfo(String title, String info, int width, int height) {
        this.init(title, info, width, height);
    }

    public WSClientI getthisService() {
        return this.thisService;
    }

    public void setthisService(WSClientI newservice) {
        this.thisService = newservice;
        this.serviceIsCancellable = newservice.isCancellable();
        this.frame.setClosable(!this.serviceIsCancellable);
        this.serviceCanMergeResults = newservice.canMergeResults();
        this.rebuildButtonPanel();
    }

    private void rebuildButtonPanel() {
        if (this.buttonPanel != null) {
            this.buttonPanel.removeAll();
            if (this.serviceIsCancellable) {
                this.buttonPanel.add(this.cancel);
                this.frame.setClosable(false);
            } else {
                this.frame.setClosable(true);
            }
        }
    }

    void init(String title, String info, int width, int height) {
        this.frame = new JInternalFrame();
        this.frame.setContentPane(this);
        Desktop.addInternalFrame(this.frame, title, width, height);
        this.frame.setClosable(false);
        this.title = title;
        this.setInfoText(info);
        URL url = this.getClass().getResource("/images/logo.gif");
        this.image = Toolkit.getDefaultToolkit().createImage(url);
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(this.image, 0);
        try {
            mt.waitForID(0);
        }
        catch (Exception ex) {
            // empty catch block
        }
        AnimatedPanel ap = new AnimatedPanel();
        this.titlePanel.add((Component)ap, "Center");
        Thread thread = new Thread(ap);
        thread.start();
        final WebserviceInfo thisinfo = this;
        this.frame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosed(InternalFrameEvent evt) {
                WSClientI service = thisinfo.getthisService();
                if (service != null && service.isCancellable()) {
                    service.cancelJob();
                }
            }
        });
    }

    public void setStatus(int status) {
        this.currentStatus = status;
    }

    public void setStatus(int jobpane, int status) {
        if (jobpane < 0 || jobpane >= this.jobPanes.size()) {
            throw new Error("setStatus called for non-existent job pane." + jobpane);
        }
        switch (status) {
            case 0: {
                this.setProgressName(jobpane + " - QUEUED", jobpane);
                break;
            }
            case 1: {
                this.setProgressName(jobpane + " - RUNNING", jobpane);
                break;
            }
            case 2: {
                this.setProgressName(jobpane + " - FINISHED", jobpane);
                break;
            }
            case 3: {
                this.setProgressName(jobpane + " - CANCELLED", jobpane);
                break;
            }
            case 4: {
                this.setProgressName(jobpane + " - BROKEN", jobpane);
                break;
            }
            case 5: {
                this.setProgressName(jobpane + " - ALERT", jobpane);
                break;
            }
            default: {
                this.setProgressName(jobpane + " - UNKNOWN STATE", jobpane);
            }
        }
    }

    public String getInfoText() {
        return this.infoText.getText();
    }

    public void setInfoText(String text) {
        this.infoText.setText(text);
    }

    public void appendInfoText(String text) {
        this.infoText.append(text);
    }

    public String getProgressText(int which) {
        if (this.jobPanes == null) {
            this.addJobPane();
        }
        return ((JTextArea)((JScrollPane)this.jobPanes.get(which)).getViewport().getComponent(0)).getText();
    }

    public void setProgressText(int which, String text) {
        if (this.jobPanes == null) {
            this.addJobPane();
        }
        ((JTextArea)((JScrollPane)this.jobPanes.get(which)).getViewport().getComponent(0)).setText(text);
    }

    public void appendProgressText(int which, String text) {
        if (this.jobPanes == null) {
            this.addJobPane();
        }
        ((JTextArea)((JScrollPane)this.jobPanes.get(which)).getViewport().getComponent(0)).append(text);
    }

    public void setProgressText(String text) {
        this.setProgressText(0, text);
    }

    public void appendProgressText(String text) {
        this.appendProgressText(0, text);
    }

    public String getProgressText() {
        return this.getProgressText(0);
    }

    public String getProgressName(int which) {
        if (this.jobPanes == null) {
            this.addJobPane();
        }
        if (this.subjobs != null) {
            return this.subjobs.getTitleAt(which);
        }
        return ((JScrollPane)this.jobPanes.get(which)).getViewport().getComponent(0).getName();
    }

    public void setProgressName(String name, int which) {
        if (this.subjobs != null) {
            this.subjobs.setTitleAt(which, name);
            this.subjobs.revalidate();
            this.subjobs.repaint();
        }
        JScrollPane c = (JScrollPane)this.jobPanes.get(which);
        c.getViewport().getComponent(0).setName(name);
        c.repaint();
    }

    protected void cancel_actionPerformed(ActionEvent e) {
        if (!this.serviceIsCancellable) {
            JOptionPane.showInternalMessageDialog(Desktop.desktop, "This job cannot be cancelled.\nJust close the window.", "Cancel job", 2);
        } else {
            this.thisService.cancelJob();
        }
        this.frame.setClosable(true);
    }

    public void setResultsReady() {
        this.frame.setClosable(true);
        this.buttonPanel.remove(this.cancel);
        this.buttonPanel.add(this.showResultsNewFrame);
        if (this.serviceCanMergeResults) {
            this.buttonPanel.add(this.mergeResults);
            this.buttonPanel.setLayout(new GridLayout(2, 1, 5, 5));
        }
        this.buttonPanel.validate();
        this.validate();
        if (this.viewResultsImmediatly) {
            this.showResultsNewFrame.doClick();
        }
    }

    public void setFinishedNoResults() {
        this.frame.setClosable(true);
        this.buttonPanel.remove(this.cancel);
        this.buttonPanel.validate();
        this.validate();
    }

    class AnimatedPanel
    extends JPanel
    implements Runnable {
        long startTime = 0L;
        BufferedImage offscreen;

        AnimatedPanel() {
        }

        public void run() {
            this.startTime = System.currentTimeMillis();
            while (WebserviceInfo.this.currentStatus < 2) {
                try {
                    Thread.sleep(50L);
                    int units = (int)((float)(System.currentTimeMillis() - this.startTime) / 10.0f);
                    WebserviceInfo.this.angle += units;
                    WebserviceInfo.this.angle %= 360;
                    this.startTime = System.currentTimeMillis();
                    if (WebserviceInfo.this.currentStatus >= 2) {
                        WebserviceInfo.this.angle = 0;
                    }
                    this.repaint();
                }
                catch (Exception exception) {}
            }
            WebserviceInfo.this.cancel.setEnabled(false);
        }

        void drawPanel() {
            if (this.offscreen == null || this.offscreen.getWidth(this) != this.getWidth() || this.offscreen.getHeight(this) != this.getHeight()) {
                this.offscreen = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            }
            Graphics2D g = (Graphics2D)this.offscreen.getGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setFont(new Font("Arial", 1, 12));
            g.setColor(Color.black);
            switch (WebserviceInfo.this.currentStatus) {
                case 0: {
                    g.drawString(WebserviceInfo.this.title.concat(" - queuing"), 60, 30);
                    break;
                }
                case 1: {
                    g.drawString(WebserviceInfo.this.title.concat(" - running"), 60, 30);
                    break;
                }
                case 2: {
                    g.drawString(WebserviceInfo.this.title.concat(" - complete"), 60, 30);
                    break;
                }
                case 3: {
                    g.drawString(WebserviceInfo.this.title.concat(" - job cancelled!"), 60, 30);
                    break;
                }
                case 4: {
                    g.drawString(WebserviceInfo.this.title.concat(" - job error!"), 60, 30);
                    break;
                }
                case 5: {
                    g.drawString(WebserviceInfo.this.title.concat(" - Server Error! (try later)"), 60, 30);
                }
            }
            if (WebserviceInfo.this.image != null) {
                g.rotate(Math.toRadians(WebserviceInfo.this.angle), 28.0, 28.0);
                g.drawImage(WebserviceInfo.this.image, 10, 10, this);
                g.rotate(-Math.toRadians(WebserviceInfo.this.angle), 28.0, 28.0);
            }
        }

        public void paintComponent(Graphics g1) {
            this.drawPanel();
            g1.drawImage(this.offscreen, 0, 0, this);
        }
    }
}

