/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.AppletFormatAdapter;
import jalview.io.BLCFile;
import jalview.io.ClustalFile;
import jalview.io.FastaFile;
import jalview.io.MSFfile;
import jalview.io.PIRFile;
import jalview.io.PfamFile;
import jalview.io.PileUpfile;

public class FormatAdapter
extends AppletFormatAdapter {
    public String formatSequences(String format, SequenceI[] seqs, String[] omitHiddenColumns) {
        return this.formatSequences(format, this.replaceStrings(seqs, omitHiddenColumns));
    }

    public SequenceI[] replaceStrings(SequenceI[] seqs, String[] omitHiddenColumns) {
        if (omitHiddenColumns != null) {
            SequenceI[] tmp = new SequenceI[seqs.length];
            for (int i = 0; i < seqs.length; ++i) {
                tmp[i] = new Sequence(seqs[i].getName(), omitHiddenColumns[i], seqs[i].getStart(), seqs[i].getEnd());
                tmp[i].setDescription(seqs[i].getDescription());
            }
            seqs = tmp;
        }
        return seqs;
    }

    public String formatSequences(String format, SequenceI[] seqs) {
        try {
            AlignFile afile = null;
            if (format.equalsIgnoreCase("FASTA")) {
                afile = new FastaFile();
                afile.addJVSuffix(Cache.getDefault("FASTA_JVSUFFIX", true));
            } else if (format.equalsIgnoreCase("MSF")) {
                afile = new MSFfile();
                afile.addJVSuffix(Cache.getDefault("MSF_JVSUFFIX", true));
            } else if (format.equalsIgnoreCase("PileUp")) {
                afile = new PileUpfile();
                afile.addJVSuffix(Cache.getDefault("PILEUP_JVSUFFIX", true));
            } else if (format.equalsIgnoreCase("CLUSTAL")) {
                afile = new ClustalFile();
                afile.addJVSuffix(Cache.getDefault("CLUSTAL_JVSUFFIX", true));
            } else if (format.equalsIgnoreCase("BLC")) {
                afile = new BLCFile();
                afile.addJVSuffix(Cache.getDefault("BLC_JVSUFFIX", true));
            } else if (format.equalsIgnoreCase("PIR")) {
                afile = new PIRFile();
                afile.addJVSuffix(Cache.getDefault("PIR_JVSUFFIX", true));
            } else if (format.equalsIgnoreCase("PFAM")) {
                afile = new PfamFile();
                afile.addJVSuffix(Cache.getDefault("PFAM_JVSUFFIX", true));
            }
            afile.setSeqs(seqs);
            return afile.print();
        }
        catch (Exception e) {
            System.err.println("Failed to write alignment as a '" + format + "' file\n");
            e.printStackTrace();
            return null;
        }
    }

    public boolean getCacheSuffixDefault(String format) {
        if (FormatAdapter.isValidFormat(format)) {
            return Cache.getDefault(format.toUpperCase() + "_JVSUFFIX", true);
        }
        return false;
    }

    public String formatSequences(String format, AlignmentI alignment, String[] omitHidden, ColumnSelection colSel) {
        return this.formatSequences(format, alignment, omitHidden, this.getCacheSuffixDefault(format), colSel, null);
    }

    public String formatSequences(String format, AlignmentI alignment, String[] omitHidden, ColumnSelection colSel, SequenceGroup sgp) {
        return this.formatSequences(format, alignment, omitHidden, this.getCacheSuffixDefault(format), colSel, sgp);
    }

    public String formatSequences(String format, AlignmentI alignment, String[] omitHidden, boolean suffix, ColumnSelection colSel) {
        return this.formatSequences(format, alignment, omitHidden, suffix, colSel, null);
    }

    public String formatSequences(String format, AlignmentI alignment, String[] omitHidden, boolean suffix, ColumnSelection colSel, SequenceGroup selgp) {
        if (omitHidden != null) {
            Alignment alv = new Alignment(this.replaceStrings(alignment.getSequencesArray(), omitHidden));
            AlignmentAnnotation[] ala = alignment.getAlignmentAnnotation();
            for (int i = 0; i < ala.length; ++i) {
                AlignmentAnnotation na = new AlignmentAnnotation(ala[i]);
                if (selgp != null) {
                    colSel.makeVisibleAnnotation(selgp.getStartRes(), selgp.getEndRes(), na);
                } else {
                    colSel.makeVisibleAnnotation(na);
                }
                alv.addAnnotation(na);
            }
            return this.formatSequences(format, alv, suffix);
        }
        return this.formatSequences(format, alignment, suffix);
    }

    public static final boolean isValidIOFormat(String format, boolean forwriting) {
        if (format.equalsIgnoreCase("jalview")) {
            return true;
        }
        return AppletFormatAdapter.isValidFormat(format, forwriting);
    }
}

