/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.bin.Cache;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.FeatureRenderer;
import jalview.gui.SequenceRenderer;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.util.BrowserLauncher;
import jalview.util.Comparison;
import jalview.util.Format;
import java.awt.Color;
import java.io.FileWriter;
import java.io.PrintWriter;

public class HTMLOutput {
    AlignViewport av;
    SequenceRenderer sr;
    FeatureRenderer fr;
    Color color;

    public HTMLOutput(AlignmentPanel ap, SequenceRenderer sr, FeatureRenderer fr1) {
        this.av = ap.av;
        this.sr = sr;
        this.fr = new FeatureRenderer(ap);
        this.fr.transferSettings(fr1);
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"), new String[]{"html"}, new String[]{"HTML files"}, "HTML files");
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle("Save as HTML");
        chooser.setToolTipText("Save");
        int value = chooser.showSaveDialog(null);
        if (value == 0) {
            String choice = chooser.getSelectedFile().getPath();
            Cache.setProperty("LAST_DIRECTORY", chooser.getSelectedFile().getParent());
            try {
                PrintWriter out = new PrintWriter(new FileWriter(choice));
                out.println("<HTML>");
                out.println("<style type=\"text/css\">");
                out.println("<!--");
                out.print("td {font-family: \"" + this.av.getFont().getFamily() + "\", \"" + this.av.getFont().getName() + "\", mono; " + "font-size: " + this.av.getFont().getSize() + "px; ");
                if (this.av.getFont().getStyle() == 1) {
                    out.print("font-weight: BOLD; ");
                }
                if (this.av.getFont().getStyle() == 2) {
                    out.print("font-style: italic; ");
                }
                out.println("text-align: center; }");
                out.println("-->");
                out.println("</style>");
                out.println("<BODY>");
                if (this.av.getWrapAlignment()) {
                    this.drawWrappedAlignment(out);
                } else {
                    this.drawUnwrappedAlignment(out);
                }
                out.println("\n</body>\n</html>");
                out.close();
                BrowserLauncher.openURL("file:///" + choice);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void drawUnwrappedAlignment(PrintWriter out) {
        out.println("<table border=\"1\"><tr><td>\n");
        out.println("<table border=\"0\"  cellpadding=\"0\" cellspacing=\"0\">\n");
        AlignmentI alignment = this.av.getAlignment();
        out.println("<tr><td colspan=\"6\"></td>");
        int i = 0;
        for (i = 10; i < alignment.getWidth() - 10; i += 10) {
            out.println("<td colspan=\"9\">" + i + "<br>|</td><td></td>");
        }
        out.println("<td colspan=\"3\"></td><td colspan=\"3\">" + i + "<br>|</td>");
        out.println("</tr>");
        for (i = 0; i < alignment.getHeight(); ++i) {
            SequenceI seq = alignment.getSequenceAt(i);
            String id = seq.getDisplayId(this.av.getShowJVSuffix());
            out.println("<tr><td nowrap>" + id + "&nbsp;&nbsp;</td>");
            for (int res = 0; res < seq.getLength(); ++res) {
                if (!Comparison.isGap(seq.getCharAt(res))) {
                    this.color = this.sr.getResidueBoxColour(seq, res);
                    this.color = this.fr.findFeatureColour(this.color, seq, res);
                } else {
                    this.color = Color.white;
                }
                if (this.color.getRGB() < -1) {
                    out.println("<td bgcolor=\"#" + Format.getHexString(this.color) + "\">" + seq.getCharAt(res) + "</td>");
                    continue;
                }
                out.println("<td>" + seq.getCharAt(res) + "</td>");
            }
            out.println("</tr>");
        }
        out.println("</table>");
        out.println("</td></tr></table>");
    }

    void drawWrappedAlignment(PrintWriter out) {
        AlignmentI al = this.av.getAlignment();
        out.println("<table border=\"1\"><tr><td>\n");
        out.println("<table border=\"0\"  cellpadding=\"0\" cellspacing=\"0\">\n");
        for (int startRes = 0; startRes < al.getWidth(); startRes += this.av.getWrappedWidth()) {
            int endRes = startRes + this.av.getWrappedWidth();
            if (endRes > al.getWidth()) {
                endRes = al.getWidth();
            }
            if (this.av.getScaleAboveWrapped()) {
                out.println("<tr>");
                if (this.av.getScaleLeftWrapped()) {
                    out.println("<td colspan=\"7\">&nbsp;</td>");
                } else {
                    out.println("<td colspan=\"6\">&nbsp;</td>");
                }
                for (int i = startRes + 10; i < endRes; i += 10) {
                    out.println("<td colspan=\"9\">" + i + "<br>|</td><td></td>");
                }
                out.println("</tr>");
            }
            for (int s = 0; s < al.getHeight(); ++s) {
                out.println("<tr>");
                SequenceI seq = al.getSequenceAt(s);
                int startPos = seq.findPosition(startRes);
                int endPos = seq.findPosition(endRes) - 1;
                String id = seq.getDisplayId(this.av.getShowJVSuffix());
                out.println("<td nowrap>" + id + "&nbsp;&nbsp;</td>");
                if (this.av.getScaleLeftWrapped()) {
                    if (startPos > seq.getEnd() || endPos == 0) {
                        out.println("<td nowrap>&nbsp;</td>");
                    } else {
                        out.println("<td nowrap>" + startPos + "&nbsp;&nbsp;</td>");
                    }
                }
                for (int res = startRes; res < endRes; ++res) {
                    if (!Comparison.isGap(seq.getCharAt(res))) {
                        this.color = this.sr.getResidueBoxColour(seq, res);
                        this.color = this.fr.findFeatureColour(this.color, seq, res);
                    } else {
                        this.color = Color.white;
                    }
                    if (this.color.getRGB() < -1) {
                        out.println("<td bgcolor=\"#" + Format.getHexString(this.color) + "\">" + seq.getCharAt(res) + "</td>");
                        continue;
                    }
                    out.println("<td>" + seq.getCharAt(res) + "</td>");
                }
                if (this.av.getScaleRightWrapped() && endRes < startRes + this.av.getWrappedWidth()) {
                    out.println("<td colspan=\"" + (startRes + this.av.getWrappedWidth() - endRes) + "\">" + "&nbsp;&nbsp;</td>");
                }
                if (this.av.getScaleRightWrapped() && startPos < endPos) {
                    out.println("<td nowrap>&nbsp;" + endPos + "&nbsp;&nbsp;</td>");
                }
                out.println("</tr>");
            }
            if (endRes >= al.getWidth()) continue;
            out.println("<tr><td height=\"5\"></td></tr>");
        }
        out.println("</table>");
        out.println("</table>");
    }

    public static String getImageMapHTML() {
        return new String("<html>\n<head>\n<script language=\"JavaScript\">\nvar ns4 = document.layers;\nvar ns6 = document.getElementById && !document.all;\nvar ie4 = document.all;\noffsetX = 0;\noffsetY = 20;\nvar toolTipSTYLE=\"\";\nfunction initToolTips()\n{\n  if(ns4||ns6||ie4)\n  {\n    if(ns4) toolTipSTYLE = document.toolTipLayer;\n    else if(ns6) toolTipSTYLE = document.getElementById(\"toolTipLayer\").style;\n    else if(ie4) toolTipSTYLE = document.all.toolTipLayer.style;\n    if(ns4) document.captureEvents(Event.MOUSEMOVE);\n    else\n    {\n      toolTipSTYLE.visibility = \"visible\";\n      toolTipSTYLE.display = \"none\";\n    }\n    document.onmousemove = moveToMouseLoc;\n  }\n}\nfunction toolTip(msg, fg, bg)\n{\n  if(toolTip.arguments.length < 1) // hide\n  {\n    if(ns4) toolTipSTYLE.visibility = \"hidden\";\n    else toolTipSTYLE.display = \"none\";\n  }\n  else // show\n  {\n    if(!fg) fg = \"#555555\";\n    if(!bg) bg = \"#FFFFFF\";\n    var content =\n    '<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\" bgcolor=\"' + fg + '\"><td>' +\n    '<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\" bgcolor=\"' + bg + \n    '\"><td align=\"center\"><font face=\"sans-serif\" color=\"' + fg +\n    '\" size=\"-2\">&nbsp;' + msg +\n    '&nbsp;</font></td></table></td></table>';\n    if(ns4)\n    {\n      toolTipSTYLE.document.write(content);\n      toolTipSTYLE.document.close();\n      toolTipSTYLE.visibility = \"visible\";\n    }\n    if(ns6)\n    {\n      document.getElementById(\"toolTipLayer\").innerHTML = content;\n      toolTipSTYLE.display='block'\n    }\n    if(ie4)\n    {\n      document.all(\"toolTipLayer\").innerHTML=content;\n      toolTipSTYLE.display='block'\n    }\n  }\n}\nfunction moveToMouseLoc(e)\n{\n  if(ns4||ns6)\n  {\n    x = e.pageX;\n    y = e.pageY;\n  }\n  else\n  {\n    x = event.x + document.body.scrollLeft;\n    y = event.y + document.body.scrollTop;\n  }\n  toolTipSTYLE.left = x + offsetX;\n  toolTipSTYLE.top = y + offsetY;\n  return true;\n}\n</script>\n</head>\n<body>\n<div id=\"toolTipLayer\" style=\"position:absolute; visibility: hidden\"></div>\n<script language=\"JavaScript\"><!--\ninitToolTips(); //--></script>\n");
    }
}

