/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.bin.Cache;
import jalview.io.JalviewFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class JalviewFileChooser
extends JFileChooser {
    public JalviewFileChooser(String dir) {
        super(JalviewFileChooser.safePath(dir));
        this.setAccessory(new RecentlyOpened());
    }

    private static File safePath(String dir) {
        if (dir == null) {
            return null;
        }
        File f = new File(dir);
        if (f.getName().indexOf(58) > -1) {
            return null;
        }
        return f;
    }

    public JalviewFileChooser(String dir, String[] suffix, String[] desc, String selected, boolean selectAll) {
        super(JalviewFileChooser.safePath(dir));
        this.init(suffix, desc, selected, selectAll);
    }

    public JalviewFileChooser(String dir, String[] suffix, String[] desc, String selected) {
        super(JalviewFileChooser.safePath(dir));
        this.init(suffix, desc, selected, true);
    }

    void init(String[] suffix, String[] desc, String selected, boolean selectAll) {
        JalviewFileFilter chosen = null;
        this.setAcceptAllFileFilterUsed(selectAll);
        for (int i = 0; i < suffix.length; ++i) {
            JalviewFileFilter jvf = new JalviewFileFilter(suffix[i], desc[i]);
            this.addChoosableFileFilter(jvf);
            if (selected == null || !selected.equalsIgnoreCase(desc[i])) continue;
            chosen = jvf;
        }
        if (chosen != null) {
            this.setFileFilter(chosen);
        }
        this.setAccessory(new RecentlyOpened());
    }

    public void setFileFilter(FileFilter filter) {
        super.setFileFilter(filter);
        try {
            if (this.getUI() instanceof BasicFileChooserUI) {
                final BasicFileChooserUI ui = (BasicFileChooserUI)this.getUI();
                final String name = ui.getFileName().trim();
                if (name == null || name.length() == 0) {
                    return;
                }
                EventQueue.invokeLater(new Thread(){

                    public void run() {
                        String currentName = ui.getFileName();
                        if (currentName == null || currentName.length() == 0) {
                            ui.setFileName(name);
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getSelectedFormat() {
        if (this.getFileFilter() == null) {
            return null;
        }
        String format = this.getFileFilter().getDescription();
        if (format.toUpperCase().startsWith("JALVIEW")) {
            format = "Jalview";
        } else if (format.toUpperCase().startsWith("FASTA")) {
            format = "FASTA";
        } else if (format.toUpperCase().startsWith("MSF")) {
            format = "MSF";
        } else if (format.toUpperCase().startsWith("CLUSTAL")) {
            format = "CLUSTAL";
        } else if (format.toUpperCase().startsWith("BLC")) {
            format = "BLC";
        } else if (format.toUpperCase().startsWith("PIR")) {
            format = "PIR";
        } else if (format.toUpperCase().startsWith("PFAM")) {
            format = "PFAM";
        }
        return format;
    }

    public int showSaveDialog(Component parent) throws HeadlessException {
        int confirm;
        JalviewFileFilter jvf;
        this.setAccessory(null);
        this.setDialogType(1);
        int ret = this.showDialog(parent, "Save");
        if (this.getFileFilter() instanceof JalviewFileFilter && !(jvf = (JalviewFileFilter)this.getFileFilter()).accept(this.getSelectedFile())) {
            String withExtension = this.getSelectedFile() + "." + jvf.getAcceptableExtension();
            this.setSelectedFile(new File(withExtension));
        }
        if (ret == 0 && this.getSelectedFile().exists() && (confirm = JOptionPane.showConfirmDialog(parent, "Overwrite existing file?", "File exists", 0)) != 0) {
            ret = 1;
        }
        return ret;
    }

    void recentListSelectionChanged(String selection) {
        JalviewFileFilter jvf;
        this.setSelectedFile(null);
        File file = new File(selection);
        if (this.getFileFilter() instanceof JalviewFileFilter && !(jvf = (JalviewFileFilter)this.getFileFilter()).accept(file)) {
            this.setFileFilter(this.getChoosableFileFilters()[0]);
        }
        this.setSelectedFile(file);
    }

    class RecentlyOpened
    extends JPanel {
        JList list;

        public RecentlyOpened() {
            String historyItems = Cache.getProperty("RECENT_FILE");
            Vector<Object> recent = new Vector<Object>();
            if (historyItems != null) {
                StringTokenizer st = new StringTokenizer(historyItems, "\t");
                while (st.hasMoreTokens()) {
                    recent.addElement(st.nextElement());
                }
            }
            this.list = new JList(recent);
            DefaultListCellRenderer dlcr = new DefaultListCellRenderer();
            dlcr.setHorizontalAlignment(4);
            this.list.setCellRenderer(dlcr);
            this.list.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent evt) {
                    JalviewFileChooser.this.recentListSelectionChanged(RecentlyOpened.this.list.getSelectedValue().toString());
                }
            });
            this.setBorder(new TitledBorder("Recently Opened"));
            final JScrollPane scroller = new JScrollPane(this.list);
            scroller.setPreferredSize(new Dimension(130, 200));
            this.add(scroller);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    scroller.getHorizontalScrollBar().setValue(scroller.getHorizontalScrollBar().getMaximum());
                }
            });
        }
    }
}

