/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileView;

public class JalviewFileView
extends FileView {
    static Hashtable alignSuffix = new Hashtable();

    public String getTypeDescription(File f) {
        String extension = JalviewFileView.getExtension(f);
        String type = null;
        if (extension != null && alignSuffix.containsKey(extension)) {
            type = alignSuffix.get(extension).toString();
        }
        return type;
    }

    public Icon getIcon(File f) {
        String extension = JalviewFileView.getExtension(f);
        ImageIcon icon = null;
        if (extension != null && alignSuffix.containsKey(extension)) {
            icon = JalviewFileView.createImageIcon("/images/file.png");
        }
        return icon;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = JalviewFileView.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("JalviewFileView.createImageIcon: Couldn't find file: " + path);
        return null;
    }

    static {
        alignSuffix.put("fasta", "Fasta file");
        alignSuffix.put("fa", "Fasta file");
        alignSuffix.put("fastq", "Fasta file");
        alignSuffix.put("blc", "BLC file");
        alignSuffix.put("msf", "MSF file");
        alignSuffix.put("pfam", "PFAM file");
        alignSuffix.put("aln", "Clustal file");
        alignSuffix.put("pir", "PIR file");
        alignSuffix.put("jar", "Jalview file");
    }
}

