/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.vamsas;

import jalview.bin.Cache;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.Mapping;
import jalview.datamodel.SequenceI;
import jalview.io.VamsasAppDatastore;
import jalview.io.vamsas.Rangetype;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.objects.core.DbRef;
import uk.ac.vamsas.objects.core.Map;
import uk.ac.vamsas.objects.core.MapType;
import uk.ac.vamsas.objects.core.Sequence;

public class Dbref
extends Rangetype {
    SequenceI sq = null;
    Sequence sequence = null;
    DbRef dbref = null;
    DBRefEntry dbentry = null;

    public Dbref(VamsasAppDatastore datastore, DBRefEntry dbentry, SequenceI sq2, Sequence sequence2) {
        super(datastore);
        this.dbref = (DbRef)this.getjv2vObj(dbentry);
        this.sq = sq2;
        this.sequence = sequence2;
        this.dbentry = dbentry;
        if (this.dbref == null) {
            this.add();
        } else if (this.dbref.isUpdated()) {
            this.conflict();
        } else {
            this.update();
        }
    }

    public Dbref(VamsasAppDatastore datastore, DbRef ref, Sequence vdseq, SequenceI dsseq) {
        super(datastore);
        this.dbref = ref;
        this.sequence = vdseq;
        this.sq = dsseq;
        this.dbentry = (DBRefEntry)this.getvObj2jv((Vobject)this.dbref);
        if (this.dbentry == null) {
            this.addFromDocument();
        } else if (this.dbref.isUpdated()) {
            this.update();
        }
    }

    private void update() {
        Cache.log.debug((Object)"TODO verify update of dataset sequence database references.");
    }

    private void conflict() {
        Cache.log.debug((Object)("Conflict in dbentry update for " + this.dbref.getAccessionId() + this.dbref.getSource() + " " + this.dbref.getVorbaId()));
    }

    private void addFromDocument() {
        this.dbentry = new DBRefEntry(this.dbref.getSource().toString(), this.dbref.getVersion().toString(), this.dbref.getAccessionId().toString());
        this.sq.addDBRef(this.dbentry);
        if (this.dbref.getMapCount() > 0) {
            if (this.dbref.getMapCount() > 1) {
                Cache.log.debug((Object)("Ignoring additional mappings on DbRef: " + this.dbentry.getSource() + ":" + this.dbentry.getAccessionId()));
            }
            Mapping mp = new Mapping(this.parsemapType((MapType)this.dbref.getMap(0)));
            this.dbentry.setMap(mp);
        }
        this.bindjvvobj(this.dbentry, (Vobject)this.dbref);
    }

    private void add() {
        DbRef dbref = new DbRef();
        this.bindjvvobj(this.dbentry, (Vobject)dbref);
        dbref.setAccessionId(this.dbentry.getAccessionId());
        dbref.setSource(this.dbentry.getSource());
        dbref.setVersion(this.dbentry.getVersion());
        if (this.dbentry.getMap() != null) {
            Mapping mp = this.dbentry.getMap();
            if (mp.getMap() != null) {
                Map vMap = new Map();
                this.initMapType((MapType)vMap, mp.getMap(), true);
                dbref.addMap(vMap);
            } else {
                Cache.log.debug((Object)("Ignoring mapless DbRef.Map " + this.dbentry.getSrcAccString()));
            }
        }
        this.sequence.addDbRef(dbref);
    }
}

