/*
 * Decompiled with CFR 0.152.
 */
package jalview.jbgui;

import jalview.bin.Cache;
import jalview.gui.Desktop;
import jalview.gui.UserDefinedColours;
import jalview.io.FormatAdapter;
import jalview.schemes.ColourSchemeProperty;
import jalview.util.Platform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class GAlignFrame
extends JInternalFrame {
    protected JMenuBar alignFrameMenuBar = new JMenuBar();
    protected JMenu fileMenu = new JMenu();
    protected JMenuItem closeMenuItem = new JMenuItem();
    protected JMenu editMenu = new JMenu();
    protected JMenu viewMenu = new JMenu();
    protected JMenu colourMenu = new JMenu();
    protected JMenu calculateMenu = new JMenu();
    protected JMenu webService = new JMenu();
    protected JMenuItem webServiceNoServices;
    protected JMenuItem selectAllSequenceMenuItem = new JMenuItem();
    protected JMenuItem deselectAllSequenceMenuItem = new JMenuItem();
    protected JMenuItem invertSequenceMenuItem = new JMenuItem();
    protected JMenuItem remove2LeftMenuItem = new JMenuItem();
    protected JMenuItem remove2RightMenuItem = new JMenuItem();
    protected JMenuItem removeGappedColumnMenuItem = new JMenuItem();
    protected JMenuItem removeAllGapsMenuItem = new JMenuItem();
    public JCheckBoxMenuItem viewBoxesMenuItem = new JCheckBoxMenuItem();
    public JCheckBoxMenuItem viewTextMenuItem = new JCheckBoxMenuItem();
    protected JMenuItem sortPairwiseMenuItem = new JMenuItem();
    protected JMenuItem sortIDMenuItem = new JMenuItem();
    protected JMenuItem sortGroupMenuItem = new JMenuItem();
    protected JMenu sortByAnnotScore = new JMenu();
    protected JMenuItem removeRedundancyMenuItem = new JMenuItem();
    protected JMenuItem pairwiseAlignmentMenuItem = new JMenuItem();
    protected JMenuItem PCAMenuItem = new JMenuItem();
    protected JMenuItem averageDistanceTreeMenuItem = new JMenuItem();
    protected JMenuItem neighbourTreeMenuItem = new JMenuItem();
    BorderLayout borderLayout1 = new BorderLayout();
    public JLabel statusBar = new JLabel();
    protected JMenuItem saveAs = new JMenuItem();
    protected JMenu outputTextboxMenu = new JMenu();
    protected JRadioButtonMenuItem clustalColour = new JRadioButtonMenuItem();
    protected JRadioButtonMenuItem zappoColour = new JRadioButtonMenuItem();
    protected JRadioButtonMenuItem taylorColour = new JRadioButtonMenuItem();
    protected JRadioButtonMenuItem hydrophobicityColour = new JRadioButtonMenuItem();
    protected JRadioButtonMenuItem helixColour = new JRadioButtonMenuItem();
    protected JRadioButtonMenuItem strandColour = new JRadioButtonMenuItem();
    protected JRadioButtonMenuItem turnColour = new JRadioButtonMenuItem();
    protected JRadioButtonMenuItem buriedColour = new JRadioButtonMenuItem();
    protected JRadioButtonMenuItem userDefinedColour = new JRadioButtonMenuItem();
    protected JRadioButtonMenuItem PIDColour = new JRadioButtonMenuItem();
    protected JRadioButtonMenuItem BLOSUM62Colour = new JRadioButtonMenuItem();
    JMenuItem njTreeBlosumMenuItem = new JMenuItem();
    JMenuItem avDistanceTreeBlosumMenuItem = new JMenuItem();
    public JCheckBoxMenuItem annotationPanelMenuItem = new JCheckBoxMenuItem();
    public JCheckBoxMenuItem colourTextMenuItem = new JCheckBoxMenuItem();
    JMenuItem htmlMenuItem = new JMenuItem();
    JMenuItem overviewMenuItem = new JMenuItem();
    protected JMenuItem undoMenuItem = new JMenuItem();
    protected JMenuItem redoMenuItem = new JMenuItem();
    public JCheckBoxMenuItem conservationMenuItem = new JCheckBoxMenuItem();
    JRadioButtonMenuItem noColourmenuItem = new JRadioButtonMenuItem();
    public JCheckBoxMenuItem wrapMenuItem = new JCheckBoxMenuItem();
    JMenuItem printMenuItem = new JMenuItem();
    public JCheckBoxMenuItem renderGapsMenuItem = new JCheckBoxMenuItem();
    JMenuItem findMenuItem = new JMenuItem();
    public JCheckBoxMenuItem abovePIDThreshold = new JCheckBoxMenuItem();
    public JCheckBoxMenuItem showSeqFeatures = new JCheckBoxMenuItem();
    protected JRadioButtonMenuItem nucleotideColour = new JRadioButtonMenuItem();
    JMenuItem deleteGroups = new JMenuItem();
    JMenuItem delete = new JMenuItem();
    JMenuItem copy = new JMenuItem();
    JMenuItem cut = new JMenuItem();
    JMenu pasteMenu = new JMenu();
    JMenuItem pasteNew = new JMenuItem();
    JMenuItem pasteThis = new JMenuItem();
    public JCheckBoxMenuItem applyToAllGroups = new JCheckBoxMenuItem();
    JMenuItem createPNG = new JMenuItem();
    protected JMenuItem font = new JMenuItem();
    public JCheckBoxMenuItem seqLimits = new JCheckBoxMenuItem();
    JMenuItem epsFile = new JMenuItem();
    JMenuItem LoadtreeMenuItem = new JMenuItem();
    public JCheckBoxMenuItem scaleAbove = new JCheckBoxMenuItem();
    public JCheckBoxMenuItem scaleLeft = new JCheckBoxMenuItem();
    public JCheckBoxMenuItem scaleRight = new JCheckBoxMenuItem();
    protected JMenuItem modifyPID = new JMenuItem();
    protected JMenuItem modifyConservation = new JMenuItem();
    protected JMenu sortByTreeMenu = new JMenu();
    protected JMenu sort = new JMenu();
    JMenu calculate = new JMenu();
    JMenu jMenu2 = new JMenu();
    protected JCheckBoxMenuItem padGapsMenuitem = new JCheckBoxMenuItem();
    protected ButtonGroup colours = new ButtonGroup();
    JMenuItem vamsasStore = new JMenuItem();
    protected JMenuItem showTranslation = new JMenuItem();
    protected JMenuItem extractScores = new JMenuItem();
    protected JMenu showProducts = new JMenu();
    public JMenuItem featureSettings = new JMenuItem();
    JMenuItem fetchSequence = new JMenuItem();
    JMenuItem annotationColour = new JMenuItem();
    JMenuItem associatedData = new JMenuItem();
    protected JCheckBoxMenuItem autoCalculate = new JCheckBoxMenuItem();
    JMenu addSequenceMenu = new JMenu();
    JMenuItem addFromFile = new JMenuItem();
    JMenuItem addFromText = new JMenuItem();
    JMenuItem addFromURL = new JMenuItem();
    JMenuItem exportAnnotations = new JMenuItem();
    JMenuItem exportFeatures = new JMenuItem();
    protected JPanel statusPanel = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JMenu jMenu3 = new JMenu();
    JMenuItem showAllSeqs = new JMenuItem();
    JMenuItem showAllColumns = new JMenuItem();
    JMenu hideMenu = new JMenu();
    JMenuItem hideSelSequences = new JMenuItem();
    JMenuItem hideSelColumns = new JMenuItem();
    protected JCheckBoxMenuItem hiddenMarkers = new JCheckBoxMenuItem();
    JMenuItem invertColSel = new JMenuItem();
    protected JTabbedPane tabbedPane = new JTabbedPane();
    JMenuItem save = new JMenuItem();
    protected JMenuItem reload = new JMenuItem();
    JMenuItem newView = new JMenuItem();
    JMenuItem textColour = new JMenuItem();
    JMenu formatMenu = new JMenu();
    JMenu selectMenu = new JMenu();
    protected JCheckBoxMenuItem idRightAlign = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem centreColumnLabelsMenuItem = new JCheckBoxMenuItem();
    protected JMenuItem gatherViews = new JMenuItem();
    protected JMenuItem expandViews = new JMenuItem();
    JMenuItem pageSetup = new JMenuItem();
    JMenuItem alignmentProperties = new JMenuItem();

    public GAlignFrame() {
        try {
            this.jbInit();
            this.setJMenuBar(this.alignFrameMenuBar);
            for (int i = 0; i < FormatAdapter.WRITEABLE_FORMATS.length; ++i) {
                JMenuItem item = new JMenuItem(FormatAdapter.WRITEABLE_FORMATS[i]);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        GAlignFrame.this.outputText_actionPerformed(e);
                    }
                });
                this.outputTextboxMenu.add(item);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!new Platform().isAMac()) {
            this.closeMenuItem.setMnemonic('C');
            this.outputTextboxMenu.setMnemonic('T');
            this.undoMenuItem.setMnemonic('Z');
            this.redoMenuItem.setMnemonic('0');
            this.copy.setMnemonic('C');
            this.cut.setMnemonic('U');
            this.pasteMenu.setMnemonic('P');
            this.reload.setMnemonic('R');
        }
        if (UserDefinedColours.getUserColourSchemes() != null) {
            Enumeration userColours = UserDefinedColours.getUserColourSchemes().keys();
            while (userColours.hasMoreElements()) {
                final JRadioButtonMenuItem radioItem = new JRadioButtonMenuItem(userColours.nextElement().toString());
                radioItem.setName("USER_DEFINED");
                radioItem.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent evt) {
                        if (evt.isControlDown() || SwingUtilities.isRightMouseButton(evt)) {
                            radioItem.removeActionListener(radioItem.getActionListeners()[0]);
                            int option = JOptionPane.showInternalConfirmDialog(Desktop.desktop, "Remove from default list?", "Remove user defined colour", 0);
                            if (option == 0) {
                                UserDefinedColours.removeColourFromDefaults(radioItem.getText());
                                GAlignFrame.this.colourMenu.remove(radioItem);
                            } else {
                                radioItem.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent evt) {
                                        GAlignFrame.this.userDefinedColour_actionPerformed(evt);
                                    }
                                });
                            }
                        }
                    }
                });
                radioItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        GAlignFrame.this.userDefinedColour_actionPerformed(evt);
                    }
                });
                this.colourMenu.insert(radioItem, 15);
                this.colours.add(radioItem);
            }
        }
        this.colours.add(this.noColourmenuItem);
        this.colours.add(this.clustalColour);
        this.colours.add(this.zappoColour);
        this.colours.add(this.taylorColour);
        this.colours.add(this.hydrophobicityColour);
        this.colours.add(this.helixColour);
        this.colours.add(this.strandColour);
        this.colours.add(this.turnColour);
        this.colours.add(this.buriedColour);
        this.colours.add(this.userDefinedColour);
        this.colours.add(this.PIDColour);
        this.colours.add(this.BLOSUM62Colour);
        this.colours.add(this.nucleotideColour);
        this.setColourSelected(Cache.getDefault("DEFAULT_COLOUR", "None"));
    }

    public void setColourSelected(String defaultColour) {
        if (defaultColour != null) {
            int index = ColourSchemeProperty.getColourIndexFromName(defaultColour);
            switch (index) {
                case 12: {
                    this.noColourmenuItem.setSelected(true);
                    break;
                }
                case 0: {
                    this.clustalColour.setSelected(true);
                    break;
                }
                case 1: {
                    this.BLOSUM62Colour.setSelected(true);
                    break;
                }
                case 2: {
                    this.PIDColour.setSelected(true);
                    break;
                }
                case 3: {
                    this.zappoColour.setSelected(true);
                    break;
                }
                case 4: {
                    this.taylorColour.setSelected(true);
                    break;
                }
                case 5: {
                    this.hydrophobicityColour.setSelected(true);
                    break;
                }
                case 6: {
                    this.helixColour.setSelected(true);
                    break;
                }
                case 7: {
                    this.strandColour.setSelected(true);
                    break;
                }
                case 8: {
                    this.turnColour.setSelected(true);
                    break;
                }
                case 9: {
                    this.buriedColour.setSelected(true);
                    break;
                }
                case 10: {
                    this.nucleotideColour.setSelected(true);
                    break;
                }
                case 11: {
                    this.userDefinedColour.setSelected(true);
                }
            }
        }
    }

    private void jbInit() throws Exception {
        this.fileMenu.setText("File");
        this.saveAs.setText("Save As...");
        this.saveAs.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1, false));
        this.saveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.saveAs_actionPerformed(e);
            }
        });
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.closeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.closeMenuItem_actionPerformed(false);
            }
        });
        this.editMenu.setText("Edit");
        this.viewMenu.setText("View");
        this.colourMenu.setText("Colour");
        this.calculateMenu.setText("Calculate");
        this.webService.setText("Web Service");
        this.selectAllSequenceMenuItem.setText("Select All");
        this.selectAllSequenceMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.selectAllSequenceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.selectAllSequenceMenuItem_actionPerformed(e);
            }
        });
        this.deselectAllSequenceMenuItem.setText("Deselect All");
        this.deselectAllSequenceMenuItem.setAccelerator(KeyStroke.getKeyStroke(27, 0, false));
        this.deselectAllSequenceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.deselectAllSequenceMenuItem_actionPerformed(e);
            }
        });
        this.invertSequenceMenuItem.setText("Invert Sequence Selection");
        this.invertSequenceMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.invertSequenceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.invertSequenceMenuItem_actionPerformed(e);
            }
        });
        this.remove2LeftMenuItem.setText("Remove Left");
        this.remove2LeftMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.remove2LeftMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.remove2LeftMenuItem_actionPerformed(e);
            }
        });
        this.remove2RightMenuItem.setText("Remove Right");
        this.remove2RightMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.remove2RightMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.remove2RightMenuItem_actionPerformed(e);
            }
        });
        this.removeGappedColumnMenuItem.setText("Remove Empty Columns");
        this.removeGappedColumnMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.removeGappedColumnMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.removeGappedColumnMenuItem_actionPerformed(e);
            }
        });
        this.removeAllGapsMenuItem.setText("Remove All Gaps");
        this.removeAllGapsMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1, false));
        this.removeAllGapsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.removeAllGapsMenuItem_actionPerformed(e);
            }
        });
        this.viewBoxesMenuItem.setText("Boxes");
        this.viewBoxesMenuItem.setState(true);
        this.viewBoxesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.viewBoxesMenuItem_actionPerformed(e);
            }
        });
        this.viewTextMenuItem.setText("Text");
        this.viewTextMenuItem.setState(true);
        this.viewTextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.viewTextMenuItem_actionPerformed(e);
            }
        });
        this.sortPairwiseMenuItem.setText("by Pairwise Identity");
        this.sortPairwiseMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.sortPairwiseMenuItem_actionPerformed(e);
            }
        });
        this.sortIDMenuItem.setText("by ID");
        this.sortIDMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.sortIDMenuItem_actionPerformed(e);
            }
        });
        this.sortGroupMenuItem.setText("by Group");
        this.sortGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.sortGroupMenuItem_actionPerformed(e);
            }
        });
        this.removeRedundancyMenuItem.setText("Remove Redundancy...");
        this.removeRedundancyMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.removeRedundancyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.removeRedundancyMenuItem_actionPerformed(e);
            }
        });
        this.pairwiseAlignmentMenuItem.setText("Pairwise Alignments...");
        this.pairwiseAlignmentMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.pairwiseAlignmentMenuItem_actionPerformed(e);
            }
        });
        this.PCAMenuItem.setText("Principal Component Analysis");
        this.PCAMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.PCAMenuItem_actionPerformed(e);
            }
        });
        this.averageDistanceTreeMenuItem.setText("Average Distance Using % Identity");
        this.averageDistanceTreeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.averageDistanceTreeMenuItem_actionPerformed(e);
            }
        });
        this.neighbourTreeMenuItem.setText("Neighbour Joining Using % Identity");
        this.neighbourTreeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.neighbourTreeMenuItem_actionPerformed(e);
            }
        });
        this.getContentPane().setLayout(this.borderLayout1);
        this.alignFrameMenuBar.setFont(new Font("Verdana", 0, 11));
        this.statusBar.setBackground(Color.white);
        this.statusBar.setFont(new Font("Verdana", 0, 11));
        this.statusBar.setBorder(BorderFactory.createLineBorder(Color.black));
        this.statusBar.setText("Status bar");
        this.outputTextboxMenu.setText("Output to Textbox");
        this.clustalColour.setText("Clustalx");
        this.clustalColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.clustalColour_actionPerformed(e);
            }
        });
        this.zappoColour.setText("Zappo");
        this.zappoColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.zappoColour_actionPerformed(e);
            }
        });
        this.taylorColour.setText("Taylor");
        this.taylorColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.taylorColour_actionPerformed(e);
            }
        });
        this.hydrophobicityColour.setText("Hydrophobicity");
        this.hydrophobicityColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.hydrophobicityColour_actionPerformed(e);
            }
        });
        this.helixColour.setText("Helix Propensity");
        this.helixColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.helixColour_actionPerformed(e);
            }
        });
        this.strandColour.setText("Strand Propensity");
        this.strandColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.strandColour_actionPerformed(e);
            }
        });
        this.turnColour.setText("Turn Propensity");
        this.turnColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.turnColour_actionPerformed(e);
            }
        });
        this.buriedColour.setText("Buried Index");
        this.buriedColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.buriedColour_actionPerformed(e);
            }
        });
        this.userDefinedColour.setText("User Defined...");
        this.userDefinedColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.userDefinedColour_actionPerformed(e);
            }
        });
        this.PIDColour.setText("Percentage Identity");
        this.PIDColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.PIDColour_actionPerformed(e);
            }
        });
        this.BLOSUM62Colour.setText("BLOSUM62 Score");
        this.BLOSUM62Colour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.BLOSUM62Colour_actionPerformed(e);
            }
        });
        this.avDistanceTreeBlosumMenuItem.setText("Average Distance Using BLOSUM62");
        this.avDistanceTreeBlosumMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.avTreeBlosumMenuItem_actionPerformed(e);
            }
        });
        this.njTreeBlosumMenuItem.setText("Neighbour Joining using BLOSUM62");
        this.njTreeBlosumMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.njTreeBlosumMenuItem_actionPerformed(e);
            }
        });
        this.annotationPanelMenuItem.setActionCommand("");
        this.annotationPanelMenuItem.setText("Show Annotations");
        this.annotationPanelMenuItem.setState(Cache.getDefault("SHOW_ANNOTATIONS", true));
        this.annotationPanelMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.annotationPanelMenuItem_actionPerformed(e);
            }
        });
        this.colourTextMenuItem.setText("Colour Text");
        this.colourTextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.colourTextMenuItem_actionPerformed(e);
            }
        });
        this.htmlMenuItem.setText("HTML");
        this.htmlMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.htmlMenuItem_actionPerformed(e);
            }
        });
        this.overviewMenuItem.setText("Overview Window");
        this.overviewMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.overviewMenuItem_actionPerformed(e);
            }
        });
        this.undoMenuItem.setEnabled(false);
        this.undoMenuItem.setText("Undo");
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.undoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.undoMenuItem_actionPerformed(e);
            }
        });
        this.redoMenuItem.setEnabled(false);
        this.redoMenuItem.setText("Redo");
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.redoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.redoMenuItem_actionPerformed(e);
            }
        });
        this.conservationMenuItem.setText("By Conservation");
        this.conservationMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.conservationMenuItem_actionPerformed(e);
            }
        });
        this.noColourmenuItem.setText("None");
        this.noColourmenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.noColourmenuItem_actionPerformed(e);
            }
        });
        this.wrapMenuItem.setText("Wrap");
        this.wrapMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.wrapMenuItem_actionPerformed(e);
            }
        });
        this.printMenuItem.setText("Print ...");
        this.printMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.printMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.printMenuItem_actionPerformed(e);
            }
        });
        this.renderGapsMenuItem.setText("Show Gaps");
        this.renderGapsMenuItem.setState(true);
        this.renderGapsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.renderGapsMenuItem_actionPerformed(e);
            }
        });
        this.findMenuItem.setText("Find...");
        this.findMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.findMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.findMenuItem_actionPerformed(e);
            }
        });
        this.abovePIDThreshold.setText("Above Identity Threshold");
        this.abovePIDThreshold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.abovePIDThreshold_actionPerformed(e);
            }
        });
        this.showSeqFeatures.setText("Show Sequence Features");
        this.showSeqFeatures.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GAlignFrame.this.showSeqFeatures_actionPerformed(actionEvent);
            }
        });
        this.nucleotideColour.setText("Nucleotide");
        this.nucleotideColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.nucleotideColour_actionPerformed(e);
            }
        });
        this.deleteGroups.setText("Undefine groups");
        this.deleteGroups.setAccelerator(KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.deleteGroups.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.deleteGroups_actionPerformed(e);
            }
        });
        this.copy.setText("Copy");
        this.copy.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.copy_actionPerformed(e);
            }
        });
        this.cut.setText("Cut");
        this.cut.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.cut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.cut_actionPerformed(e);
            }
        });
        this.delete.setText("Delete");
        this.delete.setAccelerator(KeyStroke.getKeyStroke(8, 0, false));
        this.delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.delete_actionPerformed(e);
            }
        });
        this.pasteMenu.setText("Paste");
        this.pasteNew.setText("To New Alignment");
        this.pasteNew.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1, false));
        this.pasteNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.pasteNew_actionPerformed(e);
            }
        });
        this.pasteThis.setText("Add To This Alignment");
        this.pasteThis.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.pasteThis.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.pasteThis_actionPerformed(e);
            }
        });
        this.applyToAllGroups.setText("Apply Colour To All Groups");
        this.applyToAllGroups.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.applyToAllGroups_actionPerformed(e);
            }
        });
        this.createPNG.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.createPNG(null);
            }
        });
        this.createPNG.setActionCommand("Save As PNG Image");
        this.createPNG.setText("PNG");
        this.font.setText("Font...");
        this.font.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.font_actionPerformed(e);
            }
        });
        this.seqLimits.setText("Show Sequence Limits");
        this.seqLimits.setState(Cache.getDefault("SHOW_JVSUFFIX", true));
        this.seqLimits.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.seqLimit_actionPerformed(e);
            }
        });
        this.epsFile.setText("EPS");
        this.epsFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.createEPS(null);
            }
        });
        this.LoadtreeMenuItem.setActionCommand("Load a tree for this sequence set");
        this.LoadtreeMenuItem.setText("Load Associated Tree");
        this.LoadtreeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.LoadtreeMenuItem_actionPerformed(e);
            }
        });
        this.scaleAbove.setVisible(false);
        this.scaleAbove.setText("Scale Above");
        this.scaleAbove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.scaleAbove_actionPerformed(e);
            }
        });
        this.scaleLeft.setVisible(false);
        this.scaleLeft.setSelected(true);
        this.scaleLeft.setText("Scale Left");
        this.scaleLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.scaleLeft_actionPerformed(e);
            }
        });
        this.scaleRight.setVisible(false);
        this.scaleRight.setSelected(true);
        this.scaleRight.setText("Scale Right");
        this.scaleRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.scaleRight_actionPerformed(e);
            }
        });
        this.centreColumnLabelsMenuItem.setVisible(true);
        this.centreColumnLabelsMenuItem.setState(false);
        this.centreColumnLabelsMenuItem.setText("Centre Column Labels");
        this.centreColumnLabelsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.centreColumnLabels_actionPerformed(e);
            }
        });
        this.modifyPID.setText("Modify Identity Threshold...");
        this.modifyPID.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.modifyPID_actionPerformed(e);
            }
        });
        this.modifyConservation.setText("Modify Conservation Threshold...");
        this.modifyConservation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.modifyConservation_actionPerformed(e);
            }
        });
        this.sortByTreeMenu.setText("By Tree Order");
        this.sort.setText("Sort");
        this.sort.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                GAlignFrame.this.buildTreeMenu();
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
        this.sortByAnnotScore.setText("by Score");
        this.sort.add(this.sortByAnnotScore);
        this.sortByAnnotScore.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                GAlignFrame.this.buildSortByAnnotationScoresMenu();
            }
        });
        this.sortByAnnotScore.setVisible(false);
        this.calculate.setText("Calculate Tree");
        this.jMenu2.setText("Export Image");
        this.padGapsMenuitem.setText("Pad Gaps");
        this.padGapsMenuitem.setState(Cache.getDefault("PAD_GAPS", false));
        this.padGapsMenuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.padGapsMenuitem_actionPerformed(e);
            }
        });
        this.vamsasStore.setVisible(false);
        this.vamsasStore.setText("VAMSAS store");
        this.vamsasStore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.vamsasStore_actionPerformed(e);
            }
        });
        this.showTranslation.setText("Translate cDNA");
        this.showTranslation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showTranslation_actionPerformed(e);
            }
        });
        this.extractScores.setText("Extract Scores...");
        this.extractScores.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.extractScores_actionPerformed(e);
            }
        });
        this.extractScores.setVisible(true);
        this.showProducts.setText("Get Cross References");
        this.featureSettings.setText("Feature Settings...");
        this.featureSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.featureSettings_actionPerformed(e);
            }
        });
        this.fetchSequence.setText("Fetch Sequence(s)...");
        this.fetchSequence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.fetchSequence_actionPerformed(e);
            }
        });
        this.annotationColour.setText("By Annotation...");
        this.annotationColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.annotationColour_actionPerformed(e);
            }
        });
        this.associatedData.setText("Load Features / Annotations");
        this.associatedData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.associatedData_actionPerformed(e);
            }
        });
        this.autoCalculate.setText("Autocalculate Consensus");
        this.autoCalculate.setState(Cache.getDefault("AUTO_CALC_CONSENSUS", true));
        this.autoCalculate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.autoCalculate_actionPerformed(e);
            }
        });
        this.addSequenceMenu.setText("Add Sequences");
        this.addFromFile.setText("From File");
        this.addFromFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.addFromFile_actionPerformed(e);
            }
        });
        this.addFromText.setText("From Textbox");
        this.addFromText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.addFromText_actionPerformed(e);
            }
        });
        this.addFromURL.setText("From URL");
        this.addFromURL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.addFromURL_actionPerformed(e);
            }
        });
        this.exportFeatures.setText("Export Features...");
        this.exportFeatures.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.exportFeatures_actionPerformed(e);
            }
        });
        this.exportAnnotations.setText("Export Annotations...");
        this.exportAnnotations.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.exportAnnotations_actionPerformed(e);
            }
        });
        this.statusPanel.setLayout(this.gridLayout1);
        this.jMenu3.setText("Show");
        this.showAllSeqs.setText("All Sequences");
        this.showAllSeqs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showAllSeqs_actionPerformed(e);
            }
        });
        this.showAllColumns.setText("All Columns");
        this.showAllColumns.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showAllColumns_actionPerformed(e);
            }
        });
        this.hideMenu.setText("Hide");
        this.hideSelSequences.setText("Selected Sequences");
        this.hideSelSequences.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.hideSelSequences_actionPerformed(e);
            }
        });
        this.hideSelColumns.setText("Selected Columns");
        this.hideSelColumns.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.hideSelColumns_actionPerformed(e);
            }
        });
        this.hiddenMarkers.setText("Show Hidden Markers");
        this.hiddenMarkers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.hiddenMarkers_actionPerformed(e);
            }
        });
        this.invertColSel.setText("Invert Column Selection");
        this.invertColSel.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8, false));
        this.invertColSel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.invertColSel_actionPerformed(e);
            }
        });
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                int sel = pane.getSelectedIndex();
                GAlignFrame.this.tabSelectionChanged(sel);
            }
        });
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                GAlignFrame.this.tabbedPane_mousePressed(e);
            }
        });
        this.tabbedPane.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                GAlignFrame.this.tabbedPane_focusGained(e);
            }
        });
        this.save.setText("Save");
        this.save.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.save_actionPerformed(e);
            }
        });
        this.reload.setEnabled(false);
        this.reload.setText("Reload");
        this.reload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.reload_actionPerformed(e);
            }
        });
        this.newView.setText("New View");
        this.newView.setAccelerator(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.newView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.newView_actionPerformed(e);
            }
        });
        this.tabbedPane.setToolTipText("<html><i> Right-click to rename tab<br> Press X to eXpand tabs, G to reGroup.</i></html>");
        this.textColour.setText("Colour Text ...");
        this.textColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.textColour_actionPerformed(e);
            }
        });
        this.formatMenu.setText("Format");
        this.selectMenu.setText("Select");
        this.idRightAlign.setText("Right Align Sequence Id");
        this.idRightAlign.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.idRightAlign_actionPerformed(e);
            }
        });
        this.gatherViews.setEnabled(false);
        this.gatherViews.setText("Gather Views");
        this.gatherViews.setAccelerator(KeyStroke.getKeyStroke(71, 0, false));
        this.gatherViews.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.gatherViews_actionPerformed(e);
            }
        });
        this.expandViews.setEnabled(false);
        this.expandViews.setText("Expand Views");
        this.expandViews.setAccelerator(KeyStroke.getKeyStroke(88, 0, false));
        this.expandViews.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.expandViews_actionPerformed(e);
            }
        });
        this.pageSetup.setText("Page Setup ...");
        this.pageSetup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.pageSetup_actionPerformed(e);
            }
        });
        this.alignmentProperties.setText("Alignment Properties...");
        this.alignmentProperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GAlignFrame.this.alignmentProperties();
            }
        });
        this.alignFrameMenuBar.add(this.fileMenu);
        this.alignFrameMenuBar.add(this.editMenu);
        this.alignFrameMenuBar.add(this.selectMenu);
        this.alignFrameMenuBar.add(this.viewMenu);
        this.alignFrameMenuBar.add(this.formatMenu);
        this.alignFrameMenuBar.add(this.colourMenu);
        this.alignFrameMenuBar.add(this.calculateMenu);
        this.alignFrameMenuBar.add(this.webService);
        this.fileMenu.add(this.fetchSequence);
        this.fileMenu.add(this.addSequenceMenu);
        this.fileMenu.add(this.reload);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.vamsasStore);
        this.fileMenu.add(this.save);
        this.fileMenu.add(this.saveAs);
        this.fileMenu.add(this.outputTextboxMenu);
        this.fileMenu.add(this.pageSetup);
        this.fileMenu.add(this.printMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.jMenu2);
        this.fileMenu.add(this.exportFeatures);
        this.fileMenu.add(this.exportAnnotations);
        this.fileMenu.add(this.LoadtreeMenuItem);
        this.fileMenu.add(this.associatedData);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.closeMenuItem);
        this.editMenu.add(this.undoMenuItem);
        this.editMenu.add(this.redoMenuItem);
        this.editMenu.add(this.cut);
        this.editMenu.add(this.copy);
        this.editMenu.add(this.pasteMenu);
        this.editMenu.add(this.delete);
        this.editMenu.addSeparator();
        this.editMenu.add(this.remove2LeftMenuItem);
        this.editMenu.add(this.remove2RightMenuItem);
        this.editMenu.add(this.removeGappedColumnMenuItem);
        this.editMenu.add(this.removeAllGapsMenuItem);
        this.editMenu.add(this.removeRedundancyMenuItem);
        this.editMenu.addSeparator();
        this.editMenu.add(this.padGapsMenuitem);
        this.viewMenu.add(this.newView);
        this.viewMenu.add(this.expandViews);
        this.viewMenu.add(this.gatherViews);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.jMenu3);
        this.viewMenu.add(this.hideMenu);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.annotationPanelMenuItem);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.showSeqFeatures);
        this.viewMenu.add(this.featureSettings);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.alignmentProperties);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.overviewMenuItem);
        this.colourMenu.add(this.applyToAllGroups);
        this.colourMenu.add(this.textColour);
        this.colourMenu.addSeparator();
        this.colourMenu.add(this.noColourmenuItem);
        this.colourMenu.add(this.clustalColour);
        this.colourMenu.add(this.BLOSUM62Colour);
        this.colourMenu.add(this.PIDColour);
        this.colourMenu.add(this.zappoColour);
        this.colourMenu.add(this.taylorColour);
        this.colourMenu.add(this.hydrophobicityColour);
        this.colourMenu.add(this.helixColour);
        this.colourMenu.add(this.strandColour);
        this.colourMenu.add(this.turnColour);
        this.colourMenu.add(this.buriedColour);
        this.colourMenu.add(this.nucleotideColour);
        this.colourMenu.add(this.userDefinedColour);
        this.colourMenu.addSeparator();
        this.colourMenu.add(this.conservationMenuItem);
        this.colourMenu.add(this.modifyConservation);
        this.colourMenu.add(this.abovePIDThreshold);
        this.colourMenu.add(this.modifyPID);
        this.colourMenu.add(this.annotationColour);
        this.calculateMenu.add(this.sort);
        this.calculateMenu.add(this.calculate);
        this.calculateMenu.addSeparator();
        this.calculateMenu.add(this.pairwiseAlignmentMenuItem);
        this.calculateMenu.add(this.PCAMenuItem);
        this.calculateMenu.addSeparator();
        this.calculateMenu.add(this.showTranslation);
        this.calculateMenu.add(this.showProducts);
        this.calculateMenu.add(this.autoCalculate);
        this.calculateMenu.addSeparator();
        this.calculateMenu.add(this.extractScores);
        this.webServiceNoServices = new JMenuItem("<No Services>");
        this.webService.add(this.webServiceNoServices);
        this.pasteMenu.add(this.pasteNew);
        this.pasteMenu.add(this.pasteThis);
        this.sort.add(this.sortIDMenuItem);
        this.sort.add(this.sortGroupMenuItem);
        this.sort.add(this.sortPairwiseMenuItem);
        this.sort.add(this.sortByTreeMenu);
        this.calculate.add(this.averageDistanceTreeMenuItem);
        this.calculate.add(this.neighbourTreeMenuItem);
        this.calculate.add(this.avDistanceTreeBlosumMenuItem);
        this.calculate.add(this.njTreeBlosumMenuItem);
        this.jMenu2.add(this.htmlMenuItem);
        this.jMenu2.add(this.epsFile);
        this.jMenu2.add(this.createPNG);
        this.addSequenceMenu.add(this.addFromFile);
        this.addSequenceMenu.add(this.addFromText);
        this.addSequenceMenu.add(this.addFromURL);
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.statusPanel.add((Component)this.statusBar, null);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.jMenu3.add(this.showAllColumns);
        this.jMenu3.add(this.showAllSeqs);
        this.hideMenu.add(this.hideSelColumns);
        this.hideMenu.add(this.hideSelSequences);
        this.formatMenu.add(this.font);
        this.formatMenu.addSeparator();
        this.formatMenu.add(this.wrapMenuItem);
        this.formatMenu.add(this.scaleAbove);
        this.formatMenu.add(this.scaleLeft);
        this.formatMenu.add(this.scaleRight);
        this.formatMenu.add(this.seqLimits);
        this.formatMenu.add(this.idRightAlign);
        this.formatMenu.add(this.hiddenMarkers);
        this.formatMenu.add(this.viewBoxesMenuItem);
        this.formatMenu.add(this.viewTextMenuItem);
        this.formatMenu.add(this.colourTextMenuItem);
        this.formatMenu.add(this.renderGapsMenuItem);
        this.formatMenu.add(this.centreColumnLabelsMenuItem);
        this.selectMenu.add(this.findMenuItem);
        this.selectMenu.addSeparator();
        this.selectMenu.add(this.selectAllSequenceMenuItem);
        this.selectMenu.add(this.deselectAllSequenceMenuItem);
        this.selectMenu.add(this.invertSequenceMenuItem);
        this.selectMenu.add(this.invertColSel);
        this.selectMenu.add(this.deleteGroups);
    }

    protected void centreColumnLabels_actionPerformed(ActionEvent e) {
    }

    protected void showProducts_actionPerformed(ActionEvent e) {
    }

    protected void buildSortByAnnotationScoresMenu() {
    }

    protected void extractScores_actionPerformed(ActionEvent e) {
    }

    protected void outputText_actionPerformed(ActionEvent e) {
    }

    public void addFromFile_actionPerformed(ActionEvent e) {
    }

    public void addFromText_actionPerformed(ActionEvent e) {
    }

    public void addFromURL_actionPerformed(ActionEvent e) {
    }

    public void exportFeatures_actionPerformed(ActionEvent e) {
    }

    public void exportAnnotations_actionPerformed(ActionEvent e) {
    }

    protected void htmlMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void closeMenuItem_actionPerformed(boolean b) {
    }

    protected void redoMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void undoMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void selectAllSequenceMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void deselectAllSequenceMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void invertSequenceMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void remove2LeftMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void remove2RightMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void removeGappedColumnMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void removeAllGapsMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void wrapMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void viewBoxesMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void viewTextMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void colourTextMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void annotationPanelMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void overviewMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void sortPairwiseMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void sortIDMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void sortGroupMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void removeRedundancyMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void pairwiseAlignmentMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void PCAMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void averageDistanceTreeMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void neighbourTreeMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void njTreeBlosumMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void avTreeBlosumMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void clustalColour_actionPerformed(ActionEvent e) {
    }

    protected void zappoColour_actionPerformed(ActionEvent e) {
    }

    protected void taylorColour_actionPerformed(ActionEvent e) {
    }

    protected void hydrophobicityColour_actionPerformed(ActionEvent e) {
    }

    protected void helixColour_actionPerformed(ActionEvent e) {
    }

    protected void strandColour_actionPerformed(ActionEvent e) {
    }

    protected void turnColour_actionPerformed(ActionEvent e) {
    }

    protected void buriedColour_actionPerformed(ActionEvent e) {
    }

    protected void userDefinedColour_actionPerformed(ActionEvent e) {
    }

    protected void PIDColour_actionPerformed(ActionEvent e) {
    }

    protected void BLOSUM62Colour_actionPerformed(ActionEvent e) {
    }

    protected void noColourmenuItem_actionPerformed(ActionEvent e) {
    }

    protected void conservationMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void printMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void renderGapsMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void findMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void abovePIDThreshold_actionPerformed(ActionEvent e) {
    }

    public void showSeqFeatures_actionPerformed(ActionEvent actionEvent) {
    }

    protected void nucleotideColour_actionPerformed(ActionEvent e) {
    }

    protected void deleteGroups_actionPerformed(ActionEvent e) {
    }

    protected void copy_actionPerformed(ActionEvent e) {
    }

    protected void cut_actionPerformed(ActionEvent e) {
    }

    protected void delete_actionPerformed(ActionEvent e) {
    }

    protected void pasteNew_actionPerformed(ActionEvent e) {
    }

    protected void pasteThis_actionPerformed(ActionEvent e) {
    }

    protected void applyToAllGroups_actionPerformed(ActionEvent e) {
    }

    public void createPNG(File f) {
    }

    protected void font_actionPerformed(ActionEvent e) {
    }

    protected void seqLimit_actionPerformed(ActionEvent e) {
    }

    public void seqDBRef_actionPerformed(ActionEvent e) {
    }

    public void createEPS(File f) {
    }

    protected void LoadtreeMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void jpred_actionPerformed(ActionEvent e) {
    }

    protected void scaleAbove_actionPerformed(ActionEvent e) {
    }

    protected void scaleLeft_actionPerformed(ActionEvent e) {
    }

    protected void scaleRight_actionPerformed(ActionEvent e) {
    }

    protected void modifyPID_actionPerformed(ActionEvent e) {
    }

    protected void modifyConservation_actionPerformed(ActionEvent e) {
    }

    protected void saveAs_actionPerformed(ActionEvent e) {
    }

    protected void padGapsMenuitem_actionPerformed(ActionEvent e) {
    }

    public void vamsasStore_actionPerformed(ActionEvent e) {
    }

    public void vamsasLoad_actionPerformed(ActionEvent e) {
    }

    public void showTranslation_actionPerformed(ActionEvent e) {
    }

    public void featureSettings_actionPerformed(ActionEvent e) {
    }

    public void fetchSequence_actionPerformed(ActionEvent e) {
    }

    public void smoothFont_actionPerformed(ActionEvent e) {
    }

    public void annotationColour_actionPerformed(ActionEvent e) {
    }

    public void associatedData_actionPerformed(ActionEvent e) {
    }

    public void autoCalculate_actionPerformed(ActionEvent e) {
    }

    public void showAllSeqs_actionPerformed(ActionEvent e) {
    }

    public void showAllColumns_actionPerformed(ActionEvent e) {
    }

    public void hideSelSequences_actionPerformed(ActionEvent e) {
    }

    public void hideSelColumns_actionPerformed(ActionEvent e) {
    }

    public void hiddenMarkers_actionPerformed(ActionEvent e) {
    }

    public void findPdbId_actionPerformed(ActionEvent e) {
    }

    public void enterPdbId_actionPerformed(ActionEvent e) {
    }

    public void pdbFile_actionPerformed(ActionEvent e) {
    }

    public void invertColSel_actionPerformed(ActionEvent e) {
    }

    public void tabSelectionChanged(int sel) {
    }

    public void tabbedPane_mousePressed(MouseEvent e) {
    }

    public void tabbedPane_focusGained(FocusEvent e) {
        this.requestFocus();
    }

    public void save_actionPerformed(ActionEvent e) {
    }

    public void reload_actionPerformed(ActionEvent e) {
    }

    public void newView_actionPerformed(ActionEvent e) {
    }

    public void textColour_actionPerformed(ActionEvent e) {
    }

    public void idRightAlign_actionPerformed(ActionEvent e) {
    }

    public void expandViews_actionPerformed(ActionEvent e) {
    }

    public void gatherViews_actionPerformed(ActionEvent e) {
    }

    public void buildTreeMenu() {
    }

    public void pageSetup_actionPerformed(ActionEvent e) {
    }

    public void alignmentProperties() {
    }
}

