/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.bin.Cache;
import jalview.gui.EPSOptions;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;
import org.jibble.epsgraphics.EpsGraphics2D;

public class ImageMaker {
    public static final int EPS = 0;
    public static final int PNG = 1;
    int type = -1;
    EpsGraphics2D pg;
    Graphics graphics;
    FileOutputStream out;
    BufferedImage bi;

    public ImageMaker(Component parent, int type, String title, int width, int height, File file, String EPStitle) {
        this.type = type;
        if (file == null) {
            JalviewFileChooser chooser = type == 0 ? this.getEPSChooser() : this.getPNGChooser();
            chooser.setFileView(new JalviewFileView());
            chooser.setDialogTitle(title);
            chooser.setToolTipText("Save");
            int value = chooser.showSaveDialog(parent);
            if (value == 0) {
                Cache.setProperty("LAST_DIRECTORY", chooser.getSelectedFile().getParent());
                file = chooser.getSelectedFile();
            }
        }
        if (file != null) {
            try {
                this.out = new FileOutputStream(file);
                if (type == 0) {
                    this.setupEPS(width, height, EPStitle);
                } else {
                    this.setupPNG(width, height);
                }
            }
            catch (Exception ex) {
                System.out.println("Error creating " + (type == 0 ? "EPS" : "PNG") + " file.");
            }
        }
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    void setupPNG(int width, int height) {
        this.bi = new BufferedImage(width, height, 1);
        this.graphics = this.bi.getGraphics();
        Graphics2D ig2 = (Graphics2D)this.graphics;
        ig2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public void writeImage() {
        try {
            switch (this.type) {
                case 0: {
                    this.pg.flush();
                    this.pg.close();
                    break;
                }
                case 1: {
                    ImageIO.write((RenderedImage)this.bi, "png", this.out);
                    this.out.close();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void setupEPS(int width, int height, String title) {
        EPSOptions eps;
        boolean accurateText = true;
        String renderStyle = Cache.getDefault("EPS_RENDERING", "Prompt each time");
        if (!(!renderStyle.equalsIgnoreCase("Prompt each time") || System.getProperty("java.awt.headless") != null && System.getProperty("java.awt.headless").equals("true") || (renderStyle = (eps = new EPSOptions()).getValue()) != null && !eps.cancelled)) {
            return;
        }
        if (renderStyle.equalsIgnoreCase("text")) {
            accurateText = false;
        }
        try {
            EpsGraphics2D ig2 = this.pg = new EpsGraphics2D(title, this.out, 0, 0, width, height);
            ((Graphics2D)ig2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.pg.setAccurateTextMode(accurateText);
            this.graphics = this.pg;
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    JalviewFileChooser getPNGChooser() {
        return new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"), new String[]{"png"}, new String[]{"Portable network graphics"}, "Portable network graphics");
    }

    JalviewFileChooser getEPSChooser() {
        return new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"), new String[]{"eps"}, new String[]{"Encapsulated Postscript"}, "Encapsulated Postscript");
    }
}

