/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws;

import jalview.bin.Cache;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.DasSourceBrowser;
import jalview.gui.Desktop;
import jalview.gui.FeatureSettings;
import jalview.util.DBRefUtils;
import jalview.ws.DBRefFetcher;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.biojava.dasobert.das.FeatureThread;
import org.biojava.dasobert.das2.Das2Source;
import org.biojava.dasobert.das2.DasSourceConverter;
import org.biojava.dasobert.das2.io.DasSourceReaderImpl;
import org.biojava.dasobert.dasregistry.Das1Source;
import org.biojava.dasobert.dasregistry.DasCoordinateSystem;
import org.biojava.dasobert.dasregistry.DasSource;
import org.biojava.dasobert.eventmodel.FeatureEvent;
import org.biojava.dasobert.eventmodel.FeatureListener;

public class DasSequenceFeatureFetcher {
    SequenceI[] sequences;
    AlignFrame af;
    FeatureSettings fsettings;
    StringBuffer sbuffer = new StringBuffer();
    Vector selectedSources;
    boolean cancelled = false;
    long startTime;
    int sourcesRemaining = 0;

    private void debug(String mesg) {
        this.debug(mesg, null);
    }

    private void debug(String mesg, Exception e) {
        if (Cache.log != null) {
            Cache.log.debug((Object)mesg, (Throwable)e);
        } else {
            System.err.println(mesg);
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    public DasSequenceFeatureFetcher(SequenceI[] sequences, FeatureSettings fsettings, Vector selectedSources) {
        this(sequences, fsettings, selectedSources, true, true);
    }

    public DasSequenceFeatureFetcher(SequenceI[] sequences, FeatureSettings fsettings, Vector selectedSources, boolean checkDbrefs, boolean promptFetchDbrefs) {
        this.selectedSources = selectedSources;
        this.sequences = sequences;
        if (fsettings != null) {
            this.fsettings = fsettings;
            this.af = fsettings.af;
            this.af.getViewport().setShowSequenceFeatures(true);
        }
        int uniprotCount = 0;
        block0: for (int i = 0; i < selectedSources.size(); ++i) {
            DasSource source = (DasSource)selectedSources.elementAt(i);
            DasCoordinateSystem[] coords = source.getCoordinateSystem();
            for (int c = 0; c < coords.length; ++c) {
                if (coords[c].getName().indexOf("UniProt") <= -1) continue;
                ++uniprotCount;
                continue block0;
            }
        }
        int refCount = 0;
        block2: for (int i = 0; i < sequences.length; ++i) {
            DBRefEntry[] dbref = sequences[i].getDBRef();
            if (dbref == null) continue;
            for (int j = 0; j < dbref.length; ++j) {
                if (!dbref[j].getSource().equals(DBRefSource.UNIPROT)) continue;
                ++refCount;
                continue block2;
            }
        }
        if (checkDbrefs && refCount < sequences.length && uniprotCount > 0) {
            int reply = 0;
            if (promptFetchDbrefs) {
                reply = JOptionPane.showInternalConfirmDialog(Desktop.desktop, "Do you want Jalview to find\nUniprot Accession ids for given sequence names?", "Find Uniprot Accession Ids", 0, 3);
            }
            if (reply == 0) {
                Thread thread = new Thread(new FetchDBRefs());
                thread.start();
            } else {
                this.startFetching();
            }
        } else {
            this.startFetching();
        }
    }

    void startFetching() {
        this.cancelled = false;
        this.startTime = System.currentTimeMillis();
        if (this.af != null) {
            this.af.setProgressBar("Fetching DAS Sequence Features", this.startTime);
        }
        DasSource[] sources = new DasSourceBrowser().getDASSource();
        if (this.selectedSources == null || this.selectedSources.size() == 0) {
            String active = Cache.getDefault("DAS_ACTIVE_SOURCE", "uniprot");
            StringTokenizer st = new StringTokenizer(active, "\t");
            Vector<DasSource> selectedSources = new Vector<DasSource>();
            block0: while (st.hasMoreTokens()) {
                String token = st.nextToken();
                for (int i = 0; i < sources.length; ++i) {
                    if (!sources[i].getNickname().equals(token)) continue;
                    selectedSources.addElement(sources[i]);
                    continue block0;
                }
            }
        }
        if (this.selectedSources == null || this.selectedSources.size() == 0) {
            System.out.println("No DAS Sources active");
            this.cancelled = true;
            this.setGuiNoDassourceActive();
            return;
        }
        this.sourcesRemaining = this.selectedSources.size();
        for (int sourceIndex = 0; sourceIndex < this.selectedSources.size() && !this.cancelled; ++sourceIndex) {
            DasSource dasSource = (DasSource)this.selectedSources.elementAt(sourceIndex);
            this.nextSequence(dasSource, this.sequences[0]);
        }
    }

    private void setGuiNoDassourceActive() {
        if (this.af != null) {
            this.af.setProgressBar("No DAS Sources Active", this.startTime);
        }
        if (this.getFeatSettings() != null) {
            this.fsettings.noDasSourceActive();
        }
    }

    private FeatureSettings getFeatSettings() {
        if (this.fsettings == null && this.af != null) {
            this.fsettings = this.af.featureSettings;
        }
        return this.fsettings;
    }

    public void cancel() {
        if (this.af != null) {
            this.af.setProgressBar("DAS Feature Fetching Cancelled", this.startTime);
        }
        this.cancelled = true;
    }

    void responseComplete(DasSource dasSource, SequenceI seq) {
        if (seq != null) {
            for (int seqIndex = 0; seqIndex < this.sequences.length - 1 && !this.cancelled; ++seqIndex) {
                if (this.sequences[seqIndex] != seq) continue;
                this.nextSequence(dasSource, this.sequences[++seqIndex]);
                return;
            }
        }
        --this.sourcesRemaining;
        if (this.sourcesRemaining == 0) {
            System.err.println("Fetching Complete.");
            this.setGuiFetchComplete();
        }
    }

    private void setGuiFetchComplete() {
        if (this.af != null) {
            this.af.setProgressBar("DAS Feature Fetching Complete", this.startTime);
        }
        if (this.af != null && this.af.featureSettings != null) {
            this.af.featureSettings.setTableData();
        }
        if (this.getFeatSettings() != null) {
            this.fsettings.complete();
        }
    }

    void featuresAdded(SequenceI seq) {
        if (this.af == null) {
            return;
        }
        this.af.getFeatureRenderer().featuresAdded();
        int start = this.af.getViewport().getStartSeq();
        int end = this.af.getViewport().getEndSeq();
        for (int index = start; index < end; ++index) {
            if (seq != this.af.getViewport().getAlignment().getSequenceAt(index).getDatasetSequence()) continue;
            this.af.alignPanel.paintAlignment(true);
            break;
        }
    }

    void nextSequence(DasSource dasSource, SequenceI seq) {
        if (this.cancelled) {
            return;
        }
        DBRefEntry[] uprefs = DBRefUtils.selectRefs(seq.getDBRef(), new String[]{DBRefSource.UNIPROT});
        boolean dasCoordSysFound = false;
        if (uprefs != null) {
            for (int j = 0; !dasCoordSysFound && j < uprefs.length; ++j) {
                DasCoordinateSystem[] cs = dasSource.getCoordinateSystem();
                for (int csIndex = 0; csIndex < cs.length && !dasCoordSysFound; ++csIndex) {
                    if (cs.length > 0 && DBRefUtils.isDasCoordinateSystem(cs[csIndex].getName(), uprefs[j])) {
                        this.debug("Launched fetcher for coordinate system " + cs[0].getName());
                        System.out.println(seq.getName() + " " + (seq.getDatasetSequence() == null) + " " + dasSource.getUrl());
                        dasCoordSysFound = true;
                        this.createFeatureFetcher(seq, dasSource, uprefs[j]);
                        continue;
                    }
                    System.out.println("IGNORE " + cs[csIndex].getName());
                }
            }
        }
        if (!dasCoordSysFound) {
            String id = null;
            if (seq.getName().indexOf("|") > -1) {
                id = seq.getName().substring(seq.getName().lastIndexOf("|") + 1);
                if (id.trim().length() < 4 && (id = seq.getName().substring(0, seq.getName().lastIndexOf("|"))).indexOf("|") > -1) {
                    id = id.substring(id.lastIndexOf("|") + 1);
                }
            } else {
                id = seq.getName();
            }
            if (id != null) {
                this.createFeatureFetcher(seq, dasSource, id);
            }
        }
    }

    protected void createFeatureFetcher(final SequenceI seq, final DasSource dasSource, final DBRefEntry dbref) {
        final Das1Source source = new Das1Source();
        source.setUrl(dasSource.getUrl());
        source.setNickname(dasSource.getNickname());
        if (dbref == null || dbref.getAccessionId() == null || dbref.getAccessionId().length() < 1) {
            this.responseComplete(dasSource, seq);
            return;
        }
        this.debug("new Das Feature Fetcher for " + dbref.getSource() + ":" + dbref.getAccessionId() + " querying " + dasSource.getUrl());
        FeatureThread fetcher = new FeatureThread(dbref.getAccessionId(), source);
        fetcher.addFeatureListener(new FeatureListener(){

            public void comeBackLater(FeatureEvent e) {
                DasSequenceFeatureFetcher.this.responseComplete(dasSource, seq);
                DasSequenceFeatureFetcher.this.debug("das source " + e.getSource().getNickname() + " asked us to come back in " + e.getComeBackLater() + " secs.");
            }

            public void newFeatures(FeatureEvent e) {
                Das1Source ds = e.getSource();
                Map[] features = e.getFeatures();
                DasSequenceFeatureFetcher.this.debug("das source " + ds.getUrl() + " returned " + features.length + " features");
                if (features.length > 0) {
                    for (int i = 0; i < features.length; ++i) {
                        SequenceFeature f = DasSequenceFeatureFetcher.this.newSequenceFeature(features[i], source.getNickname());
                        if (dbref.getMap() != null && f.getBegin() > 0 && f.getEnd() > 0) {
                            DasSequenceFeatureFetcher.this.debug("mapping from " + f.getBegin() + " - " + f.getEnd());
                            SequenceFeature[] vf = null;
                            try {
                                vf = dbref.getMap().locateFeature(f);
                            }
                            catch (Exception ex) {
                                Cache.log.info((Object)"Error in 'experimental' mapping of features. Please try to reproduce and then report info to help@jalview.org.");
                                Cache.log.info((Object)("Mapping feature from " + f.getBegin() + " to " + f.getEnd() + " in dbref " + dbref.getAccessionId() + " in " + dbref.getSource()));
                                Cache.log.info((Object)("using das Source " + ds.getUrl()));
                                Cache.log.info((Object)"Exception", (Throwable)ex);
                            }
                            if (vf == null) continue;
                            for (int v = 0; v < vf.length; ++v) {
                                DasSequenceFeatureFetcher.this.debug("mapping to " + v + ": " + vf[v].getBegin() + " - " + vf[v].getEnd());
                                seq.addSequenceFeature(vf[v]);
                            }
                            continue;
                        }
                        seq.addSequenceFeature(f);
                    }
                    DasSequenceFeatureFetcher.this.featuresAdded(seq);
                }
                DasSequenceFeatureFetcher.this.responseComplete(dasSource, seq);
            }
        });
        fetcher.start();
    }

    protected void createFeatureFetcher(final SequenceI seq, final DasSource dasSource, String id) {
        final Das1Source source = new Das1Source();
        source.setUrl(dasSource.getUrl());
        source.setNickname(dasSource.getNickname());
        if (id != null) {
            id = id.trim();
        }
        if (id != null && id.length() > 0) {
            this.debug("new Das Feature Fetcher for " + id + " querying " + dasSource.getUrl());
            FeatureThread fetcher = new FeatureThread(id, source);
            fetcher.addFeatureListener(new FeatureListener(){

                public void comeBackLater(FeatureEvent e) {
                    DasSequenceFeatureFetcher.this.responseComplete(dasSource, seq);
                    DasSequenceFeatureFetcher.this.debug("das source " + e.getSource().getNickname() + " asked us to come back in " + e.getComeBackLater() + " secs.");
                }

                public void newFeatures(FeatureEvent e) {
                    Das1Source ds = e.getSource();
                    Map[] features = e.getFeatures();
                    DasSequenceFeatureFetcher.this.debug("das source " + ds.getUrl() + " returned " + features.length + " features");
                    if (features.length > 0) {
                        for (int i = 0; i < features.length; ++i) {
                            SequenceFeature f = DasSequenceFeatureFetcher.this.newSequenceFeature(features[i], source.getNickname());
                            seq.addSequenceFeature(f);
                        }
                        DasSequenceFeatureFetcher.this.featuresAdded(seq);
                    }
                    DasSequenceFeatureFetcher.this.responseComplete(dasSource, seq);
                }
            });
            fetcher.start();
        } else {
            this.debug("Skipping empty ID for querying " + dasSource.getUrl());
            this.responseComplete(dasSource, seq);
        }
    }

    SequenceFeature newSequenceFeature(Map dasfeature, String nickname) {
        if (dasfeature == null) {
            return null;
        }
        try {
            String desc = new String();
            if (dasfeature.containsKey("NOTE")) {
                desc = desc + (String)dasfeature.get("NOTE");
            }
            int start = 0;
            int end = 0;
            float score = 0.0f;
            try {
                start = Integer.parseInt(dasfeature.get("START").toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                end = Integer.parseInt(dasfeature.get("END").toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                score = Integer.parseInt(dasfeature.get("SCORE").toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
            SequenceFeature f = new SequenceFeature((String)dasfeature.get("TYPE"), desc, start, end, score, nickname);
            if (dasfeature.containsKey("LINK")) {
                f.addLink(f.getType() + " " + f.begin + "_" + f.end + "|" + dasfeature.get("LINK"));
            }
            return f;
        }
        catch (Exception e) {
            System.out.println("ERRR " + e);
            e.printStackTrace();
            System.out.println("############");
            this.debug("Failed to parse " + dasfeature.toString(), e);
            return null;
        }
    }

    public static DasSource[] getDASSources() {
        String registryURL = Cache.getDefault("DAS_REGISTRY_URL", DasSourceBrowser.DEFAULT_REGISTRY);
        return DasSequenceFeatureFetcher.getDASSources(registryURL);
    }

    public static DasSource[] getDASSources(String registryURL) {
        DasSourceReaderImpl reader = new DasSourceReaderImpl();
        try {
            URL url = new URL(registryURL);
            DasSource[] sources = reader.readDasSource(url);
            ArrayList<Das1Source> das1sources = new ArrayList<Das1Source>();
            for (int i = 0; i < sources.length; ++i) {
                DasSource ds = sources[i];
                if (ds instanceof Das2Source) {
                    Das2Source d2s = (Das2Source)ds;
                    if (!d2s.hasDas1Capabilities()) continue;
                    Das1Source d1s = DasSourceConverter.toDas1Source(d2s);
                    das1sources.add(d1s);
                    continue;
                }
                if (!(ds instanceof Das1Source)) continue;
                das1sources.add((Das1Source)ds);
            }
            return das1sources.toArray(new Das1Source[das1sources.size()]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    class FetchDBRefs
    implements Runnable {
        FetchDBRefs() {
        }

        public void run() {
            new DBRefFetcher(DasSequenceFeatureFetcher.this.sequences, DasSequenceFeatureFetcher.this.af).fetchDBRefs(true);
            DasSequenceFeatureFetcher.this.startFetching();
        }
    }
}

