/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws;

import ext.vamsas.IRegistry;
import ext.vamsas.IRegistryServiceLocator;
import ext.vamsas.RegistryServiceSoapBindingStub;
import ext.vamsas.ServiceHandle;
import ext.vamsas.ServiceHandles;
import jalview.bin.Cache;
import jalview.gui.Desktop;
import jalview.ws.JPredClient;
import jalview.ws.MsaWSClient;
import jalview.ws.SeqSearchWSClient;
import jalview.ws.WSClient;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.axis.AxisFault;

public class Discoverer
extends Thread
implements Runnable {
    IRegistry registry;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private static URL RootServiceURL = null;
    public static Vector ServiceURLList = null;
    private static boolean reallyDiscoverServices = true;
    public static Hashtable services = null;
    public static Vector serviceList = null;
    private static Hashtable serviceClientBindings;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void firePropertyChange(String prop, Object oldvalue, Object newvalue) {
        this.changeSupport.firePropertyChange(prop, oldvalue, newvalue);
    }

    private IRegistry locateWebService(URL WsURL) {
        IRegistryServiceLocator loc = new IRegistryServiceLocator();
        IRegistry server = null;
        try {
            server = loc.getRegistryService(WsURL);
            ((RegistryServiceSoapBindingStub)server).setTimeout(60000);
        }
        catch (Exception ex) {
            Cache.log.error((Object)("Serious!  Service location failed\nfor URL :" + WsURL + "\n"), (Throwable)ex);
            return null;
        }
        loc.getEngine().setOption("axis", (Object)"1");
        return server;
    }

    private static Vector getDiscoveryURLS() {
        Vector<URL> urls = new Vector<URL>();
        String RootServiceURLs = Cache.getDefault("DISCOVERY_URLS", "http://www.compbio.dundee.ac.uk/JalviewWS/services/ServiceRegistry");
        try {
            StringTokenizer st = new StringTokenizer(RootServiceURLs, ",");
            while (st.hasMoreElements()) {
                String url = null;
                try {
                    url = st.nextToken();
                    URL u = new URL(url);
                    if (!urls.contains(u)) {
                        urls.add(u);
                        continue;
                    }
                    Cache.log.info((Object)"Ignoring duplicate url in DISCOVERY_URLS list");
                }
                catch (Exception ex) {
                    Cache.log.warn((Object)("Problem whilst trying to make a URL from '" + (url != null ? url : "<null>") + "'"));
                    Cache.log.warn((Object)"This was probably due to a malformed comma separated list in the DISCOVERY_URLS entry of $(HOME)/.jalview_properties)");
                    Cache.log.debug((Object)"Exception was ", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            Cache.log.warn((Object)"Error parsing comma separated list of urls in DISCOVERY_URLS.", (Throwable)ex);
        }
        if (urls.size() > 0) {
            return urls;
        }
        return null;
    }

    public static void doDiscovery() {
        Cache.log.debug((Object)"(Re)-Initialising the discovery URL list.");
        try {
            reallyDiscoverServices = Cache.getDefault("DISCOVERY_START", false);
            if (reallyDiscoverServices) {
                ServiceURLList = Discoverer.getDiscoveryURLS();
            } else {
                Cache.log.debug((Object)"Setting default services");
                services = new Hashtable();
                ServiceHandle[] defServices = new ServiceHandle[]{new ServiceHandle("MsaWS", "Edgar, Robert C. (2004), MUSCLE: multiple sequence alignment with high accuracy and high throughput, Nucleic Acids Research 32(5), 1792-97.", "http://www.compbio.dundee.ac.uk/JalviewWS/services/MuscleWS", "Muscle Multiple Protein Sequence Alignment"), new ServiceHandle("MsaWS", "Katoh, K., K. Kuma, K., Toh, H.,  and Miyata, T. (2005) \"MAFFT version 5: improvement in accuracy of multiple sequence alignment.\" Nucleic Acids Research, 33 511-518", "http://www.compbio.dundee.ac.uk/JalviewWS/services/MafftWS", "MAFFT Multiple Sequence Alignment"), new ServiceHandle("MsaWS", "Thompson, J.D., Higgins, D.G. and Gibson, T.J. (1994) CLUSTAL W: improving the sensitivity of progressive multiple sequence alignment through sequence weighting, position specific gap penalties and weight matrix choice. Nucleic Acids Research, 22 4673-4680", "http://www.compbio.dundee.ac.uk/JalviewWS/services/ClustalWS", "ClustalW Multiple Sequence Alignment"), new ServiceHandle("SecStrPred", "Cole C., Barber J. D., Barton G.J (2008) The Jpred 3 secondary structure prediction server Nucleic Acids Research, 36 W197-W201", "http://www.compbio.dundee.ac.uk/JalviewWS/services/jpred", "JNet Secondary Structure Prediction")};
                services = new Hashtable();
                serviceList = new Vector();
                Discoverer.buildServiceLists(defServices, serviceList, services);
            }
        }
        catch (Exception e) {
            System.err.println("jalview.rootRegistry is not a proper url!\nWas set to " + RootServiceURL + "\n" + e);
        }
    }

    private ServiceHandle[] getServices(URL location) {
        ServiceHandles shs = null;
        try {
            Cache.log.debug((Object)("Discovering services using " + location));
            shs = this.locateWebService(location).getServices();
        }
        catch (AxisFault f) {
            if (f.getFaultReason().indexOf("(407)") > -1) {
                if (Desktop.desktop != null) {
                    JOptionPane.showMessageDialog(Desktop.desktop, "Please set up your proxy settings in the 'Connections' tab of the Preferences window", "Proxy Authorization Failed", 2);
                }
            } else {
                Cache.log.warn((Object)("No Discovery service at " + location));
                Cache.log.debug((Object)"Axis Fault", (Throwable)f);
            }
        }
        catch (Exception e) {
            Cache.log.warn((Object)("No Discovery service at " + location));
            Cache.log.debug((Object)"Discovery Service General Exception", (Throwable)e);
        }
        if (shs != null && shs.getServices().length > 0) {
            return shs.getServices();
        }
        return null;
    }

    private static boolean buildServiceLists(ServiceHandle[] sh, Vector cat, Hashtable sscat) {
        boolean seenNewDiscovery = false;
        int j = sh.length;
        for (int i = 0; i < j; ++i) {
            if (cat.contains(sh[i])) continue;
            Cache.log.debug((Object)("A " + sh[i].getAbstractName() + " service called " + sh[i].getName() + " exists at " + sh[i].getEndpointURL() + "\n"));
            if (!sscat.containsKey(sh[i].getAbstractName())) {
                cat = new Vector<ServiceHandle>();
                sscat.put(sh[i].getAbstractName(), cat);
            } else {
                cat = (Vector)sscat.get(sh[i].getAbstractName());
            }
            cat.add(sh[i]);
            if (!sh[i].getAbstractName().equals("Registry")) continue;
            int sUrls = ServiceURLList.size();
            for (int s = 0; s < sUrls; ++s) {
                URL disc_serv = null;
                try {
                    disc_serv = new URL(sh[i].getEndpointURL());
                    if (ServiceURLList.contains(disc_serv)) continue;
                    Cache.log.debug((Object)("Adding new discovery service at " + disc_serv));
                    ServiceURLList.add(disc_serv);
                    seenNewDiscovery = true;
                    continue;
                }
                catch (Exception e) {
                    Cache.log.debug((Object)("Ignoring bad discovery service URL " + sh[i].getEndpointURL()), (Throwable)e);
                }
            }
        }
        return seenNewDiscovery;
    }

    public void discoverServices() {
        Hashtable sscat = new Hashtable();
        Vector cat = new Vector();
        ServiceHandle[] sh = null;
        if (ServiceURLList == null) {
            Cache.log.debug((Object)"No service endpoints to use for service discovery.");
            return;
        }
        for (int s_url = 0; s_url < ServiceURLList.size(); ++s_url) {
            sh = this.getServices((URL)ServiceURLList.get(s_url));
            if (sh != null) {
                Discoverer.buildServiceLists(sh, cat, sscat);
                continue;
            }
            Cache.log.warn((Object)("No services at " + (URL)ServiceURLList.get(s_url) + " - check DISCOVERY_URLS property in .jalview_properties"));
        }
        Hashtable oldServices = services;
        services = sscat;
        serviceList = cat;
        this.firePropertyChange("services", oldServices, services);
    }

    public void run() {
        final Discoverer discoverer = this;
        Thread discoverThread = new Thread(){

            public void run() {
                1 v0 = this;
                v0.discoverer.doDiscovery();
                discoverer.discoverServices();
            }
        };
        discoverThread.start();
    }

    public static WSClient getServiceClient(ServiceHandle sh) {
        WSClient instance;
        if (serviceClientBindings == null) {
            serviceClientBindings = new Hashtable();
            serviceClientBindings.put("MsaWS", new MsaWSClient());
            serviceClientBindings.put("SecStrPred", new JPredClient());
            serviceClientBindings.put("SeqSearch", new SeqSearchWSClient());
        }
        if ((instance = (WSClient)serviceClientBindings.get(sh.getAbstractName())) == null) {
            System.err.println("WARNING - POSSIBLE IMPLEMENTATION ERROR - cannot find WSClient implementation for " + sh.getAbstractName());
        } else {
            instance.serviceHandle = sh;
        }
        return instance;
    }
}

