/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws;

import ext.vamsas.Jpred;
import ext.vamsas.JpredServiceLocator;
import ext.vamsas.JpredSoapBindingStub;
import ext.vamsas.ServiceHandle;
import jalview.analysis.AlignSeq;
import jalview.analysis.SeqsetUtils;
import jalview.bin.Cache;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.WebserviceInfo;
import jalview.ws.JPredThread;
import jalview.ws.WSClient;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class JPredClient
extends WSClient {
    public JPredClient(ServiceHandle sh, String title, boolean msa, AlignmentView alview, AlignFrame parentFrame, boolean viewonly) {
        this.wsInfo = this.setWebService(sh);
        this.startJPredClient(title, msa, alview, parentFrame, viewonly);
    }

    private void startJPredClient(String title, boolean msa, AlignmentView alview, AlignFrame parentFrame, boolean viewonly) {
        String altitle;
        int i;
        Jpred server;
        AlignmentView input = alview;
        if (this.wsInfo == null) {
            this.wsInfo = this.setWebService();
        }
        if ((server = this.locateWebService()) == null) {
            Cache.log.warn((Object)"Couldn't find a Jpred webservice to invoke!");
            return;
        }
        SeqCigar[] msf = null;
        SequenceI seq = null;
        int[] delMap = null;
        msf = input.getSequences();
        seq = msf[0].getSeq('-');
        if (viewonly) {
            int[] viscontigs = alview.getVisibleContigs();
            int spos = 0;
            i = 0;
            if (viscontigs != null) {
                delMap = new int[seq.getEnd() - seq.getStart() + 1];
                int[] gapMap = seq.gapMap();
                for (int contig = 0; contig < viscontigs.length; contig += 2) {
                    while (spos < gapMap.length && gapMap[spos] < viscontigs[contig]) {
                        ++spos;
                    }
                    while (spos < gapMap.length && gapMap[spos] <= viscontigs[contig + 1]) {
                        delMap[i++] = spos++;
                    }
                }
                int[] tmap = new int[i];
                System.arraycopy(delMap, 0, tmap, 0, i);
                delMap = tmap;
            }
        }
        if (msa && msf.length > 1) {
            altitle = this.getPredictionName(this.WebServiceName) + " on " + (viewonly ? "visible " : "") + seq.getName() + " using alignment from " + title;
            SequenceI[] aln = new SequenceI[msf.length];
            int j = msf.length;
            for (i = 0; i < j; ++i) {
                aln[i] = msf[i].getSeq('-');
            }
            Hashtable SequenceInfo = SeqsetUtils.uniquify(aln, true);
            if (viewonly) {
                String[] seqs = alview.getSequenceStrings('-');
                int j2 = msf.length;
                for (int i2 = 0; i2 < j2; ++i2) {
                    aln[i2].setSequence(seqs[i2]);
                }
                seq.setSequence(seqs[0]);
            }
            this.wsInfo.setProgressText("Job details for " + (viewonly ? "visible " : "") + "MSA based prediction (" + title + ") on sequence :\n>" + seq.getName() + "\n" + AlignSeq.extractGaps("-. ", seq.getSequenceAsString()) + "\n");
            JPredThread jthread = new JPredThread(this.wsInfo, altitle, server, SequenceInfo, aln, delMap, alview, parentFrame, this.WsURL);
            this.wsInfo.setthisService(jthread);
            jthread.start();
        } else {
            if (!msa && msf.length > 1) {
                throw new Error("Implementation Error! Multiple single sequence prediction jobs are not yet supported.");
            }
            altitle = this.getPredictionName(this.WebServiceName) + " for " + (viewonly ? "visible " : "") + "sequence " + seq.getName() + " from " + title;
            String seqname = seq.getName();
            Hashtable SequenceInfo = SeqsetUtils.SeqCharacterHash(seq);
            if (viewonly) {
                String[] seqs = alview.getSequenceStrings('-');
                seq.setSequence(seqs[0]);
            }
            this.wsInfo.setProgressText("Job details for prediction on " + (viewonly ? "visible " : "") + "sequence :\n>" + seqname + "\n" + AlignSeq.extractGaps("-. ", seq.getSequenceAsString()) + "\n");
            JPredThread jthread = new JPredThread(this.wsInfo, altitle, server, this.WsURL, SequenceInfo, seq, delMap, alview, parentFrame);
            this.wsInfo.setthisService(jthread);
            jthread.start();
        }
    }

    private String getPredictionName(String webServiceName) {
        if (webServiceName.toLowerCase().indexOf("secondary structure prediction") > -1) {
            return webServiceName;
        }
        return webServiceName + "secondary structure prediction";
    }

    public JPredClient(ServiceHandle sh, String title, SequenceI seq, AlignFrame parentFrame) {
        this.wsInfo = this.setWebService(sh);
        this.startJPredClient(title, seq, parentFrame);
    }

    public JPredClient(ServiceHandle sh, String title, SequenceI[] msa, AlignFrame parentFrame) {
        this.wsInfo = this.setWebService(sh);
        this.startJPredClient(title, msa, parentFrame);
    }

    public JPredClient(String title, SequenceI[] msf) {
        this.startJPredClient(title, msf, null);
    }

    public JPredClient(String title, SequenceI seq) {
        this.startJPredClient(title, seq, null);
    }

    public JPredClient() {
    }

    private void startJPredClient(String title, SequenceI[] msf, AlignFrame parentFrame) {
        if (this.wsInfo == null) {
            this.wsInfo = this.setWebService();
        }
        SequenceI seq = msf[0];
        String altitle = "JNet prediction on " + seq.getName() + " using alignment from " + title;
        this.wsInfo.setProgressText("Job details for MSA based prediction (" + title + ") on sequence :\n>" + seq.getName() + "\n" + AlignSeq.extractGaps("-. ", seq.getSequenceAsString()) + "\n");
        SequenceI[] aln = new SequenceI[msf.length];
        int j = msf.length;
        for (int i = 0; i < j; ++i) {
            aln[i] = new Sequence(msf[i]);
        }
        Hashtable SequenceInfo = SeqsetUtils.uniquify(aln, true);
        Jpred server = this.locateWebService();
        if (server == null) {
            return;
        }
        JPredThread jthread = new JPredThread(this.wsInfo, altitle, server, SequenceInfo, aln, null, null, parentFrame, this.WsURL);
        this.wsInfo.setthisService(jthread);
        jthread.start();
    }

    public void startJPredClient(String title, SequenceI seq, AlignFrame parentFrame) {
        if (this.wsInfo == null) {
            this.wsInfo = this.setWebService();
        }
        this.wsInfo.setProgressText("Job details for prediction on sequence :\n>" + seq.getName() + "\n" + AlignSeq.extractGaps("-. ", seq.getSequenceAsString()) + "\n");
        String altitle = "JNet prediction for sequence " + seq.getName() + " from " + title;
        Hashtable SequenceInfo = SeqsetUtils.SeqCharacterHash(seq);
        Jpred server = this.locateWebService();
        if (server == null) {
            return;
        }
        JPredThread jthread = new JPredThread(this.wsInfo, altitle, server, this.WsURL, SequenceInfo, seq, null, null, parentFrame);
        this.wsInfo.setthisService(jthread);
        jthread.start();
    }

    private WebserviceInfo setWebService() {
        this.WebServiceName = "JNetWS";
        this.WebServiceJobTitle = "JNet secondary structure prediction";
        this.WebServiceReference = "\"Cuff J. A and Barton G.J (2000) Application of multiple sequence alignment profiles to improve protein secondary structure prediction, Proteins 40:502-511\".";
        this.WsURL = "http://www.compbio.dundee.ac.uk/JalviewWS/services/jpred";
        WebserviceInfo wsInfo = new WebserviceInfo(this.WebServiceJobTitle, this.WebServiceReference);
        return wsInfo;
    }

    private Jpred locateWebService() {
        JpredServiceLocator loc = new JpredServiceLocator();
        Jpred server = null;
        try {
            server = loc.getjpred(new URL(this.WsURL));
            ((JpredSoapBindingStub)server).setTimeout(60000);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Desktop.desktop, "The Secondary Structure Prediction Service named " + this.WebServiceName + " at " + this.WsURL + " couldn't be located.", "Internal Jalview Error", 2);
            this.wsInfo.setProgressText("Serious! " + this.WebServiceName + " Service location failed\nfor URL :" + this.WsURL + "\n" + ex.getMessage());
            this.wsInfo.setStatus(5);
        }
        return server;
    }

    public void attachWSMenuEntry(JMenu wsmenu, final ServiceHandle sh, final AlignFrame af) {
        JMenuItem method = new JMenuItem(sh.getName());
        method.setToolTipText(sh.getEndpointURL());
        method.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlignmentView msa = af.gatherSeqOrMsaForSecStrPrediction();
                if (msa.getSequences().length == 1) {
                    new JPredClient(sh, af.getTitle(), false, msa, af, true);
                } else if (msa.getSequences().length > 1) {
                    new JPredClient(sh, af.getTitle(), true, msa, af, true);
                }
            }
        });
        wsmenu.add(method);
    }
}

