/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws;

import ext.vamsas.Jpred;
import jalview.analysis.AlignSeq;
import jalview.analysis.SeqsetUtils;
import jalview.bin.Cache;
import jalview.commands.RemoveGapsCommand;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.WebserviceInfo;
import jalview.io.FormatAdapter;
import jalview.io.IdentifyFile;
import jalview.io.JPredFile;
import jalview.io.JnetAnnotationMaker;
import jalview.io.PileUpfile;
import jalview.util.ShiftList;
import jalview.ws.WSClientI;
import jalview.ws.WSThread;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import vamsas.objects.simple.JpredResult;
import vamsas.objects.simple.Msfalignment;
import vamsas.objects.simple.Sequence;

class JPredThread
extends WSThread
implements WSClientI {
    Jpred server;
    String altitle = "";

    JPredThread(WebserviceInfo wsinfo, String altitle, Jpred server, String wsurl, AlignmentView alview, AlignFrame alframe) {
        super(alframe, wsinfo, alview, wsurl);
        this.altitle = altitle;
        this.server = server;
    }

    JPredThread(WebserviceInfo wsinfo, String altitle, Jpred server, String wsurl, Hashtable SequenceInfo, SequenceI seq, int[] delMap, AlignmentView alview, AlignFrame alframe) {
        this(wsinfo, altitle, server, wsurl, alview, alframe);
        JPredJob job = new JPredJob(SequenceInfo, seq, delMap);
        if (job.hasValidInput()) {
            this.OutputHeader = this.wsInfo.getProgressText();
            this.jobs = new WSThread.WSJob[]{job};
            job.jobnum = 0;
        }
    }

    JPredThread(WebserviceInfo wsinfo, String altitle, Jpred server, Hashtable SequenceInfo, SequenceI[] msf, int[] delMap, AlignmentView alview, AlignFrame alframe, String wsurl) {
        this(wsinfo, altitle, server, wsurl, alview, alframe);
        JPredJob job = new JPredJob(SequenceInfo, msf, delMap);
        if (job.hasValidInput()) {
            this.jobs = new WSThread.WSJob[]{job};
            this.OutputHeader = this.wsInfo.getProgressText();
            job.jobnum = 0;
        }
    }

    void StartJob(WSThread.WSJob j) {
        if (!(j instanceof JPredJob)) {
            throw new Error("Implementation error - StartJob(JpredJob) called on " + j.getClass());
        }
        try {
            JPredJob job = (JPredJob)j;
            if (job.msa != null) {
                job.jobId = this.server.predictOnMsa(job.msa);
            } else if (job.sequence != null) {
                job.jobId = this.server.predict(job.sequence);
            }
            if (job.jobId != null) {
                if (job.jobId.startsWith("Broken")) {
                    job.result = new JpredResult();
                    job.result.setInvalid(true);
                    job.result.setStatus("Submission " + job.jobId);
                    throw new Exception(job.jobId);
                }
            } else {
                throw new Exception("Server timed out - try again later\n");
            }
            job.submitted = true;
            job.subjobComplete = false;
            Cache.log.info((Object)(this.WsUrl + " Job Id '" + job.jobId + "'"));
        }
        catch (Exception e) {
            this.wsInfo.setStatus(5);
            if (e.getMessage().indexOf("Exception") > -1) {
                this.wsInfo.setStatus(j.jobnum, 5);
                this.wsInfo.setProgressText(j.jobnum, "Failed to submit the prediction. (Just close the window)\nIt is most likely that there is a problem with the server.\n");
                System.err.println("JPredWS Client: Failed to submit the prediction. Quite possibly because of a server error - see below)\n" + e.getMessage() + "\n");
                Cache.log.warn((Object)"Server Exception", (Throwable)e);
            } else {
                this.wsInfo.setStatus(j.jobnum, 4);
                this.wsInfo.appendProgressText(j.jobnum, "Failed to submit the prediction:\n" + e.getMessage() + this.wsInfo.getProgressText());
                Cache.log.debug((Object)("Failed Submission of job " + j.jobnum), (Throwable)e);
            }
            j.allowedServerExceptions = -1;
            j.subjobComplete = true;
        }
    }

    void parseResult() {
        int results = 0;
        WSThread.JobStateSummary finalState = new WSThread.JobStateSummary(this);
        try {
            for (int j = 0; j < this.jobs.length; ++j) {
                finalState.updateJobPanelState(this.wsInfo, this.OutputHeader, this.jobs[j]);
                if (!this.jobs[j].submitted || !this.jobs[j].subjobComplete || !this.jobs[j].hasResults()) continue;
                ++results;
            }
        }
        catch (Exception ex) {
            Cache.log.error((Object)("Unexpected exception when processing results for " + this.altitle), (Throwable)ex);
            this.wsInfo.setStatus(4);
        }
        if (results > 0) {
            this.wsInfo.showResultsNewFrame.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    JPredThread.this.displayResults(true);
                }
            });
            this.wsInfo.mergeResults.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    JPredThread.this.displayResults(false);
                }
            });
            this.wsInfo.setResultsReady();
        } else {
            this.wsInfo.setFinishedNoResults();
        }
    }

    void displayResults(boolean newWindow) {
        if (this.jobs != null) {
            Object[] res = null;
            boolean msa = false;
            for (int jn = 0; jn < this.jobs.length; ++jn) {
                Object[] jobres = null;
                JPredJob j = (JPredJob)this.jobs[jn];
                if (!j.hasResults()) continue;
                msa = j.msa != null ? true : msa;
                try {
                    Cache.log.debug((Object)("Parsing output of job " + jn));
                    jobres = j.getResultSet();
                    Cache.log.debug((Object)"Finished parsing output.");
                    if (this.jobs.length != 1) {
                        throw new Error("Multiple JNet subjob merging not yet implemented.");
                    }
                    res = jobres;
                    continue;
                }
                catch (Exception e) {
                    Cache.log.error((Object)"JNet Client: JPred Annotation Parse Error", (Throwable)e);
                    this.wsInfo.setStatus(j.jobnum, 4);
                    this.wsInfo.appendProgressText(j.jobnum, this.OutputHeader + "\n" + j.result.getStatus() + "\nInvalid JNet job result data!\n" + e.getMessage());
                    j.result.setBroken(true);
                }
            }
            if (res != null) {
                if (newWindow) {
                    AlignFrame af = this.input == null ? (res[1] != null ? new AlignFrame((Alignment)res[0], (ColumnSelection)res[1], 700, 500) : new AlignFrame((Alignment)res[0], 700, 500)) : new AlignFrame((Alignment)res[0], (ColumnSelection)res[1], 700, 500);
                    Desktop.addInternalFrame(af, this.altitle, 700, 500);
                } else {
                    Cache.log.info((Object)"Append results onto existing alignment.");
                }
            }
        }
    }

    void pollJob(WSThread.WSJob job) throws Exception {
        job.result = this.server.getresult(job.jobId);
    }

    public boolean isCancellable() {
        return false;
    }

    public void cancelJob() {
        throw new Error("Implementation error!");
    }

    public boolean canMergeResults() {
        return false;
    }

    class JPredJob
    extends WSThread.WSJob {
        int[] predMap;
        Sequence sequence;
        Msfalignment msa;
        Hashtable SequenceInfo;
        int msaIndex;

        public boolean hasResults() {
            return this.subjobComplete && this.result != null && this.result.isFinished() && ((JpredResult)this.result).getPredfile() != null && ((JpredResult)this.result).getAligfile() != null;
        }

        boolean hasValidInput() {
            return this.sequence != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object[] getResultSet() throws Exception {
            if (this.result == null || !this.result.isFinished()) {
                return null;
            }
            Alignment al = null;
            ColumnSelection alcsel = null;
            int FirstSeq = -1;
            JpredResult result = (JpredResult)this.result;
            Cache.log.debug((Object)"Parsing output from JNet job.");
            JPredFile prediction = new JPredFile(result.getPredfile(), "Paste");
            SequenceI[] preds = prediction.getSeqsAsArray();
            Cache.log.debug((Object)"Got prediction profile.");
            if (this.msa != null && result.getAligfile() != null) {
                Cache.log.debug((Object)"Getting associated alignment.");
                String format = new IdentifyFile().Identify(result.getAligfile(), "Paste");
                if (!FormatAdapter.isValidFormat(format)) throw new Exception("Unknown format " + format + " for file : \n" + result.getAligfile());
                if (this.predMap != null) {
                    Object[] alandcolsel = JPredThread.this.input.getAlignmentAndColumnSelection(JPredThread.this.getGapChar());
                    SequenceI[] sqs = (SequenceI[])alandcolsel[0];
                    al = new Alignment(sqs);
                    alcsel = (ColumnSelection)alandcolsel[1];
                } else {
                    al = new FormatAdapter().readFile(result.getAligfile(), "Paste", format);
                    SequenceI[] sqs = new SequenceI[al.getHeight()];
                    int j = al.getHeight();
                    for (int i = 0; i < j; ++i) {
                        sqs[i] = al.getSequenceAt(i);
                    }
                    if (!SeqsetUtils.deuniquify(this.SequenceInfo, sqs)) {
                        throw new Exception("Couldn't recover sequence properties for alignment.");
                    }
                }
                FirstSeq = 0;
                al.setDataset(null);
                JnetAnnotationMaker.add_annotation(prediction, al, FirstSeq, false, this.predMap);
                return new Object[]{al, alcsel};
            } else {
                al = new Alignment(preds);
                FirstSeq = prediction.getQuerySeqPosition();
                if (this.predMap != null) {
                    char gc = JPredThread.this.getGapChar();
                    SequenceI[] sqs = (SequenceI[])JPredThread.this.input.getAlignmentAndColumnSelection(gc)[0];
                    if (this.msaIndex >= sqs.length) {
                        throw new Error("Implementation Error! Invalid msaIndex for JPredJob on parent MSA input object!");
                    }
                    new RemoveGapsCommand("Remove Gaps", new SequenceI[]{sqs[this.msaIndex]}, JPredThread.this.currentView);
                    SequenceI profileseq = al.getSequenceAt(FirstSeq);
                    profileseq.setSequence(sqs[this.msaIndex].getSequenceAsString());
                }
                if (!SeqsetUtils.SeqCharacterUnhash(al.getSequenceAt(FirstSeq), this.SequenceInfo)) {
                    throw new Exception("Couldn't recover sequence properties for JNet Query sequence!");
                }
                al.setDataset(null);
                JnetAnnotationMaker.add_annotation(prediction, al, FirstSeq, true, this.predMap);
                SequenceI profileseq = al.getSequenceAt(0);
                this.alignToProfileSeq(al, profileseq);
                if (this.predMap == null) return new Object[]{al, alcsel};
                alcsel = this.propagateInsertions(profileseq, al, JPredThread.this.input);
            }
            return new Object[]{al, alcsel};
        }

        private void alignToProfileSeq(Alignment al, SequenceI profileseq) {
            char gc = al.getGapCharacter();
            int[] gapMap = profileseq.gapMap();
            int lp = 0;
            for (int r = 0; r < gapMap.length; ++r) {
                if (gapMap[r] - lp > 1) {
                    int s;
                    StringBuffer sb = new StringBuffer();
                    int ns = gapMap[r] - lp;
                    for (s = 0; s < ns; ++s) {
                        sb.append(gc);
                    }
                    ns = al.getHeight();
                    for (s = 1; s < ns; ++s) {
                        String sq = al.getSequenceAt(s).getSequenceAsString();
                        int diff = gapMap[r] - sq.length();
                        if (diff > 0) {
                            sq = sq + sb;
                            while ((diff = gapMap[r] - sq.length()) > 0) {
                                sq = sq + (diff >= sb.length() ? sb.toString() : sb.substring(0, diff));
                            }
                            al.getSequenceAt(s).setSequence(sq);
                            continue;
                        }
                        al.getSequenceAt(s).setSequence(sq.substring(0, gapMap[r]) + sb.toString() + sq.substring(gapMap[r]));
                    }
                }
                lp = gapMap[r];
            }
        }

        private ColumnSelection propagateInsertions(SequenceI profileseq, Alignment al, AlignmentView input) {
            char gc = al.getGapCharacter();
            Object[] alandcolsel = input.getAlignmentAndColumnSelection(gc);
            ColumnSelection nview = (ColumnSelection)alandcolsel[1];
            SequenceI origseq = ((SequenceI[])alandcolsel[0])[0];
            nview.pruneDeletions(ShiftList.parseMap(origseq.gapMap()));
            int[] viscontigs = nview.getVisibleContigs(0, profileseq.getLength());
            int spos = 0;
            int offset = 0;
            for (int v = 0; v < viscontigs.length; v += 2) {
                if (viscontigs[v] > spos) {
                    int s;
                    StringBuffer sb = new StringBuffer();
                    int ns = viscontigs[v] - spos;
                    for (s = 0; s < ns; ++s) {
                        sb.append(gc);
                    }
                    ns = al.getHeight();
                    for (s = 0; s < ns; ++s) {
                        SequenceI sqobj = al.getSequenceAt(s);
                        if (sqobj == profileseq) continue;
                        String sq = al.getSequenceAt(s).getSequenceAsString();
                        if (sq.length() <= spos + offset) {
                            int diff = spos + offset - sq.length() - 1;
                            if (diff > 0) {
                                sq = sq + sb;
                                while ((diff = spos + offset - sq.length() - 1) > 0) {
                                    sq = sq + (diff >= sb.length() ? sb.toString() : sb.substring(0, diff));
                                }
                            }
                            sq = sq + sb.toString();
                            continue;
                        }
                        al.getSequenceAt(s).setSequence(sq.substring(0, spos + offset) + sb.toString() + sq.substring(spos + offset));
                    }
                }
                spos = viscontigs[v + 1] + 1;
            }
            if (offset + spos < profileseq.getLength()) {
                int s;
                StringBuffer sb = new StringBuffer();
                int ns = profileseq.getLength() - spos - offset;
                for (s = 0; s < ns; ++s) {
                    sb.append(gc);
                }
                ns = al.getHeight();
                for (s = 1; s < ns; ++s) {
                    String sq = al.getSequenceAt(s).getSequenceAsString();
                    int diff = origseq.getLength() - sq.length();
                    while (diff > 0) {
                        sq = sq + (diff >= sb.length() ? sb.toString() : sb.substring(0, diff));
                        diff = origseq.getLength() - sq.length();
                    }
                }
            }
            return nview;
        }

        public JPredJob(Hashtable SequenceInfo, SequenceI seq, int[] delMap) {
            super(JPredThread.this);
            this.predMap = null;
            this.SequenceInfo = null;
            this.msaIndex = 0;
            this.predMap = delMap;
            String sq = AlignSeq.extractGaps(" .-", seq.getSequenceAsString());
            if (sq.length() >= 20) {
                this.SequenceInfo = SequenceInfo;
                this.sequence = new Sequence();
                this.sequence.setId(seq.getName());
                this.sequence.setSeq(sq);
            }
        }

        public JPredJob(Hashtable SequenceInfo, SequenceI[] msf, int[] delMap) {
            this(SequenceInfo, msf[0], delMap);
            if (this.sequence != null && msf.length > 1) {
                this.msa = new Msfalignment();
                PileUpfile pileup = new PileUpfile();
                this.msa.setMsf(pileup.print(msf));
            }
        }
    }
}

