/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws;

import ext.vamsas.MuscleWS;
import ext.vamsas.MuscleWSServiceLocator;
import ext.vamsas.MuscleWSSoapBindingStub;
import ext.vamsas.ServiceHandle;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentView;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.ws.MsaWSThread;
import jalview.ws.WSClient;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class MsaWSClient
extends WSClient {
    MuscleWS server;
    AlignFrame alignFrame;

    public MsaWSClient(ServiceHandle sh, String altitle, AlignmentView msa, boolean submitGaps, boolean preserveOrder, Alignment seqdataset, AlignFrame _alignFrame) {
        this.alignFrame = _alignFrame;
        if (!sh.getAbstractName().equals("MsaWS")) {
            JOptionPane.showMessageDialog(Desktop.desktop, "The Service called \n" + sh.getName() + "\nis not a \nMultiple Sequence Alignment Service !", "Internal Jalview Error", 2);
            return;
        }
        this.wsInfo = this.setWebService(sh);
        if (this.wsInfo == null) {
            JOptionPane.showMessageDialog(Desktop.desktop, "The Multiple Sequence Alignment Service named " + sh.getName() + " is unknown", "Internal Jalview Error", 2);
            return;
        }
        this.startMsaWSClient(altitle, msa, submitGaps, preserveOrder, seqdataset);
    }

    public MsaWSClient() {
    }

    private void startMsaWSClient(String altitle, AlignmentView msa, boolean submitGaps, boolean preserveOrder, Alignment seqdataset) {
        if (!this.locateWebService()) {
            return;
        }
        this.wsInfo.setProgressText((submitGaps ? "Re-alignment" : "Alignment") + " of " + altitle + "\nJob details\n");
        String jobtitle = this.WebServiceName.toLowerCase();
        if (jobtitle.endsWith("alignment")) {
            if (submitGaps && (!jobtitle.endsWith("realignment") || jobtitle.indexOf("profile") == -1)) {
                int pos = jobtitle.indexOf("alignment");
                jobtitle = this.WebServiceName.substring(0, pos) + "re-alignment of " + altitle;
            } else {
                jobtitle = this.WebServiceName + " of " + altitle;
            }
        } else {
            jobtitle = this.WebServiceName + (submitGaps ? " re" : " ") + "alignment of " + altitle;
        }
        MsaWSThread msathread = new MsaWSThread(this.server, this.WsURL, this.wsInfo, this.alignFrame, this.WebServiceName, jobtitle, msa, submitGaps, preserveOrder, seqdataset);
        this.wsInfo.setthisService(msathread);
        msathread.start();
    }

    private boolean locateWebService() {
        MuscleWSServiceLocator loc = new MuscleWSServiceLocator();
        try {
            this.server = loc.getMuscleWS(new URL(this.WsURL));
            ((MuscleWSSoapBindingStub)this.server).setTimeout(60000);
        }
        catch (Exception ex) {
            this.wsInfo.setProgressText("Serious! " + this.WebServiceName + " Service location failed\nfor URL :" + this.WsURL + "\n" + ex.getMessage());
            this.wsInfo.setStatus(64);
            ex.printStackTrace();
            return false;
        }
        loc.getEngine().setOption("axis", (Object)"1");
        return true;
    }

    protected String getServiceActionKey() {
        return "MsaWS";
    }

    protected String getServiceActionDescription() {
        return "Multiple Sequence Alignment";
    }

    private boolean canSubmitGaps() {
        return this.WebServiceName.indexOf("lustal") > -1;
    }

    public void attachWSMenuEntry(JMenu msawsmenu, final ServiceHandle serviceHandle, final AlignFrame alignFrame) {
        this.setWebService(serviceHandle, true);
        JMenuItem method = new JMenuItem(this.WebServiceName);
        method.setToolTipText(this.WsURL);
        method.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlignmentView msa = alignFrame.gatherSequencesForAlignment();
                new MsaWSClient(serviceHandle, alignFrame.getTitle(), msa, false, true, alignFrame.getViewport().getAlignment().getDataset(), alignFrame);
            }
        });
        msawsmenu.add(method);
        if (this.canSubmitGaps()) {
            JMenuItem methodR = new JMenuItem(serviceHandle.getName() + " Realign");
            methodR.setToolTipText(this.WsURL);
            methodR.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AlignmentView msa = alignFrame.gatherSequencesForAlignment();
                    new MsaWSClient(serviceHandle, alignFrame.getTitle(), msa, true, true, alignFrame.getViewport().getAlignment().getDataset(), alignFrame);
                }
            });
            msawsmenu.add(methodR);
        }
    }
}

