/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws;

import jalview.analysis.CrossRef;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.SequenceI;
import jalview.util.QuickSort;
import jalview.ws.DasSequenceFeatureFetcher;
import jalview.ws.dbsources.DasSequenceSource;
import jalview.ws.dbsources.EmblCdsSouce;
import jalview.ws.dbsources.EmblSource;
import jalview.ws.dbsources.Pdb;
import jalview.ws.dbsources.PfamFull;
import jalview.ws.dbsources.PfamSeed;
import jalview.ws.dbsources.Uniprot;
import jalview.ws.dbsources.UnprotName;
import jalview.ws.seqfetcher.ASequenceFetcher;
import jalview.ws.seqfetcher.DbSourceProxy;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.biojava.dasobert.das2.Das2Source;
import org.biojava.dasobert.das2.DasSourceConverter;
import org.biojava.dasobert.dasregistry.Das1Source;
import org.biojava.dasobert.dasregistry.DasCoordinateSystem;
import org.biojava.dasobert.dasregistry.DasSource;

public class SequenceFetcher
extends ASequenceFetcher {
    public SequenceFetcher() {
        this.addDBRefSourceImpl(EmblSource.class);
        this.addDBRefSourceImpl(EmblCdsSouce.class);
        this.addDBRefSourceImpl(Uniprot.class);
        this.addDBRefSourceImpl(UnprotName.class);
        this.addDBRefSourceImpl(Pdb.class);
        this.addDBRefSourceImpl(PfamFull.class);
        this.addDBRefSourceImpl(PfamSeed.class);
        this.registerDasSequenceSources();
    }

    public String[] getOrderedSupportedSources() {
        String[] srcs = this.getSupportedDb();
        ArrayList<String[]> dassrc = new ArrayList<String[]>();
        ArrayList<String[]> nondas = new ArrayList<String[]>();
        for (int i = 0; i < srcs.length; ++i) {
            String nm = this.getSourceProxy(srcs[i]).getDbName();
            if (this.getSourceProxy(srcs[i]) instanceof DasSequenceSource) {
                if (nm.startsWith("das:")) {
                    nm = nm.substring(4);
                }
                dassrc.add(new String[]{srcs[i], nm.toUpperCase()});
                continue;
            }
            nondas.add(new String[]{srcs[i], nm.toUpperCase()});
        }
        Object[] sorted = nondas.toArray();
        String[] tosort = new String[sorted.length];
        nondas.clear();
        for (int j = 0; j < sorted.length; ++j) {
            tosort[j] = ((String[])sorted[j])[1];
        }
        QuickSort.sort(tosort, sorted);
        int i = 0;
        int j = sorted.length - 1;
        while (j >= 0) {
            srcs[i] = ((String[])sorted[j])[0];
            sorted[j] = null;
            --j;
            ++i;
        }
        sorted = dassrc.toArray();
        tosort = new String[sorted.length];
        dassrc.clear();
        for (j = 0; j < sorted.length; ++j) {
            tosort[j] = ((String[])sorted[j])[1];
        }
        QuickSort.sort(tosort, sorted);
        j = sorted.length - 1;
        while (j >= 0) {
            srcs[i] = ((String[])sorted[j])[0];
            sorted[j] = null;
            --j;
            ++i;
        }
        return srcs;
    }

    public static void main(String[] argv) {
        AlignmentI al;
        AlignmentI ds = null;
        Vector<Object[]> noProds = new Vector<Object[]>();
        String usage = "SequenceFetcher.main [<DBNAME> <ACCNO>]\nWith no arguments, all DbSources will be queried with their test Accession number.\nIf given two arguments, SequenceFetcher will try to find the DbFetcher corresponding to <DBNAME> and retrieve <ACCNO> from it.";
        if (argv != null && argv.length > 0) {
            DbSourceProxy sp = new SequenceFetcher().getSourceProxy(argv[0]);
            if (sp != null) {
                AlignmentI al2 = null;
                try {
                    al2 = sp.getSequenceRecords(argv[1]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("Error when retrieving " + argv[1] + " from " + argv[0] + "\nUsage: " + usage);
                }
                SequenceI[] prod = al2.getSequencesArray();
                if (al2 != null) {
                    for (int p = 0; p < prod.length; ++p) {
                        System.out.println("Prod " + p + ": " + prod[p].getDisplayId(true) + " : " + prod[p].getDescription());
                    }
                }
                return;
            }
            System.err.println("Can't resolve " + argv[0] + " as a database name. Allowed values are :\n" + new SequenceFetcher().getSupportedDb());
            System.out.println(usage);
        }
        SequenceFetcher sfetcher = new SequenceFetcher();
        String[] dbSources = sfetcher.getSupportedDb();
        for (int dbsource = 0; dbsource < dbSources.length; ++dbsource) {
            String db = dbSources[dbsource];
            if (db.equals(DBRefSource.PDB)) continue;
            DbSourceProxy sp = sfetcher.getSourceProxy(db);
            System.out.println("Source: " + sp.getDbName() + " (" + db + "): retrieving test:" + sp.getTestQuery());
            al = null;
            try {
                al = sp.getSequenceRecords(sp.getTestQuery());
                if (al != null && al.getHeight() > 0 && sp.getDbSourceProperties() != null) {
                    boolean dna = sp.getDbSourceProperties().containsKey(DBRefSource.DNACODINGSEQDB) || sp.getDbSourceProperties().containsKey(DBRefSource.DNASEQDB) || sp.getDbSourceProperties().containsKey(DBRefSource.CODINGSEQDB);
                    String[] types = CrossRef.findSequenceXrefTypes(dna, al.getSequencesArray());
                    if (types != null) {
                        System.out.println("Xref Types for: " + (dna ? "dna" : "prot"));
                        for (int t = 0; t < types.length; ++t) {
                            System.out.println("Type: " + types[t]);
                            SequenceI[] prod = CrossRef.findXrefSequences(al.getSequencesArray(), dna, types[t]).getSequencesArray();
                            System.out.println("Found " + (prod == null ? "no" : "" + prod.length) + " products");
                            if (prod == null) continue;
                            for (int p = 0; p < prod.length; ++p) {
                                System.out.println("Prod " + p + ": " + prod[p].getDisplayId(true));
                            }
                        }
                    } else {
                        Object[] objectArray;
                        if (dna) {
                            Object[] objectArray2 = new Object[2];
                            objectArray2[0] = al;
                            objectArray = objectArray2;
                            objectArray2[1] = al;
                        } else {
                            Object[] objectArray3 = new Object[1];
                            objectArray = objectArray3;
                            objectArray3[0] = al;
                        }
                        noProds.addElement(objectArray);
                    }
                }
            }
            catch (Exception ex) {
                System.out.println("ERROR:Failed to retrieve test query.");
                ex.printStackTrace(System.out);
            }
            if (al == null) {
                System.out.println("ERROR:No alignment retrieved.");
                StringBuffer raw = sp.getRawRecords();
                if (raw != null) {
                    System.out.println(raw.toString());
                } else {
                    System.out.println("ERROR:No Raw results.");
                }
            } else {
                System.out.println("Retrieved " + al.getHeight() + " sequences.");
                for (int s = 0; s < al.getHeight(); ++s) {
                    SequenceI sq = al.getSequenceAt(s);
                    while (sq.getDatasetSequence() != null) {
                        sq = sq.getDatasetSequence();
                    }
                    if (ds == null) {
                        ds = new Alignment(new SequenceI[]{sq});
                        continue;
                    }
                    ds.addSequence(sq);
                }
            }
            System.out.flush();
            System.err.flush();
        }
        if (noProds.size() > 0) {
            Enumeration ts = noProds.elements();
            while (ts.hasMoreElements()) {
                Object[] typeSq = (Object[])ts.nextElement();
                boolean dna = typeSq.length > 1;
                al = (AlignmentI)typeSq[0];
                System.out.println("Trying getProducts for " + al.getSequenceAt(0).getDisplayId(true));
                System.out.println("Search DS Xref for: " + (dna ? "dna" : "prot"));
                SequenceI[] seqs = al.getSequencesArray();
                Alignment prodal = CrossRef.findXrefSequences(seqs, dna, null, ds);
                System.out.println("Found " + (prodal == null ? "no" : "" + prodal.getHeight()) + " products");
                if (prodal == null) continue;
                SequenceI[] prod = prodal.getSequencesArray();
                for (int p = 0; p < prod.length; ++p) {
                    System.out.println("Prod " + p + ": " + prod[p].getDisplayId(true));
                }
            }
        }
    }

    public void registerDasSequenceSources() {
        DasSource[] sources = DasSequenceFeatureFetcher.getDASSources();
        for (int s = 0; s < sources.length; ++s) {
            Das1Source d1s = null;
            if (sources[s].hasCapability("sequence")) {
                if (sources[s] instanceof Das2Source) {
                    if (((Das2Source)sources[s]).hasDas1Capabilities()) {
                        try {
                            d1s = DasSourceConverter.toDas1Source((Das2Source)sources[s]);
                        }
                        catch (Exception e) {
                            System.err.println("Ignoring DAS2 sequence source " + sources[s].getNickname() + " - couldn't map to Das1Source.\n");
                            e.printStackTrace();
                        }
                    }
                } else if (sources[s] instanceof Das1Source) {
                    d1s = (Das1Source)sources[s];
                }
            }
            if (d1s == null) continue;
            DasCoordinateSystem[] css = d1s.getCoordinateSystem();
            for (int c = 0; c < css.length; ++c) {
                try {
                    this.addDbRefSourceImpl(new DasSequenceSource("das:" + d1s.getNickname() + " (" + css[c].getName() + ")", css[c].getName(), d1s, css[c]));
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Ignoring sequence coord system " + c + " (" + css[c].getName() + ") for source " + d1s.getNickname() + "- threw exception when constructing fetcher.\n");
                    e.printStackTrace();
                }
            }
        }
    }
}

