/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws;

import jalview.bin.Cache;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.FeatureRenderer;
import jalview.gui.OOMWarning;
import jalview.gui.WebserviceInfo;
import vamsas.objects.simple.Result;

public abstract class WSThread
extends Thread {
    AlignmentI currentView = null;
    FeatureRenderer.FeatureRendererSettings featureSettings = null;
    WebserviceInfo wsInfo = null;
    AlignmentView input = null;
    AlignedCodonFrame[] codonframe = null;
    boolean jobComplete = false;
    WSJob[] jobs = null;
    String WebServiceName = null;
    String OutputHeader;
    String WsUrl = null;
    char defGapChar = (char)45;

    abstract void pollJob(WSJob var1) throws Exception;

    public void run() {
        JobStateSummary jstate = null;
        if (this.jobs == null) {
            this.jobComplete = true;
        }
        while (!this.jobComplete) {
            jstate = new JobStateSummary();
            for (int j = 0; j < this.jobs.length; ++j) {
                if (!this.jobs[j].submitted && this.jobs[j].hasValidInput()) {
                    this.StartJob(this.jobs[j]);
                }
                if (this.jobs[j].submitted && !this.jobs[j].subjobComplete) {
                    try {
                        this.pollJob(this.jobs[j]);
                        if (this.jobs[j].result == null) {
                            throw new Exception("Timed out when communicating with server\nTry again later.\n");
                        }
                        Cache.log.debug((Object)("Job " + j + " Result state " + this.jobs[j].result.getState() + "(ServerError=" + this.jobs[j].result.isServerError() + ")"));
                    }
                    catch (Exception ex) {
                        this.wsInfo.appendProgressText(this.jobs[j].jobnum, "\n" + this.WebServiceName + " Server exception!\n" + ex.getMessage());
                        Cache.log.warn((Object)(this.WebServiceName + " job(" + this.jobs[j].jobnum + ") Server exception: " + ex.getMessage()));
                        if (this.jobs[j].allowedServerExceptions > 0) {
                            --this.jobs[j].allowedServerExceptions;
                            Cache.log.debug((Object)"Sleeping after a server exception.");
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException ex1) {}
                        } else {
                            Cache.log.warn((Object)("Dropping job " + j + " " + this.jobs[j].jobId));
                            this.jobs[j].subjobComplete = true;
                            this.wsInfo.setStatus(this.jobs[j].jobnum, 5);
                        }
                    }
                    catch (OutOfMemoryError er) {
                        this.jobComplete = true;
                        this.jobs[j].subjobComplete = true;
                        this.jobs[j].result = null;
                        this.wsInfo.setStatus(this.jobs[j].jobnum, 4);
                        Cache.log.error((Object)("Out of memory when retrieving Job " + j + " id:" + this.WsUrl + "/" + this.jobs[j].jobId), (Throwable)er);
                        new OOMWarning("retrieving result for " + this.WebServiceName, er);
                        System.gc();
                    }
                }
                jstate.updateJobPanelState(this.wsInfo, this.OutputHeader, this.jobs[j]);
            }
            if (jstate.running > 0) {
                this.wsInfo.setStatus(1);
            } else if (jstate.queuing > 0) {
                this.wsInfo.setStatus(0);
            } else {
                this.jobComplete = true;
                if (jstate.finished > 0) {
                    this.wsInfo.setStatus(2);
                } else if (jstate.error > 0) {
                    this.wsInfo.setStatus(4);
                } else if (jstate.serror > 0) {
                    this.wsInfo.setStatus(5);
                }
            }
            if (this.jobComplete) continue;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                Cache.log.debug((Object)"Interrupted sleep waiting for next job poll.", (Throwable)e);
            }
        }
        if (this.jobComplete && this.jobs != null) {
            this.parseResult();
        } else {
            Cache.log.debug((Object)"WebServiceJob poll loop finished with no jobs created.");
            this.wsInfo.setFinishedNoResults();
        }
    }

    abstract void StartJob(WSJob var1);

    abstract void parseResult();

    protected void propagateDatasetMappings(Alignment al) {
        if (this.codonframe != null) {
            SequenceI[] alignment = al.getSequencesArray();
            block0: for (int sq = 0; sq < alignment.length; ++sq) {
                for (int i = 0; i < this.codonframe.length; ++i) {
                    if (this.codonframe[i] == null || !this.codonframe[i].involvesSequence(alignment[sq])) continue;
                    al.addCodonFrame(this.codonframe[i]);
                    this.codonframe[i] = null;
                    continue block0;
                }
            }
        }
    }

    public WSThread(AlignFrame alignFrame, WebserviceInfo wsinfo, AlignmentView input, String webServiceName, String wsUrl) {
        this(alignFrame, wsinfo, input, wsUrl);
        this.WebServiceName = webServiceName;
    }

    public char getGapChar() {
        return this.defGapChar;
    }

    public WSThread(AlignFrame alframe, WebserviceInfo wsinfo2, AlignmentView alview, String wsurl2) {
        AlignedCodonFrame[] cf;
        this.currentView = alframe.getCurrentView().getAlignment();
        this.featureSettings = alframe.getFeatureRenderer().getSettings();
        this.defGapChar = alframe.getViewport().getGapCharacter();
        this.wsInfo = wsinfo2;
        this.input = alview;
        this.WsUrl = wsurl2;
        if (alframe != null && (cf = alframe.getViewport().getAlignment().getCodonFrames()) != null) {
            this.codonframe = new AlignedCodonFrame[cf.length];
            System.arraycopy(cf, 0, this.codonframe, 0, cf.length);
        }
    }

    class JobStateSummary {
        int running = 0;
        int queuing = 0;
        int finished = 0;
        int error = 0;
        int serror = 0;
        int cancelled = 0;
        int results = 0;

        JobStateSummary() {
        }

        void updateJobPanelState(WebserviceInfo wsInfo, String OutputHeader, WSJob j) {
            if (j.result != null) {
                String progheader = "";
                if (j.result.isRunning()) {
                    ++this.running;
                    wsInfo.setStatus(j.jobnum, 1);
                } else if (j.result.isQueued()) {
                    ++this.queuing;
                    wsInfo.setStatus(j.jobnum, 0);
                } else if (j.result.isFinished()) {
                    ++this.finished;
                    j.subjobComplete = true;
                    if (j.hasResults()) {
                        ++this.results;
                    }
                    wsInfo.setStatus(j.jobnum, 2);
                } else if (j.result.isFailed()) {
                    progheader = progheader + "Job failed.\n";
                    j.subjobComplete = true;
                    wsInfo.setStatus(j.jobnum, 4);
                    ++this.error;
                } else if (j.result.isServerError()) {
                    ++this.serror;
                    j.subjobComplete = true;
                    wsInfo.setStatus(j.jobnum, 5);
                } else if (j.result.isBroken() || j.result.isFailed()) {
                    ++this.error;
                    j.subjobComplete = true;
                    wsInfo.setStatus(j.jobnum, 4);
                }
                wsInfo.setProgressText(j.jobnum, OutputHeader);
                wsInfo.appendProgressText(j.jobnum, progheader);
                if (j.result.getStatus() != null) {
                    wsInfo.appendProgressText(j.jobnum, j.result.getStatus());
                }
            } else if (j.submitted && j.subjobComplete) {
                if (j.allowedServerExceptions == 0) {
                    ++this.serror;
                } else if (j.result == null) {
                    ++this.error;
                }
            }
        }
    }

    abstract class WSJob {
        int jobnum = 0;
        String jobId;
        boolean cancelled = false;
        int allowedServerExceptions = 3;
        boolean submitted = false;
        boolean subjobComplete = false;
        Result result;

        WSJob() {
        }

        abstract boolean hasResults();

        abstract boolean hasValidInput();
    }
}

