/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.dbsources;

import com.stevesoft.pat.Regex;
import jalview.datamodel.AlignmentI;
import jalview.ws.dbsources.das.DasSequenceSourceListener;
import jalview.ws.seqfetcher.DbSourceProxy;
import jalview.ws.seqfetcher.DbSourceProxyImpl;
import org.biojava.dasobert.das.SequenceThread;
import org.biojava.dasobert.dasregistry.Das1Source;
import org.biojava.dasobert.dasregistry.DasCoordinateSystem;

public class DasSequenceSource
extends DbSourceProxyImpl
implements DbSourceProxy {
    protected Das1Source source = null;
    protected String dbname = "DASCS";
    protected String dbrefname = "das:source";
    protected DasCoordinateSystem coordsys = null;

    public DasSequenceSource(String dbname, String dbrefname, Das1Source source, DasCoordinateSystem coordsys) throws Exception {
        if (!source.hasCapability("sequence")) {
            throw new Exception("Source " + source.getNickname() + " does not support the sequence command.");
        }
        this.source = source;
        this.dbname = dbname;
        this.dbrefname = dbrefname;
        this.coordsys = coordsys;
    }

    public String getAccessionSeparator() {
        return null;
    }

    public Regex getAccessionValidator() {
        return Regex.perlCode("\\S+");
    }

    public String getDbName() {
        return this.dbname + " (DAS)";
    }

    public String getDbSource() {
        return this.dbrefname;
    }

    public String getDbVersion() {
        return this.coordsys.getVersion();
    }

    public AlignmentI getSequenceRecords(String queries) throws Exception {
        SequenceThread seqfetcher = new SequenceThread(queries, this.source);
        DasSequenceSourceListener ourlistener = new DasSequenceSourceListener(this, queries);
        seqfetcher.addSequenceListener(ourlistener);
        seqfetcher.start();
        try {
            Thread.sleep(5L);
        }
        catch (Exception e) {
            // empty catch block
        }
        while (ourlistener.isNotCalled() && seqfetcher.isAlive()) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception e) {}
        }
        if (ourlistener.isNotCalled() || ourlistener.hasNoSequences()) {
            System.err.println("Sequence Query to " + this.source.getNickname() + " with '" + queries + "' returned no sequences.");
            return null;
        }
        return ourlistener.getSequences();
    }

    public String getTestQuery() {
        return this.coordsys.getTestCode();
    }

    public boolean isValidReference(String accession) {
        return true;
    }

    public Das1Source getSource() {
        return this.source;
    }

    public DasCoordinateSystem getCoordsys() {
        return this.coordsys;
    }
}

