/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.seqfetcher;

import jalview.datamodel.Alignment;
import jalview.io.FormatAdapter;
import jalview.io.IdentifyFile;
import jalview.ws.seqfetcher.DbSourceProxy;
import java.util.Hashtable;

public abstract class DbSourceProxyImpl
implements DbSourceProxy {
    private Hashtable props = null;
    boolean queryInProgress = false;
    protected StringBuffer results = null;

    public Hashtable getDbSourceProperties() {
        return this.props;
    }

    protected void addDbSourceProperty(Object propname) {
        this.addDbSourceProperty(propname, propname);
    }

    protected void addDbSourceProperty(Object propname, Object propvalue) {
        if (this.props == null) {
            this.props = new Hashtable();
        }
        this.props.put(propname, propvalue);
    }

    public StringBuffer getRawRecords() {
        return this.results;
    }

    public boolean queryInProgress() {
        return this.queryInProgress;
    }

    protected void startQuery() {
        this.queryInProgress = true;
    }

    protected void stopQuery() {
        this.queryInProgress = false;
    }

    protected Alignment parseResult(String result) throws Exception {
        Alignment sequences = null;
        String format = new IdentifyFile().Identify(result, "Paste");
        if (FormatAdapter.isValidFormat(format)) {
            sequences = new FormatAdapter().readFile(result.toString(), "Paste", format);
        }
        return sequences;
    }
}

