/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.dasobert.das;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.dasobert.das.DAS_Feature_Handler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DAS_FeatureRetrieve {
    String version;
    List features;
    Logger logger = Logger.getLogger("org.biojava.spice");
    int comeBackLater = -1;
    URL url;

    public DAS_FeatureRetrieve(URL url) {
        this.features = new ArrayList();
        this.url = url;
        this.reload();
    }

    public void reload() {
        try {
            InputStream dasInStream = null;
            try {
                dasInStream = this.open(this.url);
            }
            catch (Exception e) {
                this.comeBackLater = -1;
                System.out.println("NO RESPONSE FROM " + this.url);
                this.logger.log(Level.FINE, "could not open connection to " + this.url, e);
                return;
            }
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            spfactory.setValidating(false);
            SAXParser saxParser = null;
            try {
                saxParser = spfactory.newSAXParser();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            String vali = System.getProperty("XMLVALIDATION");
            boolean validation = false;
            if (vali != null && vali.equals("true")) {
                validation = true;
            }
            XMLReader xmlreader = saxParser.getXMLReader();
            try {
                xmlreader.setFeature("http://xml.org/sax/features/validation", validation);
            }
            catch (SAXException e) {
                this.logger.log(Level.FINE, "Cannot set validation " + validation);
            }
            try {
                xmlreader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", validation);
            }
            catch (SAXNotRecognizedException e) {
                e.printStackTrace();
                this.logger.log(Level.FINE, "Cannot set load-external-dtd " + validation);
            }
            DAS_Feature_Handler cont_handle = new DAS_Feature_Handler();
            cont_handle.setDASCommand(this.url.toString());
            xmlreader.setContentHandler(cont_handle);
            xmlreader.setErrorHandler(new DefaultHandler());
            InputSource insource = new InputSource();
            insource.setByteStream(dasInStream);
            try {
                xmlreader.parse(insource);
                this.features = cont_handle.get_features();
                this.version = cont_handle.getVersion();
                this.comeBackLater = cont_handle.getComBackLater();
            }
            catch (Exception e) {
                System.out.println("Error parsing response from: " + this.url + "\n" + e);
                this.logger.log(Level.FINE, "error while parsing response from " + this.url);
                this.comeBackLater = -1;
                this.features = new ArrayList();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.comeBackLater = -1;
        }
    }

    public static HttpURLConnection openHttpURLConnection(URL url) throws IOException, ConnectException {
        HttpURLConnection huc = null;
        huc = (HttpURLConnection)url.openConnection();
        String os_name = System.getProperty("os.name");
        String os_version = System.getProperty("os.version");
        String os_arch = System.getProperty("os.arch");
        String VERSION = "1.0";
        String userAgent = "Jalview " + VERSION + "(" + os_name + "; " + os_arch + " ; " + os_version + ")";
        huc.addRequestProperty("User-Agent", userAgent);
        int timeout = 10000;
        System.setProperty("sun.net.client.defaultConnectTimeout", timeout + "");
        System.setProperty("sun.net.client.defaultReadTimeout", timeout + "");
        try {
            Class<?> urlconnectionClass = Class.forName("java.net.HttpURLConnection");
            Method setconnecttimeout = urlconnectionClass.getMethod("setConnectTimeout", Integer.TYPE);
            setconnecttimeout.invoke((Object)huc, new Integer(timeout));
            Method setreadtimeout = urlconnectionClass.getMethod("setReadTimeout", Integer.TYPE);
            setreadtimeout.invoke((Object)huc, new Integer(timeout));
        }
        catch (Exception e) {
            // empty catch block
        }
        return huc;
    }

    private InputStream open(URL url) throws IOException, ConnectException {
        InputStream inStream = null;
        HttpURLConnection huc = DAS_FeatureRetrieve.openHttpURLConnection(url);
        inStream = huc.getInputStream();
        return inStream;
    }

    public List get_features() {
        return this.features;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int getComeBackLater() {
        return this.comeBackLater;
    }
}

