/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.dasobert.das;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.biojava.dasobert.das.DAS_FeatureRetrieve;
import org.biojava.dasobert.dasregistry.Das1Source;
import org.biojava.dasobert.eventmodel.FeatureEvent;
import org.biojava.dasobert.eventmodel.FeatureListener;

public class FeatureThread
implements Runnable {
    public static int MAX_COME_BACK_ITERATIONS = 5;
    public static int MAX_NR_FEATURES = 300;
    static Logger logger = Logger.getLogger("org.biojava.spice");
    Das1Source dasSource;
    String ac;
    List featureListeners;
    Thread thread;

    public FeatureThread(String accessionCode, Das1Source dasSource) {
        this.dasSource = dasSource;
        this.ac = accessionCode;
        this.featureListeners = new ArrayList();
    }

    public void addFeatureListener(FeatureListener li) {
        this.featureListeners.add(li);
    }

    public void clearFeatureListeners() {
        this.featureListeners.clear();
    }

    public synchronized void stop() {
        this.thread = null;
        this.notify();
    }

    public void run() {
        Thread me = Thread.currentThread();
        if (this.thread == me) {
            String url = this.dasSource.getUrl();
            String queryString = url + "features?segment=" + this.ac;
            URL cmd = null;
            try {
                cmd = new URL(queryString);
            }
            catch (MalformedURLException e) {
                logger.warning("got MalformedURL from das source " + this.dasSource);
                e.printStackTrace();
            }
            logger.info("requesting features from " + cmd);
            DAS_FeatureRetrieve ftmp = new DAS_FeatureRetrieve(cmd);
            int comeBackLater = ftmp.getComeBackLater();
            int securityCounter = 0;
            while (this.thread == me && comeBackLater > 0) {
                if (++securityCounter >= MAX_COME_BACK_ITERATIONS) {
                    comeBackLater = -1;
                    break;
                }
                this.notifyComeBackLater(comeBackLater);
                try {
                    this.wait(comeBackLater);
                }
                catch (InterruptedException e) {
                    comeBackLater = -1;
                    break;
                }
                ftmp.reload();
                comeBackLater = ftmp.getComeBackLater();
            }
            if (this.thread == me) {
                List features = ftmp.get_features();
                String version = ftmp.getVersion();
                if (features.size() > MAX_NR_FEATURES) {
                    logger.warning("DAS source returned more than " + MAX_NR_FEATURES + "features. " + " throwing away excess features at " + cmd);
                    features = features.subList(0, MAX_NR_FEATURES);
                }
                Map[] feats = features.toArray(new Map[features.size()]);
                this.notifyFeatureListeners(feats, version);
            }
        }
        this.thread = null;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    private void notifyFeatureListeners(Map[] feats, String version) {
        logger.finest("FeatureThread found " + feats.length + " features");
        FeatureEvent fevent = new FeatureEvent(feats, this.dasSource, version);
        Iterator fiter = this.featureListeners.iterator();
        while (fiter.hasNext()) {
            FeatureListener fi = (FeatureListener)fiter.next();
            fi.newFeatures(fevent);
        }
    }

    private void notifyComeBackLater(int comeBackLater) {
        FeatureEvent event = new FeatureEvent(new HashMap[0], this.dasSource, "");
        event.setComeBackLater(comeBackLater);
        Iterator fiter = this.featureListeners.iterator();
        while (fiter.hasNext()) {
            FeatureListener fi = (FeatureListener)fiter.next();
            fi.comeBackLater(event);
        }
    }
}

