/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.dasobert.das;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.dasobert.das.DAS_FeatureRetrieve;
import org.biojava.dasobert.das.DAS_Sequence_Handler;
import org.biojava.dasobert.dasregistry.Das1Source;
import org.biojava.dasobert.eventmodel.SequenceEvent;
import org.biojava.dasobert.eventmodel.SequenceListener;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SequenceThread
extends Thread {
    Das1Source[] sequenceServers;
    String sp_accession;
    List seqListeners;
    String version;
    static Logger logger = Logger.getLogger("org.biojava.spice");

    public SequenceThread(String sp_accession, Das1Source ds) {
        Das1Source[] dss = new Das1Source[]{ds};
        this.sp_accession = sp_accession;
        this.sequenceServers = dss;
        this.clearSequenceListeners();
        this.version = "";
    }

    public SequenceThread(String sp_accession, Das1Source[] ds) {
        this.sp_accession = sp_accession;
        this.sequenceServers = ds;
        this.clearSequenceListeners();
    }

    public void clearSequenceListeners() {
        this.seqListeners = new ArrayList();
    }

    public void addSequenceListener(SequenceListener lis) {
        this.seqListeners.add(lis);
    }

    public void run() {
        this.getSequence();
    }

    public void getSequence() {
        boolean gotSequence = false;
        for (int i = 0; i < this.sequenceServers.length && !gotSequence; ++i) {
            Das1Source ds = this.sequenceServers[i];
            String url = ds.getUrl();
            char lastChar = url.charAt(url.length() - 1);
            if (lastChar != '/') {
                url = url + "/";
            }
            String dascmd = url + "sequence?segment=";
            String connstr = dascmd + this.sp_accession;
            try {
                this.version = "";
                String sequence = this.retrieveSequence(connstr);
                sequence.replaceAll(" ", "");
                gotSequence = true;
                this.triggerNewSequence(this.sp_accession, sequence, ds, this.version);
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.warning(ex.getMessage());
                continue;
            }
        }
        logger.log(Level.WARNING, "could not retreive UniProt sequence from any available DAS sequence server");
        this.triggerNoSequence(this.sp_accession);
    }

    private void triggerNewSequence(String sp_accession, String sequence, Das1Source source, String version) {
        Iterator iter = this.seqListeners.iterator();
        while (iter.hasNext()) {
            SequenceListener li = (SequenceListener)iter.next();
            SequenceEvent event = new SequenceEvent(sp_accession, sequence, version);
            event.setSource(source);
            li.newSequence(event);
        }
    }

    private void triggerNoSequence(String ac) {
        Iterator iter = this.seqListeners.iterator();
        while (iter.hasNext()) {
            SequenceListener li = (SequenceListener)iter.next();
            li.noObjectFound(ac);
        }
    }

    public String retrieveSequence(String connstr) throws Exception {
        URL dasUrl = new URL(connstr);
        logger.info("requesting sequence from " + connstr);
        InputStream dasInStream = this.open(dasUrl);
        SAXParserFactory spfactory = SAXParserFactory.newInstance();
        String vali = "false";
        boolean validate = false;
        if (vali != null && vali.equals("true")) {
            validate = true;
        }
        spfactory.setValidating(validate);
        SAXParser saxParser = null;
        try {
            saxParser = spfactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.FINER, "Uncaught exception", e);
        }
        XMLReader xmlreader = saxParser.getXMLReader();
        try {
            xmlreader.setFeature("http://xml.org/sax/features/validation", validate);
        }
        catch (SAXException e) {
            logger.finer("Cannot set validation to " + validate);
            logger.log(Level.FINER, "Uncaught exception", e);
        }
        try {
            xmlreader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", validate);
        }
        catch (SAXNotRecognizedException e) {
            logger.finer("Cannot set load-external-dtd to" + validate);
            logger.log(Level.FINER, "Uncaught exception", e);
        }
        DAS_Sequence_Handler cont_handle = new DAS_Sequence_Handler();
        xmlreader.setContentHandler(cont_handle);
        xmlreader.setErrorHandler(new DefaultHandler());
        InputSource insource = new InputSource();
        insource.setByteStream(dasInStream);
        xmlreader.parse(insource);
        String sequence = cont_handle.get_sequence();
        this.version = cont_handle.getVersion();
        logger.exiting(this.getClass().getName(), "retreiveSequence", sequence);
        return sequence;
    }

    private InputStream open(URL url) {
        InputStream inStream = null;
        try {
            HttpURLConnection huc = null;
            huc = DAS_FeatureRetrieve.openHttpURLConnection(url);
            logger.finest(huc.getResponseMessage());
            inStream = huc.getInputStream();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.log(Level.WARNING, "exception occured", ex);
        }
        return inStream;
    }
}

