/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.dasobert.das2.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.dasobert.das.DAS_FeatureRetrieve;
import org.biojava.dasobert.das2.io.DAS2SourceHandler;
import org.biojava.dasobert.das2.io.DasSourceReader;
import org.biojava.dasobert.dasregistry.DasSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DasSourceReaderImpl
implements DasSourceReader {
    Exception loggedException = null;

    private InputStream open(URL url) throws IOException, ConnectException {
        InputStream inStream = null;
        HttpURLConnection huc = DAS_FeatureRetrieve.openHttpURLConnection(url);
        inStream = huc.getInputStream();
        return inStream;
    }

    public DasSource[] readDasSource(URL url) {
        DasSource[] sources = new DasSource[]{};
        try {
            InputStream stream = this.open(url);
            sources = this.readDasSource(stream);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.loggedException = e;
        }
        return sources;
    }

    public DasSource[] readDasSource(InputStream stream) {
        DasSource[] sources = new DasSource[]{};
        try {
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            spfactory.setValidating(false);
            SAXParser saxParser = null;
            try {
                saxParser = spfactory.newSAXParser();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                this.loggedException = e;
            }
            String vali = System.getProperty("XMLVALIDATION");
            boolean validation = false;
            if (vali != null && vali.equals("true")) {
                validation = true;
            }
            XMLReader xmlreader = saxParser.getXMLReader();
            try {
                xmlreader.setFeature("http://xml.org/sax/features/validation", validation);
            }
            catch (SAXException e) {
                // empty catch block
            }
            try {
                xmlreader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", validation);
            }
            catch (SAXNotRecognizedException e) {
                e.printStackTrace();
            }
            DAS2SourceHandler cont_handle = new DAS2SourceHandler();
            xmlreader.setContentHandler(cont_handle);
            xmlreader.setErrorHandler(new DefaultHandler());
            InputSource insource = new InputSource();
            insource.setByteStream(stream);
            xmlreader.parse(insource);
            sources = cont_handle.getSources();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.loggedException = e;
        }
        return sources;
    }

    public Exception getLoggedException() {
        return this.loggedException;
    }

    public static void main(String[] args) {
        String url = "http://www.spice-3d.org/dasregistry/das2/sources/";
        DasSourceReaderImpl reader = new DasSourceReaderImpl();
        try {
            URL u = new URL(url);
            DasSource[] sources = reader.readDasSource(u);
            for (int i = 0; i < sources.length; ++i) {
                DasSource ds = sources[i];
                System.out.println(ds.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

