/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.dasobert.dasregistry;

import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.biojava.dasobert.dasregistry.DasCoordinateSystem;
import org.biojava.dasobert.dasregistry.DasSource;

public abstract class DasSourceComparator
implements Comparator {
    private final String name;
    private static final Map COMPS_BY_NAME;
    private static final int TWODAYS = 172800000;
    public static final Comparator BY_ID;
    public static final Comparator BY_NICKNAME;
    public static final Comparator BY_STATUS;
    public static final Comparator BY_REGISTER_DATE;
    public static final Comparator BY_LEASE_DATE;
    public static final Comparator BY_URL;
    public static final Comparator BY_ADMIN_EMAIL;
    public static final Comparator BY_DESCRIPTION;
    public static final Comparator BY_CAPABILITIES;
    public static final Comparator BY_COORDINATE_SYSTEM;

    public DasSourceComparator(String str) {
        this.name = str;
    }

    public static Comparator fromString(String name) {
        if (COMPS_BY_NAME.containsKey(name)) {
            return (Comparator)COMPS_BY_NAME.get(name);
        }
        throw new IllegalArgumentException("Can't compare by key " + name);
    }

    protected abstract Comparable getField(DasSource var1);

    public int compare(Object a, Object b) {
        DasSource x = (DasSource)a;
        DasSource y = (DasSource)b;
        return this.getField(x).compareTo(this.getField(y));
    }

    public String toString() {
        return this.name;
    }

    static {
        BY_ID = new DasSourceComparator("id"){

            protected Comparable getField(DasSource ds) {
                return ds.getId();
            }
        };
        BY_NICKNAME = new DasSourceComparator("nickname"){

            protected Comparable getField(DasSource ds) {
                return ds.getNickname();
            }
        };
        BY_STATUS = new DasSourceComparator("status"){

            protected Comparable getField(DasSource ds) {
                Date now = new Date();
                if (ds.getLeaseDate().getTime() < now.getTime() - 172800000L) {
                    return new Integer(0);
                }
                return new Integer(1);
            }
        };
        BY_REGISTER_DATE = new DasSourceComparator("registerdate"){

            protected Comparable getField(DasSource ds) {
                return ds.getRegisterDate();
            }
        };
        BY_LEASE_DATE = new DasSourceComparator("leasedate"){

            protected Comparable getField(DasSource ds) {
                return ds.getLeaseDate();
            }
        };
        BY_URL = new DasSourceComparator("url"){

            protected Comparable getField(DasSource ds) {
                return ds.getUrl();
            }
        };
        BY_ADMIN_EMAIL = new DasSourceComparator("adminemail"){

            protected Comparable getField(DasSource ds) {
                return ds.getAdminemail();
            }
        };
        BY_DESCRIPTION = new DasSourceComparator("description"){

            protected Comparable getField(DasSource ds) {
                return ds.getDescription();
            }
        };
        BY_CAPABILITIES = new DasSourceComparator("capabilities"){

            protected Comparable getField(DasSource ds) {
                String[] caps = ds.getCapabilities();
                return caps.length == 0 ? "" : caps[0];
            }
        };
        BY_COORDINATE_SYSTEM = new DasSourceComparator("coordinateSystem"){

            protected Comparable getField(DasSource ds) {
                DasCoordinateSystem[] dcss = ds.getCoordinateSystem();
                return dcss.length == 0 ? "" : dcss[0].toString();
            }
        };
        COMPS_BY_NAME = new HashMap();
        COMPS_BY_NAME.put(BY_ID.toString(), BY_ID);
        COMPS_BY_NAME.put(BY_NICKNAME.toString(), BY_NICKNAME);
        COMPS_BY_NAME.put(BY_REGISTER_DATE.toString(), BY_REGISTER_DATE);
        COMPS_BY_NAME.put(BY_LEASE_DATE.toString(), BY_LEASE_DATE);
        COMPS_BY_NAME.put(BY_URL.toString(), BY_URL);
        COMPS_BY_NAME.put(BY_ADMIN_EMAIL.toString(), BY_ADMIN_EMAIL);
        COMPS_BY_NAME.put(BY_DESCRIPTION.toString(), BY_DESCRIPTION);
        COMPS_BY_NAME.put(BY_CAPABILITIES.toString(), BY_CAPABILITIES);
        COMPS_BY_NAME.put(BY_COORDINATE_SYSTEM.toString(), BY_COORDINATE_SYSTEM);
        COMPS_BY_NAME.put(BY_STATUS.toString(), BY_STATUS);
    }
}

