/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.dasobert.feature;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.dasobert.feature.FeatureTrack;
import org.biojava.dasobert.feature.Segment;
import org.biojava.dasobert.feature.SegmentImpl;

public abstract class AbstractFeatureTrack
implements FeatureTrack,
Cloneable {
    String name;
    String method = "Unknown";
    String type = "Unknown";
    List segments = new ArrayList();
    String note = "";
    String link = "";
    String source = "Unknown";
    String score = "";
    String orientation = null;
    String typeID;
    String typeCategory;

    public abstract Object clone();

    public String toString() {
        String str = "Feature: method: " + this.method + " type: " + this.type;
        if (this.name != null) {
            str = str + " name: " + this.name;
        }
        if (this.note != null && !this.note.equals("null")) {
            str = this.note.length() > 40 ? str + "note: " + this.note.substring(0, 39) + "..." : str + " note: " + this.note;
        }
        str = str + " # segments: " + this.segments.size();
        return str;
    }

    public boolean overlaps(int seqPosition) {
        List segments = this.getSegments();
        Iterator iter = segments.iterator();
        while (iter.hasNext()) {
            Segment seg = (Segment)iter.next();
            if (!seg.overlaps(seqPosition)) continue;
            return true;
        }
        return false;
    }

    public void setSource(String s) {
        this.source = s;
    }

    public String getSource() {
        return this.source;
    }

    public void setName(String nam) {
        this.name = nam;
    }

    public String getName() {
        return this.name;
    }

    public void setMethod(String methd) {
        this.method = methd;
    }

    public String getMethod() {
        return this.method;
    }

    public void setType(String typ) {
        this.type = typ;
    }

    public String getType() {
        return this.type;
    }

    public void setNote(String nte) {
        if (nte != null) {
            this.note = nte;
        }
    }

    public String getNote() {
        return this.note;
    }

    public void setLink(String lnk) {
        this.link = lnk;
    }

    public String getLink() {
        return this.link;
    }

    public void setScore(String s) {
        this.score = s;
    }

    public String getScore() {
        return this.score;
    }

    public void addSegment(int start, int end, String name) {
        SegmentImpl s = new SegmentImpl();
        s.setStart(start);
        s.setEnd(end);
        s.setName(name);
        s.setParent(this);
        this.segments.add(s);
    }

    public void addSegment(Segment s) {
        s.setParent(this);
        this.segments.add(s);
    }

    public List getSegments() {
        return this.segments;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public boolean equals(FeatureTrack feat) {
        return this.type.equals(feat.getType()) && this.method.equals(feat.getMethod()) && this.source.equals(feat.getSource()) && this.note.equals(feat.getNote());
    }

    public String getTypeCategory() {
        return this.typeCategory;
    }

    public String getTypeID() {
        return this.typeID;
    }

    public void setTypeCategory(String typeCategory) {
        this.typeCategory = typeCategory;
    }

    public void setTypeID(String typeID) {
        this.typeID = typeID;
    }
}

