/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.dasobert.feature;

import java.awt.Color;
import org.biojava.dasobert.feature.FeatureTrack;
import org.biojava.dasobert.feature.Segment;

public abstract class AbstractSegment
implements Segment,
Cloneable {
    int start;
    int end;
    String name;
    Color color;
    FeatureTrack parent;
    String txtColor;
    String note;

    public abstract Object clone();

    public String toString() {
        String str = "Segment: " + this.name + " " + this.start + " " + this.end;
        if (this.note != null && !this.note.equals("null")) {
            str = this.note.length() > 40 ? str + this.note.substring(0, 39) + "..." : str + this.note;
        }
        return str;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setStart(int strt) {
        this.start = strt;
    }

    public int getStart() {
        return this.start;
    }

    public void setEnd(int ed) {
        this.end = ed;
    }

    public int getEnd() {
        return this.end;
    }

    public void setName(String nam) {
        this.name = nam;
    }

    public String getName() {
        return this.name;
    }

    public void setColor(Color col) {
        this.color = col;
    }

    public Color getColor() {
        return this.color;
    }

    public void setParent(FeatureTrack f) {
        this.parent = f;
    }

    public FeatureTrack getParent() {
        return this.parent;
    }

    public void setTxtColor(String str) {
        this.txtColor = str;
    }

    public String getTxtColor() {
        return this.txtColor;
    }

    public boolean overlaps(int seqPosition) {
        return this.getStart() <= seqPosition && this.getEnd() >= seqPosition;
    }

    public boolean overlaps(Segment segment) {
        if (this.start > this.end) {
            throw new IndexOutOfBoundsException("start > end for segment" + this);
        }
        if (segment.getStart() > segment.getEnd()) {
            throw new IndexOutOfBoundsException("start > end for segment" + segment);
        }
        if (this.start >= segment.getStart() && this.start <= segment.getEnd()) {
            return true;
        }
        if (this.end >= segment.getStart() && this.end <= segment.getEnd()) {
            return true;
        }
        return this.start <= segment.getStart() && this.end >= segment.getEnd();
    }
}

