/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.menu;

import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import org.biolegato.main.BLMain;
import org.biolegato.menu.ChoiceList;
import org.biolegato.menu.Chooser;
import org.biolegato.menu.ComboBoxWidget;
import org.biolegato.menu.CommandButton;
import org.biolegato.menu.CommandThread;
import org.biolegato.menu.FileChooser;
import org.biolegato.menu.NumberWidget;
import org.biolegato.menu.RunWindow;
import org.biolegato.menu.TempFile;
import org.biolegato.menu.TextWidget;
import org.biolegato.menu.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDEMenuParser {
    private static final String[] BLANK_STRING = new String[0];

    public static void loadGDEMenus() {
        try {
            if (!"true".equalsIgnoreCase(BLMain.getProperty("GDE.menu.disable"))) {
                if (System.getenv("GDE_HELP_DIR") != null) {
                    GDEMenuParser.readGDEMenuFile(new File(System.getenv("GDE_HELP_DIR") + File.separator + ".GDEmenus"));
                } else {
                    BLMain.warning("GDE_HELP_DIR not set!", "GDEMenu plugin");
                }
                GDEMenuParser.readGDEMenuFile(new File(BLMain.PROGRAM_DIR + File.separator + ".GDEmenus"));
                if (BLMain.HOME_DIR != null) {
                    GDEMenuParser.readGDEMenuFile(new File(BLMain.HOME_DIR + File.separator + ".GDEmenus"));
                } else {
                    BLMain.warning("HOME not set!", "GDEMenu plugin");
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
    }

    public static void loadMakemenus() {
        String basedir = System.getenv("GDE_MAKEMENUS_DIR");
        Object menulist = null;
        HashMap<String, Set<String>> directoryList = new HashMap<String, Set<String>>();
        BufferedReader localreader = null;
        if (basedir != null) {
            File menudirfile = new File(basedir + File.separator + "ldir.param");
            if (menudirfile.exists() && menudirfile.canRead() && menudirfile.isFile()) {
                try {
                    String line;
                    localreader = new BufferedReader(new FileReader(menudirfile));
                    while ((line = localreader.readLine()) != null) {
                        GDEMenuParser.readMenulistFile(directoryList, line);
                    }
                    localreader.close();
                    localreader = null;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(System.err);
                }
            }
            try {
                GDEMenuParser.readMenulistFile(directoryList, basedir + File.separator + "menus");
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
            }
        } else {
            BLMain.warning("GDE_MAKEMENUS_DIR not set!", "GDE Makemenus plugin");
        }
    }

    private static void readMenulistFile(Map<String, Set<String>> directoryList, String basename) throws IOException {
        String dirname = null;
        File menulist = new File(basename + File.separator + "menulist");
        File menufile = null;
        BufferedReader reader = null;
        if (menulist.exists() && menulist.canRead() && menulist.isFile()) {
            String line;
            reader = new BufferedReader(new FileReader(menulist));
            while ((line = reader.readLine()) != null) {
                boolean possible = true;
                if (line.length() <= 0 || line.trim().equals("") || line.startsWith("#")) continue;
                if (Character.isWhitespace(line.charAt(0))) {
                    if (dirname == null || directoryList.get(dirname).contains(line)) continue;
                    int tabindex = (line = line.trim()).indexOf(9);
                    if (tabindex >= 0) {
                        char[] system = line.substring(tabindex + 1).trim().toCharArray();
                        line = line.substring(0, tabindex);
                        if (system.length > 0) {
                            possible = false;
                            for (char av : system) {
                                possible = possible || av == 'S' && "solaris-sparc".equalsIgnoreCase(System.getenv("BIRCH_PLATFORM")) || av == 's' && "solaris-amd64".equalsIgnoreCase(System.getenv("BIRCH_PLATFORM")) || av == 'L' && "linux-intel".equalsIgnoreCase(System.getenv("BIRCH_PLATFORM")) || av == 'l' && "linux-x86_64".equalsIgnoreCase(System.getenv("BIRCH_PLATFORM"));
                            }
                            if (BLMain.debug) {
                                BLMain.message(line + "    " + String.valueOf(system) + "    " + System.getenv("BIRCH_PLATFORM") + "    " + (possible ? "loaded" : "NOT loaded"), "BIRCH Makemenus");
                            }
                        }
                    }
                    if (!possible) continue;
                    menufile = new File(basename + File.separatorChar + dirname + File.separatorChar + line + ".item");
                    if (!menufile.exists()) {
                        BLMain.error("Cannot read menu item - file does not exist", "GDEMakeMenus plugin");
                        continue;
                    }
                    if (!menufile.isFile()) {
                        BLMain.error("Cannot read menu item - location does not point to a file", "GDEMakeMenus plugin");
                        continue;
                    }
                    if (!menufile.canRead()) {
                        BLMain.error("Cannot read menu item - permission denied", "GDEMakeMenus plugin");
                        continue;
                    }
                    GDEMenuParser.readGDEMenuFile(dirname, menufile);
                    continue;
                }
                dirname = line;
                if (directoryList.containsKey(dirname)) continue;
                directoryList.put(dirname, new HashSet());
            }
            reader.close();
        }
    }

    public static void readGDEMenuFile(File file) {
        GDEMenuParser.readGDEMenuFile("File", file);
    }

    public static void readGDEMenuFile(String menuName, File file) {
        int tmpindex = 0;
        String line = "";
        String fname = "";
        String fvalue = "";
        BufferedReader reader = null;
        HashSet<String> argList = new HashSet<String>();
        LinkedList<String> fileVariables = new LinkedList<String>();
        LinkedList<String> choicenames = new LinkedList<String>();
        LinkedList<String> choicevalues = new LinkedList<String>();
        LinkedHashMap<String, Widget> widgets = new LinkedHashMap<String, Widget>();
        String itemName = null;
        Object command = null;
        ActionListener itemAction = null;
        JMenuItem jmiresult = null;
        String runCommand = null;
        String helpCommand = null;
        WidgetType argtype = null;
        String argname = null;
        String arglabel = null;
        int argintvalue = 0;
        int minimum = 0;
        int maximum = 500000;
        String argdefault = null;
        String inname = null;
        String informat = null;
        boolean insave = false;
        String outname = null;
        String outformat = null;
        boolean outsave = false;
        boolean outoverwrite = false;
        if (file.exists() && file.isFile() && file.canRead()) {
            try {
                reader = new BufferedReader(new FileReader(file));
                do {
                    boolean saveMenuItem;
                    fname = "";
                    fvalue = "";
                    line = reader.readLine();
                    if (!(line == null || "".equals(line) || (tmpindex = line.indexOf(58)) < 0 || line.startsWith("#") && !line.startsWith("#@"))) {
                        if (line.startsWith("#@")) {
                            line = line.substring(2);
                        }
                        fname = line.substring(0, tmpindex).trim().toLowerCase();
                        fvalue = line.substring(tmpindex + 1).trim();
                    }
                    boolean bl = saveMenuItem = line == null || "item".equals(fname) || "menu".equals(fname);
                    if (itemName != null) {
                        if (saveMenuItem || "in".equals(fname)) {
                            if (inname != null && informat != null) {
                                widgets.put(inname, new TempFile(true, false, insave, false, informat));
                                fileVariables.add(inname.toLowerCase());
                                informat = null;
                                insave = false;
                            }
                            inname = !saveMenuItem ? fvalue.toLowerCase() : null;
                        }
                        if (saveMenuItem || "out".equals(fname)) {
                            if (outname != null && outformat != null) {
                                widgets.put(outname, new TempFile(false, true, outsave, outoverwrite, outformat));
                                fileVariables.add(outname.toLowerCase());
                                outformat = null;
                                outoverwrite = false;
                            }
                            outname = !saveMenuItem ? fvalue.toLowerCase() : null;
                        }
                        if (saveMenuItem || "arg".equals(fname)) {
                            if (argname != null) {
                                argList.add(argname.toLowerCase());
                                if (argtype == WidgetType.CHOICE_LIST || argtype == WidgetType.CHOOSER || argtype == WidgetType.COMBOBOX || argtype == WidgetType.SLIDER) {
                                    if (argdefault != null) {
                                        try {
                                            argintvalue = Integer.parseInt(argdefault);
                                        }
                                        catch (NumberFormatException nfe) {
                                            // empty catch block
                                        }
                                    }
                                    if (argtype == WidgetType.SLIDER) {
                                        minimum = Math.max(0, minimum);
                                        maximum = Math.max(minimum, maximum);
                                        argintvalue = Math.max(Math.min(argintvalue, maximum), minimum);
                                        widgets.put(argname, new NumberWidget(arglabel, minimum, maximum, argintvalue));
                                    } else {
                                        String[] choices = choicevalues.toArray(BLANK_STRING);
                                        String[] choicenamearray = choicenames.toArray(BLANK_STRING);
                                        for (int count = 0; count < choices.length; ++count) {
                                            choices[count] = GDEMenuParser.GDE2BLArgs(argList, fileVariables, choices[count]);
                                        }
                                        argintvalue = Math.max(Math.min(argintvalue, choices.length - 1), 0);
                                        switch (argtype) {
                                            case CHOICE_LIST: {
                                                BLMain.warning("Using deprecated menu widget \"choice_list\"", "GDE menu parser");
                                                widgets.put(argname, new ChoiceList(arglabel, choicenamearray, choices, argintvalue));
                                                break;
                                            }
                                            case CHOOSER: {
                                                widgets.put(argname, new Chooser(arglabel, choicenamearray, choices, argintvalue));
                                                break;
                                            }
                                            case COMBOBOX: {
                                                widgets.put(argname, new ComboBoxWidget(arglabel, choicenamearray, choices, argintvalue));
                                            }
                                        }
                                    }
                                } else if (argtype == WidgetType.FILE) {
                                    widgets.put(argname, new FileChooser(arglabel, argdefault));
                                } else {
                                    widgets.put(argname, new TextWidget(arglabel, argdefault));
                                }
                                choicenames.clear();
                                choicevalues.clear();
                                argtype = null;
                                arglabel = null;
                                maximum = 0;
                                minimum = 500000;
                                argintvalue = 0;
                            }
                            argname = !saveMenuItem ? fvalue.toLowerCase() : null;
                        }
                    }
                    if (saveMenuItem) {
                        if (itemName != null) {
                            if (argList.isEmpty() && helpCommand == null) {
                                if (runCommand != null) {
                                    itemAction = new CommandThread(GDEMenuParser.GDE2BLArgs(argList, fileVariables, runCommand), widgets);
                                } else if (helpCommand != null) {
                                    itemAction = new CommandThread(GDEMenuParser.GDE2BLArgs(argList, fileVariables, runCommand), widgets);
                                }
                            } else {
                                LinkedList<CommandButton> buttons = new LinkedList<CommandButton>();
                                if (runCommand != null) {
                                    buttons.add(new CommandButton(widgets, "Run", GDEMenuParser.GDE2BLArgs(argList, fileVariables, runCommand), true));
                                }
                                if (helpCommand != null) {
                                    buttons.add(new CommandButton(widgets, "Help", GDEMenuParser.GDE2BLArgs(argList, fileVariables, helpCommand), false));
                                }
                                itemAction = new RunWindow(itemName, buttons, widgets);
                            }
                            jmiresult = new JMenuItem(itemName);
                            jmiresult.addActionListener(itemAction);
                            BLMain.addMenuItem(menuName, jmiresult);
                            widgets = new LinkedHashMap();
                        } else {
                            widgets.clear();
                        }
                        itemName = null;
                        fileVariables.clear();
                        argList.clear();
                        runCommand = null;
                        helpCommand = null;
                    }
                    if ("".equals(fname)) continue;
                    if ("menu".equals(fname)) {
                        menuName = fvalue;
                        BLMain.addMenuHeading(menuName);
                        continue;
                    }
                    if ("item".equals(fname)) {
                        itemName = fvalue;
                        continue;
                    }
                    if (itemName != null) {
                        if (fname.startsWith("item")) {
                            if ("itemmeta".equals(fname) && fvalue.length() >= 1 || "itemlabel".equals(fname) || "itemopen".equals(fname)) continue;
                            if ("itemhelp".equals(fname)) {
                                helpCommand = BLMain.getProperty("GDE.help.viewer") + " " + BLMain.envreplace(BLMain.getProperty("GDE.help.path")) + File.separator + fvalue;
                                continue;
                            }
                            if (!"itemmethod".equals(fname)) continue;
                            runCommand = fvalue;
                            continue;
                        }
                        if (fname.startsWith("arg")) {
                            if ("argtype".equals(fname)) {
                                argtype = WidgetType.toType(fvalue);
                                continue;
                            }
                            if ("arglabel".equals(fname)) {
                                arglabel = fvalue;
                                continue;
                            }
                            if ("argmin".equals(fname)) {
                                try {
                                    minimum = Integer.parseInt(fvalue);
                                }
                                catch (NumberFormatException nfe) {
                                    BLMain.error("Invalid GDE field value (item: " + itemName + "): " + fname + " = " + fvalue, "GDEMenu plugin");
                                }
                                continue;
                            }
                            if ("argmax".equals(fname)) {
                                try {
                                    maximum = Integer.parseInt(fvalue);
                                }
                                catch (NumberFormatException nfe) {
                                    BLMain.error("Invalid GDE field value (item: " + itemName + "): " + fname + " = " + fvalue, "GDEMenu plugin");
                                }
                                continue;
                            }
                            if ("argvalue".equals(fname) || "argtext".equals(fname)) {
                                argdefault = fvalue;
                                continue;
                            }
                            if (!"argchoice".equals(fname)) continue;
                            tmpindex = fvalue.indexOf(58);
                            if (tmpindex >= 0) {
                                choicenames.add(fvalue.substring(0, tmpindex));
                                choicevalues.add(fvalue.substring(tmpindex + 1));
                                continue;
                            }
                            choicenames.add(fvalue);
                            choicevalues.add("");
                            BLMain.warning("Badly formed argchoice field: " + fvalue, "GDEMenu");
                            continue;
                        }
                        if (fname.startsWith("in")) {
                            if ("informat".equals(fname)) {
                                informat = fvalue;
                                continue;
                            }
                            if ("inmask".equals(fname)) {
                                BLMain.warning("Warning unsupported GDE menu field \"inmask\" -- ignoring", "GDEMenu");
                                continue;
                            }
                            if (!"insave".equals(fname)) continue;
                            insave = true;
                            continue;
                        }
                        if (!fname.startsWith("out")) continue;
                        if ("outformat".equals(fname)) {
                            outformat = fvalue;
                            continue;
                        }
                        if ("outsave".equals(fname)) {
                            outsave = true;
                            continue;
                        }
                        if (!"outoverwrite".equals(fname)) continue;
                        outoverwrite = true;
                        continue;
                    }
                    BLMain.error("Invalid GDE location or field value (item: " + itemName + "): " + fname + " = " + fvalue, "GDEMenu plugin");
                } while (line != null);
                reader.close();
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private static String GDE2BLArgs(Set<String> argList, List<String> fileVariables, String runCommand) {
        int start = -1;
        int end = -1;
        String name = "";
        String value = "";
        String smallrun = runCommand.toLowerCase();
        String test = null;
        while ((start = runCommand.indexOf(36, start)) >= 0) {
            for (end = start + 1; end < runCommand.length() && (BLMain.isDigit(runCommand.charAt(end)) || runCommand.charAt(end) == '_'); ++end) {
            }
            test = runCommand.substring(start + 1, end).toLowerCase();
            if (argList.contains(test)) {
                runCommand = (start == 0 ? "" : runCommand.substring(0, start)) + '%' + test.toLowerCase() + '%' + (end > runCommand.length() ? "" : runCommand.substring(end));
            }
            ++start;
        }
        smallrun = runCommand.toLowerCase();
        for (String file : fileVariables) {
            boolean searchCount = false;
            start = -1;
            end = -1;
            if (file == null || "".equals(file)) continue;
            while ((start = smallrun.indexOf(file, end + 1)) >= 0) {
                end = start + file.length();
                if (start != 0 && BLMain.isDigit(runCommand.charAt(start - 1)) || end < runCommand.length() && BLMain.isDigit(runCommand.charAt(end))) continue;
                runCommand = (start == 0 ? "" : runCommand.substring(0, start)) + '%' + file.toLowerCase() + '%' + (end > runCommand.length() ? "" : runCommand.substring(end));
                smallrun = runCommand.toLowerCase();
            }
        }
        return runCommand;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WidgetType {
        CHOICE_LIST,
        CHOOSER,
        COMBOBOX,
        FILE,
        TEXT,
        SLIDER;


        public static WidgetType toType(String test) {
            int length = test.length();
            WidgetType type = TEXT;
            if (length == 6 && "slider".equalsIgnoreCase(test)) {
                type = SLIDER;
            } else if (length == 7 && "chooser".equalsIgnoreCase(test)) {
                type = CHOOSER;
            } else if (length == 11) {
                if ("choice_menu".equalsIgnoreCase(test)) {
                    type = COMBOBOX;
                } else if ("choice_list".equalsIgnoreCase(test)) {
                    type = CHOICE_LIST;
                }
            } else if (length == 12 && "file_chooser".equalsIgnoreCase(test)) {
                type = FILE;
            }
            return type;
        }
    }
}

