/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.categories;

import JSci.maths.ExtraMath;
import JSci.maths.MathInteger;
import JSci.maths.categories.Bifunctor;
import JSci.maths.categories.Category;
import JSci.maths.categories.Functor;
import JSci.maths.categories.Homset;
import JSci.maths.categories.Morphism;
import JSci.maths.categories.Preorder;
import JSci.maths.categories.UndefinedCompositionException;

public final class Simplicial
implements Category {
    public final Bifunctor ADDITION = new Addition();

    public Morphism identity(Object object) {
        Preorder preorder = (Preorder)object;
        Integer[] integerArray = new Integer[preorder.ordinal()];
        int n = 0;
        while (n < integerArray.length) {
            integerArray[n] = new Integer(n);
            ++n;
        }
        return new IncreasingMap(preorder, integerArray);
    }

    public Object cardinality(Object object) {
        return new MathInteger(((Preorder)object).ordinal());
    }

    public Homset homset(Object object, Object object2) {
        return new FunctionSet((Preorder)object, (Preorder)object2);
    }

    public Object terminal() {
        return new Preorder(1);
    }

    public final class Addition
    implements Bifunctor {
        public Object map(Object object, Object object2) {
            return new Preorder(((Preorder)object).ordinal() + ((Preorder)object2).ordinal());
        }

        public Morphism map(Morphism morphism, Morphism morphism2) {
            IncreasingMap increasingMap = (IncreasingMap)morphism;
            IncreasingMap increasingMap2 = (IncreasingMap)morphism2;
            Preorder preorder = new Preorder(increasingMap.to.ordinal() + increasingMap2.to.ordinal());
            Integer[] integerArray = new Integer[increasingMap.out.length + increasingMap2.out.length];
            int n = 0;
            while (n < increasingMap.out.length) {
                integerArray[n] = increasingMap.out[n];
                ++n;
            }
            while (n < integerArray.length) {
                integerArray[n] = increasingMap2.out[n];
                ++n;
            }
            return new IncreasingMap(preorder, integerArray);
        }
    }

    public final class DegeneracyMap
    extends IncreasingMap {
        private final int repeat;

        public DegeneracyMap(Preorder preorder, int n) {
            super(preorder, new Integer[preorder.ordinal() + 1]);
            this.repeat = n;
            n = 0;
            while (n <= this.repeat) {
                this.out[n] = new Integer(n);
                ++n;
            }
            while (n < this.out.length) {
                this.out[n] = new Integer(n - 1);
                ++n;
            }
        }
    }

    public final class FaceMap
    extends IncreasingMap {
        private final int skip;

        public FaceMap(Preorder preorder, int n) {
            super(preorder, new Integer[preorder.ordinal() - 1]);
            this.skip = n;
            n = 0;
            while (n < this.skip) {
                this.out[n] = new Integer(n);
                ++n;
            }
            while (n < this.out.length) {
                this.out[n] = new Integer(n + 1);
                ++n;
            }
        }
    }

    public class IncreasingMap
    implements Functor {
        protected final Preorder from;
        protected final Preorder to;
        protected final Integer[] out;

        public IncreasingMap(Preorder preorder, Integer[] integerArray) {
            this.from = new Preorder(integerArray.length);
            this.to = preorder;
            this.out = integerArray;
        }

        public Object domain() {
            return this.from;
        }

        public Object codomain() {
            return this.to;
        }

        public Object map(Object object) {
            return this.out[(Integer)object];
        }

        public Morphism map(Morphism morphism) {
            return ((Preorder.RelationSet)this.to.homset((Object)this.map((Object)morphism.domain()), (Object)this.map((Object)morphism.codomain()))).morphism;
        }

        public Morphism compose(Morphism morphism) {
            return this.compose((Functor)morphism);
        }

        public Functor compose(Functor functor) {
            if (functor instanceof IncreasingMap) {
                IncreasingMap increasingMap = (IncreasingMap)functor;
                if (this.to.equals(increasingMap.from)) {
                    Integer[] integerArray = new Integer[this.out.length];
                    int n = 0;
                    while (n < integerArray.length) {
                        integerArray[n] = (Integer)increasingMap.map(this.out[n]);
                        ++n;
                    }
                    return new IncreasingMap(increasingMap.to, integerArray);
                }
                throw new UndefinedCompositionException();
            }
            throw new IllegalArgumentException("Morphism is not an IncreasingMap.");
        }
    }

    public class FunctionSet
    implements Homset {
        private final Preorder from;
        private final Preorder to;

        public FunctionSet(Preorder preorder, Preorder preorder2) {
            this.from = preorder;
            this.to = preorder2;
        }

        public int cardinality() {
            return (int)ExtraMath.binomial(this.from.ordinal() + this.to.ordinal() - 1, this.from.ordinal());
        }
    }
}

